(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8486,        282]
NotebookOptionsPosition[      6618,        225]
NotebookOutlinePosition[      7748,        255]
CellTagsIndexPosition[      7705,        252]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["REGRESSION COMMON PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Regression Common Functions Package" :> 
          Documentation`HelpLookup[
           "paclet:RegressionCommon/tutorial/RegressionCommon"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Regression Common Functions Package\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SummaryReport" :> 
          Documentation`HelpLookup[
           "paclet:RegressionCommon/ref/SummaryReport"], "Regress" :> 
          Documentation`HelpLookup["paclet:LinearRegression/ref/Regress"], 
          "NonlinearRegress" :> 
          Documentation`HelpLookup[
           "paclet:NonlinearRegression/ref/NonlinearRegress"], 
          "DesignedRegress" :> 
          Documentation`HelpLookup[
           "paclet:LinearRegression/ref/DesignedRegress"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"SummaryReport\"\>", 
       2->"\<\"Regress\"\>", 3->"\<\"NonlinearRegress\"\>", 
       4->"\<\"DesignedRegress\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["RegressionReport", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["RegressionReport"], "InlineFormula"],
     " \[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Regress",
       BaseStyle->"Link",
       ButtonData->"paclet:LinearRegression/ref/Regress"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["DesignedRegress",
       BaseStyle->"Link",
       ButtonData->"paclet:LinearRegression/ref/DesignedRegress"]], 
      "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["NonlinearRegress",
       BaseStyle->"Link",
       ButtonData->"paclet:NonlinearRegression/ref/NonlinearRegress"]], 
      "InlineFormula"],
     " which specifies the report values to return."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The value of ",
 Cell[BoxData["RegressionReport"], "InlineFormula"],
 " can be any subset of the values returned by ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["RegressionReportValues",
    BaseStyle->"Link",
    ButtonData->"paclet:RegressionCommon/ref/RegressionReportValues"], "[", 
   StyleBox["f", "TI"], "]"}]], "InlineFormula"],
 " for the regression function ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 "The default setting ",
 Cell[BoxData[
  RowBox[{"RegressionReport", "->", 
   ButtonBox["SummaryReport",
    BaseStyle->"Link",
    ButtonData->"paclet:RegressionCommon/ref/SummaryReport"]}]], 
  "InlineFormula"],
 " gives a few of the most common diagnostics."
}], "Notes",
 CellID->489838166]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SummaryReport",
    BaseStyle->"Link",
    ButtonData->"paclet:RegressionCommon/ref/SummaryReport"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Regress",
    BaseStyle->"Link",
    ButtonData->"paclet:LinearRegression/ref/Regress"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NonlinearRegress",
    BaseStyle->"Link",
    ButtonData->"paclet:NonlinearRegression/ref/NonlinearRegress"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DesignedRegress",
    BaseStyle->"Link",
    ButtonData->"paclet:LinearRegression/ref/DesignedRegress"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Regression Common Functions Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:RegressionCommon/tutorial/RegressionCommon"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"RegressionReport - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 7, 23.0355536}", "context" -> 
    "RegressionCommon`", "keywords" -> {}, "index" -> True, "label" -> 
    "Regression Common Package Symbol", "language" -> "en", "paclet" -> 
    "RegressionCommon Package", "status" -> "None", "summary" -> 
    "RegressionReport is an option for Regress, DesignedRegress and \
NonlinearRegress which specifies the report values to return.", 
    "synonyms" -> {}, "title" -> "RegressionReport", "type" -> "Symbol", 
    "uri" -> "RegressionCommon/ref/RegressionReport"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1719, 43, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2342, 70, 59, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[2404, 73, 907, 27, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[3348, 105, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3826, 122, 481, 15, 70, "Notes",
 CellID->1067943069],
Cell[4310, 139, 312, 10, 70, "Notes",
 CellID->489838166]
}, Closed]],
Cell[CellGroupData[{
Cell[4659, 154, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[4978, 165, 1054, 35, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[6069, 205, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[6390, 216, 186, 4, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[6591, 223, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

