(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9698,        339]
NotebookOptionsPosition[      7131,        256]
NotebookOutlinePosition[      8445,        293]
CellTagsIndexPosition[      8361,        288]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["REGRESSION COMMON PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Regression Common Functions Package" :> 
          Documentation`HelpLookup[
           "paclet:RegressionCommon/tutorial/RegressionCommon"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Regression Common Functions Package\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"RegressionReport" :> 
          Documentation`HelpLookup[
           "paclet:RegressionCommon/ref/RegressionReport"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"RegressionReport\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["RegressionReportValues", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"RegressionReportValues", "[", 
       StyleBox["f", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives a list of the possible report values for the \
regression function ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["RegressionReportValues"], "InlineFormula"],
 " gives a list of possible elements for the ",
 Cell[BoxData[
  ButtonBox["RegressionReport",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/RegressionReport"]], 
  "InlineFormula"],
 " option."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 Cell[BoxData["RegressionReportValues"], "InlineFormula"],
 " can be evaluated for ",
 Cell[BoxData[
  ButtonBox["Regress",
   BaseStyle->"Link",
   ButtonData->"paclet:LinearRegression/ref/Regress"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["DesignedRegress",
   BaseStyle->"Link",
   ButtonData->"paclet:LinearRegression/ref/DesignedRegress"]], 
  "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["NonlinearRegress",
   BaseStyle->"Link",
   ButtonData->"paclet:NonlinearRegression/ref/NonlinearRegress"]], 
  "InlineFormula"],
 "."
}], "Notes",
 CellID->554730261]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->128668835],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->10495429],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NonlinearRegression`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->455158924],

Cell[TextData[{
 "Possible ",
 Cell[BoxData[
  ButtonBox["RegressionReport",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/RegressionReport"]], 
  "InlineFormula"],
 " values for ",
 Cell[BoxData[
  ButtonBox["NonlinearRegress",
   BaseStyle->"Link",
   ButtonData->"paclet:NonlinearRegression/ref/NonlinearRegress"]], 
  "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->805238988],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegressionReportValues", "[", "NonlinearRegress", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->6974537],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "ANOVATable", ",", "AsymptoticCorrelationMatrix", ",", 
   "AsymptoticCovarianceMatrix", ",", "BestFit", ",", "BestFitParameters", 
   ",", "EstimatedVariance", ",", "FitCurvatureTable", ",", "FitResiduals", 
   ",", "HatDiagonal", ",", "MeanPredictionCITable", ",", "ParameterBias", 
   ",", "ParameterConfidenceRegion", ",", "ParameterCITable", ",", 
   "ParameterTable", ",", "PredictedResponse", ",", "SinglePredictionCITable",
    ",", "StartingParameters", ",", "StandardizedResiduals", ",", 
   "SummaryReport"}], "}"}]], "Output",
 ImageSize->{577, 84},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->933058248]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["RegressionReport",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/RegressionReport"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Regression Common Functions Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:RegressionCommon/tutorial/RegressionCommon"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"RegressionReportValues - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 7, 23.2386838}", "context" -> 
    "RegressionCommon`", "keywords" -> {}, "index" -> True, "label" -> 
    "Regression Common Package Symbol", "language" -> "en", "paclet" -> 
    "RegressionCommon Package", "status" -> "None", "summary" -> 
    "RegressionReportValues[f] gives a list of the possible report values for \
the regression function f.", "synonyms" -> {}, "title" -> 
    "RegressionReportValues", "type" -> "Symbol", "uri" -> 
    "RegressionCommon/ref/RegressionReportValues"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3977, 141, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->128668835]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 8218, 281}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1287, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1910, 62, 65, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[1978, 65, 520, 16, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[2535, 86, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3013, 103, 323, 10, 70, "Notes",
 CellID->1067943069],
Cell[3339, 115, 601, 21, 70, "Notes",
 CellID->554730261]
}, Closed]],
Cell[CellGroupData[{
Cell[3977, 141, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->128668835],
Cell[CellGroupData[{
Cell[4362, 155, 147, 5, 70, "ExampleSection",
 CellID->10495429],
Cell[4512, 162, 144, 4, 70, "Input",
 CellID->455158924],
Cell[4659, 168, 403, 15, 70, "ExampleText",
 CellID->805238988],
Cell[CellGroupData[{
Cell[5087, 187, 131, 3, 28, "Input",
 CellID->6974537],
Cell[5221, 192, 711, 15, 105, "Output",
 CellID->933058248]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5993, 214, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[6312, 225, 233, 6, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[6582, 236, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[6903, 247, 186, 4, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[7104, 254, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

