(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11597,        391]
NotebookOptionsPosition[      8900,        304]
NotebookOutlinePosition[     10239,        341]
CellTagsIndexPosition[     10154,        336]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["REGRESSION COMMON PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Regression Common Functions Package" :> 
          Documentation`HelpLookup[
           "paclet:RegressionCommon/tutorial/RegressionCommon"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Regression Common Functions Package\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FitResiduals" :> 
          Documentation`HelpLookup[
           "paclet:RegressionCommon/ref/FitResiduals"], 
          "StudentizedResiduals" :> 
          Documentation`HelpLookup[
           "paclet:RegressionCommon/ref/StudentizedResiduals"], "HatDiagonal" :> 
          Documentation`HelpLookup[
           "paclet:RegressionCommon/ref/HatDiagonal"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"FitResiduals\"\>", 
       2->"\<\"StudentizedResiduals\"\>", 
       3->"\<\"HatDiagonal\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["StandardizedResiduals", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["StandardizedResiduals"], "InlineFormula"],
     "\[LineSeparator]is a possible value for the ",
     Cell[BoxData[
      ButtonBox["RegressionReport",
       BaseStyle->"Link",
       ButtonData->"paclet:RegressionCommon/ref/RegressionReport"]], 
      "InlineFormula"],
     " option which represents the list of standardized residuals."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["StandardizedResiduals"], "InlineFormula"],
 " gives the fit residuals divided by the standard error for each residual. "
}], "Notes",
 CellID->142602272],

Cell[TextData[{
 Cell[BoxData["StandardizedResiduals"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FitResiduals",
    BaseStyle->"Link",
    ButtonData->"paclet:RegressionCommon/ref/FitResiduals"], "/", 
   RowBox[{
    ButtonBox["Sqrt",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Sqrt"], "[", 
    RowBox[{
     ButtonBox["EstimatedVariance",
      BaseStyle->"Link",
      ButtonData->"paclet:RegressionCommon/ref/EstimatedVariance"], " ", 
     RowBox[{"(", 
      RowBox[{"1", " ", "-", " ", 
       ButtonBox["HatDiagonal",
        BaseStyle->"Link",
        ButtonData->"paclet:RegressionCommon/ref/HatDiagonal"]}], ")"}]}], 
    "]"}]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->677246013]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->823350211],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->57685509],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<LinearRegression`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->455158924],

Cell["Sample data:", "ExampleText",
 CellID->3902],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.05", ",", " ", "90"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.09", ",", " ", "95"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.14", ",", " ", "110"}], "}"}], ",", "\n", " ", 
     RowBox[{"{", 
      RowBox[{"0.17", ",", " ", "125"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.2", ",", " ", "140"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.21", ",", " ", "150"}], "}"}], ",", "\n", " ", 
     RowBox[{"{", 
      RowBox[{"0.23", ",", " ", "175"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.25", ",", " ", "190"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.3", ",", " ", "210"}], "}"}], ",", "\n", " ", 
     RowBox[{"{", 
      RowBox[{"0.35", ",", " ", "255"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->26500],

Cell["StandardizedResiduals for a linear regression:", "ExampleText",
 CellID->153],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Regress", "[", 
  RowBox[{"data", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     SuperscriptBox["x", "2"]}], "}"}], ",", "x", ",", 
   RowBox[{"RegressionReport", "\[Rule]", 
    RowBox[{"{", "StandardizedResiduals", "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->471749153],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"StandardizedResiduals", "\[Rule]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.08953233720851392`"}], ",", 
     RowBox[{"-", "0.517285608595132`"}], ",", 
     RowBox[{"-", "0.6859641583633618`"}], ",", 
     RowBox[{"-", "0.4279056162638952`"}], ",", 
     RowBox[{"-", "0.5274341569582303`"}], ",", "0.03753891502584517`", ",", 
     "1.727917618518772`", ",", "1.9290978307026305`", ",", 
     RowBox[{"-", "0.7320965889279979`"}], ",", 
     RowBox[{"-", "1.1820515558402935`"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{508, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->202061467]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FitResiduals",
    BaseStyle->"Link",
    ButtonData->"paclet:RegressionCommon/ref/FitResiduals"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StudentizedResiduals",
    BaseStyle->"Link",
    ButtonData->"paclet:RegressionCommon/ref/StudentizedResiduals"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["HatDiagonal",
    BaseStyle->"Link",
    ButtonData->"paclet:RegressionCommon/ref/HatDiagonal"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->330934021]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Regression Common Functions Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:RegressionCommon/tutorial/RegressionCommon"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"StandardizedResiduals - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 7, 30.5044948}", "context" -> 
    "RegressionCommon`", "keywords" -> {}, "index" -> True, "label" -> 
    "Regression Common Package Symbol", "language" -> "en", "paclet" -> 
    "RegressionCommon Package", "status" -> "None", "summary" -> 
    "StandardizedResiduals is a possible value for the RegressionReport \
option which represents the list of standardized residuals.", 
    "synonyms" -> {}, "title" -> "StandardizedResiduals", "type" -> "Symbol", 
    "uri" -> "RegressionCommon/ref/StandardizedResiduals"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4355, 144, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->823350211]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 10011, 329}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1591, 41, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2214, 68, 64, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[2281, 71, 586, 16, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[2904, 92, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3382, 109, 184, 4, 70, "Notes",
 CellID->142602272],
Cell[3569, 115, 749, 24, 70, "Notes",
 CellID->677246013]
}, Closed]],
Cell[CellGroupData[{
Cell[4355, 144, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->823350211],
Cell[CellGroupData[{
Cell[4740, 158, 147, 5, 70, "ExampleSection",
 CellID->57685509],
Cell[4890, 165, 141, 4, 70, "Input",
 CellID->455158924],
Cell[5034, 171, 50, 1, 70, "ExampleText",
 CellID->3902],
Cell[5087, 174, 937, 26, 70, "Input",
 CellID->26500],
Cell[6027, 202, 83, 1, 70, "ExampleText",
 CellID->153],
Cell[CellGroupData[{
Cell[6135, 207, 315, 9, 70, "Input",
 CellID->471749153],
Cell[6453, 218, 692, 17, 54, "Output",
 CellID->202061467]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7206, 242, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[7525, 253, 789, 26, 70, "SeeAlso",
 CellID->330934021]
}, Open  ]],
Cell[CellGroupData[{
Cell[8351, 284, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[8672, 295, 186, 4, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[8873, 302, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

