(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12474,        417]
NotebookOptionsPosition[      9752,        330]
NotebookOutlinePosition[     11114,        367]
CellTagsIndexPosition[     11029,        362]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["REGRESSION COMMON PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Regression Common Functions Package" :> 
          Documentation`HelpLookup[
           "paclet:RegressionCommon/tutorial/RegressionCommon"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Regression Common Functions Package\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FitResiduals" :> 
          Documentation`HelpLookup[
           "paclet:RegressionCommon/ref/FitResiduals"], 
          "StandardizedResiduals" :> 
          Documentation`HelpLookup[
           "paclet:RegressionCommon/ref/StandardizedResiduals"], 
          "HatDiagonal" :> 
          Documentation`HelpLookup["paclet:RegressionCommon/ref/HatDiagonal"],
           "JackknifedVariance" :> 
          Documentation`HelpLookup[
           "paclet:RegressionCommon/ref/JackknifedVariance"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"FitResiduals\"\>", 
       2->"\<\"StandardizedResiduals\"\>", 3->"\<\"HatDiagonal\"\>", 
       4->"\<\"JackknifedVariance\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["StudentizedResiduals", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["StudentizedResiduals"], "InlineFormula"],
     "\[LineSeparator]is a possible value for the ",
     Cell[BoxData[
      ButtonBox["RegressionReport",
       BaseStyle->"Link",
       ButtonData->"paclet:RegressionCommon/ref/RegressionReport"]], 
      "InlineFormula"],
     " option for ",
     Cell[BoxData[
      ButtonBox["Regress",
       BaseStyle->"Link",
       ButtonData->"paclet:LinearRegression/ref/Regress"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["DesignedRegress",
       BaseStyle->"Link",
       ButtonData->"paclet:LinearRegression/ref/DesignedRegress"]], 
      "InlineFormula"],
     " which represents the list of studentized residuals."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["StudentizedResiduals"], "InlineFormula"],
 " gives the fit residuals divided by their jackknifed variance estimates. "
}], "Notes",
 CellID->237826104],

Cell[TextData[{
 Cell[BoxData["StudentizedResiduals"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FitResiduals",
    BaseStyle->"Link",
    ButtonData->"paclet:RegressionCommon/ref/FitResiduals"], "/", 
   RowBox[{
    ButtonBox["Sqrt",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Sqrt"], "[", 
    RowBox[{
     ButtonBox["JackknifedVariance",
      BaseStyle->"Link",
      ButtonData->"paclet:RegressionCommon/ref/JackknifedVariance"], " ", 
     RowBox[{"(", 
      RowBox[{"1", " ", "-", " ", 
       ButtonBox["HatDiagonal",
        BaseStyle->"Link",
        ButtonData->"paclet:RegressionCommon/ref/HatDiagonal"]}], ")"}]}], 
    "]"}]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->677246013]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->98001335],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->23833760],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<LinearRegression`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->455158924],

Cell["Sample data:", "ExampleText",
 CellID->3902],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.05", ",", " ", "90"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.09", ",", " ", "95"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.14", ",", " ", "110"}], "}"}], ",", "\n", " ", 
     RowBox[{"{", 
      RowBox[{"0.17", ",", " ", "125"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.2", ",", " ", "140"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.21", ",", " ", "150"}], "}"}], ",", "\n", " ", 
     RowBox[{"{", 
      RowBox[{"0.23", ",", " ", "175"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.25", ",", " ", "190"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.3", ",", " ", "210"}], "}"}], ",", "\n", " ", 
     RowBox[{"{", 
      RowBox[{"0.35", ",", " ", "255"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->26500],

Cell[TextData[{
 Cell[BoxData["StudentizedResiduals"], "InlineFormula"],
 " for a linear regression:"
}], "ExampleText",
 CellID->153],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Regress", "[", 
  RowBox[{"data", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"x", "^", "2"}]}], "}"}], ",", "x", ",", 
   RowBox[{"RegressionReport", "\[Rule]", 
    RowBox[{"{", "StudentizedResiduals", "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->159482781],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"StudentizedResiduals", "\[Rule]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.08379182314890031`"}], ",", 
     RowBox[{"-", "0.49217757476889845`"}], ",", 
     RowBox[{"-", "0.6614069072573325`"}], ",", 
     RowBox[{"-", "0.40492987360281013`"}], ",", 
     RowBox[{"-", "0.5021779339757003`"}], ",", "0.035117532721855686`", ",", 
     "2.0415821764365467`", ",", "2.4674784314914118`", ",", 
     RowBox[{"-", "0.7089744458457631`"}], ",", 
     RowBox[{"-", "1.2170905111901418`"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{508, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->299134122]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FitResiduals",
    BaseStyle->"Link",
    ButtonData->"paclet:RegressionCommon/ref/FitResiduals"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StandardizedResiduals",
    BaseStyle->"Link",
    ButtonData->"paclet:RegressionCommon/ref/StandardizedResiduals"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["HatDiagonal",
    BaseStyle->"Link",
    ButtonData->"paclet:RegressionCommon/ref/HatDiagonal"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["JackknifedVariance",
    BaseStyle->"Link",
    ButtonData->"paclet:RegressionCommon/ref/JackknifedVariance"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->330934021]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Regression Common Functions Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:RegressionCommon/tutorial/RegressionCommon"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"StudentizedResiduals - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 7, 30.8482536}", "context" -> 
    "RegressionCommon`", "keywords" -> {}, "index" -> True, "label" -> 
    "Regression Common Package Symbol", "language" -> "en", "paclet" -> 
    "RegressionCommon Package", "status" -> "None", "summary" -> 
    "StudentizedResiduals is a possible value for the RegressionReport option \
for Regress and DesignedRegress which represents the list of studentized \
residuals.", "synonyms" -> {}, "title" -> "StudentizedResiduals", "type" -> 
    "Symbol", "uri" -> "RegressionCommon/ref/StudentizedResiduals"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4871, 158, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->98001335]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 10887, 355}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1760, 44, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2383, 71, 63, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[2449, 74, 935, 27, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[3421, 106, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3899, 123, 182, 4, 70, "Notes",
 CellID->237826104],
Cell[4084, 129, 750, 24, 70, "Notes",
 CellID->677246013]
}, Closed]],
Cell[CellGroupData[{
Cell[4871, 158, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->98001335],
Cell[CellGroupData[{
Cell[5255, 172, 147, 5, 70, "ExampleSection",
 CellID->23833760],
Cell[5405, 179, 141, 4, 70, "Input",
 CellID->455158924],
Cell[5549, 185, 50, 1, 70, "ExampleText",
 CellID->3902],
Cell[5602, 188, 937, 26, 70, "Input",
 CellID->26500],
Cell[6542, 216, 134, 4, 70, "ExampleText",
 CellID->153],
Cell[CellGroupData[{
Cell[6701, 224, 313, 9, 70, "Input",
 CellID->159482781],
Cell[7017, 235, 696, 17, 54, "Output",
 CellID->299134122]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7774, 259, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[8093, 270, 1073, 35, 70, "SeeAlso",
 CellID->330934021]
}, Open  ]],
Cell[CellGroupData[{
Cell[9203, 310, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[9524, 321, 186, 4, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[9725, 328, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

