(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     30488,        928]
NotebookOptionsPosition[     26459,        797]
NotebookOutlinePosition[     28121,        839]
CellTagsIndexPosition[     28078,        836]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["RESONANCE ABSORPTION LINES PACKAGE TUTORIAL", "PacletNameCell"], 
    Cell[TextData[Cell[BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"AirWavelength" :> 
         Documentation`HelpLookup[
          "paclet:ResonanceAbsorptionLines/ref/AirWavelength"], "AtomicData" :> 
         Documentation`HelpLookup[
          "paclet:ResonanceAbsorptionLines/ref/AtomicData"], 
         "DampingConstant" :> 
         Documentation`HelpLookup[
          "paclet:ResonanceAbsorptionLines/ref/DampingConstant"], 
         "ElementAbsorptionMap" :> 
         Documentation`HelpLookup[
          "paclet:ResonanceAbsorptionLines/ref/ElementAbsorptionMap"], 
         "FindIons" :> 
         Documentation`HelpLookup[
          "paclet:ResonanceAbsorptionLines/ref/FindIons"], 
         "LowerStatisticalWeight" :> 
         Documentation`HelpLookup[
          "paclet:ResonanceAbsorptionLines/ref/LowerStatisticalWeight"], 
         "LowerTermFineStructureEnergy" :> 
         Documentation`HelpLookup[
          "paclet:ResonanceAbsorptionLines/ref/LowerTermFineStructureEnergy"],
          "OscillatorStrength" :> 
         Documentation`HelpLookup[
          "paclet:ResonanceAbsorptionLines/ref/OscillatorStrength"], 
         "RelativeStrength" :> 
         Documentation`HelpLookup[
          "paclet:ResonanceAbsorptionLines/ref/RelativeStrength"], 
         "TransitionProbability" :> 
         Documentation`HelpLookup[
          "paclet:ResonanceAbsorptionLines/ref/TransitionProbability"], 
         "UpperStatisticalWeight" :> 
         Documentation`HelpLookup[
          "paclet:ResonanceAbsorptionLines/ref/UpperStatisticalWeight"], 
         "VacuumWavelength" :> 
         Documentation`HelpLookup[
          "paclet:ResonanceAbsorptionLines/ref/VacuumWavelength"], 
         "WavelengthAbsorptionMap" :> 
         Documentation`HelpLookup[
          "paclet:ResonanceAbsorptionLines/ref/WavelengthAbsorptionMap"]}, #, 
        2]& , Evaluator -> Automatic], {1->"\<\"AirWavelength\"\>", 
      2->"\<\"AtomicData\"\>", 3->"\<\"DampingConstant\"\>", 
      4->"\<\"ElementAbsorptionMap\"\>", 5->"\<\"FindIons\"\>", 
      6->"\<\"LowerStatisticalWeight\"\>", 
      7->"\<\"LowerTermFineStructureEnergy\"\>", 
      8->"\<\"OscillatorStrength\"\>", 9->"\<\"RelativeStrength\"\>", 
      10->"\<\"TransitionProbability\"\>", 
      11->"\<\"UpperStatisticalWeight\"\>", 12->"\<\"VacuumWavelength\"\>", 
      13->"\<\"WavelengthAbsorptionMap\"\>"}, "\<\"functions\"\>", 
      StyleBox["\<\"functions\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Resonance Absorption Lines Package", "Title",
 CellID->8540],

Cell[TextData[{
 "The functions defined in ",
 StyleBox["ResonanceAbsorptionLines`", "MR"],
 " allow you to efficiently search through an atomic data table for resonance \
absorption lines. Other functions give absorption maps of particular elements \
or of a particular wavelength range. "
}], "Text",
 CellID->5642],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["FindIons",
      BaseStyle->"Link",
      ButtonData->"paclet:ResonanceAbsorptionLines/ref/FindIons"], "[", 
     StyleBox["wavelength1", "TI"], ",", 
     StyleBox["wavelength2", "TI"], "]"}], Cell[TextData[{
     "give the resonance absorption lines in the wavelength range between ",
     StyleBox["wavelength1", "TI"],
     " and ",
     StyleBox["wavelength2", "TI"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->12796],

Cell["Finding the resonance absorption lines. ", "Caption",
 CellID->3234],

Cell["This loads the package. ", "MathCaption",
 CellID->23535],

Cell[BoxData[
 RowBox[{"<<", "ResonanceAbsorptionLines`"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20537],

Cell["\<\
This gives the resonance absorption lines in the wavelength range between \
1215 Angstrom and 1220 Angstrom. \
\>", "MathCaption",
 CellID->3317],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindIons", "[", 
  RowBox[{
   RowBox[{"1215", " ", "Angstrom"}], ",", 
   RowBox[{"1220", " ", "Angstrom"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2408],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Hydrogen", ",", "\<\"I\"\>", ",", 
     RowBox[{"1215.6701`", " ", "Angstrom"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"Hydrogen", ",", "\<\"I\"\>", ",", 
     RowBox[{"1215.6737`", " ", "Angstrom"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"Hydrogen", ",", "\<\"I\"\>", ",", 
     RowBox[{"1215.6683`", " ", "Angstrom"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"Deuterium", ",", "\<\"I\"\>", ",", 
     RowBox[{"1215.3394`", " ", "Angstrom"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"Deuterium", ",", "\<\"I\"\>", ",", 
     RowBox[{"1215.343`", " ", "Angstrom"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"Deuterium", ",", "\<\"I\"\>", ",", 
     RowBox[{"1215.3376`", " ", "Angstrom"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"Oxygen", ",", "Vanadium", ",", 
     RowBox[{"1218.344`", " ", "Angstrom"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"Phosphorus", ",", "\<\"I\"\>", ",", 
     RowBox[{"1218.385`", " ", "Angstrom"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"Phosphorus", ",", "\<\"I\"\>", ",", 
     RowBox[{"1217.843`", " ", "Angstrom"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"Sulfur", ",", "\<\"I\"\>", ",", 
     RowBox[{"1218.5953`", " ", "Angstrom"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"Sulfur", ",", "\<\"I\"\>", ",", 
     RowBox[{"1218.57`", " ", "Angstrom"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"Sulfur", ",", "\<\"I\"\>", ",", 
     RowBox[{"1218.5133`", " ", "Angstrom"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"Manganese", ",", "\<\"II\"\>", ",", 
     RowBox[{"1219.604`", " ", "Angstrom"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"Manganese", ",", "\<\"II\"\>", ",", 
     RowBox[{"1218.745`", " ", "Angstrom"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"Manganese", ",", "\<\"II\"\>", ",", 
     RowBox[{"1218.704`", " ", "Angstrom"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{486, 135},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->11795939]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["AtomicData",
      BaseStyle->"Link",
      ButtonData->"paclet:ResonanceAbsorptionLines/ref/AtomicData"], "[", 
     StyleBox["element", "TI"], "]"}], Cell["\<\
give the spectral data for the resonance absorption lines produced by the \
specified element\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["VacuumWavelength",
      BaseStyle->"Link",
      ButtonData->"paclet:ResonanceAbsorptionLines/ref/VacuumWavelength"], 
     "[", 
     StyleBox["element", "TI"], "]"}], Cell["\<\
give a list of the wavelength in vacuum for the resonance absorption lines \
produced by the specified element\
\>", "TableText"]}
  }]], "DefinitionBox",
 CellID->7745],

Cell["Properties of resonance absorption lines. ", "Caption",
 CellID->21280],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["AtomicData",
    BaseStyle->"Link",
    ButtonData->"paclet:ResonanceAbsorptionLines/ref/AtomicData"], "[", 
   StyleBox["element", "TI"], "]"}]], "InlineFormula"],
 " gives a list of properties for the lines produced by the specified \
element. These properties are vacuum wavelength, air wavelength, lower term \
fine structure energy, statistical weight of the lower level, statistical \
weight of the upper level, relative strength, transition probability, damping \
constant, and oscillator strength of the element. Individual properties can \
be selected using the functions ",
 Cell[BoxData[
  ButtonBox["VacuumWavelength",
   BaseStyle->"Link",
   ButtonData->"paclet:ResonanceAbsorptionLines/ref/VacuumWavelength"]], 
  "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["AirWavelength",
   BaseStyle->"Link",
   ButtonData->"paclet:ResonanceAbsorptionLines/ref/AirWavelength"]], 
  "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["LowerTermFineStructureEnergy",
   BaseStyle->"Link",
   ButtonData->
    "paclet:ResonanceAbsorptionLines/ref/LowerTermFineStructureEnergy"]], 
  "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["LowerStatisticalWeight",
   BaseStyle->"Link",
   ButtonData->"paclet:ResonanceAbsorptionLines/ref/LowerStatisticalWeight"]],
   "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["UpperStatisticalWeight",
   BaseStyle->"Link",
   ButtonData->"paclet:ResonanceAbsorptionLines/ref/UpperStatisticalWeight"]],
   "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["RelativeStrength",
   BaseStyle->"Link",
   ButtonData->"paclet:ResonanceAbsorptionLines/ref/RelativeStrength"]], 
  "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["TransitionProbability",
   BaseStyle->"Link",
   ButtonData->"paclet:ResonanceAbsorptionLines/ref/TransitionProbability"]], 
  "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["DampingConstant",
   BaseStyle->"Link",
   ButtonData->"paclet:ResonanceAbsorptionLines/ref/DampingConstant"]], 
  "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["OscillatorStrength",
   BaseStyle->"Link",
   ButtonData->"paclet:ResonanceAbsorptionLines/ref/OscillatorStrength"]], 
  "InlineFormula"],
 ". "
}], "Text",
 CellID->1116],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["AirWavelength",
      BaseStyle->"Link",
      ButtonData->"paclet:ResonanceAbsorptionLines/ref/AirWavelength"], "[", 
     StyleBox["element", "TI"], "]"}], Cell[TextData[{
     "give a list of ",
     Cell[BoxData["{"], "InlineFormula"],
     Cell[BoxData[
      SubscriptBox[
       StyleBox["wavelength", "TI"], 
       StyleBox["v", "TI"]]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["wavelength", "TI"], 
       StyleBox["a", "TI"]]], "InlineFormula"],
     "}",
     StyleBox[" pairs, where ", "TR"],
     Cell[BoxData[
      SubscriptBox[
       StyleBox["wavelength", "TI"], 
       StyleBox["v", "TI"]]], "InlineFormula"],
     " is the wavelength in vacuum and ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["wavelength", "TI"], 
       StyleBox["a", "TI"]]], "InlineFormula"],
     " is the wavelength in air for the resonance absorption lines produced \
by the specified element"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["LowerTermFineStructureEnergy",
      BaseStyle->"Link",
      ButtonData->
       "paclet:ResonanceAbsorptionLines/ref/LowerTermFineStructureEnergy"], 
     "[", 
     StyleBox["element", "TI"], "]"}], Cell[TextData[{
     "give a list of ",
     Cell[BoxData["{"], "InlineFormula"],
     Cell[BoxData[
      SubscriptBox[
       StyleBox["wavelength", "TI"], 
       StyleBox["v", "TI"]]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      RowBox[{
       StyleBox["energy", "TI"], "}"}]], "InlineFormula"],
     " pairs, where ",
     Cell[BoxData[
      StyleBox["energy", "TI"]], "InlineFormula"],
     " is the energy of the fine structure level in the lower term for the \
lines produced by the specified element"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["LowerStatisticalWeight",
      BaseStyle->"Link",
      ButtonData->
       "paclet:ResonanceAbsorptionLines/ref/LowerStatisticalWeight"], "[", 
     StyleBox["element", "TI"], "]"}], Cell[TextData[{
     "give a list of ",
     Cell[BoxData["{"], "InlineFormula"],
     Cell[BoxData[
      SubscriptBox[
       StyleBox["wavelength", "TI"], 
       StyleBox["v", "TI"]]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      RowBox[{
       StyleBox["weight", "TI"], "}"}]], "InlineFormula"],
     " pairs, where ",
     Cell[BoxData[
      StyleBox["weight", "TI"]], "InlineFormula"],
     " is the statistical weight of the lower level for the lines produced by \
the specified element"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["UpperStatisticalWeight",
      BaseStyle->"Link",
      ButtonData->
       "paclet:ResonanceAbsorptionLines/ref/UpperStatisticalWeight"], "[", 
     StyleBox["element", "TI"], "]"}], Cell[TextData[{
     "give a list of ",
     Cell[BoxData["{"], "InlineFormula"],
     Cell[BoxData[
      SubscriptBox[
       StyleBox["wavelength", "TI"], 
       StyleBox["v", "TI"]]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      RowBox[{
       StyleBox["weight", "TI"], "}"}]], "InlineFormula"],
     " pairs, where ",
     Cell[BoxData[
      StyleBox["weight", "TI"]], "InlineFormula"],
     " is the statistical weight of the upper level for the lines produced by \
the specified element"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["RelativeStrength",
      BaseStyle->"Link",
      ButtonData->"paclet:ResonanceAbsorptionLines/ref/RelativeStrength"], 
     "[", 
     StyleBox["element", "TI"], "]"}], Cell[TextData[{
     "give a list of ",
     Cell[BoxData["{"], "InlineFormula"],
     Cell[BoxData[
      SubscriptBox[
       StyleBox["wavelength", "TI"], 
       StyleBox["v", "TI"]]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      RowBox[{
       StyleBox["strength", "TI"], "}"}]], "InlineFormula"],
     " pairs, where ",
     Cell[BoxData[
      StyleBox["strength", "TI"]], "InlineFormula"],
     " is the relative strength of the lines produced by the specified \
element"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["TransitionProbability",
      BaseStyle->"Link",
      ButtonData->
       "paclet:ResonanceAbsorptionLines/ref/TransitionProbability"], "[", 
     StyleBox["element", "TI"], "]"}], Cell[TextData[{
     "give a list of ",
     Cell[BoxData["{"], "InlineFormula"],
     Cell[BoxData[
      SubscriptBox[
       StyleBox["wavelength", "TI"], 
       StyleBox["v", "TI"]]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      RowBox[{
       StyleBox["probability", "TI"], "}"}]], "InlineFormula"],
     " pairs, where ",
     Cell[BoxData[
      StyleBox["probability", "TI"]], "InlineFormula"],
     " is the spontaneous transition probability of the lines produced by the \
specified element"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["DampingConstant",
      BaseStyle->"Link",
      ButtonData->"paclet:ResonanceAbsorptionLines/ref/DampingConstant"], "[",
      
     StyleBox["element", "TI"], "]"}], Cell[TextData[{
     "give a list of ",
     Cell[BoxData["{"], "InlineFormula"],
     Cell[BoxData[
      SubscriptBox[
       StyleBox["wavelength", "TI"], 
       StyleBox["v", "TI"]]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      RowBox[{
       StyleBox["damping", "TI"], "}"}]], "InlineFormula"],
     " pairs, where ",
     Cell[BoxData[
      StyleBox["damping", "TI"]], "InlineFormula"],
     " is a natural damping constant of the lines produced by the specified \
element"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["OscillatorStrength",
      BaseStyle->"Link",
      ButtonData->"paclet:ResonanceAbsorptionLines/ref/OscillatorStrength"], 
     "[", 
     StyleBox["element", "TI"], "]"}], Cell[TextData[{
     "give a list of ",
     Cell[BoxData["{"], "InlineFormula"],
     Cell[BoxData[
      SubscriptBox[
       StyleBox["wavelength", "TI"], 
       StyleBox["v", "TI"]]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      RowBox[{
       StyleBox["strength", "TI"], "}"}]], "InlineFormula"],
     " pairs, where ",
     Cell[BoxData[
      StyleBox["strength", "TI"]], "InlineFormula"],
     " is the absorption oscillator strength of the lines produced by the \
specified element"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->18889],

Cell["\<\
Properties of resonance absorption lines paired with associated wavelengths \
in vacuum. \
\>", "Caption",
 CellID->21521],

Cell["\<\
This gives a list of pairs of vacuum wavelength and oscillator strength for \
the resonance absorption lines produced by Beryllium. \
\>", "MathCaption",
 CellID->13249],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OscillatorStrength", "[", "Beryllium", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->11916],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1036.299`", " ", "Angstrom"}], ",", "0.053453`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1036.3057`", " ", "Angstrom"}], ",", "0.080179`"}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1036.319`", " ", "Angstrom"}], ",", "0.026726`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1661.478`", " ", "Angstrom"}], ",", "0.024831`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2349.329`", " ", "Angstrom"}], ",", "1.3554`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"3131.327`", " ", "Angstrom"}], ",", "0.33817`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"3131.5423`", " ", "Angstrom"}], ",", "0.50722`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"3131.973`", " ", "Angstrom"}], ",", "0.16905`"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{408, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->269279137]
}, Open  ]],

Cell["\<\
The ionization level of an element can be specified by giving the quoted \
roman numeral, \"I\", \"II\", \"III\", \"IV\", \"V\", or \"VI\", as a second \
argument to a property function. \
\>", "Text",
 CellID->21937],

Cell["\<\
This gives the paired data for vacuum wavelength and oscillator strength for \
the lines produced by Beryllium at the ionization level I. \
\>", "MathCaption",
 CellID->8908],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OscillatorStrength", "[", 
  RowBox[{"Beryllium", ",", "\"\<I\>\""}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->3044],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1661.478`", " ", "Angstrom"}], ",", "0.024831`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2349.329`", " ", "Angstrom"}], ",", "1.3554`"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{394, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->34331738]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["WavelengthAbsorptionMap",
      BaseStyle->"Link",
      ButtonData->
       "paclet:ResonanceAbsorptionLines/ref/WavelengthAbsorptionMap"], "[", 
     StyleBox["wavelength1", "TI"], ",", 
     StyleBox["wavelength2", "TI"], "]"}], Cell[TextData[{
     "give the absorption map in the wavelength range between ",
     StyleBox["wavelength1", "TI"],
     " and ",
     StyleBox["wavelength2", "TI"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ElementAbsorptionMap",
      BaseStyle->"Link",
      ButtonData->"paclet:ResonanceAbsorptionLines/ref/ElementAbsorptionMap"],
      "[", 
     StyleBox["element", "TI"], "]"}], Cell[
    "give the absorption map of the specified element", "TableText"]},
   {
    RowBox[{
     ButtonBox["ElementAbsorptionMap",
      BaseStyle->"Link",
      ButtonData->"paclet:ResonanceAbsorptionLines/ref/ElementAbsorptionMap"],
      "[", 
     StyleBox["element", "TI"], ",", 
     StyleBox["ionstage", "TI"], "]"}], Cell["\<\
give the absorption map of the element at the specified ionization level\
\>", "TableText"]}
  }]], "DefinitionBox",
 CellID->17192],

Cell["Absorption maps. ", "Caption",
 CellID->25920],

Cell["\<\
This gives the absorption map in the range between 1213 Angstrom and 1215 \
Angstrom. \
\>", "MathCaption",
 CellID->7740],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WavelengthAbsorptionMap", "[", 
  RowBox[{
   RowBox[{"1213", " ", "Angstrom"}], ",", 
   RowBox[{"1218", " ", "Angstrom"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->4908],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWs1OGzEQdrKbJUlVUZJURBBVHHpCIJEQ0ipCJRxoTz1W4kSJUCU4VI0o
6nPkDaC9cOIBOOUxOPIoW493nfXO/theoFLFWMraY8/4+zzj2UViPo8vTr99
H1+cnYzXPp2PJ6dnJz/XPv4451NOibHSKWPsV5vxsc9H4gftjP+CYfaIVYIu
aDB2eV/mAwcmXHW1J2edaLasaItpR6L7rKvRj+++rdGGvmyop7LQsZb7BsvC
emFuHZiEhvh8WN6ysE1jWRS3q7N1I92kf7TWFbTGdqzx+CVlJegjH+f4Asup
frawd8Nb8xDMrom93s8WDFJviDWDfM+nxxdmyyk+S9dW9wS5b2RV0XgnByt2
RjOOrsaX+X5Q3gzWSGbnkkhmvrPTlu85M+1insq4/Vnz2tuwZWgX84Shvoqz
/cR2Gfe1kGXgUfUrpt5P9YvWQ/OyT7ubWXplzT55646GRzyvgIrJXyr10A9f
WDAOn8p5XiA5iNpsNhuNRsKdik+DWbyDbke8HsTu/v6+3W7z7Y6Pjy8vLxN+
rgqZr3NQiNtLSxRPyAcHB57nzVF1rEC+vr6O7IufEq/b6hutRxkQerGW5kWK
eR6rZxLzJRRjD8lvkf5iasQWlQjBcBVZNVEEWsjDTaS/j+SBkAOw+VkSZ3uj
OcvAiHtXw3WKuDQJm7AJm7AJm7AJm7AJm7AJm7AJm7AJm7AJm7AJm7AJm7AJ
m7AJm7CfHXbwf8fJZDISjS3Bw+n1eq1WC4aekPv9fqPRgOEAHpXhcFiv1/nU
ysrKxsYGWxRaXOaKMOwKeXl52XGAIRNbAZfNzU0YToXc6XTW19dhWBXy4eGh
L1rsf6L83DPRWAMezu3tbSh7SB7wB4iv0HxPyDc3N6HcRPIU6VeFfHd3F2MD
Q1yvAT6GY8mKFREoRYbm8d/Aj+owoR/y3mVRFcmVH1WXQv9amItnjcmqs+TT
oCJvR6sxTGjgSqArJOP11qOxfZ/Q2JUu9WVjKXaq/zKYVbOYQZWOrBDORhj4
Sj0P9p4Rv/yTR0wliovuVdJ77zRxeTpu0C+k83mMu2bARmaezBgIoBdyEBkZ
q7tOyze1BjzIN9g+uzZrNdSVlWFqjkOh8J5mfddP1mgDhz9C7KBT2tfe7j14
B7Nc+53gK7XkG86cp52lLT8HrTJjfsUsgV/F2GOmVab7Be0+2EYzvWJVH8sC
djaRhLzzwryqhXmmyvl5BRtl5/SRn/9dbuTufaQ9p/5917DwxDixm5kfbTC+
+g/5zgFSdgYcodniGKan+dcRAu/pvz75twq2oxtLN1Yq/k83lpX+Al09nwc=
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->11614649]
}, Open  ]],

Cell["Here is the absorption map of Hydrogen. ", "MathCaption",
 CellID->14262],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ElementAbsorptionMap", "[", "Hydrogen", "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->16790],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnMuKGkEUhqvbHpIJQQITdHa6mVvcJ5DF4GriJiD9BMogKBLSTAZUCLgR
fASXbgQXgq/gsvduTFY+go9gTl1MlzXtbbyMA39DV51L1TlfnZbu2pTf84/F
wo/8Y+k+n/z2kPeKpftfybufD2SKWIxZRcbY73NG8pQkcfOrRLcUF0sX1No0
IUJ9RPVcTynd1vx6f2P4bWO+7g+Lc234mSNw1GVGEQbls0OinQn3FW8js9VP
5SSlMzVL9/PozAn0+RHmjLAIV0sjcHGtCOb4tZm4eLkk4zpVEASn/3U5Sm9X
EnwQ9kv1rBxUfd2qb0Ugq37xZB7q/5z6Lxu/SfX19+G8J3WIuodmvtlPtYMI
C9dsZt5lldmJnv+gv/Q5S+RQ9X6y3gWZt1px8C631btE/96mpuG7Af17revm
fNNv9tdbzpf7AL6QdfY+vAAlJi6tAm+Mipyu0N8euf/YeI5hPbRpZpbq8fRf
k3+/T/+TMfrLCv3zhuNjoVl5U9iZR+z/3ler1Vqt1u12Pc/zfb/ZbJKZ5PF4
TMJoNKIBcqeYzWbVzBOh53K5yWTCxXdCJ4VMXDwXejQaHQ6HXPwqdNd1b29v
ufhH6J1OJx6Pz+It4kun05lMplKpkNBut2UGkgeDAQnUkqzvZAO+ZDIpF6H4
SCFTwGdZVq/Xm/HZiUTir7CXy2XHccAFLnCBC1zgAhe4wAUucIELXOACF7jA
BS5wgQtc4AIXuMAFLnCBC1zgAhe4wAUucIELXOACF7jABS5wgQtc4AIXuMAF
LnCBC1zg2gdXvV5vNBr9fp8E3/dbrRaZSZYpqSVZcknkgMvzPPNcH5kCrlgs
pp3rs13XlVwES4yLuXhT2JnnZU5gnhmjPhr6rk+xmvE3zffSfM/JjzPXr9W/
+zPX2j8vWP8A/xZKZw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 124},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->63614240]
}, Open  ]],

Cell["You can zoom in on a particular area of the spectrum. ", "MathCaption",
 CellID->7102],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ElementAbsorptionMap", "[", 
  RowBox[{"Hydrogen", ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"915", ",", "950"}], "}"}], ",", "All"}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->17210],

Cell[BoxData[
 GraphicsBox[
  {Thickness[0], LineBox[{{1215.6701, 0}, {1215.6701, 1}}], 
   LineBox[{{1215.6737, 0}, {1215.6737, 1}}], 
   LineBox[{{1215.6683, 0}, {1215.6683, 1}}], 
   LineBox[{{1025.7223, 0}, {1025.7223, 1}}], 
   LineBox[{{1025.723, 0}, {1025.723, 1}}], 
   LineBox[{{1025.7219, 0}, {1025.7219, 1}}], 
   LineBox[{{972.5368, 0}, {972.5368, 1}}], 
   LineBox[{{972.5371, 0}, {972.5371, 1}}], 
   LineBox[{{972.5367, 0}, {972.5367, 1}}], 
   LineBox[{{949.7431, 0}, {949.7431, 1}}], 
   LineBox[{{937.8035, 0}, {937.8035, 1}}], 
   LineBox[{{930.7483, 0}, {930.7483, 1}}], 
   LineBox[{{926.2257, 0}, {926.2257, 1}}], 
   LineBox[{{923.1504, 0}, {923.1504, 1}}], 
   LineBox[{{920.9631, 0}, {920.9631, 1}}], 
   LineBox[{{919.3514, 0}, {919.3514, 1}}], 
   LineBox[{{918.1294, 0}, {918.1294, 1}}], 
   LineBox[{{917.1806, 0}, {917.1806, 1}}]},
  AspectRatio->0.3,
  Frame->True,
  FrameTicks->{Automatic, None},
  ImageMargins->0.,
  ImageSize->Medium,
  PlotRange->{{915, 950}, All}]], "Output",
 ImageSize->{364, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->439715375]
}, Open  ]],

Cell["\<\
Here is the absorption map of Carbon at the ionization level I. \
\>", "MathCaption",
 CellID->22412],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ElementAbsorptionMap", "[", 
  RowBox[{"Carbon", ",", "\"\<I\>\""}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->23390],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzt3D2L4kAYB/BJJr4cohEEORBkuwNtxO/gugt7rdccciKHWhwe6zbWsbG1
8BuIrd/Aws5msbQSK73K0nLvmUk0uWyixtvlrvgHTOaZPJn5zeTFbj7Xnprf
f9SeWvXaTfmx9rPZqndubtuPVMUVxpQmY6z7kVH5hUryJ7YW/cyiu1SiPac0
psnQ2jgFquN4R0eNjqqr3n3+dCv3Vl/ueueRsVux5wf5i1lrxcwy+MWiKK8P
Hc9fcJVvK47zWsDr7wPkH2K6gUwRxzeZh7LYaXYcfA7Kfyn493Nwd4XA73pR
vGYG1UN92Hkv/O+IxwzYdzFAe+8y/qB9B37+PEYfco5e5PELBaUAs35qFkre
I3nlev/3oWTdf83xHLi/sH5fVuf5U9ef/0KLwfj/o3iW6Npv9PtgjsznjRbF
pCvWEb+KVc+ZfHBlfjkTly5uWewUj9b8s7+6siNXZonnNKwoCgvruk5HCrvd
LhVGo5F8crR2u01hLBbb7XbSEul0OsVisdFopNNpVVWHw+FisWAh2dd6vaZa
UfwkY8Mw8vn8sW9erVa32+2hZ8b3+30qlaI9+3WI+/0+dWW1d84eZdbLxrk4
k0wmTTVtTG7j8ViquVkTCoXkN5bxTCZTr9dtSaVSsT4Mpjwej1uxKadJGAwG
dj41TOdns5klX61W0Wh0Op1CDjnkkEMOOeSQQw455JBDDjnkkEMOOeSQQw45
5JBDDjnkkEMOOeSQQw455JBDDjnkkEMOOeSQQw455JBDDjnkkEMOOeSQQw45
5JBDDjnkkEN+lIulaZhc3kJWJxIJKuRyOdOv67rppw5MPw1NVVWRZvoLhYJh
GLan1+v94c9ms+aaGZY/EolMJhM7fz6fU/5yubT8m82GpuT5+fkCv9i91Sof
l2UFXd/Ef4WScy39D2u8uGPvkXBXJlbPCTKTrlWJlN9YbtZo\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 121},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->68350183]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Resonance Absorption Lines Package - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 7, 47.4111776}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Resonance Absorption Lines Package Tutorial", "language" -> "en", 
    "paclet" -> "ResonanceAbsorptionLines Package", "status" -> "None", 
    "summary" -> 
    "The functions defined in ResonanceAbsorptionLines` allow you to \
efficiently search through an atomic data table for resonance absorption \
lines. Other functions give absorption maps of particular elements or of a \
particular wavelength range. Finding the resonance absorption lines. This \
loads the package. ", "synonyms" -> {}, "title" -> 
    "Resonance Absorption Lines Package", "type" -> "Tutorial", "uri" -> 
    "ResonanceAbsorptionLines/tutorial/ResonanceAbsorptionLines"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 2751, 58, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3376, 85, 66, 1, 70, "Title",
 CellID->8540],
Cell[3445, 88, 317, 7, 70, "Text",
 CellID->5642],
Cell[3765, 97, 490, 14, 70, "DefinitionBox",
 CellID->12796],
Cell[4258, 113, 74, 1, 70, "Caption",
 CellID->3234],
Cell[4335, 116, 63, 1, 70, "MathCaption",
 CellID->23535],
Cell[4401, 119, 108, 3, 70, "Input",
 CellID->20537],
Cell[4512, 124, 155, 4, 70, "MathCaption",
 CellID->3317],
Cell[CellGroupData[{
Cell[4692, 132, 190, 6, 28, "Input",
 CellID->2408],
Cell[4885, 140, 2069, 52, 156, "Output",
 CellID->11795939]
}, Open  ]],
Cell[6969, 195, 717, 21, 70, "DefinitionBox",
 CellID->7745],
Cell[7689, 218, 77, 1, 70, "Caption",
 CellID->21280],
Cell[7769, 221, 2258, 69, 70, "Text",
 CellID->1116],
Cell[10030, 292, 6262, 195, 70, "DefinitionBox",
 CellID->18889],
Cell[16295, 489, 132, 4, 70, "Caption",
 CellID->21521],
Cell[16430, 495, 179, 4, 70, "MathCaption",
 CellID->13249],
Cell[CellGroupData[{
Cell[16634, 503, 118, 3, 70, "Input",
 CellID->11916],
Cell[16755, 508, 1052, 33, 88, "Output",
 CellID->269279137]
}, Open  ]],
Cell[17822, 544, 227, 5, 70, "Text",
 CellID->21937],
Cell[18052, 551, 184, 4, 70, "MathCaption",
 CellID->8908],
Cell[CellGroupData[{
Cell[18261, 559, 148, 4, 70, "Input",
 CellID->3044],
Cell[18412, 565, 400, 14, 36, "Output",
 CellID->34331738]
}, Open  ]],
Cell[18827, 582, 1160, 33, 70, "DefinitionBox",
 CellID->17192],
Cell[19990, 617, 52, 1, 70, "Caption",
 CellID->25920],
Cell[20045, 620, 132, 4, 70, "MathCaption",
 CellID->7740],
Cell[CellGroupData[{
Cell[20202, 628, 205, 6, 28, "Input",
 CellID->4908],
Cell[20410, 636, 1554, 30, 139, "Output",
 Evaluatable->False,
 CellID->11614649]
}, Open  ]],
Cell[21979, 669, 79, 1, 70, "MathCaption",
 CellID->14262],
Cell[CellGroupData[{
Cell[22083, 674, 119, 3, 28, "Input",
 CellID->16790],
Cell[22205, 679, 1147, 23, 145, "Output",
 Evaluatable->False,
 CellID->63614240]
}, Open  ]],
Cell[23367, 705, 92, 1, 70, "MathCaption",
 CellID->7102],
Cell[CellGroupData[{
Cell[23484, 710, 295, 10, 70, "Input",
 CellID->17210],
Cell[23782, 722, 1146, 30, 140, "Output",
 CellID->439715375]
}, Open  ]],
Cell[24943, 755, 111, 3, 70, "MathCaption",
 CellID->22412],
Cell[CellGroupData[{
Cell[25079, 762, 148, 4, 28, "Input",
 CellID->23390],
Cell[25230, 768, 1175, 23, 142, "Output",
 Evaluatable->False,
 CellID->68350183]
}, Open  ]]
}, Open  ]],
Cell[26432, 795, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

