(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10200,        339]
NotebookOptionsPosition[      7933,        263]
NotebookOutlinePosition[      9142,        299]
CellTagsIndexPosition[      9058,        294]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["SPLINES PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Spline" :> 
         Documentation`HelpLookup["paclet:Splines/ref/Spline"], "SplineFit" :> 
         Documentation`HelpLookup["paclet:Splines/ref/SplineFit"], 
         "CompositeBezier" :> 
         Documentation`HelpLookup["paclet:Splines/ref/CompositeBezier"], 
         "Cubic" :> Documentation`HelpLookup["paclet:Splines/ref/Cubic"]}, #, 
        2]& , Evaluator -> Automatic], {1->"\<\"Spline\"\>", 
      2->"\<\"SplineFit\"\>", 3->"\<\"CompositeBezier\"\>", 
      4->"\<\"Cubic\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Bezier", "ObjectName",
 CellID->16552],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Bezier"], "InlineFormula"],
     " \[LineSeparator]is a setting specifying the type of spline generated \
by ",
     Cell[BoxData[
      ButtonBox["Spline",
       BaseStyle->"Link",
       ButtonData->"paclet:Splines/ref/Spline"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["SplineFit",
       BaseStyle->"Link",
       ButtonData->"paclet:Splines/ref/SplineFit"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->15874]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
A Bezier spline interpolates only the endpoints. The other points control the \
spline, forming a convex hull. \
\>", "Notes",
 CellID->16977],

Cell[TextData[{
 "Given n points, a spline of degree ",
 Cell[BoxData[
  StyleBox[
   RowBox[{
    StyleBox["n", "TI"], "\[Dash]", 
    StyleBox["1", "TR"]}]]], "InlineFormula"],
 " is created."
}], "Notes",
 CellID->13697]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->979151220],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->46633590],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Splines`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->428080665],

Cell["Bezier splines only go through the endpoints:", "ExampleText",
 CellID->515573858],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Spline", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}]}], "}"}], ",", " ", "Bezier"}], "]"}],
     ",", "\[IndentingNewLine]", 
    RowBox[{"Point", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1832633730],

Cell[BoxData[
 GraphicsBox[{
   LineBox[{{0., 0.}, {0.124782986111111, 0.0100549768518519}, {
    0.248263888888889, 0.0387731481481481}, {0.369140625, 0.083984375}, {
    0.486111111111111, 0.143518518518519}, {0.597873263888889, 
    0.215205439814815}, {0.703125, 0.296875}, {0.800564236111111, 
    0.386357060185185}, {0.888888888888889, 0.481481481481482}, {0.966796875, 
    0.580078125}, {1.03298611111111, 0.679976851851852}, {1.08615451388889, 
    0.779007523148148}, {1.125, 0.875}, {1.13864474826389, 
    0.921178747106481}, {1.14822048611111, 0.965784143518518}, {
    1.153564453125, 1.008544921875}, {1.15459865993924, 1.02914880823206}, {
    1.15451388888889, 1.04918981481481}, {1.15090603298611, 
    1.08744755497685}, {1.14734225802951, 1.10559647171586}, {1.142578125, 
    1.123046875}, {1.12936740451389, 1.15571650752315}, {1.12088012695313, 
    1.17086791992188}, {1.11111111111111, 1.18518518518519}, {
    1.10004001193576, 1.19863439489294}, {1.087646484375, 1.211181640625}, {
    1.07391018337674, 1.22279301396123}, {1.06653213500977, 
    1.22823715209961}, {1.05881076388889, 1.23343460648148}, {
    1.02444118923611, 1.25167281539352}, {1.00513034396701, 
    1.25920161494502}, {0.984375, 1.265625}, {0.938449435763889, 
    1.27501989293981}, {0.886501736111111, 1.27958622685185}, {
    0.763888888888889, 1.27314814814815}, {0.615234375, 1.244140625}, {
    0.439236111111111, 1.19039351851852}, {0.234592013888889, 
    1.10973668981482}, {0., 1.}}], 
   PointBox[{{0, 0}, {1, 0}, {2, 2}, {0, 1}}]}]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->68425146]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->617],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Spline",
    BaseStyle->"Link",
    ButtonData->"paclet:Splines/ref/Spline"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SplineFit",
    BaseStyle->"Link",
    ButtonData->"paclet:Splines/ref/SplineFit"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CompositeBezier",
    BaseStyle->"Link",
    ButtonData->"paclet:Splines/ref/CompositeBezier"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Cubic",
    BaseStyle->"Link",
    ButtonData->"paclet:Splines/ref/Cubic"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->24968]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Bezier - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 7, 47.8330634}", "context" -> "Splines`", 
    "keywords" -> {}, "index" -> True, "label" -> "Splines Package Symbol", 
    "language" -> "en", "paclet" -> "Splines Package", "status" -> "None", 
    "summary" -> 
    "Bezier is a setting specifying the type of spline generated by Spline \
and SplineFit.", "synonyms" -> {}, "title" -> "Bezier", "type" -> "Symbol", 
    "uri" -> "Splines/ref/Bezier"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3169, 113, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->979151220]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 8915, 287}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 907, 20, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1530, 47, 44, 1, 70, "ObjectName",
 CellID->16552],
Cell[1577, 50, 662, 21, 70, "Usage",
 CellID->15874]
}, Open  ]],
Cell[CellGroupData[{
Cell[2276, 76, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2754, 93, 152, 4, 70, "Notes",
 CellID->16977],
Cell[2909, 99, 223, 9, 70, "Notes",
 CellID->13697]
}, Closed]],
Cell[CellGroupData[{
Cell[3169, 113, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->979151220],
Cell[CellGroupData[{
Cell[3554, 127, 147, 5, 70, "ExampleSection",
 CellID->46633590],
Cell[3704, 134, 130, 3, 70, "Input",
 CellID->428080665],
Cell[3837, 139, 88, 1, 70, "ExampleText",
 CellID->515573858],
Cell[CellGroupData[{
Cell[3950, 144, 900, 30, 47, "Input",
 CellID->1832633730],
Cell[4853, 176, 1686, 29, 201, "Output",
 CellID->68425146]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6600, 212, 309, 9, 70, "SeeAlsoSection",
 CellID->617],
Cell[6912, 223, 979, 35, 70, "SeeAlso",
 CellID->24968]
}, Open  ]],
Cell[7906, 261, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

