(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11535,        357]
NotebookOptionsPosition[      9205,        280]
NotebookOutlinePosition[     10451,        316]
CellTagsIndexPosition[     10366,        311]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["SPLINES PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Spline" :> 
         Documentation`HelpLookup["paclet:Splines/ref/Spline"], "SplineFit" :> 
         Documentation`HelpLookup["paclet:Splines/ref/SplineFit"], "Bezier" :> 
         Documentation`HelpLookup["paclet:Splines/ref/Bezier"], "Cubic" :> 
         Documentation`HelpLookup["paclet:Splines/ref/Cubic"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"Spline\"\>", 2->"\<\"SplineFit\"\>", 
      3->"\<\"Bezier\"\>", 4->"\<\"Cubic\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["CompositeBezier", "ObjectName",
 CellID->14419],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["CompositeBezier"], "InlineFormula"],
     " \[LineSeparator]is a setting specifying the type of spline generated \
by ",
     Cell[BoxData[
      ButtonBox["Spline",
       BaseStyle->"Link",
       ButtonData->"paclet:Splines/ref/Spline"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["SplineFit",
       BaseStyle->"Link",
       ButtonData->"paclet:Splines/ref/SplineFit"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->31851]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "A composite Bezier spline is made up of a series of third\[Hyphen]order \
Bezier curves with ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["C", "TI"], "1"], TraditionalForm]], "InlineFormula"],
 " continuity. It alternates interpolating points and control points. "
}], "Notes",
 CellID->8741],

Cell["\<\
If the number of points given is even, then the last two points are reversed \
so that the final point is interpolated and the next to last is a control \
point for the final segment; if odd, then the final vertex is doubled.\
\>", "Notes",
 CellID->25315]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->445419618],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->402499580],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Splines`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->503934402],

Cell["\<\
Composite Bezier splines go through some, but not all, of the points:\
\>", "ExampleText",
 CellID->515573858],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"pts", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Cos", "[", "t", "]"}], ",", 
       RowBox[{"Sin", "[", "t", "]"}]}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"t", ",", " ", "0", ",", " ", 
       RowBox[{
        RowBox[{"2", "Pi"}], "-", 
        RowBox[{"Pi", "/", "3"}]}], ",", " ", 
       RowBox[{"Pi", "/", "3"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Spline", "[", 
     RowBox[{"pts", ",", " ", "CompositeBezier"}], "]"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"Point", "[", "pts", "]"}]}], "}"}], "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->1832633730],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 188},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->307600455]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->19587],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Spline",
    BaseStyle->"Link",
    ButtonData->"paclet:Splines/ref/Spline"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SplineFit",
    BaseStyle->"Link",
    ButtonData->"paclet:Splines/ref/SplineFit"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Bezier",
    BaseStyle->"Link",
    ButtonData->"paclet:Splines/ref/Bezier"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Cubic",
    BaseStyle->"Link",
    ButtonData->"paclet:Splines/ref/Cubic"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->20531]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CompositeBezier - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 7, 54.4894838}", "context" -> "Splines`", 
    "keywords" -> {}, "index" -> True, "label" -> "Splines Package Symbol", 
    "language" -> "en", "paclet" -> "Splines Package", "status" -> "None", 
    "summary" -> 
    "CompositeBezier is a setting specifying the type of spline generated by \
Spline and SplineFit.", "synonyms" -> {}, "title" -> "CompositeBezier", 
    "type" -> "Symbol", "uri" -> "Splines/ref/CompositeBezier"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3359, 112, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->445419618]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 10223, 304}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 862, 18, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1485, 45, 53, 1, 70, "ObjectName",
 CellID->14419],
Cell[1541, 48, 671, 21, 70, "Usage",
 CellID->31851]
}, Open  ]],
Cell[CellGroupData[{
Cell[2249, 74, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2727, 91, 326, 9, 70, "Notes",
 CellID->8741],
Cell[3056, 102, 266, 5, 70, "Notes",
 CellID->25315]
}, Closed]],
Cell[CellGroupData[{
Cell[3359, 112, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->445419618],
Cell[CellGroupData[{
Cell[3744, 126, 148, 5, 70, "ExampleSection",
 CellID->402499580],
Cell[3895, 133, 130, 3, 70, "Input",
 CellID->503934402],
Cell[4028, 138, 120, 3, 70, "ExampleText",
 CellID->515573858],
Cell[CellGroupData[{
Cell[4173, 145, 759, 24, 65, "Input",
 CellID->1832633730],
Cell[4935, 171, 2892, 51, 209, "Output",
 Evaluatable->False,
 CellID->307600455]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7888, 229, 311, 9, 70, "SeeAlsoSection",
 CellID->19587],
Cell[8202, 240, 961, 35, 70, "SeeAlso",
 CellID->20531]
}, Open  ]],
Cell[9178, 278, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

