(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     52017,       1362]
NotebookOptionsPosition[     47163,       1194]
NotebookOutlinePosition[     48454,       1231]
CellTagsIndexPosition[     48368,       1226]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["SPLINES PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"SplineFit" :> 
         Documentation`HelpLookup["paclet:Splines/ref/SplineFit"], "Bezier" :> 
         Documentation`HelpLookup["paclet:Splines/ref/Bezier"], 
         "CompositeBezier" :> 
         Documentation`HelpLookup["paclet:Splines/ref/CompositeBezier"], 
         "Cubic" :> Documentation`HelpLookup["paclet:Splines/ref/Cubic"]}, #, 
        2]& , Evaluator -> Automatic], {1->"\<\"SplineFit\"\>", 
      2->"\<\"Bezier\"\>", 3->"\<\"CompositeBezier\"\>", 
      4->"\<\"Cubic\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Spline", "ObjectName",
 CellID->29413],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Spline", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["pt", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["pt", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        StyleBox["type", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]is a two-dimensional graphics primitive which \
represents a spline of type ",
     Cell[BoxData[
      StyleBox["type", "TI"]], "InlineFormula"],
     " through (or controlled by) points ",
     Cell[BoxData[
      RowBox[{
       SubscriptBox[
        StyleBox["pt", "TI"], 
        StyleBox["1", "TR"]], ",", " ", 
       SubscriptBox[
        StyleBox["pt", "TI"], 
        StyleBox["2", "TR"]], ",", " ", 
       StyleBox["\[Ellipsis]", "TR"]}]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->2585]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Possible settings for ",
 Cell[BoxData[
  StyleBox["type", "TI"]], "InlineFormula"],
 " are:"
}], "Notes",
 CellID->26063],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Cubic",
     BaseStyle->"Link",
     ButtonData->"paclet:Splines/ref/Cubic"], Cell[
    "Cubic spline", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Bezier",
     BaseStyle->"Link",
     ButtonData->"paclet:Splines/ref/Bezier"], Cell[
    "Bezier spline", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["CompositeBezier",
     BaseStyle->"Link",
     ButtonData->"paclet:Splines/ref/CompositeBezier"], Cell[
    "Composite Bezier spline", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->25382],

Cell[TextData[{
 Cell[BoxData["Spline"], "InlineFormula"],
 " may be used along with other graphics primitives in a ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 " expression."
}], "Notes",
 CellID->7271],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"Spline", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["pt", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["pt", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    StyleBox["type", "TI"]}], "]"}]], "InlineFormula"],
 " produces a spline expression of the form ",
 Cell[BoxData[
  RowBox[{"Spline", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["pt", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["pt", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    StyleBox["type", "TI"], ",", 
    StyleBox["control", "TI"]}], "]"}]], "InlineFormula"],
 " where ",
 Cell[BoxData[
  StyleBox["control", "TI"]], "InlineFormula"],
 " is information which describes the spline completely."
}], "Notes",
 CellID->29892],

Cell[TextData[{
 "The information in ",
 Cell[BoxData[
  StyleBox["control", "TI"]], "InlineFormula"],
 " depends on the kind of spline used."
}], "Notes",
 CellID->22396],

Cell["The following options can be given:", "Notes",
 CellID->17239],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["SplinePoints",
     BaseStyle->"Link",
     ButtonData->"paclet:Splines/ref/SplinePoints"], "25", Cell["\<\
initial number of points sampled in default rendering of spline\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["SplineDots",
     BaseStyle->"Link",
     ButtonData->"paclet:Splines/ref/SplineDots"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "style to render interpolation or control points of curve", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], "MaxBend", "10.", Cell["\<\
maximum angle between successive segments when using adaptive rendering\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["SplineDivision",
     BaseStyle->"Link",
     ButtonData->"paclet:Splines/ref/SplineDivision"], "20.", Cell["\<\
maximum amount of subdivision to be used in attempting to generate a smooth \
curve\
\>", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->32110]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->324955593],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->119886310],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Splines`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->73229909],

Cell["Bezier spline controlled by four points:", "ExampleText",
 CellID->800558974],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Spline", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}]}], "}"}], ",", " ", "Bezier"}], "]"}],
     ",", "\[IndentingNewLine]", 
    RowBox[{"Point", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->153580769],

Cell[BoxData[
 GraphicsBox[{
   LineBox[{{0., 0.}, {0.124782986111111, 0.0100549768518519}, {
    0.248263888888889, 0.0387731481481481}, {0.369140625, 0.083984375}, {
    0.486111111111111, 0.143518518518519}, {0.597873263888889, 
    0.215205439814815}, {0.703125, 0.296875}, {0.800564236111111, 
    0.386357060185185}, {0.888888888888889, 0.481481481481482}, {0.966796875, 
    0.580078125}, {1.03298611111111, 0.679976851851852}, {1.08615451388889, 
    0.779007523148148}, {1.125, 0.875}, {1.13864474826389, 
    0.921178747106481}, {1.14822048611111, 0.965784143518518}, {
    1.153564453125, 1.008544921875}, {1.15459865993924, 1.02914880823206}, {
    1.15451388888889, 1.04918981481481}, {1.15090603298611, 
    1.08744755497685}, {1.14734225802951, 1.10559647171586}, {1.142578125, 
    1.123046875}, {1.12936740451389, 1.15571650752315}, {1.12088012695313, 
    1.17086791992188}, {1.11111111111111, 1.18518518518519}, {
    1.10004001193576, 1.19863439489294}, {1.087646484375, 1.211181640625}, {
    1.07391018337674, 1.22279301396123}, {1.06653213500977, 
    1.22823715209961}, {1.05881076388889, 1.23343460648148}, {
    1.02444118923611, 1.25167281539352}, {1.00513034396701, 
    1.25920161494502}, {0.984375, 1.265625}, {0.938449435763889, 
    1.27501989293981}, {0.886501736111111, 1.27958622685185}, {
    0.763888888888889, 1.27314814814815}, {0.615234375, 1.244140625}, {
    0.439236111111111, 1.19039351851852}, {0.234592013888889, 
    1.10973668981482}, {0., 1.}}], 
   PointBox[{{0, 0}, {1, 0}, {2, 2}, {0, 1}}]}]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->463603928]
}, Open  ]],

Cell["Cubic spline through four points:", "ExampleText",
 CellID->1009627563],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Spline", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}]}], "}"}], ",", " ", "Cubic"}], "]"}], 
    ",", "\[IndentingNewLine]", 
    RowBox[{"Point", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->951777575],

Cell[BoxData[
 GraphicsBox[{
   LineBox[{{0, 0}, {0.100390625, -0.090234375}, {0.203125, -0.171875}, {
     0.256103515625, -0.206787109375}, {0.310546875, -0.236328125}, {
     0.366748046875, -0.259423828125}, {
     0.395599365234375, -0.268218994140625}, {0.425, -0.275}, {
     0.485595703125, -0.281982421875}, {
     0.516864013671875, -0.281915283203125}, {0.548828125, -0.279296875}, {
     0.614990234375, -0.265869140625}, {
     0.649261474609375, -0.254791259765625}, {0.684375, -0.240625}, {
     0.757275390625, -0.202490234375}, {0.833984375, -0.150390625}, {1, 0}, {
     1.182421875, 0.214453125}, {1.371875, 0.478125}, {1.556640625, 
     0.771484375}, {1.725, 1.075}, {1.865234375, 1.369140625}, {1.965625, 
     1.634375}, {1.997216796875, 1.750048828125}, {2.014453125, 
     1.851171875}, {2.01723022460937, 1.89551391601562}, {2.015869140625, 
     1.935302734375}, {2.01018676757813, 1.97023315429687}, {2.00566787719727,
      1.98578109741211}, {2.00297899246216, 1.99305906295776}, {2, 2}, {
     1.99316711425781, 2.01286163330078}, {1.9851806640625, 
     2.02437744140625}, {1.97605895996094, 2.03456878662109}, {
     1.97107810974121, 2.03917446136475}, {1.9658203125, 2.04345703125}, {
     1.95448303222656, 2.05106353759766}, {1.9420654296875, 
     2.05740966796875}, {1.92858581542969, 2.06251678466797}, {
     1.92145347595215, 2.06461238861084}, {1.91779017448425, 
     2.06554687023163}, {1.9140625, 2.06640625}, {1.8819580078125, 
     2.07061767578125}, {1.8458984375, 2.07021484375}, {1.8060302734375, 
     2.06536865234375}, {1.7625, 2.05625}, {1.6650390625, 2.02587890625}, {
     1.5546875, 1.98046875}, {1.3, 1.85}, {1.0078125, 1.67578125}, {0.6875, 
     1.46875}, {0.3484375, 1.23984375}, {0, 1}}], 
   PointBox[{{0, 0}, {1, 0}, {2, 2}, {0, 1}}]}]], "Output",
 ImageSize->{184, 208},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->720546580]
}, Open  ]],

Cell["Composite Bezier spline controlled by six points:", "ExampleText",
 CellID->1542156394],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Spline", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}]}], "}"}], ",", " ", 
      "CompositeBezier"}], "]"}], ",", "\[IndentingNewLine]", 
    RowBox[{"Point", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}]}], "}"}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1583617330],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->3043833]
}, Open  ]],

Cell["Cubic spline through six points:", "ExampleText",
 CellID->1479385973],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Spline", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}]}], "}"}], ",", " ", "Cubic"}], "]"}], 
    ",", "\[IndentingNewLine]", 
    RowBox[{"Point", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}]}], "}"}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->566084627],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 196},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->672573391]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->23874],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "SplineDots",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->1757724783],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Splines`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->52329002],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SplineDots",
   BaseStyle->"Link",
   ButtonData->"paclet:Splines/ref/SplineDots"]], "InlineFormula"],
 " shows the control points:"
}], "ExampleText",
 CellID->1191189501],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Spline", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}]}], "}"}], ",", " ", "Cubic", ",", " ", 
    RowBox[{"SplineDots", "\[Rule]", "Red"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1117677677],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 196},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->92506145]
}, Open  ]],

Cell["Big purple points for the control points:", "ExampleText",
 CellID->2069101796],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{"Red", ",", 
    RowBox[{"Spline", "[", 
     RowBox[{
      RowBox[{"RandomReal", "[", 
       RowBox[{
        RowBox[{"{", "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"20", ",", "2"}], "}"}]}], "]"}], ",", " ", "Cubic", ",", 
      " ", 
      RowBox[{"SplineDots", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{
         RowBox[{"PointSize", "[", "0.05", "]"}], ",", " ", "Purple"}], 
        "]"}]}]}], "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->514926374],

Cell[BoxData[
 GraphicsBox[
  {RGBColor[1, 0, 0], 
   {RGBColor[0.5, 0, 0.5], PointSize[0.05], 
    PointBox[{0.359625938519984, 0.23671644080059}], 
    PointBox[{0.370852676753547, 0.881170682976156}], 
    PointBox[{0.347227594345646, 0.583147781767874}], 
    PointBox[{0.238489750719737, 0.064533654540998}], 
    PointBox[{0.718888716360513, 0.0506681429631886}], 
    PointBox[{0.0114892401298625, 0.746096149015443}], 
    PointBox[{0.500870111346405, 0.81146247408279}], 
    PointBox[{0.0503953403245445, 0.79802622487665}], 
    PointBox[{0.890890458118403, 0.341263758344988}], 
    PointBox[{0.151774885296513, 0.951321306254556}], 
    PointBox[{0.161515460155811, 0.796127646993493}], 
    PointBox[{0.348228875232538, 0.0996284258919964}], 
    PointBox[{0.230433599265218, 0.753690058125215}], 
    PointBox[{0.21224751925401, 0.938530140271581}], 
    PointBox[{0.192178168488162, 0.621332309077382}], 
    PointBox[{0.477205695218698, 0.870841668953325}], 
    PointBox[{0.257889397903805, 0.463896472793801}], 
    PointBox[{0.539668661935511, 0.367301833265931}], 
    PointBox[{0.158499027169053, 0.401651068650378}], 
    PointBox[{0.266469951557197, 0.668673410673715}]}, 
   LineBox[CompressedData["
1:eJwVVnk4FN77RSplK1KRJUmLUgntnNJY+2aNVLJMCREtlLUolTX1yZKlKLRY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    "]]}]], "Output",
 ImageSize->{181, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->200875863]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "SplinePoints",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->212027592],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Splines`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->206176541],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SplinePoints",
   BaseStyle->"Link",
   ButtonData->"paclet:Splines/ref/SplinePoints"]], "InlineFormula"],
 " determines how often to sample the spline for rendering:"
}], "ExampleText",
 CellID->80747979],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"Spline", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}]}], "}"}], ",", " ", "Bezier", ",", 
      " ", 
      RowBox[{"SplinePoints", "\[Rule]", "#"}], ",", " ", 
      RowBox[{"SplineDivision", "\[Rule]", "0"}]}], "]"}], "]"}], "&"}], "/@",
   
  RowBox[{"{", 
   RowBox[{"4", ",", "8", ",", " ", "16", ",", " ", "32"}], "}"}]}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->769257030],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    LineBox[{{0., 0.}, {0.888888888888889, 0.481481481481482}, {
     1.11111111111111, 1.18518518518519}, {0., 1.}}]], ",", 
   GraphicsBox[
    LineBox[{{0., 0.}, {0.419825072886297, 0.107871720116618}, {
     0.787172011661808, 0.373177842565598}, {1.04956268221574, 
     0.708454810495627}, {1.15451895043732, 1.02623906705539}, {
     1.04956268221574, 1.23906705539359}, {0.682215743440234, 
     1.25947521865889}, {0., 1.}}]], ",", 
   GraphicsBox[
    LineBox[{{0., 0.}, {0.199111111111111, 0.0251851851851852}, {
     0.392888888888889, 0.0948148148148148}, {0.576, 0.2}, {0.743111111111111,
      0.331851851851852}, {0.888888888888889, 0.481481481481482}, {1.008, 
     0.64}, {1.09511111111111, 0.798518518518519}, {1.14488888888889, 
     0.948148148148148}, {1.152, 1.08}, {1.11111111111111, 
     1.18518518518519}, {1.01688888888889, 1.25481481481481}, {0.864, 1.28}, {
     0.647111111111111, 1.25185185185185}, {0.360888888888889, 
     1.16148148148148}, {0., 1.}}]], ",", 
   GraphicsBox[
    LineBox[{{0., 0.}, {0.0966734919942265, 0.00607566043435937}, {
     0.192742774663489, 0.0236312980430331}, {0.287603638682824, 
     0.0516598972844147}, {0.380651874727267, 0.0891544426168977}, {
     0.471283273471854, 0.135107918498875}, {0.558893625591621, 
     0.188513309388742}, {0.642878721761606, 0.248363599744889}, {
     0.722634352656843, 0.313651774025712}, {0.797556308952368, 
     0.383370816689604}, {0.867040381323219, 0.456513712194958}, {
     0.93048236044443, 0.532073445000168}, {0.987278036991038, 
     0.609042999563627}, {1.03682320163808, 0.686415360343728}, {
     1.07851364506059, 0.763183511798865}, {1.1117451579336, 
     0.838340438387433}, {1.13591353093216, 0.910879124567823}, {
     1.15041455473129, 0.979792554798429}, {1.15464402000604, 
     1.04407371353765}, {1.14799771743144, 1.10271558524387}, {
     1.12987143768252, 1.15471115437548}, {1.09966097143433, 
     1.19905340539089}, {1.05676210936189, 1.23473532274848}, {
     1.00057064214024, 1.26074989090665}, {0.93048236044443, 
     1.27609009432379}, {0.845893054949482, 1.27974891745829}, {
     0.746198516330436, 1.27071934476855}, {0.630794535262328, 
     1.24799436071297}, {0.499076902420195, 1.21056694974992}, {
     0.350441408479072, 1.15743009633782}, {0.184283844113994, 
     1.08757678493505}, {0., 1.}}]]}], "}"}]], "Output",
 ImageSize->{390, 412},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->601865380]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "SplineDivision",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->94523507],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Splines`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->101446566],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SplineDivision",
   BaseStyle->"Link",
   ButtonData->"paclet:Splines/ref/SplineDivision"]], "InlineFormula"],
 " determines how much to refine the spline for rendering:"
}], "ExampleText",
 CellID->1042378315],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"Spline", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}]}], "}"}], ",", " ", "Bezier", ",", 
      " ", 
      RowBox[{"SplinePoints", "\[Rule]", "10"}], ",", " ", 
      RowBox[{"SplineDivision", "\[Rule]", "#"}]}], "]"}], "]"}], "&"}], "/@",
   
  RowBox[{"{", 
   RowBox[{"0", ",", "1", ",", "2", ",", "3"}], "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1814937740],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    LineBox[{{0., 0.}, {0.329218106995885, 0.0672153635116598}, {
     0.633744855967078, 0.241426611796982}, {0.888888888888889, 
     0.481481481481482}, {1.06995884773663, 0.746227709190672}, {
     1.1522633744856, 0.994513031550069}, {1.11111111111111, 
     1.18518518518519}, {0.921810699588478, 1.27709190672154}, {
     0.559670781893004, 1.22908093278464}, {0., 1.}}]], ",", 
   GraphicsBox[
    LineBox[{{0., 0.}, {0.166152263374486, 0.0176611796982167}, {
     0.329218106995885, 0.0672153635116598}, {0.486111111111111, 
     0.143518518518519}, {0.633744855967078, 0.241426611796982}, {
     0.769032921810699, 0.35579561042524}, {0.888888888888889, 
     0.481481481481482}, {0.990226337448559, 0.613340192043896}, {
     1.06995884773663, 0.746227709190672}, {1.125, 0.875}, {1.1522633744856, 
     0.994513031550069}, {1.14866255144033, 1.09962277091907}, {
     1.11111111111111, 1.18518518518519}, {1.03652263374486, 
     1.24605624142661}, {0.921810699588478, 1.27709190672154}, {
     0.763888888888889, 1.27314814814815}, {0.559670781893004, 
     1.22908093278464}, {0., 1.}}]], ",", 
   GraphicsBox[
    LineBox[{{0., 0.}, {0.0832690329218107, 0.00452246227709191}, {
     0.166152263374486, 0.0176611796982167}, {0.248263888888889, 
     0.0387731481481481}, {0.329218106995885, 0.0672153635116598}, {
     0.486111111111111, 0.143518518518519}, {0.633744855967078, 
     0.241426611796982}, {0.769032921810699, 0.35579561042524}, {
     0.888888888888889, 0.481481481481482}, {0.990226337448559, 
     0.613340192043896}, {1.03298611111111, 0.679976851851852}, {
     1.06995884773663, 0.746227709190672}, {1.10075874485597, 
     0.81144975994513}, {1.125, 0.875}, {1.14229681069959, 
     0.936235425240055}, {1.1522633744856, 0.994513031550069}, {
     1.15451388888889, 1.04918981481481}, {1.14866255144033, 
     1.09962277091907}, {1.13432355967078, 1.1451688957476}, {
     1.11111111111111, 1.18518518518519}, {1.07863940329218, 
     1.2190286351166}, {1.03652263374486, 1.24605624142661}, {0.984375, 
     1.265625}, {0.921810699588478, 1.27709190672154}, {0.848443930041152, 
     1.27981395747599}, {0.763888888888889, 1.27314814814815}, {
     0.667759773662552, 1.25645147462277}, {0.559670781893004, 
     1.22908093278464}, {0.306069958847737, 1.13974622770919}, {0., 1.}}]], 
   ",", 
   GraphicsBox[
    LineBox[{{0., 0.}, {0.0832690329218107, 0.00452246227709191}, {
     0.166152263374486, 0.0176611796982167}, {0.248263888888889, 
     0.0387731481481481}, {0.329218106995885, 0.0672153635116598}, {
     0.486111111111111, 0.143518518518519}, {0.633744855967078, 
     0.241426611796982}, {0.769032921810699, 0.35579561042524}, {
     0.888888888888889, 0.481481481481482}, {0.990226337448559, 
     0.613340192043896}, {1.03298611111111, 0.679976851851852}, {
     1.06995884773663, 0.746227709190672}, {1.10075874485597, 
     0.81144975994513}, {1.125, 0.875}, {1.14229681069959, 
     0.936235425240055}, {1.1522633744856, 0.994513031550069}, {
     1.15451388888889, 1.04918981481481}, {1.14866255144033, 
     1.09962277091907}, {1.13432355967078, 1.1451688957476}, {
     1.11111111111111, 1.18518518518519}, {1.07863940329218, 
     1.2190286351166}, {1.03652263374486, 1.24605624142661}, {0.984375, 
     1.265625}, {0.921810699588478, 1.27709190672154}, {0.848443930041152, 
     1.27981395747599}, {0.763888888888889, 1.27314814814815}, {
     0.667759773662552, 1.25645147462277}, {0.559670781893004, 
     1.22908093278464}, {0.306069958847737, 1.13974622770919}, {0., 1.}}]]}], 
  "}"}]], "Output",
 ImageSize->{390, 414},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->926610857]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->18681],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SplineFit",
    BaseStyle->"Link",
    ButtonData->"paclet:Splines/ref/SplineFit"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Bezier",
    BaseStyle->"Link",
    ButtonData->"paclet:Splines/ref/Bezier"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CompositeBezier",
    BaseStyle->"Link",
    ButtonData->"paclet:Splines/ref/CompositeBezier"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Cubic",
    BaseStyle->"Link",
    ButtonData->"paclet:Splines/ref/Cubic"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->27393]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Spline - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 7, 56.0363984}", "context" -> "Splines`", 
    "keywords" -> {}, "index" -> True, "label" -> "Splines Package Symbol", 
    "language" -> "en", "paclet" -> "Splines Package", "status" -> "None", 
    "summary" -> 
    "Spline[{pt_1, pt_2, ...}, type] is a two-dimensional graphics primitive \
which represents a spline of type type through (or controlled by) points \
pt_1, pt_2, .... ", "synonyms" -> {}, "title" -> "Spline", "type" -> "Symbol",
     "uri" -> "Splines/ref/Spline"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7020, 235, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->324955593]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 48225, 1219}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 907, 20, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1530, 47, 44, 1, 70, "ObjectName",
 CellID->29413],
Cell[1577, 50, 1140, 36, 70, "Usage",
 CellID->2585]
}, Open  ]],
Cell[CellGroupData[{
Cell[2754, 91, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3232, 108, 140, 6, 70, "Notes",
 CellID->26063],
Cell[3375, 116, 817, 22, 70, "2ColumnTableMod",
 CellID->25382],
Cell[4195, 140, 281, 9, 70, "Notes",
 CellID->7271],
Cell[4479, 151, 987, 34, 70, "Notes",
 CellID->29892],
Cell[5469, 187, 171, 6, 70, "Notes",
 CellID->22396],
Cell[5643, 195, 68, 1, 70, "Notes",
 CellID->17239],
Cell[5714, 198, 1269, 32, 70, "3ColumnTableMod",
 CellID->32110]
}, Closed]],
Cell[CellGroupData[{
Cell[7020, 235, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->324955593],
Cell[CellGroupData[{
Cell[7405, 249, 148, 5, 70, "ExampleSection",
 CellID->119886310],
Cell[7556, 256, 129, 3, 70, "Input",
 CellID->73229909],
Cell[7688, 261, 83, 1, 70, "ExampleText",
 CellID->800558974],
Cell[CellGroupData[{
Cell[7796, 266, 899, 30, 47, "Input",
 CellID->153580769],
Cell[8698, 298, 1687, 29, 201, "Output",
 CellID->463603928]
}, Open  ]],
Cell[10400, 330, 77, 1, 70, "ExampleText",
 CellID->1009627563],
Cell[CellGroupData[{
Cell[10502, 335, 898, 30, 70, "Input",
 CellID->951777575],
Cell[11403, 367, 1944, 33, 229, "Output",
 CellID->720546580]
}, Open  ]],
Cell[13362, 403, 93, 1, 70, "ExampleText",
 CellID->1542156394],
Cell[CellGroupData[{
Cell[13480, 408, 1183, 38, 47, "Input",
 CellID->1583617330],
Cell[14666, 448, 2915, 52, 171, "Output",
 Evaluatable->False,
 CellID->3043833]
}, Open  ]],
Cell[17596, 503, 76, 1, 70, "ExampleText",
 CellID->1479385973],
Cell[CellGroupData[{
Cell[17697, 508, 1170, 38, 47, "Input",
 CellID->566084627],
Cell[18870, 548, 4413, 76, 217, "Output",
 Evaluatable->False,
 CellID->672573391]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[23332, 630, 218, 7, 70, "ExampleSection",
 CellID->23874],
Cell[CellGroupData[{
Cell[23575, 641, 232, 7, 70, "ExampleSubsection",
 CellID->1757724783],
Cell[23810, 650, 129, 3, 70, "Input",
 CellID->52329002],
Cell[23942, 655, 216, 7, 70, "ExampleText",
 CellID->1191189501],
Cell[CellGroupData[{
Cell[24183, 666, 649, 20, 70, "Input",
 CellID->1117677677],
Cell[24835, 688, 4449, 77, 70, "Output",
 Evaluatable->False,
 CellID->92506145]
}, Open  ]],
Cell[29299, 768, 85, 1, 70, "ExampleText",
 CellID->2069101796],
Cell[CellGroupData[{
Cell[29409, 773, 575, 18, 70, "Input",
 CellID->514926374],
Cell[29987, 793, 6602, 116, 237, "Output",
 CellID->200875863]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[36638, 915, 233, 7, 70, "ExampleSubsection",
 CellID->212027592],
Cell[36874, 924, 130, 3, 70, "Input",
 CellID->206176541],
Cell[37007, 929, 249, 7, 70, "ExampleText",
 CellID->80747979],
Cell[CellGroupData[{
Cell[37281, 940, 740, 24, 70, "Input",
 CellID->769257030],
Cell[38024, 966, 2553, 47, 433, "Output",
 CellID->601865380]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[40626, 1019, 234, 7, 70, "ExampleSubsection",
 CellID->94523507],
Cell[40863, 1028, 130, 3, 70, "Input",
 CellID->101446566],
Cell[40996, 1033, 254, 7, 70, "ExampleText",
 CellID->1042378315],
Cell[CellGroupData[{
Cell[41275, 1044, 728, 23, 70, "Input",
 CellID->1814937740],
Cell[42006, 1069, 3749, 66, 435, "Output",
 CellID->926610857]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[45828, 1143, 311, 9, 70, "SeeAlsoSection",
 CellID->18681],
Cell[46142, 1154, 979, 35, 70, "SeeAlso",
 CellID->27393]
}, Open  ]],
Cell[47136, 1192, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

