(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11151,        366]
NotebookOptionsPosition[      8610,        280]
NotebookOutlinePosition[      9821,        316]
CellTagsIndexPosition[      9737,        311]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["SPLINES PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Spline" :> 
         Documentation`HelpLookup["paclet:Splines/ref/Spline"], "PointSize" :> 
         Documentation`HelpLookup["paclet:ref/PointSize"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"Spline\"\>", 
      2->"\<\"PointSize\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SplineDots", "ObjectName",
 CellID->25343],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["SplineDots"], "InlineFormula"],
     " \[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Spline",
       BaseStyle->"Link",
       ButtonData->"paclet:Splines/ref/Spline"]], "InlineFormula"],
     " that specifies a style for a point. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->21821]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"SplineDots", "->", 
   StyleBox["style", "TI"]}]], "InlineFormula"],
 " specifies to render points with the given graphics directive or list of \
directives."
}], "Notes",
 CellID->24533],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"SplineDots", "->", 
   ButtonBox["None",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/None"]}]], "InlineFormula"],
 " specifies that nothing should appear at each spline control point."
}], "Notes",
 CellID->22923],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"SplineDots", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " specifies that a red dot is placed at each point."
}], "Notes",
 CellID->10142]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->260929110],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->138376854],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Splines`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->205276],

Cell["Bezier splines only go through the end points:", "ExampleText",
 CellID->176016915],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Spline", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], "}"}], ",", " ", "Bezier", ",", " ", 
    
    RowBox[{"SplineDots", "\[Rule]", "Automatic"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->769257030],

Cell[BoxData[
 GraphicsBox[{
   {Hue[0], PointSize[0.03], PointBox[{0, 0}], PointBox[{1, 0}], 
    PointBox[{1, 1}], PointBox[{0, 1}]}, 
   LineBox[{{0., 0.}, {0.119791666666667, 0.00506365740740741}, {
    0.229166666666667, 0.0196759259259259}, {0.328125, 0.04296875}, {
    0.416666666666667, 0.0740740740740741}, {0.494791666666667, 
    0.112123842592593}, {0.5625, 0.15625}, {0.619791666666667, 
    0.205584490740741}, {0.666666666666667, 0.259259259259259}, {0.703125, 
    0.31640625}, {0.729166666666667, 0.376157407407407}, {0.744791666666667, 
    0.437644675925926}, {0.75, 0.5}, {0.744791666666667, 0.562355324074074}, {
    0.729166666666667, 0.623842592592592}, {0.703125, 0.68359375}, {
    0.666666666666667, 0.740740740740741}, {0.619791666666667, 
    0.794415509259259}, {0.5625, 0.84375}, {0.494791666666667, 
    0.887876157407407}, {0.416666666666667, 0.925925925925926}, {0.328125, 
    0.95703125}, {0.229166666666667, 0.980324074074074}, {0.119791666666667, 
    0.994936342592593}, {0., 1.}}]}]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->355429939]
}, Open  ]],

Cell["Cubic splines go through all of the points:", "ExampleText",
 CellID->1558962466],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Spline", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], "}"}], ",", " ", "Cubic", ",", " ", 
    RowBox[{"SplineDots", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Purple", ",", " ", 
       RowBox[{"PointSize", "[", "Large", "]"}]}], "]"}]}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->34189015],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[0.5, 0, 0.5], PointSize[Large], PointBox[{0, 0}], 
    PointBox[{1, 0}], PointBox[{1, 1}], PointBox[{0, 1}]}, 
   LineBox[{{0, 0}, {0.149609375, -0.041015625}, {0.296875, -0.078125}, {
     0.439453125, -0.107421875}, {0.575, -0.125}, {
     0.701171875, -0.126953125}, {0.760009765625, -0.120849609375}, {
     0.815625, -0.109375}, {0.867724609375, -0.092041015625}, {
     0.892364501953125, -0.081024169921875}, {0.916015625, -0.068359375}, {
     0.960205078125, -0.037841796875}, {
     0.980670166015625, -0.019866943359375}, {1, 0}, {1.03515625, 
     0.04541015625}, {1.065625, 0.09765625}, {1.1125, 0.21875}, {1.140625, 
     0.35546875}, {1.15, 0.5}, {1.140625, 0.64453125}, {1.1125, 0.78125}, {
     1.09140625, 0.84423828125}, {1.065625, 0.90234375}, {1.03515625, 
     0.95458984375}, {1.0181640625, 0.97821044921875}, {1, 1}, {
     0.960205078125, 1.037841796875}, {0.938641357421875, 1.05398559570313}, {
     0.916015625, 1.068359375}, {0.867724609375, 1.092041015625}, {0.815625, 
     1.109375}, {0.701171875, 1.126953125}, {0.575, 1.125}, {0.439453125, 
     1.107421875}, {0.296875, 1.078125}, {0.149609375, 1.041015625}, {0, 
     1}}]}]], "Output",
 ImageSize->{184, 195},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1491654648]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->14781],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Spline",
    BaseStyle->"Link",
    ButtonData->"paclet:Splines/ref/Spline"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PointSize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PointSize"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->27465]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SplineDots - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 7, 55.1770014}", "context" -> "Splines`", 
    "keywords" -> {}, "index" -> True, "label" -> "Splines Package Symbol", 
    "language" -> "en", "paclet" -> "Splines Package", "status" -> "None", 
    "summary" -> 
    "SplineDots is an option for Spline that specifies a style for a point. ",
     "synonyms" -> {}, "title" -> "SplineDots", "type" -> "Symbol", "uri" -> 
    "Splines/ref/SplineDots"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3141, 115, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->260929110]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 9594, 304}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 661, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1284, 43, 48, 1, 70, "ObjectName",
 CellID->25343],
Cell[1335, 46, 502, 15, 70, "Usage",
 CellID->21821]
}, Open  ]],
Cell[CellGroupData[{
Cell[1874, 66, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2352, 83, 229, 7, 70, "Notes",
 CellID->24533],
Cell[2584, 92, 262, 8, 70, "Notes",
 CellID->22923],
Cell[2849, 102, 255, 8, 70, "Notes",
 CellID->10142]
}, Closed]],
Cell[CellGroupData[{
Cell[3141, 115, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->260929110],
Cell[CellGroupData[{
Cell[3526, 129, 148, 5, 70, "ExampleSection",
 CellID->138376854],
Cell[3677, 136, 127, 3, 70, "Input",
 CellID->205276],
Cell[3807, 141, 89, 1, 70, "ExampleText",
 CellID->176016915],
Cell[CellGroupData[{
Cell[3921, 146, 530, 17, 28, "Input",
 CellID->769257030],
Cell[4454, 165, 1166, 21, 201, "Output",
 CellID->355429939]
}, Open  ]],
Cell[5635, 189, 87, 1, 70, "ExampleText",
 CellID->1558962466],
Cell[CellGroupData[{
Cell[5747, 194, 639, 20, 70, "Input",
 CellID->34189015],
Cell[6389, 216, 1347, 24, 216, "Output",
 CellID->1491654648]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7797, 247, 311, 9, 70, "SeeAlsoSection",
 CellID->14781],
Cell[8111, 258, 457, 17, 70, "SeeAlso",
 CellID->27465]
}, Open  ]],
Cell[8583, 278, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

