(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     28053,        792]
NotebookOptionsPosition[     24743,        679]
NotebookOutlinePosition[     26006,        716]
CellTagsIndexPosition[     25921,        711]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["SPLINES PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Spline" :> 
         Documentation`HelpLookup["paclet:Splines/ref/Spline"], 
         "SplineFunction" :> 
         Documentation`HelpLookup["paclet:Splines/ref/SplineFunction"], "Fit" :> 
         Documentation`HelpLookup["paclet:ref/Fit"], "Bezier" :> 
         Documentation`HelpLookup["paclet:Splines/ref/Bezier"], 
         "CompositeBezier" :> 
         Documentation`HelpLookup["paclet:Splines/ref/CompositeBezier"], 
         "Cubic" :> Documentation`HelpLookup["paclet:Splines/ref/Cubic"]}, #, 
        2]& , Evaluator -> Automatic], {1->"\<\"Spline\"\>", 
      2->"\<\"SplineFunction\"\>", 3->"\<\"Fit\"\>", 4->"\<\"Bezier\"\>", 
      5->"\<\"CompositeBezier\"\>", 6->"\<\"Cubic\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SplineFit", "ObjectName",
 CellID->21653],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SplineFit", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["pt", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["pt", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        StyleBox["type", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]generates a ",
     Cell[BoxData[
      ButtonBox["SplineFunction",
       BaseStyle->"Link",
       ButtonData->"paclet:Splines/ref/SplineFunction"]], "InlineFormula"],
     " object of the specified ",
     Cell[BoxData[
      StyleBox["type", "TI"]], "InlineFormula"],
     " from the points ",
     Cell[BoxData[
      RowBox[{
       SubscriptBox[
        StyleBox["pt", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["pt", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->21234]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "A ",
 Cell[BoxData[
  ButtonBox["SplineFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:Splines/ref/SplineFunction"]], "InlineFormula"],
 " object is a function that parametrizes a curve specified by the points ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox[
    StyleBox["pt", "TI"], 
    StyleBox["1", "TR"]], ",", 
   SubscriptBox[
    StyleBox["pt", "TI"], 
    StyleBox["2", "TR"]], ",", 
   StyleBox["\[Ellipsis]", "TR"]}]], "InlineFormula"],
 ", such that an argument of ",
 Cell[BoxData["0"], "InlineFormula"],
 " corresponds to ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["pt", "TI"], 
   StyleBox["1", "TR"]]], "InlineFormula"],
 ", 1 corresponds to ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["pt", "TI"], 
   StyleBox["2", "TR"]]], "InlineFormula"],
 ", etc."
}], "Notes",
 CellID->6266],

Cell[TextData[{
 "Supported types are ",
 Cell[BoxData[
  ButtonBox["Cubic",
   BaseStyle->"Link",
   ButtonData->"paclet:Splines/ref/Cubic"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Bezier",
   BaseStyle->"Link",
   ButtonData->"paclet:Splines/ref/Bezier"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["CompositeBezier",
   BaseStyle->"Link",
   ButtonData->"paclet:Splines/ref/CompositeBezier"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->24247],

Cell[TextData[{
 "A cubic spline is made of piecewise third\[Hyphen]order polynomials, with \
",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["C", "TI"], "1"], TraditionalForm]], "InlineFormula"],
 " continuity, and interpolates each of the points it is created from. ",
 "The second derivative of the spline at the endpoints is set to ",
 Cell[BoxData["0"], "InlineFormula"],
 "."
}], "Notes",
 CellID->32113],

Cell[TextData[{
 "A Bezier spline interpolates only the endpoints. The other points control \
the spline, forming a convex hull. Given n points, a spline of degree ",
 Cell[BoxData[
  StyleBox[
   RowBox[{
    StyleBox["n", "TI"], "\[Dash]", 
    StyleBox["1", "TR"]}]]], "InlineFormula"],
 " is created."
}], "Notes",
 CellID->27422],

Cell[TextData[{
 "A composite Bezier spline is made up of a series of third\[Hyphen]order \
Bezier curves with ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["C", "TI"], "1"], TraditionalForm]], "InlineFormula"],
 " continuity. It alternates interpolating points and control points. "
}], "Notes",
 CellID->10745],

Cell["\<\
In a composite Bezier spline generated from an even number of points the last \
two points are reversed so that the final point is interpolated and the next \
to last is a control point for the final segment; if odd, then the final \
vertex is doubled.\
\>", "Notes",
 CellID->25974],

Cell[TextData[{
 "The points ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox[
    StyleBox["pt", "TI"], 
    StyleBox["1", "TR"]], ",", 
   SubscriptBox[
    StyleBox["pt", "TI"], 
    StyleBox["2", "TR"]], ",", 
   StyleBox["\[Ellipsis]", "TR"]}]], "InlineFormula"],
 " are not restricted to two dimensions."
}], "Notes",
 CellID->23488]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->273528480],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->5053925],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Splines`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->356897905],

Cell[TextData[{
 Cell[BoxData["SplineFit"], "InlineFormula"],
 " returns a ",
 Cell[BoxData[
  ButtonBox["SplineFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:Splines/ref/SplineFunction"]], "InlineFormula"],
 " of the appropriate type:"
}], "ExampleText",
 CellID->474383245],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SplineFit", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}]}], "}"}], ",", " ", "Bezier"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->44915313],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"SplineFunction[\"\>", "\[InvisibleSpace]", "Bezier", 
   "\[InvisibleSpace]", "\<\", \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0.`", ",", "3.`"}], "}"}], 
   "\[InvisibleSpace]", "\<\", <>]\"\>"}],
  SequenceForm["SplineFunction[", Splines`Bezier, ", ", {0., 3.}, ", <>]"],
  Editable->False]], "Output",
 ImageSize->{254, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1988093117]
}, Open  ]],

Cell["Fit three types of splines to a random set of five points:", \
"ExampleText",
 CellID->1499901051],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"dat", "=", 
   RowBox[{"RandomReal", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "2"}], "}"}]}], "]"}]}], ";", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"f", ",", "g", ",", "h"}], "}"}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{"SplineFit", "[", 
      RowBox[{"dat", ",", " ", "#"}], "]"}], "&"}], "/@", 
    RowBox[{"{", 
     RowBox[{"Bezier", ",", " ", "CompositeBezier", ",", " ", "Cubic"}], 
     "}"}]}]}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1041050443],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    RowBox[{"\<\"SplineFunction[\"\>", "\[InvisibleSpace]", "Bezier", 
     "\[InvisibleSpace]", "\<\", \"\>", "\[InvisibleSpace]", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "4.`"}], "}"}], 
     "\[InvisibleSpace]", "\<\", <>]\"\>"}],
    SequenceForm["SplineFunction[", Splines`Bezier, ", ", {0., 4.}, ", <>]"],
    Editable->False], ",", 
   InterpretationBox[
    RowBox[{"\<\"SplineFunction[\"\>", "\[InvisibleSpace]", "CompositeBezier",
      "\[InvisibleSpace]", "\<\", \"\>", "\[InvisibleSpace]", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "4.`"}], "}"}], 
     "\[InvisibleSpace]", "\<\", <>]\"\>"}],
    SequenceForm[
    "SplineFunction[", Splines`CompositeBezier, ", ", {0., 4.}, ", <>]"],
    Editable->False], ",", 
   InterpretationBox[
    RowBox[{"\<\"SplineFunction[\"\>", "\[InvisibleSpace]", "Cubic", 
     "\[InvisibleSpace]", "\<\", \"\>", "\[InvisibleSpace]", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "4.`"}], "}"}], 
     "\[InvisibleSpace]", "\<\", <>]\"\>"}],
    SequenceForm["SplineFunction[", Splines`Cubic, ", ", {0., 4.}, ", <>]"],
    Editable->False]}], "}"}]], "Output",
 ImageSize->{584, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1385523392]
}, Open  ]],

Cell["Plot the resulting splines:", "ExampleText",
 CellID->1673915671],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"Through", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"f", ",", "g", ",", "h"}], "}"}], "[", "t", "]"}], "]"}], 
    "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"t", ",", " ", "0", ",", " ", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1326464923],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 188},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->72393320]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData["SplineFit"], "InlineFormula"],
 " works in arbitrary dimensions:"
}], "ExampleText",
 CellID->1464906797],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"SplineFit", "[", 
      RowBox[{
       RowBox[{"RandomReal", "[", 
        RowBox[{
         RowBox[{"{", "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{"10", ",", "3"}], "}"}]}], "]"}], ",", " ", 
       "CompositeBezier"}], "]"}], "[", "t", "]"}], "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"t", ",", " ", "0", ",", " ", "9"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1003879088],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{176, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->278911135]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->15966],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Spline",
    BaseStyle->"Link",
    ButtonData->"paclet:Splines/ref/Spline"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SplineFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:Splines/ref/SplineFunction"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Fit",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Fit"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Bezier",
    BaseStyle->"Link",
    ButtonData->"paclet:Splines/ref/Bezier"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CompositeBezier",
    BaseStyle->"Link",
    ButtonData->"paclet:Splines/ref/CompositeBezier"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Cubic",
    BaseStyle->"Link",
    ButtonData->"paclet:Splines/ref/Cubic"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->20805]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SplineFit - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 7, 55.3801316}", "context" -> "Splines`", 
    "keywords" -> {}, "index" -> True, "label" -> "Splines Package Symbol", 
    "language" -> "en", "paclet" -> "Splines Package", "status" -> "None", 
    "summary" -> 
    "SplineFit[{pt_1, pt_2, ...}, type] generates a SplineFunction object of \
the specified type from the points pt_1, pt_2, ....", "synonyms" -> {}, 
    "title" -> "SplineFit", "type" -> "Symbol", "uri" -> 
    "Splines/ref/SplineFit"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6609, 230, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->273528480]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 25778, 704}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1111, 23, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1734, 50, 47, 1, 70, "ObjectName",
 CellID->21653],
Cell[1784, 53, 1241, 40, 70, "Usage",
 CellID->21234]
}, Open  ]],
Cell[CellGroupData[{
Cell[3062, 98, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3540, 115, 826, 30, 70, "Notes",
 CellID->6266],
Cell[4369, 147, 476, 18, 70, "Notes",
 CellID->24247],
Cell[4848, 167, 423, 12, 70, "Notes",
 CellID->32113],
Cell[5274, 181, 334, 10, 70, "Notes",
 CellID->27422],
Cell[5611, 193, 327, 9, 70, "Notes",
 CellID->10745],
Cell[5941, 204, 293, 6, 70, "Notes",
 CellID->25974],
Cell[6237, 212, 335, 13, 70, "Notes",
 CellID->23488]
}, Closed]],
Cell[CellGroupData[{
Cell[6609, 230, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->273528480],
Cell[CellGroupData[{
Cell[6994, 244, 146, 5, 70, "ExampleSection",
 CellID->5053925],
Cell[7143, 251, 130, 3, 70, "Input",
 CellID->356897905],
Cell[7276, 256, 284, 9, 70, "ExampleText",
 CellID->474383245],
Cell[CellGroupData[{
Cell[7585, 269, 421, 15, 28, "Input",
 CellID->44915313],
Cell[8009, 286, 502, 13, 36, "Output",
 CellID->1988093117]
}, Open  ]],
Cell[8526, 302, 104, 2, 70, "ExampleText",
 CellID->1499901051],
Cell[CellGroupData[{
Cell[8655, 308, 555, 19, 70, "Input",
 CellID->1041050443],
Cell[9213, 329, 1310, 32, 54, "Output",
 CellID->1385523392]
}, Open  ]],
Cell[10538, 364, 71, 1, 70, "ExampleText",
 CellID->1673915671],
Cell[CellGroupData[{
Cell[10634, 369, 381, 12, 28, "Input",
 CellID->1326464923],
Cell[11018, 383, 7003, 119, 209, "Output",
 Evaluatable->False,
 CellID->72393320]
}, Open  ]],
Cell[18036, 505, 136, 4, 70, "ExampleText",
 CellID->1464906797],
Cell[CellGroupData[{
Cell[18197, 513, 532, 16, 47, "Input",
 CellID->1003879088],
Cell[18732, 531, 4121, 72, 237, "Output",
 Evaluatable->False,
 CellID->278911135]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[22914, 610, 311, 9, 70, "SeeAlsoSection",
 CellID->15966],
Cell[23228, 621, 1473, 53, 70, "SeeAlso",
 CellID->20805]
}, Open  ]],
Cell[24716, 677, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

