(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11340,        403]
NotebookOptionsPosition[      8641,        316]
NotebookOutlinePosition[     10058,        355]
CellTagsIndexPosition[      9974,        350]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["SPLINES PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Spline" :> 
         Documentation`HelpLookup["paclet:Splines/ref/Spline"], "SplineFit" :> 
         Documentation`HelpLookup["paclet:Splines/ref/SplineFit"], "Bezier" :> 
         Documentation`HelpLookup["paclet:Splines/ref/Bezier"], 
         "CompositeBezier" :> 
         Documentation`HelpLookup["paclet:Splines/ref/CompositeBezier"], 
         "Cubic" :> Documentation`HelpLookup["paclet:Splines/ref/Cubic"]}, #, 
        2]& , Evaluator -> Automatic], {1->"\<\"Spline\"\>", 
      2->"\<\"SplineFit\"\>", 3->"\<\"Bezier\"\>", 
      4->"\<\"CompositeBezier\"\>", 5->"\<\"Cubic\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SplineFunction", "ObjectName",
 CellID->18561],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SplineFunction", "[", 
       RowBox[{
        StyleBox["type", "TI"], ",", 
        StyleBox["domain", "TI"], ",", 
        StyleBox["internal", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]represents a spline function created by the ",
     Cell[BoxData[
      ButtonBox["SplineFit",
       BaseStyle->"Link",
       ButtonData->"paclet:Splines/ref/SplineFit"]], "InlineFormula"],
     " function parametrizing a curve with the parameter in the specified ",
     Cell[BoxData[
      StyleBox["domain", "TI"]], "InlineFormula"],
     ". When given a parameter value as an argument it returns the \
corresponding point on the curve."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->13303]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The ",
 Cell[BoxData["SplineFunction"], "InlineFormula"],
 " object generated with ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SplineFit",
    BaseStyle->"Link",
    ButtonData->"paclet:Splines/ref/SplineFit"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["pt", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["pt", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    StyleBox["type", "TI"]}], "]"}]], "InlineFormula"],
 " is parametrized such that a parameter value of ",
 Cell[BoxData["0"], "InlineFormula"],
 " corresponds to ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["pt", "TI"], 
   StyleBox["1", "TR"]]], "InlineFormula"],
 ", 1 corresponds to ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["pt", "TI"], 
   StyleBox["2", "TR"]]], "InlineFormula"],
 ", etc."
}], "Notes",
 CellID->14992],

Cell[TextData[{
 "Supported types are ",
 Cell[BoxData[
  ButtonBox["Cubic",
   BaseStyle->"Link",
   ButtonData->"paclet:Splines/ref/Cubic"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Bezier",
   BaseStyle->"Link",
   ButtonData->"paclet:Splines/ref/Bezier"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["CompositeBezier",
   BaseStyle->"Link",
   ButtonData->"paclet:Splines/ref/CompositeBezier"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->13959]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->90664965],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->396277659],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Splines`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->681562359],

Cell["Fit a Bezier spline to a set of four points:", "ExampleText",
 CellID->2094308663],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sf", "=", 
  RowBox[{"SplineFit", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], "}"}], ",", " ", "Bezier"}], 
   "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1841326616],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"SplineFunction[\"\>", "\[InvisibleSpace]", "Bezier", 
   "\[InvisibleSpace]", "\<\", \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0.`", ",", "3.`"}], "}"}], 
   "\[InvisibleSpace]", "\<\", <>]\"\>"}],
  SequenceForm["SplineFunction[", Splines`Bezier, ", ", {0., 3.}, ", <>]"],
  Editable->False]], "Output",
 ImageSize->{254, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->735638663]
}, Open  ]],

Cell[TextData[{
 "The endpoints of the ",
 Cell[BoxData["SplineFunction"], "InlineFormula"],
 " correspond to the original points:"
}], "ExampleText",
 CellID->1788724711],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"sf", "[", "0", "]"}], ",", " ", 
   RowBox[{"sf", "[", "3", "]"}]}], "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->682429974],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.`", ",", "1.`"}], "}"}]}], "}"}]], "Output",
 ImageSize->{122, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1296255633]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->15639],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Spline",
    BaseStyle->"Link",
    ButtonData->"paclet:Splines/ref/Spline"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SplineFit",
    BaseStyle->"Link",
    ButtonData->"paclet:Splines/ref/SplineFit"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Bezier",
    BaseStyle->"Link",
    ButtonData->"paclet:Splines/ref/Bezier"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CompositeBezier",
    BaseStyle->"Link",
    ButtonData->"paclet:Splines/ref/CompositeBezier"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Cubic",
    BaseStyle->"Link",
    ButtonData->"paclet:Splines/ref/Cubic"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->19455]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SplineFunction - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 7, 55.8176428}", "context" -> "Splines`", 
    "keywords" -> {}, "index" -> True, "label" -> "Splines Package Symbol", 
    "language" -> "en", "paclet" -> "Splines Package", "status" -> "None", 
    "summary" -> 
    "SplineFunction[type, domain, internal] represents a spline function \
created by the SplineFit function parametrizing a curve with the parameter in \
the specified domain. When given a parameter value as an argument it returns \
the corresponding point on the curve.", "synonyms" -> {}, "title" -> 
    "SplineFunction", "type" -> "Symbol", "uri" -> 
    "Splines/ref/SplineFunction"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4551, 156, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->90664965]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 9832, 343}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1005, 21, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1628, 48, 52, 1, 70, "ObjectName",
 CellID->18561],
Cell[1683, 51, 905, 24, 70, "Usage",
 CellID->13303]
}, Open  ]],
Cell[CellGroupData[{
Cell[2625, 80, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3103, 97, 932, 34, 70, "Notes",
 CellID->14992],
Cell[4038, 133, 476, 18, 70, "Notes",
 CellID->13959]
}, Closed]],
Cell[CellGroupData[{
Cell[4551, 156, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->90664965],
Cell[CellGroupData[{
Cell[4935, 170, 148, 5, 70, "ExampleSection",
 CellID->396277659],
Cell[5086, 177, 130, 3, 70, "Input",
 CellID->681562359],
Cell[5219, 182, 88, 1, 70, "ExampleText",
 CellID->2094308663],
Cell[CellGroupData[{
Cell[5332, 187, 459, 16, 28, "Input",
 CellID->1841326616],
Cell[5794, 205, 501, 13, 36, "Output",
 CellID->735638663]
}, Open  ]],
Cell[6310, 221, 171, 5, 70, "ExampleText",
 CellID->1788724711],
Cell[CellGroupData[{
Cell[6506, 230, 180, 6, 70, "Input",
 CellID->682429974],
Cell[6689, 238, 307, 11, 36, "Output",
 CellID->1296255633]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7057, 256, 311, 9, 70, "SeeAlsoSection",
 CellID->15639],
Cell[7371, 267, 1228, 44, 70, "SeeAlso",
 CellID->19455]
}, Open  ]],
Cell[8614, 314, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

