(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7457,        246]
NotebookOptionsPosition[      5528,        188]
NotebookOutlinePosition[      6620,        217]
CellTagsIndexPosition[      6577,        214]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Standard Atmosphere Package", "GuideTitle",
 CellID->942062912],

Cell["\[NonBreakingSpace]", "GuideAbstract",
 CellID->1],

Cell[TextData[{
 Cell[TextData[ButtonBox["AtmosphericPlot",
  BaseStyle->"Link",
  ButtonData->"paclet:StandardAtmosphere/ref/AtmosphericPlot"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " plot a specific property as a function of altitude"
}], "GuideText",
 CellID->203374175],

Cell["\t", "GuideDelimiterSubsection",
 CellID->311258892],

Cell[CellGroupData[{

Cell["Properties", "GuideFunctionsSubsection",
 CellID->371002039],

Cell[TextData[{
 Cell[TextData[ButtonBox["CollisionFrequency",
  BaseStyle->"Link",
  ButtonData->"paclet:StandardAtmosphere/ref/CollisionFrequency"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["DynamicViscosity",
  BaseStyle->"Link",
  ButtonData->"paclet:StandardAtmosphere/ref/DynamicViscosity"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["GravityAcceleration",
  BaseStyle->"Link",
  ButtonData->"paclet:StandardAtmosphere/ref/GravityAcceleration"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["KinematicViscosity",
  BaseStyle->"Link",
  ButtonData->"paclet:StandardAtmosphere/ref/KinematicViscosity"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["KineticTemperature",
  BaseStyle->"Link",
  ButtonData->"paclet:StandardAtmosphere/ref/KineticTemperature"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MeanDensity",
  BaseStyle->"Link",
  ButtonData->"paclet:StandardAtmosphere/ref/MeanDensity"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MeanFreePath",
  BaseStyle->"Link",
  ButtonData->"paclet:StandardAtmosphere/ref/MeanFreePath"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MeanMolecularWeight",
  BaseStyle->"Link",
  ButtonData->"paclet:StandardAtmosphere/ref/MeanMolecularWeight"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MeanParticleSpeed",
  BaseStyle->"Link",
  ButtonData->"paclet:StandardAtmosphere/ref/MeanParticleSpeed"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["NumberDensity",
  BaseStyle->"Link",
  ButtonData->"paclet:StandardAtmosphere/ref/NumberDensity"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Pressure",
  BaseStyle->"Link",
  ButtonData->"paclet:StandardAtmosphere/ref/Pressure"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PressureScaleHeight",
  BaseStyle->"Link",
  ButtonData->"paclet:StandardAtmosphere/ref/PressureScaleHeight"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SoundSpeed",
  BaseStyle->"Link",
  ButtonData->"paclet:StandardAtmosphere/ref/SoundSpeed"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ThermalConductivityCoefficient",
  BaseStyle->"Link",
  ButtonData->
   "paclet:StandardAtmosphere/ref/ThermalConductivityCoefficient"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->58033752]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Standard Atmosphere Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:StandardAtmosphere/tutorial/StandardAtmosphere"]], "GuideTutorial",
 CellID->525892917]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/guide/UnitsPackage"]], "GuideMoreAbout",
 CellID->252299663],

Cell[TextData[{
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/DataCollections"],
  FontSlant->"Italic"],
 ButtonBox[" Data Collections",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/DataCollections"]
}], "GuideMoreAbout",
 CellID->241203317]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Standard Atmosphere Package - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 8, 2.4896886}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Standard Atmosphere Package Guide", "language" -> "en", "paclet" -> 
    "StandardAtmosphere Package", "status" -> "None", "summary" -> 
    "AtmosphericPlot -- plot a specific property as a function of altitude", 
    "synonyms" -> {}, "title" -> "Standard Atmosphere Package", "type" -> 
    "Guide", "uri" -> "StandardAtmosphere/guide/StandardAtmospherePackage"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 69, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[691, 28, 56, 1, 70, "GuideAbstract",
 CellID->1],
Cell[750, 31, 310, 9, 70, "GuideText",
 CellID->203374175],
Cell[1063, 42, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->311258892],
Cell[CellGroupData[{
Cell[1146, 47, 66, 1, 70, "GuideFunctionsSubsection",
 CellID->371002039],
Cell[1215, 50, 3435, 98, 70, "InlineGuideFunctionListing",
 CellID->58033752]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[4699, 154, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[4764, 157, 186, 4, 70, "GuideTutorial",
 CellID->525892917]
}, Open  ]],
Cell[CellGroupData[{
Cell[4987, 166, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[5052, 169, 148, 3, 70, "GuideMoreAbout",
 CellID->252299663],
Cell[5203, 174, 283, 9, 70, "GuideMoreAbout",
 CellID->241203317]
}, Open  ]],
Cell[5501, 186, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

