(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6603,        228]
NotebookOptionsPosition[      4884,        174]
NotebookOutlinePosition[      5960,        203]
CellTagsIndexPosition[      5917,        200]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["STANDARD ATMOSPHERE PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Standard Atmosphere Package" :> 
          Documentation`HelpLookup[
           "paclet:StandardAtmosphere/tutorial/StandardAtmosphere"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Standard Atmosphere Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"AtmosphericPlot" :> 
          Documentation`HelpLookup[
           "paclet:StandardAtmosphere/ref/AtmosphericPlot"], 
          "PressureScaleHeight" :> 
          Documentation`HelpLookup[
           "paclet:StandardAtmosphere/ref/PressureScaleHeight"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"AtmosphericPlot\"\>", 
       2->"\<\"PressureScaleHeight\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Pressure", "ObjectName",
 CellID->5595],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Pressure", "[", 
       StyleBox["altitude", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the total atmospheric pressure at the specified \
altitude ",
     Cell[BoxData[
      StyleBox["altitude", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->12822]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The altitude ",
 Cell[BoxData[
  StyleBox["altitude", "TI"]], "InlineFormula"],
 " can be specified using distance units such as ",
 Cell[BoxData[
  ButtonBox["Meter",
   BaseStyle->"Link",
   ButtonData->"paclet:Units/ref/Meter"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->5748]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->20367],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["AtmosphericPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:StandardAtmosphere/ref/AtmosphericPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PressureScaleHeight",
    BaseStyle->"Link",
    ButtonData->"paclet:StandardAtmosphere/ref/PressureScaleHeight"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->14897]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->1503],

Cell[TextData[ButtonBox["Standard Atmosphere Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:StandardAtmosphere/tutorial/StandardAtmosphere"]], "Tutorials",
 CellID->19196]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Pressure - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 8, 10.9586554}", "context" -> 
    "StandardAtmosphere`", "keywords" -> {}, "index" -> True, "label" -> 
    "Standard Atmosphere Package Symbol", "language" -> "en", "paclet" -> 
    "StandardAtmosphere Package", "status" -> "None", "summary" -> 
    "Pressure[altitude] gives the total atmospheric pressure at the specified \
altitude altitude.", "synonyms" -> {}, "title" -> "Pressure", "type" -> 
    "Symbol", "uri" -> "StandardAtmosphere/ref/Pressure"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1440, 37, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2063, 64, 45, 1, 70, "ObjectName",
 CellID->5595],
Cell[2111, 67, 508, 16, 70, "Usage",
 CellID->12822]
}, Open  ]],
Cell[CellGroupData[{
Cell[2656, 88, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3134, 105, 301, 11, 70, "Notes",
 CellID->5748]
}, Closed]],
Cell[CellGroupData[{
Cell[3472, 121, 311, 9, 70, "SeeAlsoSection",
 CellID->20367],
Cell[3786, 132, 525, 17, 70, "SeeAlso",
 CellID->14897]
}, Open  ]],
Cell[CellGroupData[{
Cell[4348, 154, 313, 9, 70, "TutorialsSection",
 CellID->1503],
Cell[4664, 165, 178, 4, 70, "Tutorials",
 CellID->19196]
}, Open  ]],
Cell[4857, 172, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

