(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6705,        228]
NotebookOptionsPosition[      4890,        173]
NotebookOutlinePosition[      6063,        203]
CellTagsIndexPosition[      6020,        200]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["STANDARD ATMOSPHERE PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Standard Atmosphere Package" :> 
          Documentation`HelpLookup[
           "paclet:StandardAtmosphere/tutorial/StandardAtmosphere"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Standard Atmosphere Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"AtmosphericPlot" :> 
          Documentation`HelpLookup[
           "paclet:StandardAtmosphere/ref/AtmosphericPlot"], "Pressure" :> 
          Documentation`HelpLookup[
           "paclet:StandardAtmosphere/ref/Pressure"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"AtmosphericPlot\"\>", 
       2->"\<\"Pressure\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["PressureScaleHeight", "ObjectName",
 CellID->15711],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"PressureScaleHeight", "[", 
       StyleBox["altitude", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the local pressure scale height of the mixture \
of gases comprising the atmosphere at the specified altitude ",
     Cell[BoxData[
      StyleBox["altitude", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->179]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The altitude ",
 Cell[BoxData[
  StyleBox["altitude", "TI"]], "InlineFormula"],
 " can be specified using distance units such as ",
 Cell[BoxData[
  ButtonBox["Meter",
   BaseStyle->"Link",
   ButtonData->"paclet:Units/ref/Meter"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->22203]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->9976],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["AtmosphericPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:StandardAtmosphere/ref/AtmosphericPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Pressure",
    BaseStyle->"Link",
    ButtonData->"paclet:StandardAtmosphere/ref/Pressure"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->7439]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->19910],

Cell[TextData[ButtonBox["Standard Atmosphere Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:StandardAtmosphere/tutorial/StandardAtmosphere"]], "Tutorials",
 CellID->12718]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PressureScaleHeight - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 8, 11.0992840}", "context" -> 
    "StandardAtmosphere`", "keywords" -> {}, "index" -> True, "label" -> 
    "Standard Atmosphere Package Symbol", "language" -> "en", "paclet" -> 
    "StandardAtmosphere Package", "status" -> "None", "summary" -> 
    "PressureScaleHeight[altitude] gives the local pressure scale height of \
the mixture of gases comprising the atmosphere at the specified altitude \
altitude.", "synonyms" -> {}, "title" -> "PressureScaleHeight", "type" -> 
    "Symbol", "uri" -> "StandardAtmosphere/ref/PressureScaleHeight"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1396, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2019, 63, 57, 1, 70, "ObjectName",
 CellID->15711],
Cell[2079, 66, 568, 16, 70, "Usage",
 CellID->179]
}, Open  ]],
Cell[CellGroupData[{
Cell[2684, 87, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3162, 104, 302, 11, 70, "Notes",
 CellID->22203]
}, Closed]],
Cell[CellGroupData[{
Cell[3501, 120, 310, 9, 70, "SeeAlsoSection",
 CellID->9976],
Cell[3814, 131, 502, 17, 70, "SeeAlso",
 CellID->7439]
}, Open  ]],
Cell[CellGroupData[{
Cell[4353, 153, 314, 9, 70, "TutorialsSection",
 CellID->19910],
Cell[4670, 164, 178, 4, 70, "Tutorials",
 CellID->12718]
}, Open  ]],
Cell[4863, 171, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

