(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13134,        385]
NotebookOptionsPosition[     10499,        302]
NotebookOutlinePosition[     11969,        341]
CellTagsIndexPosition[     11926,        338]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["STANDARD ATMOSPHERE PACKAGE TUTORIAL", "PacletNameCell"], Cell[
    TextData[Cell[BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"AtmosphericPlot" :> 
         Documentation`HelpLookup[
          "paclet:StandardAtmosphere/ref/AtmosphericPlot"], 
         "CollisionFrequency" :> 
         Documentation`HelpLookup[
          "paclet:StandardAtmosphere/ref/CollisionFrequency"], 
         "DynamicViscosity" :> 
         Documentation`HelpLookup[
          "paclet:StandardAtmosphere/ref/DynamicViscosity"], 
         "GravityAcceleration" :> 
         Documentation`HelpLookup[
          "paclet:StandardAtmosphere/ref/GravityAcceleration"], 
         "KinematicViscosity" :> 
         Documentation`HelpLookup[
          "paclet:StandardAtmosphere/ref/KinematicViscosity"], 
         "KineticTemperature" :> 
         Documentation`HelpLookup[
          "paclet:StandardAtmosphere/ref/KineticTemperature"], "MeanDensity" :> 
         Documentation`HelpLookup[
          "paclet:StandardAtmosphere/ref/MeanDensity"], "MeanFreePath" :> 
         Documentation`HelpLookup[
          "paclet:StandardAtmosphere/ref/MeanFreePath"], 
         "MeanMolecularWeight" :> 
         Documentation`HelpLookup[
          "paclet:StandardAtmosphere/ref/MeanMolecularWeight"], 
         "MeanParticleSpeed" :> 
         Documentation`HelpLookup[
          "paclet:StandardAtmosphere/ref/MeanParticleSpeed"], "NumberDensity" :> 
         Documentation`HelpLookup[
          "paclet:StandardAtmosphere/ref/NumberDensity"], "Pressure" :> 
         Documentation`HelpLookup["paclet:StandardAtmosphere/ref/Pressure"], 
         "PressureScaleHeight" :> 
         Documentation`HelpLookup[
          "paclet:StandardAtmosphere/ref/PressureScaleHeight"], "SoundSpeed" :> 
         Documentation`HelpLookup["paclet:StandardAtmosphere/ref/SoundSpeed"],
          "ThermalConductivityCoefficient" :> 
         Documentation`HelpLookup[
          "paclet:StandardAtmosphere/ref/ThermalConductivityCoefficient"]}, #,
         2]& , Evaluator -> Automatic], {1->"\<\"AtmosphericPlot\"\>", 
      2->"\<\"CollisionFrequency\"\>", 3->"\<\"DynamicViscosity\"\>", 
      4->"\<\"GravityAcceleration\"\>", 5->"\<\"KinematicViscosity\"\>", 
      6->"\<\"KineticTemperature\"\>", 7->"\<\"MeanDensity\"\>", 
      8->"\<\"MeanFreePath\"\>", 9->"\<\"MeanMolecularWeight\"\>", 
      10->"\<\"MeanParticleSpeed\"\>", 11->"\<\"NumberDensity\"\>", 
      12->"\<\"Pressure\"\>", 13->"\<\"PressureScaleHeight\"\>", 
      14->"\<\"SoundSpeed\"\>", 
      15->"\<\"ThermalConductivityCoefficient\"\>"}, "\<\"functions\"\>", 
      StyleBox["\<\"functions\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Standard Atmosphere Package", "Title",
 CellID->29385],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["AtmosphericPlot",
      BaseStyle->"Link",
      ButtonData->"paclet:StandardAtmosphere/ref/AtmosphericPlot"], "[", 
     StyleBox["property", "TI"], "]"}], Cell["\<\
plot the specified property on the horizontal axis versus the altitude on the \
vertical axis \
\>", "TableText"]}
  }]], "DefinitionBox",
 CellID->15425],

Cell["Plotting an atmospheric property. ", "Caption",
 CellID->32593],

Cell["\<\
This package provides support for plotting how U.S. Standard Atmosphere \
properties vary with altitude. \
\>", "Text",
 CellID->30312],

Cell["This loads the package. ", "MathCaption",
 CellID->13372],

Cell[BoxData[
 RowBox[{"<<", "StandardAtmosphere`"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9642],

Cell["\<\
The speed of sound does not decrease monotonically with increasing altitude. \
\
\>", "MathCaption",
 CellID->21522],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AtmosphericPlot", "[", "SoundSpeed", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->30324],

Cell[BoxData[
 GraphicsBox[{{}, {}, {
    {Hue[0.67, 0.6, 0.6]}, LineBox[CompressedData["
1:eJxd1D1Im0EYB/CXIhKCg0iwIhK/Nakf1G+rxjyp0aitYoI6ZfADBScTW4vo
omAEQbBLB7VDQREn0S0gNC8W1KGFQgcHHdpBKujgYpGC4Hv33P8d7iAJv9xz
d8/dc+9bODYdmXhmGMaA9RG/OzGf83z6Axmyucxv957oegTOMhM34aS7Ac40
u//Mu/afwxnmfsj64/+sssOMrh/fey7hNNN5vh3zfYUNU35/gR9S/6zljpfg
u5QYHh2Hf6fiVnrbQXu8EUm6Ezeldr9/wWVlkG6P98v9/H2P+f2ie/4MNsgr
EtyD00hsJ7QKO0gsF5uCM9g9cCbJ8/DCWfTju9UcsIt/r98pZ1OdaKdwDsnz
2IVzOZ9lOI94/7Cb5PkE4AKS558PF9LmhtUeZ5SLeL0LuJjk/pNwCcd/gktp
UrQZuIz3F4fLNXs0ezW/0FyhuVJzleZqzS8112iu1VynuV5zA8n7ugI3cv0+
wk10a4UntuBmVS/4FdfrAG7h+CO4leNP4Dae/yfs4/ra9WkneZ+vYD8Jhu9g
onyxAaeq9yKRvN/lqH+A5w+iP8D1HUX/ax6/CXeQSM/5Cw6q+XF/OzmfANzF
+czBIV7vM9ytuYfPZw3uJfl8DsNvSL4fCuC3HG8/L31cr0O4n/MtVqYBjke9
FsN8f7OVzQjJ98VeXI0f5PyblWmIx1cqjwzRE2XxW68=
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.618033988749895],
  Frame->True,
  FrameLabel->{
    FormBox["\"SoundSpeed, m/s\"", TraditionalForm], 
    FormBox["\"Altitude, Km\"", TraditionalForm]},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 ImageSize->{184, 122},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->38355995]
}, Open  ]],

Cell["\<\
The speed of particles does not increase monotonically with increasing \
altitude. \
\>", "MathCaption",
 CellID->12693],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AtmosphericPlot", "[", "MeanParticleSpeed", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->10655],

Cell[BoxData[
 GraphicsBox[{{}, {}, {
    {Hue[0.67, 0.6, 0.6]}, LineBox[CompressedData["
1:eJxd1FtIFFEYB/ApBG3xQWQJSTHNS2oXNLWy2vaolXZFNy1ECRU1umBrZOWl
mi6Ll9S1osKSbvYYFhHUQ+BU9FJGvZQiZPqsD1IES/rQzPy/vw8zIB8/z/nO
+b4zZyex9pSvfqmmac3mnxUbrKfgotLsx22MDfk9rlg62pgtfRMf+HNBHGUU
T7e6hz/TkfAQHWEE3/9Nq2qjw7BeJa0Z9n4ZdGjE4zJnLKHnRtzDRdOt4+3i
qRE7/zmtafcGzCewOO59ag6PVdJzXp9Z7kwWHfLa9YUv5qvAjNnQzzbWp+x6
XtIRyu63g45UVWiI/asvo+aTSUerdGtCGO2Gx1vFy1WT1eAzOgZRp1eobOs5
SMcpu/4UOl7Z5xFqESeolVYDn+hErD9Ir1LWcXoa6ST046WTsV4UnYLzmD4v
TkU9v+jVDqc5nO5whsNrHF7r8DqH1zuc6XCWwxscznY4B+9jls7FeczTG3He
y3gem3A+MfRm1Wb9I5XOU9Z1Ksqltyj7fhXSW7FeKb0N96ea9qgP5m0KLr6f
7Xh/7bQX+3XTCvdzWKwrZd//7xzPR/4Cx/PRXxLvTwH68dOF8Ft6B+oP5/3d
qaxht4/ehfXu00XYb5Qudni3sn8ur+k9qL+R3ov5yfQ+7DfBevaj/z76AN7n
V+lPleB+u9hvKX6PdfI+DR/87Zzklyn7+5InVuXYL0NcXY71Y8V6OeqNpw/h
vHeLjcMY/8H1K5A/L/XqlRif0GX8CGLnVdm/GvMfBmR+DWJZh6xfi/3edUp+
Hdb71yX59bDruuQ3oN+Q2DgKj/ZI/jHM13sl/zhiTp/kn8B+FUGZ34iY2i/z
/VivW6w3wZNi4zTyU25I/hm4RqyaEe+I9bMY/yg25Bx/M78F4/U34QT5bi+I
1SXEyVuImZcxP+u2rHcFMeouYsk1xJMDiFMBzA8fhP0deB9dD2T/LvkeP4L7
u+HEx1JPD/p/JX7Ri/G4J1JfUP0H8JnePQ==
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.618033988749895],
  Frame->True,
  FrameLabel->{
    FormBox["\"MeanParticleSpeed, m/s\"", TraditionalForm], 
    FormBox["\"Altitude, Km\"", TraditionalForm]},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 ImageSize->{184, 123},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->279229177]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    ButtonBox["CollisionFrequency",
     BaseStyle->"Link",
     ButtonData->"paclet:StandardAtmosphere/ref/CollisionFrequency"], 
    ButtonBox["DynamicViscosity",
     BaseStyle->"Link",
     ButtonData->"paclet:StandardAtmosphere/ref/DynamicViscosity"]},
   {
    ButtonBox["GravityAcceleration",
     BaseStyle->"Link",
     ButtonData->"paclet:StandardAtmosphere/ref/GravityAcceleration"], 
    ButtonBox["KinematicViscosity",
     BaseStyle->"Link",
     ButtonData->"paclet:StandardAtmosphere/ref/KinematicViscosity"]},
   {
    ButtonBox["KineticTemperature",
     BaseStyle->"Link",
     ButtonData->"paclet:StandardAtmosphere/ref/KineticTemperature"], 
    ButtonBox["MeanDensity",
     BaseStyle->"Link",
     ButtonData->"paclet:StandardAtmosphere/ref/MeanDensity"]},
   {
    ButtonBox["MeanFreePath",
     BaseStyle->"Link",
     ButtonData->"paclet:StandardAtmosphere/ref/MeanFreePath"], 
    ButtonBox["MeanMolecularWeight",
     BaseStyle->"Link",
     ButtonData->"paclet:StandardAtmosphere/ref/MeanMolecularWeight"]},
   {
    ButtonBox["MeanParticleSpeed",
     BaseStyle->"Link",
     ButtonData->"paclet:StandardAtmosphere/ref/MeanParticleSpeed"], 
    ButtonBox["NumberDensity",
     BaseStyle->"Link",
     ButtonData->"paclet:StandardAtmosphere/ref/NumberDensity"]},
   {
    ButtonBox["Pressure",
     BaseStyle->"Link",
     ButtonData->"paclet:StandardAtmosphere/ref/Pressure"], 
    ButtonBox["PressureScaleHeight",
     BaseStyle->"Link",
     ButtonData->"paclet:StandardAtmosphere/ref/PressureScaleHeight"]},
   {
    ButtonBox["SoundSpeed",
     BaseStyle->"Link",
     ButtonData->"paclet:StandardAtmosphere/ref/SoundSpeed"], 
    ButtonBox["ThermalConductivityCoefficient",
     BaseStyle->"Link",
     ButtonData->
      "paclet:StandardAtmosphere/ref/ThermalConductivityCoefficient"]}
  }]], "DefinitionBox",
 CellID->26084],

Cell["Atmospheric properties.", "Caption",
 CellID->25945],

Cell[TextData[{
 "You can also treat the various atmospheric properties as functions of \
altitude. These functions understand the units defined in the ",
 StyleBox[ButtonBox["Units",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/guide/UnitsPackage"], "MR"],
 " package. "
}], "Text",
 CellID->45],

Cell["This gives the mean particle speed at 5 kilometers. ", "MathCaption",
 CellID->30024],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MeanParticleSpeed", "[", 
  RowBox[{"5000", " ", "Meter"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->20894],

Cell[BoxData[
 FractionBox[
  RowBox[{"432.31`", " ", "Meter"}], "Second"]], "Output",
 ImageSize->{89, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->67367331]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Standard Atmosphere Package - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 8, 11.6305476}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Standard Atmosphere Package Tutorial", "language" -> "en", "paclet" -> 
    "StandardAtmosphere Package", "status" -> "None", "summary" -> 
    "Plotting an atmospheric property. This package provides support for \
plotting how U.S. Standard Atmosphere properties vary with altitude. This \
loads the package. ", "synonyms" -> {}, "title" -> 
    "Standard Atmosphere Package", "type" -> "Tutorial", "uri" -> 
    "StandardAtmosphere/tutorial/StandardAtmosphere"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 2863, 58, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3488, 85, 60, 1, 70, "Title",
 CellID->29385],
Cell[3551, 88, 378, 11, 70, "DefinitionBox",
 CellID->15425],
Cell[3932, 101, 69, 1, 70, "Caption",
 CellID->32593],
Cell[4004, 104, 145, 4, 70, "Text",
 CellID->30312],
Cell[4152, 110, 63, 1, 70, "MathCaption",
 CellID->13372],
Cell[4218, 113, 101, 3, 70, "Input",
 CellID->9642],
Cell[4322, 118, 126, 4, 70, "MathCaption",
 CellID->21522],
Cell[CellGroupData[{
Cell[4473, 126, 116, 3, 28, "Input",
 CellID->30324],
Cell[4592, 131, 1254, 28, 143, "Output",
 CellID->38355995]
}, Open  ]],
Cell[5861, 162, 130, 4, 70, "MathCaption",
 CellID->12693],
Cell[CellGroupData[{
Cell[6016, 170, 123, 3, 70, "Input",
 CellID->10655],
Cell[6142, 175, 1559, 33, 144, "Output",
 CellID->279229177]
}, Open  ]],
Cell[7716, 211, 1889, 52, 70, "DefinitionBox",
 CellID->26084],
Cell[9608, 265, 58, 1, 70, "Caption",
 CellID->25945],
Cell[9669, 268, 300, 8, 70, "Text",
 CellID->45],
Cell[9972, 278, 91, 1, 70, "MathCaption",
 CellID->30024],
Cell[CellGroupData[{
Cell[10088, 283, 139, 4, 70, "Input",
 CellID->20894],
Cell[10230, 289, 215, 7, 51, "Output",
 CellID->67367331]
}, Open  ]]
}, Open  ]],
Cell[10472, 300, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

