(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9592,        332]
NotebookOptionsPosition[      7000,        246]
NotebookOutlinePosition[      8296,        283]
CellTagsIndexPosition[      8212,        278]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["STATISTICAL PLOTS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Statistical Plots Package" :> 
          Documentation`HelpLookup[
           "paclet:StatisticalPlots/tutorial/StatisticalPlots"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Statistical Plots Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"BoxLineStyle" :> 
          Documentation`HelpLookup[
           "paclet:StatisticalPlots/ref/BoxLineStyle"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"BoxLineStyle\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["BoxFillingStyle", "ObjectName",
 CellID->241],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["BoxFillingStyle"], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["BoxWhiskerPlot",
       BaseStyle->"Link",
       ButtonData->"paclet:StatisticalPlots/ref/BoxWhiskerPlot"]], 
      "InlineFormula"],
     " which specifies a color to be used in drawing the box."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->18882]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Valid settings are colors or ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->9091],

Cell["\<\
A list of colors can be given for multiple box-and-whisker plots, in which \
case colors are applied cyclically to plots.\
\>", "Notes",
 CellID->677954117],

Cell[TextData[{
 "A value of ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 " specifies a transparent box."
}], "Notes",
 CellID->266809914]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->397185925],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->804875546],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<StatisticalPlots`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->157626748],

Cell["Use a light gray to shade the box:", "ExampleText",
 CellID->322506763],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BoxWhiskerPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "3", ",", "2", ",", "5", ",", "6", ",", "5", ",", "10"}], "}"}],
    ",", 
   RowBox[{"BoxFillingStyle", "\[Rule]", 
    RowBox[{"GrayLevel", "[", ".8", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->224582190],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnL9v2kAUx88xaTrQEcSPxZObHcQAEurULlSoglaRUgmhqIgMVas0EluJ
1IGVlYkRlQ6MiKkjCxIjI38Co8f03pnU9gWQDW5q5O9JPt4z38+7y3HYd5cz
b+u3zU+f67fXV3XtzU39a/P66pv2+ssNP6UqjClNflwmGLfvGTOPF/c8ceMj
o0QeU+m8SOLlgh9KoN69E75hGL9FYi8pUyeTic3/4aAJNqnxePxKJKZTpubz
+Wg0Sua58Ofzua2UzeX/FP5yudQ0jcxfUEJ5NEoSBrl+UIZPecqtCH+NuCae
2ZTME3kmKVXJrwh/tVqt7yYVcXcZDAaJRILM9zz78Dfac4k+4dkpd9+J8+12
O51O53I5VqFMzWazvD5kVoUfi8V4YJJWd0Z8XD8eudFozGYzNqRMLZfL/X7f
GYlalUUs8nEruY9F7X3yEHOvCHJvAAkS5HaSwODXEiRIkMElcRUBCRIkrgUg
QQaPdLca8bSRtq3GeFx5sK3OkO9YFXmC9YbDI/jXosfVJ0GCxEgFJEiQ/5+0
rgW1Wi2VSmUyGTakTI3H491u101ZrVarVCr1ej02pEwtFAqB+ftAggSJEQVI
kOEiD5+h+7nDYXMsa9Wi0+nIezmSyaRjL8doNNqvftZeRnm3SVX40+l0rXfG
Vje0nrs9M6Jirsmz9SflnpB7BZRQHqIkYZDrByWU6OtQQolvBZRhUW6bweze
6b57RuCVpRnKINA1/FdteSy9BMrjUOIOA2VYlOjrUIZFib4OZdCU5sD4IdEz
nt7GvuKpUMdIW35OVPb9jHUnfOsZWV36r8W58A3DsOm9lEVzmu/iPA/k+L2G
YrGo67r1ew2LxWLPMuw+ZRe+8eZGUcvc9Mk6Cbnf+Psu1eWSH4ppKn8A4JYN
Mw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 347},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->89945295]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->17095],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["BoxLineStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:StatisticalPlots/ref/BoxLineStyle"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->7296]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->3523],

Cell[TextData[ButtonBox["Statistical Plots Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:StatisticalPlots/tutorial/StatisticalPlots"]], "Tutorials",
 CellID->31758]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"BoxFillingStyle - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 8, 18.7869808}", "context" -> 
    "StatisticalPlots`", "keywords" -> {}, "index" -> True, "label" -> 
    "Statistical Plots Package Symbol", "language" -> "en", "paclet" -> 
    "StatisticalPlots Package", "status" -> "None", "summary" -> 
    "BoxFillingStyle is an option for BoxWhiskerPlot which specifies a color \
to be used in drawing the box.", "synonyms" -> {}, "title" -> 
    "BoxFillingStyle", "type" -> "Symbol", "uri" -> 
    "StatisticalPlots/ref/BoxFillingStyle"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3597, 130, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->397185925]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 8069, 271}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1239, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1862, 60, 51, 1, 70, "ObjectName",
 CellID->241],
Cell[1916, 63, 556, 16, 70, "Usage",
 CellID->18882]
}, Open  ]],
Cell[CellGroupData[{
Cell[2509, 84, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2987, 101, 193, 8, 70, "Notes",
 CellID->9091],
Cell[3183, 111, 166, 4, 70, "Notes",
 CellID->677954117],
Cell[3352, 117, 208, 8, 70, "Notes",
 CellID->266809914]
}, Closed]],
Cell[CellGroupData[{
Cell[3597, 130, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->397185925],
Cell[CellGroupData[{
Cell[3982, 144, 148, 5, 70, "ExampleSection",
 CellID->804875546],
Cell[4133, 151, 141, 4, 70, "Input",
 CellID->157626748],
Cell[4277, 157, 77, 1, 70, "ExampleText",
 CellID->322506763],
Cell[CellGroupData[{
Cell[4379, 162, 325, 10, 28, "Input",
 CellID->224582190],
Cell[4707, 174, 1131, 23, 368, "Output",
 Evaluatable->False,
 CellID->89945295]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5899, 204, 311, 9, 70, "SeeAlsoSection",
 CellID->17095],
Cell[6213, 215, 220, 6, 70, "SeeAlso",
 CellID->7296]
}, Open  ]],
Cell[CellGroupData[{
Cell[6470, 226, 313, 9, 70, "TutorialsSection",
 CellID->3523],
Cell[6786, 237, 172, 4, 70, "Tutorials",
 CellID->31758]
}, Open  ]],
Cell[6973, 244, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

