(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11620,        393]
NotebookOptionsPosition[      9053,        308]
NotebookOutlinePosition[     10327,        344]
CellTagsIndexPosition[     10242,        339]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["STATISTICAL PLOTS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Statistical Plots Package" :> 
          Documentation`HelpLookup[
           "paclet:StatisticalPlots/tutorial/StatisticalPlots"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Statistical Plots Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"BoxOrientation" :> 
          Documentation`HelpLookup[
           "paclet:StatisticalPlots/ref/BoxOrientation"], "BoxExtraSpacing" :> 
          Documentation`HelpLookup[
           "paclet:StatisticalPlots/ref/BoxExtraSpacing"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"BoxOrientation\"\>", 
       2->"\<\"BoxExtraSpacing\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["BoxLabels", "ObjectName",
 CellID->6321],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["BoxLabels"], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["BoxWhiskerPlot",
       BaseStyle->"Link",
       ButtonData->"paclet:StatisticalPlots/ref/BoxWhiskerPlot"]], 
      "InlineFormula"],
     " which specifies labels to be given for each of the data sets."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->6538]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Valid settings are ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " or a list of labels. The default setting is ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->31351],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"BoxLabels", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", multiple boxes are labeled using ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Range",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Range"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 " where ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " is the number of boxes. For a single box, no label is used."
}], "Notes",
 CellID->19447],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"BoxLabels", "->", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["l", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox["l", 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}]}]], "InlineFormula"],
 " specifies that successive labels ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["s", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " should be used cyclically for successive plots."
}], "Notes",
 CellID->24208]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->51765503],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->30708874],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<StatisticalPlots`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->166735053],

Cell["Give explicit labels for plots:", "ExampleText",
 CellID->218136693],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BoxWhiskerPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "3", ",", "2", ",", "5", ",", "6", ",", "5", ",", "10"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "4.5", ",", "6", ",", "3", ",", "7", ",", "5"}], "}"}], 
   ",", 
   RowBox[{"BoxLabels", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<data set 1\>\"", ",", "\"\<data set 2\>\""}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->677379988],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXM1PE0EUn+4UUBOwUpPWkkCBpFACponEFKNSIsIeJCm2CQTU0hATCqIG
SEiMSU/GD+LVxBN3vckf4JGLCSflyJGLSY891nmzu+zu0JXdfuC2vk327fzm
vfebNx+dnd1Mdya7tfJ0PbuVW86GpzeyL1dyy5vhqRcbLIt6CPGssDMWJCxd
IkQ54cixU0mKqVkmvcyMUA75wbFXx4pSMlzNWgCUXd/XgIuqHFM8MwnyklYL
tTqClOBCTyBpFTA1YEi2CPhtHcrwCnpDbbzGkiStDahempbnVa+S2rpGm9ZS
mTrUhfl+xf3A2+Diic9pB9JWg544u5QLQimTJW3c0zJ8kpCn9aaYr9mK7fWu
Rrxi2yhRp4RccdxdFrA41j849Od607hSRvJDNfJu9boj4OmS1Xzz91S7Wsoj
Phe0C9GItf8i4DQTHtd4gpg3aUF5l1sVCgVZlhOJBOlkQorFYn4AlGUyFZj8
tuQd53h/f/87P8gVJqRMJuMHAPmqnTUD1EnK5/MAKFr9t1Zg5KZ40KrWVjD/
w/TttWUtrmrseYl3KtC0MBjhYGHhCVGONAjAqt3PEwbxDi3eJwc5jsfvPF78
/PrVD5ICQRlgWaD6VQcmfuc03fnE1rDPBe0qaZwVMYi9jZ7oeb6e4Oj+KNET
PRvDc42Jq3zFvre3p67kOzk+ODhQOcYd/wJXuf7o6CjBD/50QWgoFBoaGtJx
MpksW4KT+PNcv7S0tLu7C0nr5yBkQiZkajQmO7NN49UKmZCpmZnKPYu7ndnq
HUV1jMb3GID1NxKVMFb6BH+ejPXrITeOdGRCpn/JlOb64+Nj9dltkD+7ybK8
vb0NySjHxWLRwOdsdaWUEI2O9PXFBgZukkEQNBAI9/Ze1/G1YN/a6nMwjVZZ
l1Co+9naN10/8yCvvKxFZmRGZmR2LbM+m/b3RwKBSE/PDZICwWbLCMvSGTs6
fF1dI7re7w9PTNyzE+vo6NjU5CaLkKRAUAZYls4cDHbNJt/o+ltjmbm5xeZo
X2RGZmRG5srnZffHiszIjMzNyFzpmzb7JVS/V6jasvS3m7ncOlEOZb8Vw6ql
spNVlmdM+p2dj4YY7dZH2wn2ledbvYOlZVr9bE9xR7XzsttK+j53Z55Wu+rQ
o7k9wME90aAHepyXxyeeXywWTXuQ9PfYZ+9JMjMdHh6a9h4NDw/H43Eds9jK
MpWLDYD791ijVb2sjKPLDfGgVa2trNbm1v9msLcurY2fMTpYYc+6Lio39ila
4UyHVjhi0KoRrXBcNa6V+Usa2tce7K0T+D8lT31BwugnYjfwwKrsNs8vFAo+
nw88B0BQBk79k955bCDma+Zv/C4Ktegds4fY7061UNoiOz1K0vMHRmpjcQ==
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 304},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->409069974]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->30422],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["BoxOrientation",
    BaseStyle->"Link",
    ButtonData->"paclet:StatisticalPlots/ref/BoxOrientation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BoxExtraSpacing",
    BaseStyle->"Link",
    ButtonData->"paclet:StatisticalPlots/ref/BoxExtraSpacing"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->27666]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->9646],

Cell[TextData[ButtonBox["Statistical Plots Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:StatisticalPlots/tutorial/StatisticalPlots"]], "Tutorials",
 CellID->22276]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"BoxLabels - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 8, 18.9901110}", "context" -> 
    "StatisticalPlots`", "keywords" -> {}, "index" -> True, "label" -> 
    "Statistical Plots Package Symbol", "language" -> "en", "paclet" -> 
    "StatisticalPlots Package", "status" -> "None", "summary" -> 
    "BoxLabels is an option for BoxWhiskerPlot which specifies labels to be \
given for each of the data sets.", "synonyms" -> {}, "title" -> "BoxLabels", 
    "type" -> "Symbol", "uri" -> "StatisticalPlots/ref/BoxLabels"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4731, 168, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->51765503]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 10100, 332}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1400, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2023, 63, 46, 1, 70, "ObjectName",
 CellID->6321],
Cell[2072, 66, 556, 16, 70, "Usage",
 CellID->6538]
}, Open  ]],
Cell[CellGroupData[{
Cell[2665, 87, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3143, 104, 483, 18, 70, "Notes",
 CellID->31351],
Cell[3629, 124, 547, 19, 70, "Notes",
 CellID->19447],
Cell[4179, 145, 515, 18, 70, "Notes",
 CellID->24208]
}, Closed]],
Cell[CellGroupData[{
Cell[4731, 168, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->51765503],
Cell[CellGroupData[{
Cell[5115, 182, 147, 5, 70, "ExampleSection",
 CellID->30708874],
Cell[5265, 189, 141, 4, 70, "Input",
 CellID->166735053],
Cell[5409, 195, 74, 1, 70, "ExampleText",
 CellID->218136693],
Cell[CellGroupData[{
Cell[5508, 200, 473, 15, 47, "Input",
 CellID->677379988],
Cell[5984, 217, 1616, 31, 325, "Output",
 Evaluatable->False,
 CellID->409069974]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7661, 255, 311, 9, 70, "SeeAlsoSection",
 CellID->30422],
Cell[7975, 266, 511, 17, 70, "SeeAlso",
 CellID->27666]
}, Open  ]],
Cell[CellGroupData[{
Cell[8523, 288, 313, 9, 70, "TutorialsSection",
 CellID->9646],
Cell[8839, 299, 172, 4, 70, "Tutorials",
 CellID->22276]
}, Open  ]],
Cell[9026, 306, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

