(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13661,        450]
NotebookOptionsPosition[     10817,        354]
NotebookOutlinePosition[     12075,        390]
CellTagsIndexPosition[     11990,        385]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["STATISTICAL PLOTS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Statistical Plots Package" :> 
          Documentation`HelpLookup[
           "paclet:StatisticalPlots/tutorial/StatisticalPlots"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Statistical Plots Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"BoxOutlierMarkers" :> 
          Documentation`HelpLookup[
           "paclet:StatisticalPlots/ref/BoxOutlierMarkers"], "BoxQuantile" :> 
          Documentation`HelpLookup[
           "paclet:StatisticalPlots/ref/BoxQuantile"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"BoxOutlierMarkers\"\>", 
       2->"\<\"BoxQuantile\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["BoxOutliers", "ObjectName",
 CellID->27649],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["BoxOutliers"], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["BoxWhiskerPlot",
       BaseStyle->"Link",
       ButtonData->"paclet:StatisticalPlots/ref/BoxWhiskerPlot"]], 
      "InlineFormula"],
     " which specifies the outliers to draw."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->22015]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Valid settings are ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["All",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/All"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->26841],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"BoxOutliers", "->", 
   ButtonBox["None",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/None"]}]], "InlineFormula"],
 ", no outliers are drawn and whiskers are drawn to cover the entire data \
set. "
}], "Notes",
 CellID->189],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"BoxOutliers", "->", 
   ButtonBox["All",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/All"]}]], "InlineFormula"],
 ", near and far outliers are drawn identically. "
}], "Notes",
 CellID->16100],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 ", near and far outliers are drawn as specified by the ",
 Cell[BoxData[
  ButtonBox["BoxOutlierMarkers",
   BaseStyle->"Link",
   ButtonData->"paclet:StatisticalPlots/ref/BoxOutlierMarkers"]], 
  "InlineFormula"],
 " option."
}], "Notes",
 CellID->19812]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->26184412],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->12316298],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<StatisticalPlots`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->377925819],

Cell["Mark near and far outliers identically:", "ExampleText",
 CellID->57204223],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BoxWhiskerPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "700", ",", "800", ",", "1100", ",", "1200", ",", "1000", ",", 
     "900", ",", "1000", ",", "2500"}], "}"}], ",", 
   RowBox[{"BoxOutliers", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->86225238],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztW82O0zAQdtZNQb3ArVGLUJRVsxw5ICQqEEgI6IGfTYU4IaRqhdQVINCy
pxU8CCf+qvZOH6DHXpB67LGP0EcIHqfeOk43P43LelNbiTOTb2bsnczG07Hy
rHPcffuhc3x40LGfHHU+dQ8PPtuPPx6RW9hAyOiS07MQoX2EgrPqk0aINoIG
HMJwnzZ6eU5OIzd6lVA75GoKUr9Jh+/f+zY4lbwCt0tLCYRKgs4v0plEp59B
5yfpyil0THL9sYb9df6OdB6S9wyKiTJQjdkUD9X+1d7fVlR7Pw9qLjyI/WBl
Y9f4Fe4yhwK/E8MDKfL5rZkL9umG5lRe+IFKlZdSzFx2a8g8RaXM8BI3w/RP
Ts0o1G+IoqBfSXdjNBohPBwOR7ShBuXH4zEnE346X6iV2Wz2gDbUgA43m81K
pQKkS/lWqzWfz6MW+PF7zJJt20D2teQFlvQoP5lMFpG0TyNpMBhYlgVkm/LT
6ZSTD0eWxyzu7d0mB9qHDrvurVptF0iP8o5zs16/DqLthLlAsJ78JQfqQYff
v/tTq2lNramUZijylZ2l1lRNMyh/sSZmlmdlmOnt04w2VG+Ly4FFHkiRP/+x
r9Ufvnk9JAfqQYdfvey7jUebGBt+QLyg963qHXHMXedu8X2dKobxMobFyM0f
wRfr/1lrZl4txTyxWrVDeaLjuGnGTspZSfbLyauYe2vJ/JJyf9tm/22tQkWg
GCgD1ZjNtqHa+3nQIN1hjYlmq/iL+RjmeBFfJR9fy5ZhPboj8B/mvMxxfZn7
BRSN7BdgKbb5/Ljk6z2EdKh+A2nvbyuqva+9ry4KS3DaSmVYM9iWZ6uoH1lL
UQLvJ6618utgYftZMpqzrEfzJhlW47zO+2MTXlmnAhi2oGak6/dMcVHtfe39
bUW19/PmP+F926S1LvodBNMPev4bCACzrsbRbz9k1Xe+++IXIjhmLnLmHhkB
rV/lWeV53srquo+8bOh86j0wukdOIyCNf2ipzxM=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 337},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->379045663]
}, Open  ]],

Cell["\<\
Use triangles for near outliers and squares for far outliers:\
\>", "ExampleText",
 CellID->438236984],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BoxWhiskerPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "700", ",", "800", ",", "1100", ",", "1200", ",", "1000", ",", 
     "900", ",", "1000", ",", "2500"}], "}"}], ",", 
   RowBox[{"BoxOutliers", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"BoxOutlierMarkers", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      GraphicsBox[
       PolygonBox[{{0.31361111111111, 0.569141111111111}, {0.0202777777777772,
         0.0358077777777774}, {0.611388888888888, 0.0358077777777774}}],
       ImageSize->{19., 16.},
       PlotRange->{{0, 1}, {0, 0.61803}},
       PlotRegion->{{0., 1.57342657342657}, {0., 1.}}], ",", 
      GraphicsBox[RectangleBox[{0, 0}],
       ImageSize->{11., Automatic}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->166733461],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztW0FrE0EUnmSSNtGCAYWmiUhI27THFkRK8SAImkPVpIgnKYQgtGhQag9F
9Df0bNVaMDZFyUVPOXnsRSg99dif0GOP63tvZ7u7s0l2N9niNpkhOzsv33vf
vL593Xk7Sx5VNlZf1Coba9VK7uF65c3qWvVt7sHrdfiKRxiLrMKxkmYw1hjT
D2xrcOjDIEfjGp3YMsOGEuPGjBr7SPL+/j7T21XseKlUEvg36CJtLbdJnpqa
EpZJsoxGo6enpwjVXSyPjo5slrVaTeCmZQpGUTjHJYZPJC8sLAiGUWJIJpMC
/37OcA3FmGnJWKwtFzgNrptcW1tbPXB9JhmiJ/yKE9fExITA91y4UH/b8Af+
HJMDrpBHDqs/X0je3NwU/nDq5ufnBd7wwbVDciqVElwULLyKDq5OV40Y4mau
MYaR+tExT76STxA9nI3yykVX5BRkEvvZUXOX5Gq1KuTOnNg9DgVqgOHwZthQ
FX0V/WFFVfT7QeMiglzTV0TjLK+MdquEBUU52kXGoSz3zxYX4tIF+TQi4kBa
I6aWQeefjcXP0UA8HLV46P3KhTML1R1iUND3JJ+dnf2hxgrY8WazKeRpkg8O
DoT+B8eV0hmOj4/vUWPT2PHFxcVEIoHDAslQl8MkTgarL3WST05OcrkcDveU
5iXWLJN8eHgoMqlEmdRoNNLpNA6XSYa8sejbM6tsMM7M3IEPK2HHC4Xbmcwk
Dssk5/Nz2ewtVF128QWT9d1f+LA6dvzVy1+ZjLJUlqGytGV+aL1UlmGz1LfX
jCZXmZ2qTe/8VN3a9vO61cOyjENZ/v9z38zeX3n+Gz6sjh1/9nRvdmbpIubG
h4kn9P2N63PynJP5u4Mfa085zM0cljO3/wy+XP/PytL3ainXiePjOVudmM8X
vMztVrNC9WvRD2PtrTT71zSfbSEf5GfbsbEx89m2WCy6PtsiMkvZ02q1bM/W
wG7RCdfuwGCgBhgOb4YNVdHvjuoFjdEMVX/7+3LFxS2yjLfT775zHX5259sF
qYrVgnw7QKjj7QAPhNtaAcc09cYgCFTdgVT0hxVV0VfRDy+KC7TXnUq7pf6K
3lhjNcdKy1xkzXUlDn4fzM7vp87pxO6se4Jg7RZ1azwuIiq97ADaGcKZ6eo+
M7ioir6K/rCiKvoyugvdFRDN37nEqNM0c5fHbUVzchj2em/9JQWCftdcJ3/Q
ezzOGXgXC68zYL2z487Met/paRd5K0v7vZ/+o9PLvo+TxT0X/WtgZ8929LMM
R4SG+IWXX42xyD+KiolV\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 350},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->478151976]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->28633],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["BoxOutlierMarkers",
    BaseStyle->"Link",
    ButtonData->"paclet:StatisticalPlots/ref/BoxOutlierMarkers"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BoxQuantile",
    BaseStyle->"Link",
    ButtonData->"paclet:StatisticalPlots/ref/BoxQuantile"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->29891]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->30648],

Cell[TextData[ButtonBox["Statistical Plots Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:StatisticalPlots/tutorial/StatisticalPlots"]], "Tutorials",
 CellID->9523]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"BoxOutliers - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 8, 19.9588858}", "context" -> 
    "StatisticalPlots`", "keywords" -> {}, "index" -> True, "label" -> 
    "Statistical Plots Package Symbol", "language" -> "en", "paclet" -> 
    "StatisticalPlots Package", "status" -> "None", "summary" -> 
    "BoxOutliers is an option for BoxWhiskerPlot which specifies the outliers \
to draw.", "synonyms" -> {}, "title" -> "BoxOutliers", "type" -> "Symbol", 
    "uri" -> "StatisticalPlots/ref/BoxOutliers"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4549, 166, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->26184412]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 11848, 378}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1397, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2020, 63, 49, 1, 70, "ObjectName",
 CellID->27649],
Cell[2072, 66, 535, 16, 70, "Usage",
 CellID->22015]
}, Open  ]],
Cell[CellGroupData[{
Cell[2644, 87, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3122, 104, 432, 18, 70, "Notes",
 CellID->26841],
Cell[3557, 124, 283, 10, 70, "Notes",
 CellID->189],
Cell[3843, 136, 251, 9, 70, "Notes",
 CellID->16100],
Cell[4097, 147, 415, 14, 70, "Notes",
 CellID->19812]
}, Closed]],
Cell[CellGroupData[{
Cell[4549, 166, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->26184412],
Cell[CellGroupData[{
Cell[4933, 180, 147, 5, 70, "ExampleSection",
 CellID->12316298],
Cell[5083, 187, 141, 4, 70, "Input",
 CellID->377925819],
Cell[5227, 193, 81, 1, 70, "ExampleText",
 CellID->57204223],
Cell[CellGroupData[{
Cell[5333, 198, 325, 9, 28, "Input",
 CellID->86225238],
Cell[5661, 209, 1229, 24, 358, "Output",
 Evaluatable->False,
 CellID->379045663]
}, Open  ]],
Cell[6905, 236, 112, 3, 70, "ExampleText",
 CellID->438236984],
Cell[CellGroupData[{
Cell[7042, 243, 807, 20, 50, "Input",
 CellID->166733461],
Cell[7852, 265, 1514, 29, 371, "Output",
 Evaluatable->False,
 CellID->478151976]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9427, 301, 311, 9, 70, "SeeAlsoSection",
 CellID->28633],
Cell[9741, 312, 509, 17, 70, "SeeAlso",
 CellID->29891]
}, Open  ]],
Cell[CellGroupData[{
Cell[10287, 334, 314, 9, 70, "TutorialsSection",
 CellID->30648],
Cell[10604, 345, 171, 4, 70, "Tutorials",
 CellID->9523]
}, Open  ]],
Cell[10790, 352, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

