(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12424,        435]
NotebookOptionsPosition[      9742,        346]
NotebookOutlinePosition[     11012,        382]
CellTagsIndexPosition[     10927,        377]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["STATISTICAL PLOTS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Statistical Plots Package" :> 
          Documentation`HelpLookup[
           "paclet:StatisticalPlots/tutorial/StatisticalPlots"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Statistical Plots Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DataSpacing" :> 
          Documentation`HelpLookup["paclet:StatisticalPlots/ref/DataSpacing"],
           "DataTicks" :> 
          Documentation`HelpLookup["paclet:StatisticalPlots/ref/DataTicks"], 
          "DataRanges" :> 
          Documentation`HelpLookup["paclet:StatisticalPlots/ref/DataRanges"], 
          "PlotDirection" :> 
          Documentation`HelpLookup[
           "paclet:StatisticalPlots/ref/PlotDirection"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"DataSpacing\"\>", 2->"\<\"DataTicks\"\>", 
       3->"\<\"DataRanges\"\>", 
       4->"\<\"PlotDirection\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["DataLabels", "ObjectName",
 CellID->11064],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["DataLabels"], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["PairwiseScatterPlot",
       BaseStyle->"Link",
       ButtonData->"paclet:StatisticalPlots/ref/PairwiseScatterPlot"]], 
      "InlineFormula"],
     " which specifies labels for each column of data."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->9166]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["DataLabels"], "InlineFormula"],
 " are placed on the rows and columns of the matrix of scatter plots to \
identify the ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " data."
}], "Notes",
 CellID->8198298],

Cell[TextData[{
 "Valid settings are ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " or a list of labels. "
}], "Notes",
 CellID->16893],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"DataLabels", "->", 
   ButtonBox["None",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/None"]}]], "InlineFormula"],
 ", no labels are drawn."
}], "Notes",
 CellID->201093786],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"DataLabels", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", the columns of the matrix of data are labeled sequentially."
}], "Notes",
 CellID->16074],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"DataLabels", "->", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["l", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["l", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}]}]], "InlineFormula"],
 ", the label ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["l", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " is assigned to the ",
 Cell[BoxData[
  SuperscriptBox[
   StyleBox["i", "TI"], "th"]], "InlineFormula"],
 " column of data."
}], "Notes",
 CellID->13509]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->381573717],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->286047343],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<StatisticalPlots`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->40238483],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PairwiseScatterPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:StatisticalPlots/ref/PairwiseScatterPlot"]], 
  "InlineFormula"],
 " with matrix column numbers as labels:"
}], "ExampleText",
 CellID->299346622],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PairwiseScatterPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5", ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"9", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "8"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "3"}], "}"}]}], "}"}], ",", 
   RowBox[{"DataLabels", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->145812446],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmzFv2kAUxw8fThgQYkHqgBoLGDIyMLDRqR2qzh1CK1BUyQg1rdKsKKO7
+SOgZqF2PgAjH4WPQt+d7byelVS+klYO+Vvy+d7z7/8HHsMzp+Pd9Mr/9Hl6
NTufem8up1/92fk37/WXS0rJihAVn86LF4LmOyGSUx0zOpNpfnZGoyQsomuV
rh90dqxGmal3+m4WiwepOBeP76Vuc/HZHtRPNVQ5zt6Zoh2KbtPrxwc/P8+O
tXcYhq/0ISI1yMFg0O/31TTWcRAE6Wu5v6noFgk3m42IaHBIEatArlYrz/MU
cmTSdDerqzMajZLKbbfbg6SrOqbK0Tfh+764SdXuPfmiboSQqlar5dzMfFG3
9XpNqeVymXMz80+p5qBBgwYN2oYe6pg70kWqPs3lry3cuCOZbpy3ceOOZLpx
vphbeWoOGjRo0KBB/0tayOSiDrUm4FipE5pXQOzU+qWP7tYp6EiU8R9V+rep
e6dKJOLxNelSBi+i/EVtnKzApfiu96MDHfPT3kmqHufyby3c+GnPdOO8jRs/
7ZlunC/mVp6agwYNGjRoG/qHjrkjuan6Opc/tXDjjmS6cd7GjTuS6cb5Ym7l
qTlo0KBBg7ahX+qYO9L3VH2Ty7sWbtyRTDezgxV1445kupkd7CnV/PHp4XA4
n8/DMBSRGmS32+10OhwvFot2u51X9Xq9er3ebDZFRIMjpYxVIBuNRqvVKu+n
LSONvRSgQYMGjWcK0KBBg1ZT7FwCDRp0WWm1R0D+p30Th6o6tH0WoEGDBg0a
NOjDpQMdYz8laNCgnzeNHXvPj55MJun/Tigl3quJctjpI/3zhZrO9p6Jyi9R
85pN\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 366},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->138716300]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->13161],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["DataSpacing",
    BaseStyle->"Link",
    ButtonData->"paclet:StatisticalPlots/ref/DataSpacing"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DataTicks",
    BaseStyle->"Link",
    ButtonData->"paclet:StatisticalPlots/ref/DataTicks"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DataRanges",
    BaseStyle->"Link",
    ButtonData->"paclet:StatisticalPlots/ref/DataRanges"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PlotDirection",
    BaseStyle->"Link",
    ButtonData->"paclet:StatisticalPlots/ref/PlotDirection"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->31172]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->30300],

Cell[TextData[ButtonBox["Statistical Plots Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:StatisticalPlots/tutorial/StatisticalPlots"]], "Tutorials",
 CellID->19695]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DataLabels - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 8, 27.2403222}", "context" -> 
    "StatisticalPlots`", "keywords" -> {}, "index" -> True, "label" -> 
    "Statistical Plots Package Symbol", "language" -> "en", "paclet" -> 
    "StatisticalPlots Package", "status" -> "None", "summary" -> 
    "DataLabels is an option for PairwiseScatterPlot which specifies labels \
for each column of data.", "synonyms" -> {}, "title" -> "DataLabels", "type" -> 
    "Symbol", "uri" -> "StatisticalPlots/ref/DataLabels"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5202, 188, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->381573717]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 10784, 370}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1651, 41, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2274, 68, 48, 1, 70, "ObjectName",
 CellID->11064],
Cell[2325, 71, 553, 16, 70, "Usage",
 CellID->9166]
}, Open  ]],
Cell[CellGroupData[{
Cell[2915, 92, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3393, 109, 317, 11, 70, "Notes",
 CellID->8198298],
Cell[3713, 122, 333, 13, 70, "Notes",
 CellID->16893],
Cell[4049, 137, 231, 9, 70, "Notes",
 CellID->201093786],
Cell[4283, 148, 276, 9, 70, "Notes",
 CellID->16074],
Cell[4562, 159, 603, 24, 70, "Notes",
 CellID->13509]
}, Closed]],
Cell[CellGroupData[{
Cell[5202, 188, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->381573717],
Cell[CellGroupData[{
Cell[5587, 202, 148, 5, 70, "ExampleSection",
 CellID->286047343],
Cell[5738, 209, 140, 4, 70, "Input",
 CellID->40238483],
Cell[5881, 215, 257, 8, 70, "ExampleText",
 CellID->299346622],
Cell[CellGroupData[{
Cell[6163, 227, 531, 17, 28, "Input",
 CellID->145812446],
Cell[6697, 246, 1071, 22, 387, "Output",
 Evaluatable->False,
 CellID->138716300]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7829, 275, 311, 9, 70, "SeeAlsoSection",
 CellID->13161],
Cell[8143, 286, 1031, 35, 70, "SeeAlso",
 CellID->31172]
}, Open  ]],
Cell[CellGroupData[{
Cell[9211, 326, 314, 9, 70, "TutorialsSection",
 CellID->30300],
Cell[9528, 337, 172, 4, 70, "Tutorials",
 CellID->19695]
}, Open  ]],
Cell[9715, 344, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

