(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10532,        358]
NotebookOptionsPosition[      7972,        274]
NotebookOutlinePosition[      9296,        311]
CellTagsIndexPosition[      9212,        306]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["STATISTICAL PLOTS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Statistical Plots Package" :> 
          Documentation`HelpLookup[
           "paclet:StatisticalPlots/tutorial/StatisticalPlots"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Statistical Plots Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"StemExponent" :> 
          Documentation`HelpLookup[
           "paclet:StatisticalPlots/ref/StemExponent"], "IncludeStemUnits" :> 
          Documentation`HelpLookup[
           "paclet:StatisticalPlots/ref/IncludeStemUnits"], 
          "IncludeStemCounts" :> 
          Documentation`HelpLookup[
           "paclet:StatisticalPlots/ref/IncludeStemCounts"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"StemExponent\"\>", 
       2->"\<\"IncludeStemUnits\"\>", 
       3->"\<\"IncludeStemCounts\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["IncludeEmptyStems", "ObjectName",
 CellID->9676],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["IncludeEmptyStems"], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["StemLeafPlot",
       BaseStyle->"Link",
       ButtonData->"paclet:StatisticalPlots/ref/StemLeafPlot"]], 
      "InlineFormula"],
     " which specifies whether stems with no leaves should be included in the \
plot."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->15629]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Valid settings are ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->28650],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{"IncludeEmptyStems", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", stems with no leaves are omitted from the plot."
}], "Notes",
 CellID->2598]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->714374911],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->131054255],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<StatisticalPlots`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->263652107],

Cell["Include stems which have no leaves:", "ExampleText",
 CellID->617151523],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StemLeafPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1.2", ",", "2.5", ",", "7.1", ",", "1.6", ",", "2.6", ",", "2.9"}], 
    "}"}], ",", 
   RowBox[{"IncludeEmptyStems", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->119666391],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVWU1P3DAQ9TrOwhZVqoREl5YWpIJUiY8bf6E99dYbpxWqBIeqFfAv+qNd
O7aTycvYsXe7NETKJnbGMy8zbxx79tvq6e7Hz9XT/e3q5OvD6vfd/e3jyZdf
D6armgkhbsz5ZynMvTZ3zXmjtbnSX1G5i/2V5lqbm8p3K9E9t0dtzoVpSuiv
hB8owmHvrbTy2qTXpvzoPXO1z2c9DMJLNkN1OFpjlVdsjjmR6noXRCq8D69P
gWSjfwekqG1Fn1m9r0GDe5OatVaDrIqjH4wtwE/aO9B+U4i2BsvbQRnYsc+i
k/4pqyWJIAdtyw3KlxG8vOVKpxhB8yt4ttJdVlSiL7NLsMnWiSGpJBmtiDY1
jkO1NogeKncF7XfRqEjAfAmSx9SCGM45pb+fQP91oncJvbvQDjE4z5LGPHKj
Dkek/v8ojN08a9SB5vid55MD71eUtpYtFy4TMZtC71vtsgq/IdcFntm+rEoj
JL2vom9Je3ldS+8LHscUorXtGI7lT4lUGlVeRPKl1AuM26H3EM4sJV620Z1H
dZTEvvF1t96LytFvR1xbnpT1gHyBkZtmxi29N3lU+XwqYUzcC1OIE9+b+maH
Faa9hhXncYFn+L0Fv0/A/dFR69XUnNe0e3nK7S9o+73GjLS3iDyit7cDtI0P
OmRuanUUfElX6UMPOF1jzMQ2+74R3XlRQwt5ey9nIZYFc93t/SmbPuqp5EFZ
duAu7kznsKokH06zNLJsWFMXsnYTXE17kC15Xhrm3ucNvIv54TBYntqvA66Q
Q6aGCph72xLGfBd+/fHMTC2t4WG0KaPDHFUz/gvPQzVv0bMe53Ne9Y7ld48L
WJ/h5zu0ljdLNtY3qt89F37Wzlq1vJwZhfKCj67U/fnQseJfVO/Wm/HiKDfr
dQxZp5439oWla61WR1f3E31vqg7LaE0P11Bo/aKNFdb0jkAyzCmujuP/O5j9
BXIYt9Y=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{91, 139},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->235885605]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->10116],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["StemExponent",
    BaseStyle->"Link",
    ButtonData->"paclet:StatisticalPlots/ref/StemExponent"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["IncludeStemUnits",
    BaseStyle->"Link",
    ButtonData->"paclet:StatisticalPlots/ref/IncludeStemUnits"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["IncludeStemCounts",
    BaseStyle->"Link",
    ButtonData->"paclet:StatisticalPlots/ref/IncludeStemCounts"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->2168]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->3309],

Cell[TextData[ButtonBox["Statistical Plots Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:StatisticalPlots/tutorial/StatisticalPlots"]], "Tutorials",
 CellID->4693]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"IncludeEmptyStems - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 8, 28.0840938}", "context" -> 
    "StatisticalPlots`", "keywords" -> {}, "index" -> True, "label" -> 
    "Statistical Plots Package Symbol", "language" -> "en", "paclet" -> 
    "StatisticalPlots Package", "status" -> "None", "summary" -> 
    "IncludeEmptyStems is an option for StemLeafPlot which specifies whether \
stems with no leaves should be included in the plot.", "synonyms" -> {}, 
    "title" -> "IncludeEmptyStems", "type" -> "Symbol", "uri" -> 
    "StatisticalPlots/ref/IncludeEmptyStems"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3970, 138, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->714374911]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 9069, 299}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1569, 40, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2192, 67, 54, 1, 70, "ObjectName",
 CellID->9676],
Cell[2249, 70, 578, 17, 70, "Usage",
 CellID->15629]
}, Open  ]],
Cell[CellGroupData[{
Cell[2864, 92, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3342, 109, 306, 13, 70, "Notes",
 CellID->28650],
Cell[3651, 124, 282, 9, 70, "Notes",
 CellID->2598]
}, Closed]],
Cell[CellGroupData[{
Cell[3970, 138, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->714374911],
Cell[CellGroupData[{
Cell[4355, 152, 148, 5, 70, "ExampleSection",
 CellID->131054255],
Cell[4506, 159, 141, 4, 70, "Input",
 CellID->263652107],
Cell[4650, 165, 78, 1, 70, "ExampleText",
 CellID->617151523],
Cell[CellGroupData[{
Cell[4753, 170, 291, 9, 28, "Input",
 CellID->119666391],
Cell[5047, 181, 1196, 24, 160, "Output",
 Evaluatable->False,
 CellID->235885605]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6304, 212, 311, 9, 70, "SeeAlsoSection",
 CellID->10116],
Cell[6618, 223, 788, 26, 70, "SeeAlso",
 CellID->2168]
}, Open  ]],
Cell[CellGroupData[{
Cell[7443, 254, 313, 9, 70, "TutorialsSection",
 CellID->3309],
Cell[7759, 265, 171, 4, 70, "Tutorials",
 CellID->4693]
}, Open  ]],
Cell[7945, 272, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

