(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12026,        407]
NotebookOptionsPosition[      9361,        319]
NotebookOutlinePosition[     10684,        356]
CellTagsIndexPosition[     10599,        351]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["STATISTICAL PLOTS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Statistical Plots Package" :> 
          Documentation`HelpLookup[
           "paclet:StatisticalPlots/tutorial/StatisticalPlots"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Statistical Plots Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Leaves" :> 
          Documentation`HelpLookup["paclet:StatisticalPlots/ref/Leaves"], 
          "IncludeStemUnits" :> 
          Documentation`HelpLookup[
           "paclet:StatisticalPlots/ref/IncludeStemUnits"], 
          "IncludeEmptyStems" :> 
          Documentation`HelpLookup[
           "paclet:StatisticalPlots/ref/IncludeEmptyStems"], "ColumnLabels" :> 
          Documentation`HelpLookup[
           "paclet:StatisticalPlots/ref/ColumnLabels"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Leaves\"\>", 2->"\<\"IncludeStemUnits\"\>", 
       3->"\<\"IncludeEmptyStems\"\>", 
       4->"\<\"ColumnLabels\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["IncludeStemCounts", "ObjectName",
 CellID->28869],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["IncludeStemCounts"], "InlineFormula"],
     " \[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["StemLeafPlot",
       BaseStyle->"Link",
       ButtonData->"paclet:StatisticalPlots/ref/StemLeafPlot"]], 
      "InlineFormula"],
     " which specifies whether a column of counts for each stem should be \
included."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->58]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Valid settings for are ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->14700],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{"IncludeStemCounts", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", a column of stem counts is included only when the ",
 Cell[BoxData[
  ButtonBox["Leaves",
   BaseStyle->"Link",
   ButtonData->"paclet:StatisticalPlots/ref/Leaves"]], "InlineFormula"],
 " option is set to ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->13971],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{"IncludeStemCounts", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", a column of leaf counts is included in the plot. "
}], "Notes",
 CellID->26264],

Cell["\<\
For a single stem-and-leaf plot the count column is placed to the right of \
the leaf column. For a plot of two data sets the count columns are placed \
outside the leaf columns.\
\>", "Notes",
 CellID->15117]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->5489810],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->677433483],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<StatisticalPlots`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->234567628],

Cell["Add a column of stem counts to the plot:", "ExampleText",
 CellID->8106186],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StemLeafPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1.2", ",", "2.5", ",", "4.1", ",", "1.6", ",", "3.8", ",", "2.6", ",", 
     "2.9"}], "}"}], ",", 
   RowBox[{"IncludeStemCounts", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->48973463],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVWF9v0zAQdxMn3UBoDAZ0CIlJ8AoSGtNAogiJrTzxEXiopknbAwKNfYt9
aM9O7eTy8zl20qxApNa5y/n++e5s3/fl9cX5z+X15dny4NvV8vfF5dmfg8Wv
K43KJ0KIG/37MRP6Xem36nejlB7pv8hXg/nP9Fjol9yipWi+m6fQv20NZoDP
hZ0o3GPeDbW03DLLTdrZ9/Vovr9r6SAsZTVVuacWllvG+ikJVYPdJlTOHp6f
BMqK/xSoqGxJvxm+D4DDypKClVYArQxr783toT+BpwA/7KltAZLvRksXHY9Z
7TL7leXSqUGKtnVs0HiJ6MtLzlVXRND8cp7NVZMVuWjTbBHdstqJLqkyMlsS
bjKuh6xlED6U7i3Az4OrkoHOb4DypaU5VFht+v6/As7nHdh96xeMfef1r3as
os2zrgQYuZwCvOLyVP+XjMz02X48bQ3i9Uy1qtRgPjOCHa7NOFzMimbM7NLi
F3Z8ovrGymaxZm1y4e9PpcWfKBqZaVHB127ej7FY/1u8Znb9Qn5Z3LkG4/s6
ttan6v+IWeOZIpB7bvdx50QzfrDj3tp+5c8SeIZ6z1KRWkhocS0quFUruZMJ
hY8B3lUufikW7QvIaZ0lDfCR5b4PWKyZbiXo/u97xGie1esSyx2EWb94Mnj9
02IAJaad9o5YbDwD3R2ERu6xopH7L+Rev4zEU+Vc0d0kFqN9cvBTh9djctjI
8njNgWoviTdmBq/9Z6BK07uCvYz9AlSPknj59eAEKNLqCr9mmKtzlqrJEVMV
7sEcV1NcF2CuhuaGaT5sOkP69jJCNwVaUR2MsStF09XYVe090XU5vB5Jc5cT
7Vug4yZG64Ww+deKPbzt8rUdpaXtCDsslrfHu4V3W97RpTFNr0kFr9OH2ZTn
UA7e23muHT6MVoRpoo/C3Z+Uqk4zKKwt3bGwOzW+5bQPOU5nadj+1seGPtid
NT0Yzjk+SlYRNKS3FTv70Tpa82jVTbp6krG9ILPjnTQardaqaKcM7xdoxyHr
M9zVq9MA2097EbDoyOr5uiK1/fvJLeG0TVo=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{139, 93},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->136125795]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->3039],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Leaves",
    BaseStyle->"Link",
    ButtonData->"paclet:StatisticalPlots/ref/Leaves"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["IncludeStemUnits",
    BaseStyle->"Link",
    ButtonData->"paclet:StatisticalPlots/ref/IncludeStemUnits"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["IncludeEmptyStems",
    BaseStyle->"Link",
    ButtonData->"paclet:StatisticalPlots/ref/IncludeEmptyStems"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ColumnLabels",
    BaseStyle->"Link",
    ButtonData->"paclet:StatisticalPlots/ref/ColumnLabels"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->30212]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->16215],

Cell[TextData[ButtonBox["Statistical Plots Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:StatisticalPlots/tutorial/StatisticalPlots"]], "Tutorials",
 CellID->24555]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"IncludeStemCounts - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 8, 28.2872240}", "context" -> 
    "StatisticalPlots`", "keywords" -> {}, "index" -> True, "label" -> 
    "Statistical Plots Package Symbol", "language" -> "en", "paclet" -> 
    "StatisticalPlots Package", "status" -> "None", "summary" -> 
    "IncludeStemCounts is an option for StemLeafPlot which specifies whether \
a column of counts for each stem should be included.", "synonyms" -> {}, 
    "title" -> "IncludeStemCounts", "type" -> "Symbol", "uri" -> 
    "StatisticalPlots/ref/IncludeStemCounts"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4997, 173, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->5489810]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 10458, 344}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1688, 42, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2311, 69, 55, 1, 70, "ObjectName",
 CellID->28869],
Cell[2369, 72, 576, 17, 70, "Usage",
 CellID->58]
}, Open  ]],
Cell[CellGroupData[{
Cell[2982, 94, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3460, 111, 439, 18, 70, "Notes",
 CellID->14700],
Cell[3902, 131, 558, 19, 70, "Notes",
 CellID->13971],
Cell[4463, 152, 275, 9, 70, "Notes",
 CellID->26264],
Cell[4741, 163, 219, 5, 70, "Notes",
 CellID->15117]
}, Closed]],
Cell[CellGroupData[{
Cell[4997, 173, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->5489810],
Cell[CellGroupData[{
Cell[5380, 187, 148, 5, 70, "ExampleSection",
 CellID->677433483],
Cell[5531, 194, 141, 4, 70, "Input",
 CellID->234567628],
Cell[5675, 200, 81, 1, 70, "ExampleText",
 CellID->8106186],
Cell[CellGroupData[{
Cell[5781, 205, 303, 9, 28, "Input",
 CellID->48973463],
Cell[6087, 216, 1285, 25, 114, "Output",
 Evaluatable->False,
 CellID->136125795]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7433, 248, 310, 9, 70, "SeeAlsoSection",
 CellID->3039],
Cell[7746, 259, 1047, 35, 70, "SeeAlso",
 CellID->30212]
}, Open  ]],
Cell[CellGroupData[{
Cell[8830, 299, 314, 9, 70, "TutorialsSection",
 CellID->16215],
Cell[9147, 310, 172, 4, 70, "Tutorials",
 CellID->24555]
}, Open  ]],
Cell[9334, 317, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

