(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     27220,        898]
NotebookOptionsPosition[     22022,        714]
NotebookOutlinePosition[     23268,        750]
CellTagsIndexPosition[     23183,        745]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["STATISTICAL PLOTS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Statistical Plots Package" :> 
          Documentation`HelpLookup[
           "paclet:StatisticalPlots/tutorial/StatisticalPlots"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Statistical Plots Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"StemExponent" :> 
          Documentation`HelpLookup[
           "paclet:StatisticalPlots/ref/StemExponent"], "IncludeEmptyStems" :> 
          Documentation`HelpLookup[
           "paclet:StatisticalPlots/ref/IncludeEmptyStems"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"StemExponent\"\>", 
       2->"\<\"IncludeEmptyStems\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Leaves", "ObjectName",
 CellID->9496],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Leaves"], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["StemLeafPlot",
       BaseStyle->"Link",
       ButtonData->"paclet:StatisticalPlots/ref/StemLeafPlot"]], 
      "InlineFormula"],
     " that specifies how leaves should be displayed."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->18584]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Valid settings for the option ",
 Cell[BoxData["Leaves"], "InlineFormula"],
 " are ",
 Cell[BoxData["\"\<Digits\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Tallies\>\""], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->9515],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{"Leaves", "->", "\"\<Digits\>\""}]], "InlineFormula"],
 ", leaves are represented by the single digit obtained by rounding the \
digits remaining after the stem is removed."
}], "Notes",
 CellID->17964],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{"Leaves", "->", "\"\<Tallies\>\""}]], "InlineFormula"],
 ", leaves are represented as tally marks with the default tally symbol ",
 Cell[BoxData["\"\<X\>\""], "InlineFormula"],
 "."
}], "Notes",
 CellID->23342],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{"Leaves", "->", 
   ButtonBox["None",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/None"]}]], "InlineFormula"],
 ", the leaf column is not included in the plot."
}], "Notes",
 CellID->8075],

Cell[TextData[{
 Cell[BoxData["Leaves"], "InlineFormula"],
 " can take the following suboptions:"
}], "Notes",
 CellID->17913],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<LeafDigits\>\"", "1", Cell[
    "number of digits to use for each leaf", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<LeafSpacing\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "number of spaces between displayed leaves", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<LeafWrapping\>\"", 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "when leaves should be wrapped to a new line", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<RoundLeaves\>\"", 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell["\<\
whether data entries should be rounded before determining leaves\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<TallySymbol\>\"", "\"\<X\>\"", Cell[
    "symbol to use for each leaf", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->16142],

Cell[TextData[{
 "Valid settings for ",
 Cell[BoxData["\"\<LeafDigits\>\""], "InlineFormula"],
 " are positive integers."
}], "Notes",
 CellID->31196],

Cell[TextData[{
 "Valid settings for the suboption ",
 Cell[BoxData["\"\<LeafSpacing\>\""], "InlineFormula"],
 " are ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " or a nonnegative integer."
}], "Notes",
 CellID->21948],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{"\"\<LeafSpacing\>\"", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", zero spaces are used when ",
 Cell[BoxData[
  RowBox[{"\"\<LeafDigits\>\"", "->", "1"}]], "InlineFormula"],
 " and one space is used otherwise."
}], "Notes",
 CellID->25072],

Cell[TextData[{
 "Valid settings for ",
 Cell[BoxData["\"\<LeafWrapping\>\""], "InlineFormula"],
 " are ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 " or a positive integer indicating the number of leaves to display before \
wrapping to a new line."
}], "Notes",
 CellID->20426],

Cell[TextData[{
 Cell[BoxData["\"\<RoundLeaves\>\""], "InlineFormula"],
 " specifies whether values should be rounded to the last leaf digit before \
allocating leaves to a stem."
}], "Notes",
 CellID->26173],

Cell[TextData[{
 "Valid settings for ",
 Cell[BoxData["\"\<TallySymbol\>\""], "InlineFormula"],
 " are any string or symbol."
}], "Notes",
 CellID->32404]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->819670509],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->291381325],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<StatisticalPlots`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->82833975],

Cell["Represent leaves with tally marks:", "ExampleText",
 CellID->92877752],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StemLeafPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1.2", ",", "2.5", ",", "4.1", ",", "1.6", ",", "3.8", ",", "2.6", ",", 
     "2.9"}], "}"}], ",", 
   RowBox[{"Leaves", "\[Rule]", "\"\<Tallies\>\""}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->334917645],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNWE1PwzAMzZp0HyAkJCS2oQGTgAsMbvwFOHHjNnGoJqTtgEBj/z8kbdK6
rtsk65hWqU2T2s8vtpPWfUs2y8+vZLNaJNPXdfKzXC1+py/fazXEO4yxuTo/
RkzdS3WXnnMpVQuvjGeNvkaqjdUNN8OCFc/1EatzoLoRGufMKDJ76HstLQxa
ZNCE0T5WrX7eKXFgRjJVlfbIjXEDrI4ukCpGB0DKzofGE0gyxe8hKWhbwGca
9wQhZDOJSWsxkhX17Cu6AfxBv4f6p4FsY2T5f1ja7Dgj2UXmKYnSyMCHbZ4b
MF8cfGnLXDZlBFxf1rNcFquCs7JMH3CLcifaRRUBbQHQhJuHyG0AHCj3hPoX
tVGJEOdHJHkNLbDqnuN/vUHIzw2jY+MXnPsCsNHtfSqNZ9dFfXptPKTtubp2
CUsQQ0vPcukqUh/pYqzM0lCW9h5vvRFigrVopi6tJp+MjXexDu39kLjud1R7
nLPqu4Seh19sm/zmykM6Ui6t+qyIiLnR0tsxa++RsAgcQs7Qo9oTsWNFCFbd
vyet/Ui/jenRy9znEBf7HsdaOPpXEu8n+ta1d+E3Pe5nXMcOlO1QQ7PdzwP7
j6Jr5dRn3CGsmfYrSfdTFGf2hXj91gvRlSN3Xiiu/PXjshuU3cwo3NNDE8kj
Yhb1EQ/JqXdmvt/2nMuh9TaOI6whrAdsH9cqghWV96Bkvd7/fpU2mSel71Rc
Swkva1SFWLN/tqq198WftLNV3d20MqWJN8yL+rcHrECzrNhFpe3Dr907LmQ0
y5Btau+mOdj/FQJjFDU6K3tTFFyc9Tf+BsPWZ3mscP09QZJ2T0nrcvufr/MH
anUktQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{91, 93},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->23886335]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->6652],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "\"LeafDigits\"",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->668676134],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<StatisticalPlots`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->925004267],

Cell["Display each leaf with two digits:", "ExampleText",
 CellID->16764318],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StemLeafPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1.2", ",", "2.5", ",", "4.1", ",", "1.6", ",", "3.8", ",", "2.6", ",", 
     "2.9"}], "}"}], ",", 
   RowBox[{"Leaves", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<Digits\>\"", ",", 
      RowBox[{"\"\<LeafDigits\>\"", "\[Rule]", "2"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->107313894],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNWEtv3CAQZgE7u5uuGqlSsokiNVKPfVzaY8/tqT+hh01UKTlUjZL8fwoG
DP52jCG2V2tpjYFh5mNesPNr93L/5+/u5eFud/Pzafd4/3D3fPPj35MeEgvG
2K3+/d4y/a30V/O7VUq38ZsJ25g3122lP4QblizMm6fSv5XuchgXzC1k/jHf
hlo6btxxk271qW7N/LKDgTnKZqnyTytMOMb6qSOqMLqKqPx+aH4SKBv+J0AV
y5bxnOG7AQ52JxUprQJa2Y9+b20B/qh/Av2zQrQVSJ4HpfeOdyQ67mZJLkkE
OWhb34j9ZQAvLVmolEfE8eU1K1SICsG6NMsIG2+V6IOKR6tlxE0O45CtjIhP
TPcF+le9VuGA+TNQvnc0a4XZpvT9ATh/T4xeOr2g76PWPzXUuLsa+siF9vCP
TXuu3zUhuZTH/txyBMcL1clbI7ltI9qxyKbkZazOCR61G/fnmbV6iT8ddvTC
4cQzrFYh2sM+8ryFzu8pbQ5FxTFwNN7DE5qis/RcaOayRJk/HIMH06NGPxWh
EdzHKfTXrvXxy2fSdsl95g05avzNXLcXrd1iLGi/pt/JyuTdLRPRhuQW0GyB
N2pqWjTGZrJ31iK6pPhnR/FKhbvOOFtaNEP5APsJuT33+zHo8rw9D+M6fydF
GFN5yltKuNgRUR/j3cb3MWSssjyGt0vcV5MPBuNwrox1niW9wMsnlZt3z5te
7pJcS2W+/lyTJykzvw7mjjxpJV6Ulw+sXOPDnFiDZzjGuPX9kigzJatDR3Zp
BSz1/9L7i++jhv3paNqzjvR+S+XVvsiY7ngeVjdoT0NpVM1mf9Xbph1T/ToU
fpSzGUDeXwnLyaKxX9DW5ap7flivmKL29bos349y3Kj1kNdUw1J78JlHIo9Q
NWNdbcqAZbAihnd5lP61tRVWxK6B0ueUbw2Jq7wv/gP45Clh\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{98, 93},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->473748682]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "\"LeafSpacing\"",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->10434156],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<StatisticalPlots`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->45827587],

Cell["Insert three spaces between leaves:", "ExampleText",
 CellID->314823945],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StemLeafPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1.2", ",", "2.5", ",", "4.1", ",", "1.6", ",", "3.8", ",", "2.6", ",", 
     "2.9"}], "}"}], ",", 
   RowBox[{"Leaves", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<Digits\>\"", ",", 
      RowBox[{"\"\<LeafSpacing\>\"", "\[Rule]", "3"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->50676653],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNWEuP1DAMzjRudxeEAPGYDs+VOC93liMSnPgJHEYrpJ0DAi37/0PcJq37
jdsmU3a0ldokrv3ZsZ007vft7fXPX9vb3dX2/NvN9s/17urv+dffN55kV8aY
nb9/1Mb3ne81984538qnsW3Dz8K3pe/YQCbTv+er9PeZHxZAtyYImnhxn7kp
oBUBjYL0Q9/y+8cDG0zgbERdvDplNgD7qxJcPfVMcMX56HgEnA3+CXBJ3STf
Me4jQGhnUqraSuClcev3ZDPsF+MTGD/JtLYEzXdjZcyOZ6p1RXirokxakGJt
lxsyX2bs1TVbN5URcn1Fz1rXrwprhjynwraic2JcVIWQJoFG83ZQp0PgSL6P
MH41GpUCbL4AzveB56nD3Sb3+QGQv0xQN8EvmPvR658aLpxVBWOUbqVe+mel
YI9z7+fJaZLs2g12m2S5WlDTtR0mtQnxRe4q0D9nx+64VPaxNfvfiyrQLzOi
qO+habl2V7J1iMP0/JZoWO6btBjch2zRqeyBcmQN8DDuRrXrz1PL/LZWqRxF
PuytuO08K9HQwzh+oeK+FrjDfYK7aHEaJqNQh7kBGdxroiejVK1itlhzuYxj
nM9mAjstZqgBZzdl/dRaICWXmnPKvVgFeWsjfonjPN65lNzKWQ1vkxDVbDgQ
C7N2iV04Zj9Ssp/UNQinskO9jVKtRTxX/s48UPxrw95ku9nnZBCXrsfO2txK
eOycKc/jcYxVBJm+Jl4PtBuzrAZWc31wnsQqh5K0abXbvlSzVy6qgo9lP+p5
PmP5eEU8t7vIPCAzFt3CDWvDNiv+Rw2cYl9qRb+c2mbIIVXx1BzinwRCjL56
NkNvUm/LbGWMJyrUftnFCivjN8AZ95S2Qgp/4Fb/AG0EGug=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{105, 93},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->271134169]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "\"LeafWrapping\"",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->22912012],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<StatisticalPlots`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->704940087],

Cell["Wrap to a new line after two leaves:", "ExampleText",
 CellID->119705014],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StemLeafPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1.2", ",", "2.5", ",", "4.1", ",", "1.6", ",", "3.8", ",", "2.6", ",", 
     "2.9"}], "}"}], ",", 
   RowBox[{"Leaves", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<Digits\>\"", ",", 
      RowBox[{"\"\<LeafWrapping\>\"", "\[Rule]", "2"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5122678],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVWEtP3DAQ9sZO2KVCqlSp3UVIoFKqtkBv/Qtw6q23Pa0QEhwQFfD/jZ14
nPFknNgJrCBSHp7MyzOfX/N383Rzfbd5ur3aHF0+bP7f3F49Hl3cPxiSnAkh
1ua+Wwrzrc1Xfa+1Nm/8FLJ52Wdh3qX5kI6sRPvfXqW5F6ZZELoUTlDAZb8t
t3LaCqdNOekP5m3/zwIfhOOsRTVc3ph0is1VIa6WukBc0B9enyKctf4dwoVt
K/zP6t0jGpqelKy1kvCquPcd2Qz/UXuHtD9melsSy6/jJaDjE+td4f6yWno9
SPHWYwPjZcBf3rLUfYjA4wsiK3U7KqQIeebIt8IHEQZVgaQV0qaG/VDeBtKD
+X6T9n40KwXx+ZxwHmILojvn5D6Pif4/PdSViw4dARD705qL9q0ibSrdSH02
z4rRHefuomWeJPtFB3NOstwSUdOtjZNauSxT7srRz7Nzt12qjbEU3VWjcvSz
jCzyM2ka1l5Lduny0N+/KRamxyYtB28BLWlU2D3x2KeR+cVy0Vj8ZLlshJSP
I+dHLObb4n0vObQoLiPzGKyz9n3iucdint8lfdMwEvpQULeDFYGu3181jPo+
zKXqWREqXQMgOrD7aKIzNJvQNrX9PSPGVBfdJ574uMZmGDiRSJ+Ft4DHPJTS
PWXT6yEU5ONzSCOb2ZG6KNam+FW3g9ObSo5Sd6z8mBBdivUWn3aV3mXiaZuw
ouTj859wO9UtIzW3ohDbqeNzTcnED/5DbWERWI/jOa2WwOI7wAI9Laoka9wZ
ODLXTaombMt/1s6oykLKjIJxwWe30OF82KDiJWoJ42a8uJfTqA1CxlQXhtZQ
vOfxOtoqhAijqVpfBisMdI9DrZ/5XNEKwwHhDPfZrpI5ewYdDc7Q\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{91, 109},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->118667505]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "\"RoundLeaves\"",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->23356305],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<StatisticalPlots`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->176883690],

Cell["\<\
Construct leaves without first rounding to the number of leaf digits:\
\>", "ExampleText",
 CellID->64319578],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StemLeafPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1.2", ",", "2.5", ",", "3.99", ",", "1.6", ",", "3.8", ",", "2.6", ",", 
     "2.9"}], "}"}], ",", 
   RowBox[{"Leaves", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<Digits\>\"", ",", 
      RowBox[{"\"\<RoundLeaves\>\"", "\[Rule]", "False"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->158853404],

Cell[BoxData[
 RowBox[{
  RowBox[{"StemLeafPlot", "::", "\<\"rndlvs\"\>"}], ":", 
  " ", "\<\"Due to rounding for display, one or more leaves has more than the \
requested number of leaf digits \\!\\(1\\). These leaves will be replaced by \
a string of \\!\\(1\\) tally symbols. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\
\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:StatisticalPlots/ref/StemLeafPlot\\\", ButtonNote -> \
\\\"StatisticalPlots`StemLeafPlot::rndlvs\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->285764239],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNWE1P3DAQ9drOLtsKCQmppS0tSLQSB+DWv1BOqJfeOK1QJThUrSj/3/XX
JJOXySZOWNRI2cT2+M14/Gac2ZvN0/3PX5unh7vN6fXj5s/9w93f02+/H32X
WSilbv39/Uj5d+ff4n3rnH/yX2XSI/xq/6z8i8ndVjXj4ar8vfZNDf1G5YmK
rvAepG1G0xnN5tmv/TOML1o2qCwZpzq6amUmA/tryaSa3jWTovXIeBYkI/4K
pLhuy8cC7j4gpJVUorYKZG2/9Z25Bfaz9graB4XWVqB5N1YSOw5F63QeFVG2
WjDG2pobnC8D9sqajdvGCB5f5Fnjmqgwqi2zx2zTtRMpqDSbbRmaHbbD1joY
Dpe7gvb73l3RYPMlSJ5wDaqbc0p/zwD/65bet9k7mAuWzOeaeSuiqDfizu4B
hhwvMvc/xyf6cDkKEbPdlxlYGD3JrqO8+j4vYcZ6/tXsyuPT9r+EYS/bG/xU
CZ6h9VAOpaxwsiPvIiOOa2/zXvR6bDdnp5B1kJ8fHPGT96LlPbitUzo0PsbB
dzAbT0fyJc+kXQ8krKEYwLa43h7scbuGGsadj0nDtuig7zPOpk/uf4mDsujA
kzblnCFWlWebIUSRDROxkLVz7IrtTrSM81I39s5neBfjI9kQeBqy8yvBn3Q+
mXq1JYz54TtWxbPm95bWWbjbnNGUoyrBfzROFde6pb2fz+MqLJHfLS7gN7Sc
71DbuCwZtc+qsV7KflHPpHprTEbhvJB3V7t2PkyseI4Ka1rG67dyXm9iyJSa
a+iE5d9aNUZTm6m2N21jy2Ddhd9QqP2i3iusu45BknJKrMfo/53FPzgVMI4=
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{91, 79},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->66892120]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "\"TallySymbol\"",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->276177329],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<StatisticalPlots`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->186368694],

Cell["Represent leaves as check marks:", "ExampleText",
 CellID->779015206],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StemLeafPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1.2", ",", "2.5", ",", "3.99", ",", "1.6", ",", "3.8", ",", "2.6", ",", 
     "2.9"}], "}"}], ",", 
   RowBox[{"Leaves", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<Tallies\>\"", ",", 
      RowBox[{"\"\<TallySymbol\>\"", "\[Rule]", "\[Checkmark]"}]}], "}"}]}]}],
   "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->27828887],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVWE1PGzEQdWxvIFSVKlWC8FVoaREfCTf+Apy4cUMcIoSUHKpWlP/v2ru2
1/t21vYmJaIr7XrHnnkz9rx1PLmbvc6ff85eF0+z49uX2e/54unP8c2vF90l
BoyxB30/jpl+V/qtvB+U0m34ZKJqzJPrttAvwnZLVo+bq9D3SIsc+gWzhsxd
5t1oS4vGLZq01h90a8YHjRiY1SxNlbu8M2GB9TUMtOreUaDl5kPjSdAs8TdA
K/QtwzGD+xEQqpkUpLcCdGV39C3bHvEH8gbIn3pGW4Dnt4nSseMzGR23oyRK
NIKcaD03Qr4k4qU9CxVjRPh9uZUVqv4qBGvqbAaxcb+I7qPigbUM0GQ6Dul9
BDih3hXIe51Z4RDzFDSPQg+svefkP08A+TrSu2vXBblfjeJshiCj1WVpta2f
QwJzaGc49VptXmxGPJrxSdnuqMbuQtihfFGqjQENtXAvPM+y2gL5zK8s79A2
/ee9c7XeXrPGgrV/H657ZI/mR4pVTZ7kaLcZMrYYGD3Ni5QPmhd5a0Czo2t1
/xd2mLkXxGxXYQf+ZqF86FculhvHngLaI4XfsiL4gGySCfmLct96bGboJTXT
A7UMK1Oo+z1yg6xNYe/53MRYjTmpInoPfF6G5Skupfj9PQsF+XyabRXj7Y8s
lBRvT7JQUjz9loWSYuRX5RhoVgm1kYGVzz5cuGf2RLNmDvatNZF14fnZnXid
jOd0M+6qzlHDO2OrVZkkPxsnOKwjZJY3qjrq2N1WqjPXFT/pZ6maM7YjKJvv
kBd0drlqVl8VK/5FlZkTX27NvHpvxZBl6s7YHFytLhGjrk9ZczVlHUuy9sST
EHqf+Fxh7XkAmm5PqU7c9j+uwV+YCLkS\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{91, 93},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->33018548]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->30093],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["StemExponent",
    BaseStyle->"Link",
    ButtonData->"paclet:StatisticalPlots/ref/StemExponent"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["IncludeEmptyStems",
    BaseStyle->"Link",
    ButtonData->"paclet:StatisticalPlots/ref/IncludeEmptyStems"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->16565]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->6705],

Cell[TextData[ButtonBox["Statistical Plots Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:StatisticalPlots/tutorial/StatisticalPlots"]], "Tutorials",
 CellID->20626]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Leaves - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 8, 34.5373840}", "context" -> 
    "StatisticalPlots`", "keywords" -> {}, "index" -> True, "label" -> 
    "Statistical Plots Package Symbol", "language" -> "en", "paclet" -> 
    "StatisticalPlots Package", "status" -> "None", "summary" -> 
    "Leaves is an option for StemLeafPlot that specifies how leaves should be \
displayed.", "synonyms" -> {}, "title" -> "Leaves", "type" -> "Symbol", "uri" -> 
    "StatisticalPlots/ref/Leaves"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7262, 248, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->819670509]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 23040, 738}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1400, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2023, 63, 43, 1, 70, "ObjectName",
 CellID->9496],
Cell[2069, 66, 535, 16, 70, "Usage",
 CellID->18584]
}, Open  ]],
Cell[CellGroupData[{
Cell[2641, 87, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3119, 104, 366, 14, 70, "Notes",
 CellID->9515],
Cell[3488, 120, 273, 7, 70, "Notes",
 CellID->17964],
Cell[3764, 129, 273, 8, 70, "Notes",
 CellID->23342],
Cell[4040, 139, 258, 9, 70, "Notes",
 CellID->8075],
Cell[4301, 150, 126, 4, 70, "Notes",
 CellID->17913],
Cell[4430, 156, 1229, 27, 70, "3ColumnTableMod",
 CellID->16142],
Cell[5662, 185, 150, 5, 70, "Notes",
 CellID->31196],
Cell[5815, 192, 299, 10, 70, "Notes",
 CellID->21948],
Cell[6117, 204, 389, 12, 70, "Notes",
 CellID->25072],
Cell[6509, 218, 348, 11, 70, "Notes",
 CellID->20426],
Cell[6860, 231, 208, 5, 70, "Notes",
 CellID->26173],
Cell[7071, 238, 154, 5, 70, "Notes",
 CellID->32404]
}, Closed]],
Cell[CellGroupData[{
Cell[7262, 248, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->819670509],
Cell[CellGroupData[{
Cell[7647, 262, 148, 5, 70, "ExampleSection",
 CellID->291381325],
Cell[7798, 269, 140, 4, 70, "Input",
 CellID->82833975],
Cell[7941, 275, 76, 1, 70, "ExampleText",
 CellID->92877752],
Cell[CellGroupData[{
Cell[8042, 280, 304, 9, 28, "Input",
 CellID->334917645],
Cell[8349, 291, 1072, 22, 114, "Output",
 Evaluatable->False,
 CellID->23886335]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9470, 319, 217, 7, 70, "ExampleSection",
 CellID->6652],
Cell[CellGroupData[{
Cell[9712, 330, 235, 7, 70, "ExampleSubsection",
 CellID->668676134],
Cell[9950, 339, 141, 4, 70, "Input",
 CellID->925004267],
Cell[10094, 345, 76, 1, 70, "ExampleText",
 CellID->16764318],
Cell[CellGroupData[{
Cell[10195, 350, 407, 13, 70, "Input",
 CellID->107313894],
Cell[10605, 365, 1174, 23, 70, "Output",
 Evaluatable->False,
 CellID->473748682]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[11828, 394, 235, 7, 70, "ExampleSubsection",
 CellID->10434156],
Cell[12066, 403, 140, 4, 70, "Input",
 CellID->45827587],
Cell[12209, 409, 78, 1, 70, "ExampleText",
 CellID->314823945],
Cell[CellGroupData[{
Cell[12312, 414, 407, 13, 70, "Input",
 CellID->50676653],
Cell[12722, 429, 1114, 22, 70, "Output",
 Evaluatable->False,
 CellID->271134169]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13885, 457, 236, 7, 70, "ExampleSubsection",
 CellID->22912012],
Cell[14124, 466, 141, 4, 70, "Input",
 CellID->704940087],
Cell[14268, 472, 79, 1, 70, "ExampleText",
 CellID->119705014],
Cell[CellGroupData[{
Cell[14372, 477, 407, 13, 70, "Input",
 CellID->5122678],
Cell[14782, 492, 1118, 22, 70, "Output",
 Evaluatable->False,
 CellID->118667505]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15949, 520, 235, 7, 70, "ExampleSubsection",
 CellID->23356305],
Cell[16187, 529, 141, 4, 70, "Input",
 CellID->176883690],
Cell[16331, 535, 119, 3, 70, "ExampleText",
 CellID->64319578],
Cell[CellGroupData[{
Cell[16475, 542, 413, 13, 70, "Input",
 CellID->158853404],
Cell[16891, 557, 548, 9, 70, "Message",
 CellID->285764239],
Cell[17442, 568, 1064, 22, 70, "Output",
 Evaluatable->False,
 CellID->66892120]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18555, 596, 236, 7, 70, "ExampleSubsection",
 CellID->276177329],
Cell[18794, 605, 141, 4, 70, "Input",
 CellID->186368694],
Cell[18938, 611, 75, 1, 70, "ExampleText",
 CellID->779015206],
Cell[CellGroupData[{
Cell[19038, 616, 420, 13, 70, "Input",
 CellID->27828887],
Cell[19461, 631, 1096, 22, 70, "Output",
 Evaluatable->False,
 CellID->33018548]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[20630, 661, 311, 9, 70, "SeeAlsoSection",
 CellID->30093],
Cell[20944, 672, 511, 17, 70, "SeeAlso",
 CellID->16565]
}, Open  ]],
Cell[CellGroupData[{
Cell[21492, 694, 313, 9, 70, "TutorialsSection",
 CellID->6705],
Cell[21808, 705, 172, 4, 70, "Tutorials",
 CellID->20626]
}, Open  ]],
Cell[21995, 712, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

