(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18075,        568]
NotebookOptionsPosition[     14899,        462]
NotebookOutlinePosition[     16517,        509]
CellTagsIndexPosition[     16407,        503]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["STATISTICAL PLOTS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Statistical Plots Package" :> 
          Documentation`HelpLookup[
           "paclet:StatisticalPlots/tutorial/StatisticalPlots"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Statistical Plots Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"BoxWhiskerPlot" :> 
          Documentation`HelpLookup[
           "paclet:StatisticalPlots/ref/BoxWhiskerPlot"], "StemLeafPlot" :> 
          Documentation`HelpLookup[
           "paclet:StatisticalPlots/ref/StemLeafPlot"], "BarChart" :> 
          Documentation`HelpLookup["paclet:BarCharts/ref/BarChart"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"BoxWhiskerPlot\"\>", 
       2->"\<\"StemLeafPlot\"\>", 3->"\<\"BarChart\"\>"}, "\<\"see also\"\>", 
       
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ParetoPlot", "ObjectName",
 CellID->32678],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ParetoPlot", "[", 
       StyleBox["list", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]creates a Pareto plot from the frequencies of the \
elements in ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ParetoPlot", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["cat", "TI"], 
            StyleBox["1", "TR"]], ",", 
           SubscriptBox[
            StyleBox["freq", "TI"], 
            StyleBox["1", "TR"]]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["cat", "TI"], 
            StyleBox["2", "TR"]], ",", 
           SubscriptBox[
            StyleBox["freq", "TI"], 
            StyleBox["2", "TR"]]}], "}"}], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     " \[LineSeparator]creates a Pareto plot from categories ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["cat", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " with frequencies ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["freq", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->1752]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["ParetoPlot"], "InlineFormula"],
 " combines a bar chart displaying percentages of categories in the data with \
a line plot showing cumulative percentages of the categories."
}], "Notes",
 CellID->18443],

Cell["The categories are sorted in decreasing order of frequency.", "Notes",
 CellID->28296],

Cell[TextData[{
 Cell[BoxData["ParetoPlot"], "InlineFormula"],
 " has the same options as ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 ", with the following additions and changes:"
}], "Notes",
 CellID->12673],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Axes",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Axes"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to draw axes", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BarEdges",
     BaseStyle->"Link",
     ButtonData->"paclet:BarCharts/ref/BarEdges"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether edges should be shown with the bars", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BarEdgeStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:BarCharts/ref/BarEdgeStyle"], 
    RowBox[{
     ButtonBox["GrayLevel",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/GrayLevel"], "[", "0", "]"}], Cell[
    "style for the edges of bars", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BarLabels",
     BaseStyle->"Link",
     ButtonData->"paclet:BarCharts/ref/BarLabels"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "labels for the bar chart", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BarOrientation",
     BaseStyle->"Link",
     ButtonData->"paclet:BarCharts/ref/BarOrientation"], "Vertical", Cell[
    "orientation of the bars", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BarStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:BarCharts/ref/BarStyle"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "style of bars", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["PlotMarkers",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlotMarkers"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "markers for points", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["PlotStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlotStyle"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "styles for the line", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True, True}}}},
 CellID->10040],

Cell[TextData[{
 "The options ",
 Cell[BoxData[
  ButtonBox["BarEdges",
   BaseStyle->"Link",
   ButtonData->"paclet:BarCharts/ref/BarEdges"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["BarEdgeStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:BarCharts/ref/BarEdgeStyle"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["BarLabels",
   BaseStyle->"Link",
   ButtonData->"paclet:BarCharts/ref/BarLabels"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["BarStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:BarCharts/ref/BarStyle"]], "InlineFormula"],
 " are the same as those for ",
 Cell[BoxData[
  ButtonBox["BarChart",
   BaseStyle->"Link",
   ButtonData->"paclet:BarCharts/ref/BarChart"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->9313],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["BarOrientation",
   BaseStyle->"Link",
   ButtonData->"paclet:BarCharts/ref/BarOrientation"]], "InlineFormula"],
 " option applies to the entire plot, not just the bars."
}], "Notes",
 CellID->875],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["BarLabels",
   BaseStyle->"Link",
   ButtonData->"paclet:BarCharts/ref/BarLabels"]], "InlineFormula"],
 " option applies labels cyclically to the bars in the order in which they \
appear."
}], "Notes",
 CellID->20072]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->524359892],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->42499199],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<StatisticalPlots`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->744348991],

Cell[TextData[{
 Cell[BoxData["ParetoPlot"], "InlineFormula"],
 " for categories represented by letters:"
}], "ExampleText",
 CellID->65452639],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParetoPlot", "[", 
  RowBox[{"{", 
   RowBox[{
   "a", ",", "b", ",", "c", ",", "d", ",", "d", ",", "d", ",", "e", ",", "d", 
    ",", "e", ",", "e", ",", "f", ",", "a", ",", "b", ",", "c"}], "}"}], 
  "]"}]], "Input",
 CellTags->"S6.9.1",
 CellLabel->"In[2]:=",
 CellID->28685],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWwlsFkUU3v5XCx4gNYoHpojIpRTbgmggoByKBFFRwZCG1IbQqlBSKyF4
FRUJ4hW8gBBALgUkQIggCgYhQYkIXsQDFYtyhIAHiFqjrt+8t7PnW9r/h0Ko
27S7O7PfvHnvfW/ezM5uB5VUlY0cXVJVXlqSd0Nlydiy8tL78/pXVKIqnmUY
WWWGYdS0NHBt4or+1E85/viyD/5iqL7MU2PEGYmj0YbOnXFMolSIs7pZZLXr
Zp2LrPtFrtbqsrXd2kg4tUFcka/XokCLwkBN1/C+XLUxn9aBXpN22eq7QKz1
95ZH9fnHtMwI6VPpZMQZoI4FddrGvXWx7OhqydBnt7cMQ/cad53ZN4U+qXN9
5ft8unOvBVYvr1rnCuvMd5v7ZKjDnXXc0bbbbvDxlQxv6fFSIuC3xClqqc7D
8JeVUV9NqJzfeUjx8EX4Ndqpgypb95vS/erqaut+e7qPsqd9+P2m9ZLv3M9I
/v/Valcsp0weGf74bRyW+sdzZFVkVWRVZNX/zSplVOOxpnFyFFkVWdWgVgGC
X6O9Opz2Vl0XaR1p3ai1Ph3m7NPdx5HWkdaR1pHWkdbHo7W63wnFM33nvnZv
J2Iu29cgukdSI6ksNewND5Ub4F2A1avnfUPS1+/J6DPl60PZrl4lZjdAX9m+
vmInwb5T0ecJfJMU8tQejNlM3+SoQ56ZybiKWqbXsj6z4KnXsmFanoNDvFfP
GbkZS2iOQxISWmQsoRkOqbQl5GLQqX5zrcF3qYhspfgFyoiX3v3Gjs/3a7mF
Ipp6ix86dLRizKqVK3b4kPbXD4na2r+feXrTxOp1uFCYq0Rp9L1LfP26b8rL
Vuzbd5iqu4hI+mYmvvPrg1By+7Y9VJ0vIttS+ciRWmi4cMF2qu4sIttRecb0
LQ9OWAs8VV8hIttTedPGXdCzpuZnqu4kIjtQGRgggafqjiKyo9YTvb8wbTNV
dxCRpFN86ZJPYZHWs52IvJLK8A+8BF9R9eUedviLHfga+mn+2oqy8l084tfi
sY2IJXbjkAcNERtGeLTR1zdxhBkHG1W3FpGFOtKgKWw/Rqzz9zvwIYcbVV8i
IruZwXhrRcjAGirwTZJ/drradCJSM30xY+tcpbjL3V1xMGf2Vqq+SJCj5uGE
MB9fS2W0dEXxBSHt3Ss0ZY8y8hrTiW0dMy2F9govzdI9TCfi4VmqPj+N9j2p
DN7Anh4H5wU48a+F/F7sZQbHyLliDPQ2rTFSPHyxjsBcEUnPnL5c10JEXm9K
Y6W5iKVnS2us6BhsJiL7mc5Y0TnvbBHZX8cQZOqxcpaNVMAbTWeMaP+cIcoa
YDpjROc6+U3LTS7m9QhoIiIHav1cMZ4jIgeZVjQ/ULVa65kSkTdTecsHu125
LikiB5tOztMRmhCRt2geORYtHmMi9jbTiTg1fcZw+FdEqtlazcP/eBhR7VOe
WqkN+QKOUHV/icjbTWv+TgIGMMIaSqk8WCvi7yIbEdUwcOgdixCIf4q44RqH
gAYOjvtdxBUTDt6FzzgV/ibiRhAOTCEG4DIE9GERV0I43AYIQYAGv4i4UsIx
/xAJBX4ScSMJB7VgxOQnN8CggyJuFOHWrP4SOLgGuAMevspUKQm/wruAMC3G
flHWPRoLFLBYhig+9opY+g40AVlYiAAL6XtE3Bgvb1D0BxE3VvMBY5mPGhFX
6eIDAwMO3yXiqgiHLAQ+8IsG3xIu3e9Kx2lemS/I2ckC0nz+HK/5hByYCEO/
ykjOhADfX9Rbjpo3uT0HA6gDgTtC2scFbzysIwSxwdGkIuQzQYK/pd+OR0kS
j32OHyXpkwBHagaNCX6Y6Ior5A445GMxDh53xRVwIGCbiJtEOMwKIBkUYYBu
FXGTdfxhkHM+UFnsfRE7hcqAAEFJEYfNochU6N2nTJ1VkdRgsqrbZCMVcKqp
sykukBs5ONRI3yhKfF7z6MkKG0TsNBdTTpZ+V8S+6GKFR/t6EfeyxoEV4MDK
OyJuumbPZmWtiJsZYGWNiJtlmnaW5tH8poibbTqjFRMEFFgl4uYSDpMMjGBu
Vnp4mUf3bUJwf7koZ76LD/jY4mOZiF3o4sMZOUtF7GvUP7D2rLlExC3WfNiz
5usibqnmw541F4m4ZZoPe9ZcIOKWu/jgWXOeiCOvembNuSJulebNnjVne/gg
tj3Zc5YoZ7XIx0wR+5bIx3QR+3aAj1dE3LoAHy+JOBqFSTcfBEAmeE7E0wiP
My8qXSRweFZEvmdyRuK76c6aKutwxoJuVt1UFpHmfKfyHGU2h1WIrL8sNedt
1qyDSmZ9itA+7ElviysWnFw5OSNrPtSyPCusSRnJ+kjHkr0CeyLAVdge9XYd
X3aefkyMApqPPauyahFHKwDPquwREUdrDWdVhouHRBytaVRegDDO0xNEHK2h
PKuq8SJup44Ae9yPs3EKRmtDz6qoSpTznebPs/6pFLHfm1JeGCtid7v44NVM
hYj70cUHz5ujRdxejbPnzXtF3H7Nmz1vlou4A5oPe94cJeIOuvjgeXOkiKNn
Hs+8Werhg56dEu6FTIko51fNh2dsjhCxR0Q+ikXsUY2187Rp5dVhIv4PKnO+
1nl1qIhUT62p0Lvq2ZfyZmLggDlwIDrGknSIiFXP1ZQZ1eYFVIU30Tuih7Mk
YkjtaQ4W26oDpYkcUAQk8LcOns/pEexB2sDQdrSnlQ214EHEAhTFIMWgQZDx
fo3NokLTbk02BjpGDIIM+uKIa7WH1Te0D9pZyoZEyIV09IGe0J/a2ekd2op2
uXKgPEzggQSj2BUws0doO9q3y4G32BPwH5rCl+yJ7qHtLqR20Ak0sScQ9uwJ
hFZRaDva5c3GIGKf9Oszizf9lU/kNw7qQDvT2RiD7BO0Yp+oXSTaQbemCP3j
f+8a9l+TtI+eA4XZazABXkPssdeSVpTxbrdfJsVQnf8jyW8X4F+EKPxrxOBh
epZBWcWoivi845DP7w+gLHiA4kYqTXl601y9OzheXQpOgL+C/wEbNo87aCli
+I66KvddGVn/AQedbig=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 225},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"S6.9.1",
 CellLabel->"Out[2]=",
 CellID->16823457]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->30695],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["BoxWhiskerPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:StatisticalPlots/ref/BoxWhiskerPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StemLeafPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:StatisticalPlots/ref/StemLeafPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BarChart",
    BaseStyle->"Link",
    ButtonData->"paclet:BarCharts/ref/BarChart"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->13169]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->610],

Cell[TextData[ButtonBox["Statistical Plots Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:StatisticalPlots/tutorial/StatisticalPlots"]], "Tutorials",
 CellID->1017]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ParetoPlot - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 8, 35.5686604}", "context" -> 
    "StatisticalPlots`", "keywords" -> {}, "index" -> True, "label" -> 
    "Statistical Plots Package Symbol", "language" -> "en", "paclet" -> 
    "StatisticalPlots Package", "status" -> "None", "summary" -> 
    "ParetoPlot[list] creates a Pareto plot from the frequencies of the \
elements in list. ParetoPlot[{{cat_1, freq_1}, {cat_2, freq_2}, ...}] creates \
a Pareto plot from categories cat_i with frequencies freq_i.", 
    "synonyms" -> {}, "title" -> "ParetoPlot", "type" -> "Symbol", "uri" -> 
    "StatisticalPlots/ref/ParetoPlot"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8744, 288, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->524359892]},
 "S6.9.1"->{
  Cell[9591, 323, 302, 9, 28, "Input",
   CellTags->"S6.9.1",
   CellID->28685],
  Cell[9896, 334, 3303, 59, 246, "Output",
   Evaluatable->False,
   CellTags->"S6.9.1",
   CellID->16823457]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 16058, 488},
 {"S6.9.1", 16191, 492}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1506, 38, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2129, 65, 48, 1, 70, "ObjectName",
 CellID->32678],
Cell[2180, 68, 1550, 50, 70, "Usage",
 CellID->1752]
}, Open  ]],
Cell[CellGroupData[{
Cell[3767, 123, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4245, 140, 234, 5, 70, "Notes",
 CellID->18443],
Cell[4482, 147, 92, 1, 70, "Notes",
 CellID->28296],
Cell[4577, 150, 287, 9, 70, "Notes",
 CellID->12673],
Cell[4867, 161, 2535, 71, 70, "3ColumnTableMod",
 CellID->10040],
Cell[7405, 234, 776, 28, 70, "Notes",
 CellID->9313],
Cell[8184, 264, 250, 8, 70, "Notes",
 CellID->875],
Cell[8437, 274, 270, 9, 70, "Notes",
 CellID->20072]
}, Closed]],
Cell[CellGroupData[{
Cell[8744, 288, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->524359892],
Cell[CellGroupData[{
Cell[9129, 302, 147, 5, 70, "ExampleSection",
 CellID->42499199],
Cell[9279, 309, 141, 4, 70, "Input",
 CellID->744348991],
Cell[9423, 315, 143, 4, 70, "ExampleText",
 CellID->65452639],
Cell[CellGroupData[{
Cell[9591, 323, 302, 9, 28, "Input",
 CellTags->"S6.9.1",
 CellID->28685],
Cell[9896, 334, 3303, 59, 246, "Output",
 Evaluatable->False,
 CellTags->"S6.9.1",
 CellID->16823457]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13260, 400, 311, 9, 70, "SeeAlsoSection",
 CellID->30695],
Cell[13574, 411, 760, 26, 70, "SeeAlso",
 CellID->13169]
}, Open  ]],
Cell[CellGroupData[{
Cell[14371, 442, 312, 9, 70, "TutorialsSection",
 CellID->610],
Cell[14686, 453, 171, 4, 70, "Tutorials",
 CellID->1017]
}, Open  ]],
Cell[14872, 460, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

