(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10907,        382]
NotebookOptionsPosition[      8367,        298]
NotebookOutlinePosition[      9672,        335]
CellTagsIndexPosition[      9588,        330]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["STATISTICAL PLOTS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Statistical Plots Package" :> 
          Documentation`HelpLookup[
           "paclet:StatisticalPlots/tutorial/StatisticalPlots"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Statistical Plots Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DataRanges" :> 
          Documentation`HelpLookup["paclet:StatisticalPlots/ref/DataRanges"], 
          "DataLabels" :> 
          Documentation`HelpLookup[
           "paclet:StatisticalPlots/ref/DataLabels"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"DataRanges\"\>", 
       2->"\<\"DataLabels\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["PlotDirection", "ObjectName",
 CellID->14369],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["PlotDirection"], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["PairwiseScatterPlot",
       BaseStyle->"Link",
       ButtonData->"paclet:StatisticalPlots/ref/PairwiseScatterPlot"]], 
      "InlineFormula"],
     " which specifies the direction in which scatter plots are generated."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->22532]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "A valid setting is a list ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["h", "TI"], ",", 
    StyleBox["v", "TI"]}], "}"}]], "InlineFormula"],
 ", where the horizontal direction ",
 Cell[BoxData[
  StyleBox["h", "TI"]], "InlineFormula"],
 " can be ",
 Cell[BoxData[
  ButtonBox["Right",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Right"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Left",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Left"]], "InlineFormula"],
 ", and the vertical direction ",
 Cell[BoxData[
  StyleBox["v", "TI"]], "InlineFormula"],
 " can be ",
 Cell[BoxData["Up"], "InlineFormula"],
 " or ",
 Cell[BoxData["Down"], "InlineFormula"],
 "."
}], "Notes",
 CellID->2963],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{"PlotDirection", "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["h", "TI"], ",", 
     StyleBox["v", "TI"]}], "}"}]}]], "InlineFormula"],
 ", the subplot comparing the first column of data with itself is placed in a \
corner, with row numbers and column numbers increasing when the plot is \
traversed in the direction specified by ",
 Cell[BoxData[
  StyleBox["h", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["v", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->2607]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->29474600],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->10561440],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<StatisticalPlots`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->159370343],

Cell[TextData[{
 "Plot with ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " indices increasing toward the right and ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " indices increasing upward:"
}], "ExampleText",
 CellID->299346622],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PairwiseScatterPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5", ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"9", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "8"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "3"}], "}"}]}], "}"}], ",", 
   RowBox[{"PlotDirection", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Right", ",", "Up"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->145812446],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnL9qAkEQxlc3JhYiNkIKSQ61sLSwsDNVUoTUaVJ4SMiJ5A/GViwv3T2C
JI2cL2Dpo/goZnY9mOyR4pYE2ZhvYZeZ737ziSssLKPe+JPg/tGfDAe+dzX2
X4Lh4NW7fB6TJHNC5AKaD6eC4q0Qu6nGkOYutItO1CqjKLrQQ8RqkZ1Op91u
q3Cp8zAM9atsReFLFT2iwvV6LWJa8lSxVIlcLBae5ynk2KTpqQpjWvK9Xm+p
9c1mc5D0kc5p5+gjCoJAfCTVhW/0rG6EUFWxWEy5mXpWt9VqRdJ8Pk+5mfpf
2nPQoEG7R5/pnM+8t6T6I6UXLNz4zDPdWLdx4zPPdGM9m5s7ew4aNGj36K7O
+cx7SqpbKX1m4cZnnunGuo0bn3mmG+vZ3NzZc9CgQYMGDRo0aNCgQYMGrcJQ
53zzPE+q71L6tYUb3zxNN9Zt3Pjmabqxns3NnT0HDRq0e/S7zs2OhKqepfSW
hZtndCTYjXUbN7MjwW6sZ3NzZ89/n+52u6PRKIoiEatFNhqNer3O+XQ6rdVq
6apms1kqlSqViohpyUsplyqR5XK5Wq26+25dpPHtB9CgQYMGvW8aHVbQoEGD
Bg0aNOhDpEOdo2sBGjRo0KD3R6NLBBo0aNCg3abxy8v/R/f7fbEbJIlbFSiH
rR7JPziocPjjSOQ+ARau1Bw=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 359},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->107744915]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->22848],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["DataRanges",
    BaseStyle->"Link",
    ButtonData->"paclet:StatisticalPlots/ref/DataRanges"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DataLabels",
    BaseStyle->"Link",
    ButtonData->"paclet:StatisticalPlots/ref/DataLabels"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->4675]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->2483],

Cell[TextData[ButtonBox["Statistical Plots Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:StatisticalPlots/tutorial/StatisticalPlots"]], "Tutorials",
 CellID->911]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PlotDirection - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 8, 35.8030414}", "context" -> 
    "StatisticalPlots`", "keywords" -> {}, "index" -> True, "label" -> 
    "Statistical Plots Package Symbol", "language" -> "en", "paclet" -> 
    "StatisticalPlots Package", "status" -> "None", "summary" -> 
    "PlotDirection is an option for PairwiseScatterPlot which specifies the \
direction in which scatter plots are generated.", "synonyms" -> {}, "title" -> 
    "PlotDirection", "type" -> "Symbol", "uri" -> 
    "StatisticalPlots/ref/PlotDirection"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4479, 158, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->29474600]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 9446, 323}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1372, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1995, 63, 51, 1, 70, "ObjectName",
 CellID->14369],
Cell[2049, 66, 577, 16, 70, "Usage",
 CellID->22532]
}, Open  ]],
Cell[CellGroupData[{
Cell[2663, 87, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3141, 104, 740, 29, 70, "Notes",
 CellID->2963],
Cell[3884, 135, 558, 18, 70, "Notes",
 CellID->2607]
}, Closed]],
Cell[CellGroupData[{
Cell[4479, 158, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->29474600],
Cell[CellGroupData[{
Cell[4863, 172, 147, 5, 70, "ExampleSection",
 CellID->10561440],
Cell[5013, 179, 141, 4, 70, "Input",
 CellID->159370343],
Cell[5157, 185, 260, 9, 70, "ExampleText",
 CellID->299346622],
Cell[CellGroupData[{
Cell[5442, 198, 582, 19, 47, "Input",
 CellID->145812446],
Cell[6027, 219, 908, 19, 380, "Output",
 Evaluatable->False,
 CellID->107744915]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6996, 245, 311, 9, 70, "SeeAlsoSection",
 CellID->22848],
Cell[7310, 256, 492, 17, 70, "SeeAlso",
 CellID->4675]
}, Open  ]],
Cell[CellGroupData[{
Cell[7839, 278, 313, 9, 70, "TutorialsSection",
 CellID->2483],
Cell[8155, 289, 170, 4, 70, "Tutorials",
 CellID->911]
}, Open  ]],
Cell[8340, 296, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

