(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     19029,        632]
NotebookOptionsPosition[     15358,        506]
NotebookOutlinePosition[     16653,        543]
CellTagsIndexPosition[     16568,        538]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["STATISTICAL PLOTS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Statistical Plots Package" :> 
          Documentation`HelpLookup[
           "paclet:StatisticalPlots/tutorial/StatisticalPlots"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Statistical Plots Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PairwiseScatterPlot" :> 
          Documentation`HelpLookup[
           "paclet:StatisticalPlots/ref/PairwiseScatterPlot"], "Quantile" :> 
          Documentation`HelpLookup["paclet:ref/Quantile"], "ListPlot" :> 
          Documentation`HelpLookup["paclet:ref/ListPlot"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"PairwiseScatterPlot\"\>", 
       2->"\<\"Quantile\"\>", 3->"\<\"ListPlot\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["QuantilePlot", "ObjectName",
 CellID->20315],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"QuantilePlot", "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["data", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["data", "TI"], 
         StyleBox["2", "TR"]]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]creates a quantile\[Hyphen]quantile plot from the real\
\[Hyphen]valued vectors ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["data", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["data", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->9576]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["QuantilePlot"], "InlineFormula"],
 " plots empirical quantiles of the the two vectors against each other."
}], "Notes",
 CellID->114809958],

Cell[TextData[{
 Cell[BoxData["QuantilePlot"], "InlineFormula"],
 " sorts the shorter data set, and then determines interpolated quantiles at \
the equivalent position in the longer list of data."
}], "Notes",
 CellID->30227],

Cell[TextData[{
 "For data sets of equal length, ",
 Cell[BoxData["QuantilePlot"], "InlineFormula"],
 " yields the equivalent of plotting the sorted lists against each other."
}], "Notes",
 CellID->12043],

Cell[TextData[{
 Cell[BoxData["QuantilePlot"], "InlineFormula"],
 " has the same options as ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 ", with the following additions and changes:"
}], "Notes",
 CellID->7164],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Axes",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Axes"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to draw axes", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["PlotMarkers",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlotMarkers"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "markers for points", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ReferenceLineStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:StatisticalPlots/ref/ReferenceLineStyle"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "style for the reference line", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->5109],

Cell[TextData[{
 "Valid settings for the option ",
 Cell[BoxData[
  ButtonBox["ReferenceLineStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:StatisticalPlots/ref/ReferenceLineStyle"]], 
  "InlineFormula"],
 " are ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " or a style or a list of styles."
}], "Notes",
 CellID->7882],

Cell["\<\
The reference line has a slope of unity. If the points on the plot fall \
mostly on or near the reference line, the distributions are roughly the same.\
\
\>", "Notes",
 CellID->87769936]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->535473451],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->723234905],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<StatisticalPlots`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->188605234],

Cell[TextData[{
 Cell[BoxData["QuantilePlot"], "InlineFormula"],
 " of two data sets:"
}], "ExampleText",
 CellID->374859463],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"QuantilePlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"10", ",", "3", ",", "2", ",", "15", ",", "25", ",", "8"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "6", ",", "5", ",", "10", ",", "15"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->56168240],

Cell[BoxData[
 GraphicsBox[
  GraphicsComplexBox[{{2.1, 2.}, {4.5, 5.}, {9., 6.}, {13.5, 10.}, {24., 
   15.}, {2.1, 2.}, {4.5, 5.}, {9., 6.}, {13.5, 10.}, {24., 15.}}, {{}, 
    {Hue[0.67, 0.6, 0.6], PointBox[{6, 7, 8, 9, 10}]}, {}}],
  Axes->True,
  Epilog->{{
     LineBox[{{2, 2}, {25, 25}}]}, {}},
  PlotRange->{All, All},
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 ImageSize->{184, 121},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->44522925]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->24596],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ReferenceLineStyle",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->306150385],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<StatisticalPlots`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->812808571],

Cell[TextData[{
 Cell[BoxData["QuantilePlot"], "InlineFormula"],
 " with a dashed reference line:"
}], "ExampleText",
 CellID->180504959],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"QuantilePlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"10", ",", "3", ",", "2", ",", "15", ",", "25", ",", "8"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "6", ",", "5", ",", "10", ",", "15"}], "}"}], ",", 
   RowBox[{"ReferenceLineStyle", "\[Rule]", 
    RowBox[{"Dashing", "[", "Medium", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->704894624],

Cell[BoxData[
 GraphicsBox[
  GraphicsComplexBox[{{2.1, 2.}, {4.5, 5.}, {9., 6.}, {13.5, 10.}, {24., 
   15.}, {2.1, 2.}, {4.5, 5.}, {9., 6.}, {13.5, 10.}, {24., 15.}}, {{}, 
    {Hue[0.67, 0.6, 0.6], PointBox[{6, 7, 8, 9, 10}]}, {}}],
  Axes->True,
  Epilog->{{
     Dashing[Medium], 
     LineBox[{{2, 2}, {25, 25}}]}, {}},
  PlotRange->{All, All},
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 ImageSize->{184, 121},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->37467832]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10195],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<StatisticalPlots`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->894770317],

Cell["Compare samples from different distributions:", "ExampleText",
 CellID->320182687],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"QuantilePlot", "[", 
  RowBox[{
   RowBox[{"RandomReal", "[", 
    RowBox[{
     RowBox[{"NormalDistribution", "[", 
      RowBox[{"0", ",", "1"}], "]"}], ",", "200"}], "]"}], ",", 
   RowBox[{"RandomReal", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", "200"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->141342286],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 135},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->615643066]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->25627],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["PairwiseScatterPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:StatisticalPlots/ref/PairwiseScatterPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Quantile",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Quantile"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ListPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListPlot"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->5629]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->3487],

Cell[TextData[ButtonBox["Statistical Plots Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:StatisticalPlots/tutorial/StatisticalPlots"]], "Tutorials",
 CellID->29577]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"QuantilePlot - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 8, 36.0061716}", "context" -> 
    "StatisticalPlots`", "keywords" -> {}, "index" -> True, "label" -> 
    "Statistical Plots Package Symbol", "language" -> "en", "paclet" -> 
    "StatisticalPlots Package", "status" -> "None", "summary" -> 
    "QuantilePlot[data_1, data_2] creates a quantile-quantile plot from the \
real-valued vectors data_1 and data_2.", "synonyms" -> {}, "title" -> 
    "QuantilePlot", "type" -> "Symbol", "uri" -> 
    "StatisticalPlots/ref/QuantilePlot"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6295, 212, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->535473451]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 16425, 531}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1462, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2085, 63, 50, 1, 70, "ObjectName",
 CellID->20315],
Cell[2138, 66, 868, 29, 70, "Usage",
 CellID->9576]
}, Open  ]],
Cell[CellGroupData[{
Cell[3043, 100, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3521, 117, 170, 4, 70, "Notes",
 CellID->114809958],
Cell[3694, 123, 225, 5, 70, "Notes",
 CellID->30227],
Cell[3922, 130, 204, 5, 70, "Notes",
 CellID->12043],
Cell[4129, 137, 288, 9, 70, "Notes",
 CellID->7164],
Cell[4420, 148, 1113, 31, 70, "3ColumnTableMod",
 CellID->5109],
Cell[5536, 181, 522, 19, 70, "Notes",
 CellID->7882],
Cell[6061, 202, 197, 5, 70, "Notes",
 CellID->87769936]
}, Closed]],
Cell[CellGroupData[{
Cell[6295, 212, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->535473451],
Cell[CellGroupData[{
Cell[6680, 226, 148, 5, 70, "ExampleSection",
 CellID->723234905],
Cell[6831, 233, 141, 4, 70, "Input",
 CellID->188605234],
Cell[6975, 239, 125, 4, 70, "ExampleText",
 CellID->374859463],
Cell[CellGroupData[{
Cell[7125, 247, 310, 10, 28, "Input",
 CellID->56168240],
Cell[7438, 259, 514, 14, 142, "Output",
 CellID->44522925]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8001, 279, 218, 7, 70, "ExampleSection",
 CellID->24596],
Cell[CellGroupData[{
Cell[8244, 290, 239, 7, 70, "ExampleSubsection",
 CellID->306150385],
Cell[8486, 299, 141, 4, 70, "Input",
 CellID->812808571],
Cell[8630, 305, 137, 4, 70, "ExampleText",
 CellID->180504959],
Cell[CellGroupData[{
Cell[8792, 313, 406, 11, 70, "Input",
 CellID->704894624],
Cell[9201, 326, 537, 15, 142, "Output",
 CellID->37467832]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[9799, 348, 223, 7, 70, "ExampleSection",
 CellID->10195],
Cell[10025, 357, 141, 4, 70, "Input",
 CellID->894770317],
Cell[10169, 363, 88, 1, 70, "ExampleText",
 CellID->320182687],
Cell[CellGroupData[{
Cell[10282, 368, 415, 14, 70, "Input",
 CellID->141342286],
Cell[10700, 384, 2982, 53, 70, "Output",
 Evaluatable->False,
 CellID->615643066]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13743, 444, 311, 9, 70, "SeeAlsoSection",
 CellID->25627],
Cell[14057, 455, 734, 26, 70, "SeeAlso",
 CellID->5629]
}, Open  ]],
Cell[CellGroupData[{
Cell[14828, 486, 313, 9, 70, "TutorialsSection",
 CellID->3487],
Cell[15144, 497, 172, 4, 70, "Tutorials",
 CellID->29577]
}, Open  ]],
Cell[15331, 504, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

