(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9696,        347]
NotebookOptionsPosition[      7063,        260]
NotebookOutlinePosition[      8368,        297]
CellTagsIndexPosition[      8284,        292]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["STATISTICAL PLOTS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Statistical Plots Package" :> 
          Documentation`HelpLookup[
           "paclet:StatisticalPlots/tutorial/StatisticalPlots"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Statistical Plots Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"QuantilePlot" :> 
          Documentation`HelpLookup[
           "paclet:StatisticalPlots/ref/QuantilePlot"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"QuantilePlot\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ReferenceLineStyle", "ObjectName",
 CellID->17505],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["ReferenceLineStyle"], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["QuantilePlot",
       BaseStyle->"Link",
       ButtonData->"paclet:StatisticalPlots/ref/QuantilePlot"]], 
      "InlineFormula"],
     " which specifies a style to use for the reference line."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->27593]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The reference line has a slope of unity. ", "Notes",
 CellID->87769936],

Cell["\<\
If the points on the plot fall mostly on or near the reference line, the \
distributions are roughly the same.\
\>", "Notes",
 CellID->626344326],

Cell[TextData[{
 "Valid settings are ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 ", a style or a list of styles. The default setting is ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->22725],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{"ReferenceLineStyle", "->", 
   ButtonBox["None",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/None"]}]], "InlineFormula"],
 ", a reference line is not drawn."
}], "Notes",
 CellID->13031]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->61847890],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->556216419],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<StatisticalPlots`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->550515158],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["QuantilePlot",
   BaseStyle->"Link",
   ButtonData->"paclet:StatisticalPlots/ref/QuantilePlot"]], 
  "InlineFormula"],
 " with a dashed reference line:"
}], "ExampleText",
 CellID->180504959],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"QuantilePlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"10", ",", "3", ",", "2", ",", "15", ",", "25", ",", "8"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "6", ",", "5", ",", "10", ",", "15"}], "}"}], ",", 
   RowBox[{"ReferenceLineStyle", "\[Rule]", 
    RowBox[{"Dashing", "[", "Medium", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->704894624],

Cell[BoxData[
 GraphicsBox[
  GraphicsComplexBox[{{2.1, 2.}, {4.5, 5.}, {9., 6.}, {13.5, 10.}, {24., 
   15.}, {2.1, 2.}, {4.5, 5.}, {9., 6.}, {13.5, 10.}, {24., 15.}}, {{}, 
    {Hue[0.67, 0.6, 0.6], PointBox[{6, 7, 8, 9, 10}]}, {}}],
  Axes->True,
  Epilog->{{
     Dashing[Medium], 
     LineBox[{{2, 2}, {25, 25}}]}, {}},
  PlotRange->{All, All},
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 ImageSize->{184, 121},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->37467832]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->13064],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["QuantilePlot",
   BaseStyle->"Link",
   ButtonData->"paclet:StatisticalPlots/ref/QuantilePlot"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->7900]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->8492],

Cell[TextData[ButtonBox["Statistical Plots Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:StatisticalPlots/tutorial/StatisticalPlots"]], "Tutorials",
 CellID->142]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ReferenceLineStyle - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 8, 36.2561780}", "context" -> 
    "StatisticalPlots`", "keywords" -> {}, "index" -> True, "label" -> 
    "Statistical Plots Package Symbol", "language" -> "en", "paclet" -> 
    "StatisticalPlots Package", "status" -> "None", "summary" -> 
    "ReferenceLineStyle is an option for QuantilePlot which specifies a style \
to use for the reference line.", "synonyms" -> {}, "title" -> 
    "ReferenceLineStyle", "type" -> "Symbol", "uri" -> 
    "StatisticalPlots/ref/ReferenceLineStyle"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4018, 144, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->61847890]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 8142, 285}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1239, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1862, 60, 56, 1, 70, "ObjectName",
 CellID->17505],
Cell[1921, 63, 555, 16, 70, "Usage",
 CellID->27593]
}, Open  ]],
Cell[CellGroupData[{
Cell[2513, 84, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2991, 101, 77, 1, 70, "Notes",
 CellID->87769936],
Cell[3071, 104, 155, 4, 70, "Notes",
 CellID->626344326],
Cell[3229, 110, 492, 18, 70, "Notes",
 CellID->22725],
Cell[3724, 130, 257, 9, 70, "Notes",
 CellID->13031]
}, Closed]],
Cell[CellGroupData[{
Cell[4018, 144, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->61847890],
Cell[CellGroupData[{
Cell[4402, 158, 148, 5, 70, "ExampleSection",
 CellID->556216419],
Cell[4553, 165, 141, 4, 70, "Input",
 CellID->550515158],
Cell[4697, 171, 235, 8, 70, "ExampleText",
 CellID->180504959],
Cell[CellGroupData[{
Cell[4957, 183, 406, 11, 47, "Input",
 CellID->704894624],
Cell[5366, 196, 537, 15, 142, "Output",
 CellID->37467832]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5964, 218, 311, 9, 70, "SeeAlsoSection",
 CellID->13064],
Cell[6278, 229, 220, 6, 70, "SeeAlso",
 CellID->7900]
}, Open  ]],
Cell[CellGroupData[{
Cell[6535, 240, 313, 9, 70, "TutorialsSection",
 CellID->8492],
Cell[6851, 251, 170, 4, 70, "Tutorials",
 CellID->142]
}, Open  ]],
Cell[7036, 258, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

