(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18793,        637]
NotebookOptionsPosition[     15077,        509]
NotebookOutlinePosition[     16374,        546]
CellTagsIndexPosition[     16289,        541]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["STATISTICAL PLOTS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Statistical Plots Package" :> 
          Documentation`HelpLookup[
           "paclet:StatisticalPlots/tutorial/StatisticalPlots"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Statistical Plots Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"IncludeEmptyStems" :> 
          Documentation`HelpLookup[
           "paclet:StatisticalPlots/ref/IncludeEmptyStems"], 
          "IncludeStemUnits" :> 
          Documentation`HelpLookup[
           "paclet:StatisticalPlots/ref/IncludeStemUnits"], 
          "IncludeStemCounts" :> 
          Documentation`HelpLookup[
           "paclet:StatisticalPlots/ref/IncludeStemCounts"], "Leaves" :> 
          Documentation`HelpLookup["paclet:StatisticalPlots/ref/Leaves"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"IncludeEmptyStems\"\>", 
       2->"\<\"IncludeStemUnits\"\>", 3->"\<\"IncludeStemCounts\"\>", 
       4->"\<\"Leaves\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["StemExponent", "ObjectName",
 CellID->12044],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["StemExponent"], "InlineFormula"],
     " \[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["StemLeafPlot",
       BaseStyle->"Link",
       ButtonData->"paclet:StatisticalPlots/ref/StemLeafPlot"]], 
      "InlineFormula"],
     " which specifies the integer power of 10 to be used as the stem unit."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->21659]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Valid settings for are ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " or an integer."
}], "Notes",
 CellID->26292],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{"StemExponent", "->", 
   StyleBox["n", "TI"]}]], "InlineFormula"],
 ", the base unit is taken to be ",
 Cell[BoxData[
  SuperscriptBox["10", 
   StyleBox["n", "TI"]]], "InlineFormula"],
 "."
}], "Notes",
 CellID->17253],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{"StemExponent", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", the magnitude of the base unit for stems is chosen based on the data."
}], "Notes",
 CellID->26439],

Cell[TextData[{
 Cell[BoxData["StemExponent"], "InlineFormula"],
 " can take the following suboptions:"
}], "Notes",
 CellID->20024],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<UnitDivisions\>\"", "1", Cell[
    "number of divisions for each stem unit", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<DivisionLabels\>\"", 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell["\<\
list of labels appended to stem numbers within each unit division\
\>", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->26154],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{"StemExponent", "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["n", "TI"], ",", " ", 
     RowBox[{"\"\<UnitDivisions\>\"", "->", 
      StyleBox["m", "TI"]}]}], "}"}]}]], "InlineFormula"],
 ", the interval between ",
 Cell[BoxData[
  RowBox[{
   StyleBox["i", "TI"], 
   StyleBox[" ", "TI"], 
   SuperscriptBox["10", 
    StyleBox["n", "TI"]]}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     StyleBox["i", "TI"], "+", "1"}], ")"}], 
   SuperscriptBox["10", 
    StyleBox["n", "TI"]]}]], "InlineFormula"],
 " is divided into ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " stems."
}], "Notes",
 CellID->29510],

Cell[TextData[{
 "Valid settings for the suboption ",
 Cell[BoxData["\"\<DivisionLabels\>\""], "InlineFormula"],
 " are ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 " or a list of labels of a length equal to the setting for the ",
 Cell[BoxData["\"\<UnitDivisions\>\""], "InlineFormula"],
 " suboption."
}], "Notes",
 CellID->4745]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->270400660],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->26807248],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<StatisticalPlots`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->49735892],

Cell[TextData[{
 "Specify a base unit of ",
 Cell[BoxData[
  SuperscriptBox["10", "1"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->51155507],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StemLeafPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1.2", ",", "2.5", ",", "4.1", ",", "1.6", ",", "3.8", ",", "2.6", ",", 
     "11"}], "}"}], ",", 
   RowBox[{"StemExponent", "\[Rule]", "1"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->480115699],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWDtPwzAQdm0nbUGFSki0QkhUYoYBGJHYYGLjD6QVUjsgUOn/D07iSy5f
nIcb6ESkxLF9j8++hy95jXbr949ot1lFi5dt9LXerL4Xz59bM6QGQoiluZ/m
wrzH5i29l3FsWv4UKmuSpzRtYF6UHdaimE+uwNxj05UwroRlFHQl7wm1ttKk
laYt97FpAyuE5ssyJYmI6cqVKqvAXCGjKkbHjIrW5ZangTKVPwQqrlvzuUTu
BHU59QzSNnDOBSBB16+pwuuxKtYfQn/6K2sIAM/fYCePOvPALC2PU3Yjri5r
yL0L0TSswq1Zxf4+xeOXrMCjSokyzYghlvmGU9BKxq2ZNL0vOp1rZtI59y30
LzztKmF9N8B/ZWkor2WZppoHuz+vQcNjw+i53cMRzJKl7lKqOcwiNcbrP1eV
axZndj6C2dCOP3jb7rCjCX4lqmcXz6y8pSgN4yJak/YkJr+rRk3bTrpjzWc0
BImYcSc90LlOgib6kGWGNNH13B3Uh/107UV9ICoVgyP79dkPZ90A+yUpBbfg
Ou2Bo83m2OdnoxDlU1n0xNLfgxGNG11dtFK2odNGQ8vnZS7NJ0+85V582Pzk
+53g8lasJqiPXqtF8cUwLWmvt1u3LwP0n2rMYuWmO2lz5qYKV2btPl8Bh8KP
eiYtyOtrfydisDf3i/pY5ade5hW/Udd3wdcvo/iMZh6yT03flpF5FsplFLW/
KO+mLrC0VvCzFu33ua2wVr8ESsopWa1m/08MfgDbfnkz\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{98, 63},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->185382979]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4414],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "\"UnitDivisions\"",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->119864228],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<StatisticalPlots`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->173792474],

Cell[TextData[{
 "Specify that stem units be divided in ",
 Cell[BoxData["2"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->291992165],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StemLeafPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1.2", ",", "2.5", ",", "3.1", ",", "1.6", ",", "3.8", ",", "2.6", ",", 
     "2.3"}], "}"}], ",", 
   RowBox[{"StemExponent", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", 
      RowBox[{"\"\<UnitDivisions\>\"", "\[Rule]", "2"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->180910666],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWEtP4zAQdm2npSAkJKRdQEggWJCALTf+wu5pb9w4VQgJDggE3PjxXjvx
JJPpOLaTUvVApDw8npdnPj8y/+Yfjw/P84+n+/nx37f56+PT/fvxn5c3S1Ij
IcSdvT/3hP029qu874yxb/wUqnq5p7Tvwn4oT9ai6XdXYe+pbUpCV8ILCrjc
t+PWXpv02rSX3rJv1z9q+SA8Zylq4KqNKa/YXmPE1VCniAvGw+vThLPUPyFc
2LbGfU7vNtFQjaRgrRWEV4e9X5DN8B+1J6S9k+ltQSx/jZeAjl3WO+l7WS2d
HqR4W2MD4yXiL29ZmS5E4PkFkVWmmRVKtHk2kG+yDiJMKomkNdKm437o2gbS
g/muSfsgmBVJfJ4RziNsQSyuOenPU6L5poP608eFrgJjT/9dcv1gc7hBZPiZ
cVW+aVzGK5Ld81HtHt8QC8Njk5aDnKyulhryH2ZuTpzoGpyGgGVKhRCzTBtD
YtGFFuf3LDt/q6W6sRfMaAHtsL+dZUSKn138/vqrjiLWQKNZtpvzC7PynxhA
C6ZSz1L17BMqzT1EB/atKjox9NE2tX2eEWOqi54wzuq4htAJZ1lVZ2Ed8NgP
pcvaF5NwiNoXJhl1C1IxjLm2TN4TeRvfu2EacmIZjJ1p1lVW540QtWdJUhSF
lS2HGYfcTdI78TG/6sjXOlBDmGmfoL4yd3xcY1LhE1SXFG1fJkn1WwljKw2H
mv4rza0lTLKlhlNz61E0b/gfG/6KoU3PD64fKlPTlnUhhlWiWEy2zk601qCT
rHEVlMAeNagWtSr/WTu96lKxVQDjQItQdqVpV2gqVCyjEpXiX+q5fzi1Qkif
2lTsHA1xauloaliiHU3d+BKtT9HzJb/Oc/WpQ8IJa0q1T/s6+Og/6+wQuA==
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{91, 123},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->89855714]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "\"UnitDivisions\"",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->279871726],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<StatisticalPlots`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->150389932],

Cell["Label the two divisions with \"L\" and \"H\":", "ExampleText",
 CellID->14855520],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StemLeafPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1.2", ",", "2.5", ",", "3.1", ",", "1.6", ",", "3.8", ",", "2.6", ",", 
     "2.3"}], "}"}], ",", 
   RowBox[{"StemExponent", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", 
      RowBox[{"\"\<UnitDivisions\>\"", "\[Rule]", "2"}], ",", 
      RowBox[{"\"\<DivisionLabels\>\"", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<L\>\"", ",", "\"\<H\>\""}], "}"}]}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->744838370],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVWV9v1DAMzyXp3Y4JMbYHEEJi4p8EbHvbV9ieeONtT6cJaXtAoLE3PnxI
mrh1XDdp2u52q9RLkzq2azu/OL7vm/ubn78297fXm+PLu82fm9vrv8cXv+/s
kFoIIa7s/e+1sM/GPtX3lTG2xb9C+cb9SttW9kGFYS3a9+6q7L22XUnGlQgT
BVzu2VHrwE0GbjrM3rete7+IdBCBsp5q4GqEqcDYXktE1Y6uERV8D89PE8qa
/4pQYdkav3N8nxMO/ksqVlpFaHW/9p25Bfqj/or0Dwq1rYjkh9ESouOI1U6G
tyyXpAZDtG1iA8dLRl9esjKpiMDrCyyrTLsqlIhp9pBusjEiLCqJZmvETef1
0I0MxAfTnZH+m16vSKLzKaF8hyWILuYM//1AOJ8nRg+oVVvL2YuuiGWgOqmJ
XvTGSXd0j3DiV9G3uq0ju8UOxurLR+P2EnmpYr4rttC8sh/K3lNioCTWtjsK
X9XnKcCVlG3JLsZwodZBMcd7KuH7El77g+ZCtNLdgO7580tO2LNYD+xJ1z5j
7Oi+skbUnYg9ftTZxJmkm/WpxDqD/f5Twq5TMICf+7GxfH4vp3JqryZR772B
6OxkErNxP4zpTBqvIR/wVi7Hbdqn9J/NVO9RCXRNe83LsRxOGKrx+i6slfQK
khlvpvKTPKbn9sqOF5LcKMZ9MVzs55CR53JIRukOw+GrFFF2ksV3XvI4fB+S
haRQ/inkHeNQ3n/VOETM5atPkWNfxqbnsBXqn07gRRHZ6+XiGJ840wi8ClTe
ErsQv+OQN86mWXQbjbnl3HjPlGJuf05dwoXq9nUUl3l2kRz+wllhXvz9AXG/
5ZgtrdJSf+PKE9SKoE+trkVbr11H0oWYVp9lYzuKfrrr60HSuLpiD+ZNqtBu
S39WzqhqbQ5NcBxo0eddaeK6pY+KOeqzQ/QbesqYPuojZEzFNne6ATv1n2ew
NXWrS7Zq+yoj/aTxFa3aviWUgCk+jwj/Di3+A+nJiU0=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{91, 123},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->383214629]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->28022],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["IncludeEmptyStems",
    BaseStyle->"Link",
    ButtonData->"paclet:StatisticalPlots/ref/IncludeEmptyStems"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["IncludeStemUnits",
    BaseStyle->"Link",
    ButtonData->"paclet:StatisticalPlots/ref/IncludeStemUnits"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["IncludeStemCounts",
    BaseStyle->"Link",
    ButtonData->"paclet:StatisticalPlots/ref/IncludeStemCounts"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Leaves",
    BaseStyle->"Link",
    ButtonData->"paclet:StatisticalPlots/ref/Leaves"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->2168]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->20649],

Cell[TextData[ButtonBox["Statistical Plots Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:StatisticalPlots/tutorial/StatisticalPlots"]], "Tutorials",
 CellID->13186]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"StemExponent - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 8, 36.4593082}", "context" -> 
    "StatisticalPlots`", "keywords" -> {}, "index" -> True, "label" -> 
    "Statistical Plots Package Symbol", "language" -> "en", "paclet" -> 
    "StatisticalPlots Package", "status" -> "None", "summary" -> 
    "StemExponent is an option for StemLeafPlot which specifies the integer \
power of 10 to be used as the stem unit.", "synonyms" -> {}, "title" -> 
    "StemExponent", "type" -> "Symbol", "uri" -> 
    "StatisticalPlots/ref/StemExponent"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6219, 215, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->270400660]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 16146, 534}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1704, 42, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2327, 69, 50, 1, 70, "ObjectName",
 CellID->12044],
Cell[2380, 72, 564, 16, 70, "Usage",
 CellID->21659]
}, Open  ]],
Cell[CellGroupData[{
Cell[2981, 93, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3459, 110, 212, 8, 70, "Notes",
 CellID->26292],
Cell[3674, 120, 283, 11, 70, "Notes",
 CellID->17253],
Cell[3960, 133, 308, 9, 70, "Notes",
 CellID->26439],
Cell[4271, 144, 132, 4, 70, "Notes",
 CellID->20024],
Cell[4406, 150, 634, 15, 70, "3ColumnTableMod",
 CellID->26154],
Cell[5043, 167, 735, 29, 70, "Notes",
 CellID->29510],
Cell[5781, 198, 401, 12, 70, "Notes",
 CellID->4745]
}, Closed]],
Cell[CellGroupData[{
Cell[6219, 215, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->270400660],
Cell[CellGroupData[{
Cell[6604, 229, 147, 5, 70, "ExampleSection",
 CellID->26807248],
Cell[6754, 236, 140, 4, 70, "Input",
 CellID->49735892],
Cell[6897, 242, 149, 6, 70, "ExampleText",
 CellID->51155507],
Cell[CellGroupData[{
Cell[7071, 252, 295, 9, 28, "Input",
 CellID->480115699],
Cell[7369, 263, 987, 20, 84, "Output",
 Evaluatable->False,
 CellID->185382979]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8405, 289, 217, 7, 70, "ExampleSection",
 CellID->4414],
Cell[CellGroupData[{
Cell[8647, 300, 238, 7, 70, "ExampleSubsection",
 CellID->119864228],
Cell[8888, 309, 141, 4, 70, "Input",
 CellID->173792474],
Cell[9032, 315, 140, 5, 70, "ExampleText",
 CellID->291992165],
Cell[CellGroupData[{
Cell[9197, 324, 411, 13, 70, "Input",
 CellID->180910666],
Cell[9611, 339, 1126, 23, 70, "Output",
 Evaluatable->False,
 CellID->89855714]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[10786, 368, 238, 7, 70, "ExampleSubsection",
 CellID->279871726],
Cell[11027, 377, 141, 4, 70, "Input",
 CellID->150389932],
Cell[11171, 383, 87, 1, 70, "ExampleText",
 CellID->14855520],
Cell[CellGroupData[{
Cell[11283, 388, 548, 16, 70, "Input",
 CellID->744838370],
Cell[11834, 406, 1232, 24, 70, "Output",
 Evaluatable->False,
 CellID->383214629]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13139, 438, 311, 9, 70, "SeeAlsoSection",
 CellID->28022],
Cell[13453, 449, 1056, 35, 70, "SeeAlso",
 CellID->2168]
}, Open  ]],
Cell[CellGroupData[{
Cell[14546, 489, 314, 9, 70, "TutorialsSection",
 CellID->20649],
Cell[14863, 500, 172, 4, 70, "Tutorials",
 CellID->13186]
}, Open  ]],
Cell[15050, 507, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

