(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    138002,       3838]
NotebookOptionsPosition[    125695,       3410]
NotebookOutlinePosition[    127548,       3454]
CellTagsIndexPosition[    127505,       3451]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["STATISTICAL PLOTS PACKAGE TUTORIAL", "PacletNameCell"], Cell[
    TextData[Cell[BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"BoxWhiskerPlot" :> 
         Documentation`HelpLookup[
          "paclet:StatisticalPlots/ref/BoxWhiskerPlot"], 
         "PairwiseScatterPlot" :> 
         Documentation`HelpLookup[
          "paclet:StatisticalPlots/ref/PairwiseScatterPlot"], "ParetoPlot" :> 
         Documentation`HelpLookup["paclet:StatisticalPlots/ref/ParetoPlot"], 
         "QuantilePlot" :> 
         Documentation`HelpLookup["paclet:StatisticalPlots/ref/QuantilePlot"],
          "StemLeafPlot" :> 
         Documentation`HelpLookup[
          "paclet:StatisticalPlots/ref/StemLeafPlot"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"BoxWhiskerPlot\"\>", 
      2->"\<\"PairwiseScatterPlot\"\>", 3->"\<\"ParetoPlot\"\>", 
      4->"\<\"QuantilePlot\"\>", 
      5->"\<\"StemLeafPlot\"\>"}, "\<\"functions\"\>", 
      StyleBox["\<\"functions\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Statistical Plots Package", "Title",
 CellID->9219],

Cell[TextData[{
 "A wide variety of plots and charts are used to gain an overview of data \
from a statistical perspective. Some summarize statistical computations on \
the data, while others compare data in ways that highlight their properties. \
This package implements several plotting functions of this class, including \
box\[Hyphen]and\[Hyphen]whisker plots, Pareto plots, \
quantile\[Hyphen]quantile plots, and stem-and-leaf plots. Histograms, also \
commonly used in statistical applications, are included in the ",
 ButtonBox["Histograms Package",
  BaseStyle->"Link",
  ButtonData->"paclet:Histograms/guide/HistogramsPackage"],
 "."
}], "Text",
 CellID->27083],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["BoxWhiskerPlot",
      BaseStyle->"Link",
      ButtonData->"paclet:StatisticalPlots/ref/BoxWhiskerPlot"], "[", 
     StyleBox["data", "TI"], "]"}], Cell["\<\
create a box\[Hyphen]and\[Hyphen]whisker plot of a data set\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["ParetoPlot",
      BaseStyle->"Link",
      ButtonData->"paclet:StatisticalPlots/ref/ParetoPlot"], "[", 
     StyleBox["data", "TI"], "]"}], Cell[
    "create a Pareto plot from the data", "TableText"]},
   {
    RowBox[{
     ButtonBox["QuantilePlot",
      BaseStyle->"Link",
      ButtonData->"paclet:StatisticalPlots/ref/QuantilePlot"], "[", 
     SubscriptBox[
      StyleBox["list", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["list", "TI"], 
      StyleBox["2", "TR"]], "]"}], Cell["\<\
create a quantile\[Hyphen]quantile plot from the lists of data\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["PairwiseScatterPlot",
      BaseStyle->"Link",
      ButtonData->"paclet:StatisticalPlots/ref/PairwiseScatterPlot"], "[", 
     StyleBox["matrix", "TI"], "]"}], Cell[
    "create a pairs scatter plot from multivariate data", "TableText"]},
   {
    RowBox[{
     ButtonBox["StemLeafPlot",
      BaseStyle->"Link",
      ButtonData->"paclet:StatisticalPlots/ref/StemLeafPlot"], "[", 
     StyleBox["data", "TI"], "]"}], Cell["\<\
create a stem\[Hyphen]and\[Hyphen]leaf plot from a list of data\
\>", "TableText"]}
  }]], "DefinitionBox",
 CellID->13576],

Cell["\<\
Basic statistics\[Hyphen]related plots.\
\>", "Caption",
 CellID->5185],

Cell["Load the plotting package. ", "MathCaption",
 CellID->12220],

Cell[BoxData[
 RowBox[{"<<", "StatisticalPlots`"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32265],

Cell[CellGroupData[{

Cell["Box\[Hyphen]and\[Hyphen]Whisker Plots", "Section",
 CellID->3153],

Cell["\<\
The box\[Hyphen]and\[Hyphen]whisker plot is invaluable for gaining a quick \
overview of the extent of a numeric data set. It takes the form of a box that \
spans the distance between two quantiles surrounding the median, typically \
the 25% quantile to the 75% quantile. Commonly, \
\[OpenCurlyDoubleQuote]whiskers,\[CloseCurlyDoubleQuote] lines that extend to \
span either the full data set or the data set excluding outliers, are added. \
Outliers are defined as points beyond 3/2 the discrete interquantile range \
from the edge of the box; far outliers are points beyond three times that \
range.\
\>", "Text",
 CellID->9115],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["BoxWhiskerPlot",
      BaseStyle->"Link",
      ButtonData->"paclet:StatisticalPlots/ref/BoxWhiskerPlot"], "[", 
     StyleBox["vector", "TI"], "]"}], Cell[
    "plot a vector of data", "TableText"]},
   {
    RowBox[{
     ButtonBox["BoxWhiskerPlot",
      BaseStyle->"Link",
      ButtonData->"paclet:StatisticalPlots/ref/BoxWhiskerPlot"], "[", 
     StyleBox["matrix", "TI"], "]"}], Cell[
    "plot each column as a separate box", "TableText"]},
   {
    RowBox[{
     ButtonBox["BoxWhiskerPlot",
      BaseStyle->"Link",
      ButtonData->"paclet:StatisticalPlots/ref/BoxWhiskerPlot"], "[", 
     SubscriptBox[
      StyleBox["data", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["data", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"], "]"}], Cell["\<\
plot multiple data sets, with a box for each column or vector\
\>", "TableText"]}
  }]], "DefinitionBox",
 CellID->20043],

Cell["Box\[Hyphen]and\[Hyphen]whisker plots.", "Caption",
 CellID->6084],

Cell["Generate some numbers to plot. ", "MathCaption",
 CellID->19757],

Cell[BoxData[{
 RowBox[{
  RowBox[{"dat", "=", 
   RowBox[{"RandomReal", "[", 
    RowBox[{"1", ",", "50"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"datm", "=", 
   RowBox[{"RandomReal", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", 
      RowBox[{"50", ",", "3"}], "}"}]}], "]"}]}], ";"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->27684],

Cell["\<\
In its most basic form, the function takes a simple vector of data. \
\>", "MathCaption",
 CellID->13215],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BoxWhiskerPlot", "[", "dat", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->2619],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnL9r20AUx09W7CxJqhKUFrcpgYBN9QeYLCmdWi2BEjfgNgRsQos9lJY0
YCiF/AFdC6aTt1LPmjxp9NLdo0ePGj2qeicndk/+oV8xkvkKdH5P9z5fS7qT
fE+WdFK7rn/4VLtuXNYOXl/VvtQbl18PXn2+chbJEmNS3ZnPHzPHthlzZ5oa
zuyaoqXY/IO9Y3ySXe/OlG8VbJZxzKywjIozZ5ZcZGNS4zj04V0Sic6OF5RX
+J3x0TfcHw6HJp9YgQrZMIyxX+T+aDSaipc87ZJzzFlt4aq3Wq2XfGIFKuR8
Pq9pGplF7vd6PY+6Iij94X61Wm2322R2EIlImwKTvH6IRCT6OiIRiR6MyNVF
zssZuM+8o+AFSv+NnrOCVlidnMCJeY1fnU2By9huPvI7Ah9mPZbnGf7aal4e
kdR+hsh1i8RvlN/IU+73+/1cbpPqO/xY3t5+YFkWVZWXkKZpFoul79/+sg4V
8t7e08FgAHLdSQKTv5YgQYLEuQAkyDSSngw4e6cyrhBzrADagXJZV9cwjN3d
Jy+OP7IOFfLWlrJElzLIDebNJF29brerqvsTvZ2dhz70pnN32n7aKW9Cbjfx
s3LVsPsxBr2pNhcz+9mtktTeCxJkWkmMaUCCXCcSRzRIkCBxLgAJ8r7IoPf5
hs2zl/9XnRblKFcviJdj3KuiToQtF65iZCLtx3QdAyBBYpQCEiRInAtAggQZ
J4lzAcjUk8/2n1+c/2JlKuS3pz/eV35OfEVRfSpZlqXrJ0dHx6xMhayqjw4P
CxO/UrlwH3tdoBT8CQQyg93hHuOd9j6vKfh9emDeHQtJ2ZbgLYXnDxB5H5EU
mOT1QyQi0dcRubrIG+6L7x3Rdb3ZbJoL3zsyW0l8x4imaaVSKdg7Rqg4i632
tjI+RRqlVJxZck3pH0u6pOY=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 347},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->318979183]
}, Open  ]],

Cell["\<\
When the data is multivariate, a box is produced for each column. \
\>", "MathCaption",
 CellID->29715],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BoxWhiskerPlot", "[", "datm", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->15471],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnE1IG0EUgCeuP6BrFaka06iR4i9SAupGUpQeinopEaUHKa2m0mJobawK
gVLozRw914tH771ITt7qpSC0Bb1JTx495pjOm5l1NuPG7EY3u4mz4Oy8zJv3
vZ2ZnZ0dd+ZFfHvt3Xp8O7EaD81uxjfWEqtboZnkJv5J8SHkW0MI/fYjHM/h
GPmDI4H/aFSMzeJQwWqf8LkWn5NMjpLUOQgV3UqOaOkyDtGmkB4xzZUU5M+W
cm2YsGsKeiZqi8xJ01zrENRyudAVzTL2huHMS+nmEuYxpLBi06MGTg2LvqEq
eT7VXvOylp2XqDEL2kaWVqSsxLIEfZ9lEvww4SjBmHOIyEdHR8/IgZoggPTp
6Wku7+7uMv24w55cXl4ekQM1QaD4/f6DgwMun5+fM/2fRB979o0cqBECJZVK
LS8vQ1QlMrZnsO8zNB561Odoi6wzreNQKESB6C+R9/f382ixWCwcDkO0icjp
dDqbzYLq8BWttYjlf7rllZWVHLtjvJszrtfS3Nwcbx8jIyOapnF5fn4+r72U
QnpL5OPjY9YeGkn9YyyuYt4eTk5OLJEAJBLoXYXVcSYul+KrtCQt2bUkW6S0
VK2WZNuuLEuFRtZERoVGwCWR8saAdQKrGGeByHj00dzcAvoR4mAw2MP0Fyxy
6wWO+DZhzsVCR0fw65dfKAKBQd8qt0Hg1OCgDovjZeSV4zqtvkPdCdnCaL6L
yHhozsaSAeHdIiC8W0yU7I14T3bpmq2t7YODGgpAoAQCjwcGxiHaReSe7uFo
dIqXy52SJ8ZjYEQjll6/+j45KUkuk0CxWq5FkiTJORJNx50j6+E10uPjxz97
bgQcJgcCPR8//OD5cXeNnxVeIt9FX1Ip1yrJkizJsgeRZGfJZ2dnqtoyPfUe
RSAo7zWraqtL5FuX9rV5lLorKyzB/M20LL7ZmgFxyy/9P6BwhsLrdNEP48yU
V+oN/Cg8w3Ev/THcc+J8l3ututJ6fEmuRLIcuUmyJEuy7EEk2fvkvb29ocGn
mIc0CJSZ51tjY5FykHd2dpqbH/b2jiENAqWzc6C/f6i6S1v2INbJbW3t2sQS
TDhoZNahvb07k8lUN9n7Leu+kYt93+6Vd/7iX3d4yzP4we8pj7xSVoqHWpXo
h4vlJMwo1bhaa/exJ5RkOYqTZEl2gVxf38C/0wwGB/v6nnAZJzruCXkhNqx7
6hLWPdFvVU9PTx33ZJGk86+6F22RrPQotyOU71okSZKqnyTvWCPJiW9ORZL1
tT2Vaxk/yfBjE9Lpap1EYp2lL1i2bHdmhD4Tb78+yf46Fu+TjF9smK098v4V
OEoqYW+Ayl77V/2WwJBXfJGWpCXZIqUl5y1d7dTCdqyhO9SEw+FYLMZlcWef
0knZbDadTnPLyWQylUpxmV5QcZLZvWF9vxq6i9Dh4WHefkaqqkajUS5jR5n+
H5uW+Rpiuv9MJpPJky8uLmxbhuCRK9p04KQf4upws7HPzfZEC2QwdeNIDYIH
OdbmWZ01kjoaHR0NBoMQVYnMZ7yG7oSHmxarOT+pOfyewnSGbdrXP/JfvKVf
L23mN+xgZjJqBQW6GxrEbthVzfcfonR+xQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 210},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->854435838]
}, Open  ]],

Cell[BoxData[GridBox[{
   {Cell["option name ", "TableHeader"], Cell[
    "default value ", "TableHeader"], " "},
   {
    RowBox[{
     ButtonBox["BoxQuantile",
      BaseStyle->"Link",
      ButtonData->"paclet:StatisticalPlots/ref/BoxQuantile"], " "}], 
    RowBox[{"0.25", " "}], Cell[
    "distance of quantile from median (0.5) for box edges", "TableText"]},
   {
    RowBox[{
     ButtonBox["BoxOutliers",
      BaseStyle->"Link",
      ButtonData->"paclet:StatisticalPlots/ref/BoxOutliers"], " "}], 
    RowBox[{
     ButtonBox["None",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/None"], " "}], Cell[
    "whether to indicate outliers", "TableText"]},
   {
    RowBox[{
     ButtonBox["BoxOrientation",
      BaseStyle->"Link",
      ButtonData->"paclet:StatisticalPlots/ref/BoxOrientation"], " "}], 
    RowBox[{"Vertical", " "}], Cell[
    "orientation of the graph", "TableText"]},
   {
    RowBox[{
     ButtonBox["BoxLabels",
      BaseStyle->"Link",
      ButtonData->"paclet:StatisticalPlots/ref/BoxLabels"], " "}], 
    RowBox[{
     ButtonBox["Automatic",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Automatic"], " "}], Cell[
    "labels for the boxes", "TableText"]},
   {
    RowBox[{
     ButtonBox["BoxExtraSpacing",
      BaseStyle->"Link",
      ButtonData->"paclet:StatisticalPlots/ref/BoxExtraSpacing"], " "}], 
    RowBox[{"0", " "}], Cell[
    "specify extra space to place between boxes", "TableText"]},
   {
    RowBox[{
     ButtonBox["BoxFillingStyle",
      BaseStyle->"Link",
      ButtonData->"paclet:StatisticalPlots/ref/BoxFillingStyle"], " "}], 
    RowBox[{
     ButtonBox["Automatic",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Automatic"], " "}], Cell[
    "colors to use for the boxes", "TableText"]},
   {
    RowBox[{
     ButtonBox["BoxLineStyle",
      BaseStyle->"Link",
      ButtonData->"paclet:StatisticalPlots/ref/BoxLineStyle"], " "}], 
    RowBox[{
     ButtonBox["Automatic",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Automatic"], " "}], Cell[
    "styles to use for lines in the graph", "TableText"]},
   {
    RowBox[{
     ButtonBox["BoxMedianStyle",
      BaseStyle->"Link",
      ButtonData->"paclet:StatisticalPlots/ref/BoxMedianStyle"], " "}], 
    RowBox[{
     ButtonBox["Automatic",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Automatic"], " "}], Cell[
    "additional styles for the median line", "TableText"]},
   {
    RowBox[{
     ButtonBox["BoxOutlierMarkers",
      BaseStyle->"Link",
      ButtonData->"paclet:StatisticalPlots/ref/BoxOutlierMarkers"], " "}], 
    RowBox[{
     ButtonBox["Automatic",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Automatic"], " "}], Cell[
    "functions to use to draw outlier points", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellID->18766],

Cell[TextData[{
 "Options for ",
 Cell[BoxData[
  ButtonBox["BoxWhiskerPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:StatisticalPlots/ref/BoxWhiskerPlot"]], 
  "InlineFormula"],
 ". "
}], "Caption",
 CellID->27261],

Cell[TextData[{
 "A number of options can be applied to control the appearance of the boxes. \
In addition to the above options, standard ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 " options can be used. "
}], "Text",
 CellID->3199],

Cell[TextData[{
 "The amount of data covered by the boxes is determined by the ",
 Cell[BoxData[
  ButtonBox["BoxQuantile",
   BaseStyle->"Link",
   ButtonData->"paclet:StatisticalPlots/ref/BoxQuantile"]], "InlineFormula"],
 " option. This takes the form of a number from 0 to 0.5, indicating a \
distance from the median (i.e., 0.5). Thus, 0.25 places quantiles at 0.25 and \
0.75 (or the 25% and 75% quantiles). Note that all quantiles are computed as \
discrete quantiles, not interpolated quantiles."
}], "Text",
 CellID->32636],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["BoxOutliers",
   BaseStyle->"Link",
   ButtonData->"paclet:StatisticalPlots/ref/BoxOutliers"]], "InlineFormula"],
 " option indicates whether outliers should be drawn in a special way. If ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 ", the whiskers are drawn to cover the entire data set. If ",
 Cell[BoxData[
  ButtonBox["All",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/All"]], "InlineFormula"],
 ", near and far outliers (as described previously) are drawn identically, \
and the whiskers only cover non\[Hyphen]outlying data points. If ",
 StyleBox["Automatic", "MR"],
 ", the near and far outliers are drawn differently, as determined by the ",
 Cell[BoxData[
  ButtonBox["BoxOutlierMarkers",
   BaseStyle->"Link",
   ButtonData->"paclet:StatisticalPlots/ref/BoxOutlierMarkers"]], 
  "InlineFormula"],
 " option. ",
 Cell[BoxData[
  ButtonBox["BoxOutlierMarkers",
   BaseStyle->"Link",
   ButtonData->"paclet:StatisticalPlots/ref/BoxOutlierMarkers"]], 
  "InlineFormula"],
 " values are specified the same as for ",
 Cell[BoxData[
  ButtonBox["PlotMarkers",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotMarkers"]], "InlineFormula"],
 "."
}], "Text",
 CellID->7783],

Cell["\<\
This draws the box with edges at the .1 and .9 quantiles, and with non\
\[Hyphen]default outlier markers. \
\>", "MathCaption",
 CellID->4394],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BoxWhiskerPlot", "[", 
  RowBox[{
   RowBox[{"Join", "[", 
    RowBox[{"dat", ",", 
     RowBox[{"{", 
      RowBox[{"1.5", ",", "2.5", ",", "3."}], "}"}]}], "]"}], ",", 
   RowBox[{"BoxQuantile", "\[Rule]", "0.4"}], ",", 
   RowBox[{"BoxOutliers", "\[Rule]", "All"}], ",", 
   RowBox[{"BoxOutlierMarkers", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      GraphicsBox[
       PolygonBox[{{0.31361111111111, 0.569141111111111}, {0.0202777777777772,
         0.0358077777777774}, {0.611388888888888, 0.0358077777777774}}],
       ImageSize->{19., 16.},
       PlotRange->{{0, 1}, {0, 0.61803}},
       PlotRegion->{{0., 1.57342657342657}, {0., 1.}}], ",", 
      GraphicsBox[RectangleBox[{0, 0}],
       ImageSize->{11., Automatic}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->25798],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztW89rE0EUnnSbNBgpHkoJmEN6aUoOEgoGUaKeNBdpMBTaW0NR2oMYaqEg
So4BLwUvRdDGH1BbRXtcepAcexHyJ/TYY4891vfeTDLZzW42uwlmk52FTObt
e9+3s29eMm9mZ5+UtjeevShtb66Xko+3SuWNzfVXyUcvt+CUFmIstAGfUpxB
/Yox/rlxBQdUVhkeKDENz9NBX8vwCfWgZRpnalXbLCegGu6OnpQaEPCr88wQ
0WH4fkssFxcXdTrYPBbaycmJkFMkX15eCmTFc/sqJNdqtYd0sHkstEQikU6n
sZoiWdf1vq90SPLa2hpcDKtHlv0ZgapVH9qjzbEyfpZPSYberlarlUqFFbHQ
MpnM0tKSlDkNmhYdmCB4ZmZu3s89Z0UstMXFYvb2qpRjsemzs7NOJiRqMaRS
2Tev/7IjLLTZ2YQlwvLaCqmQLpAq6hRSRZ1CBgE5iKjT9T+5e+8f5D6wIyy0
u3fe+eb+goC0m52gbJXZumA25NdTJp6JEeTFuU7BIx/6cZD+NPOY5y/eImBK
tNI722hFf5CQKkdQSBV1ChkEpIo6hVRR5wIZi00DmBWx0BKJ1NzcLSlHIlPn
5+fdmVCzTOv8+Xx+Z2cHq0WSG41Gm40fVqx5ets8zDMGd+v5ZjQl0x6fLPx/
LpzRHPioPeoJjJ8s0dDP7VOWqheDYql6cRwsVS/2b2mfvZHM+sneIibZrB8c
U4VkSKsNe2Zk7my/Z6aXK8ldOXt7e4a9Mul0OpvNyr0yp6enjldAhzvvVLJC
dZON6F5WoY0Ic8SMh7ap9EdrRlGrPKg8OGxtEDyIk/de1k6MqObozUu3O1Ld
ryIY8R37by3xYXGi6BLX7a47bN2ge1jvGFy/+lcbhF+V8qC/tcqDo+zBjyQ3
Gg0xJ7pOc6BqtSr0B7bITyRnMhnGj2tYaNFoVDxj+e6A1HXdgCyXy0Jvj9wn
uVAoCGSUkPF4XDyNOWwhzWMxnrMaJfab929g3N3dFXrJaBynnXZZ1UiGexK8
EeJNJpN8AtvHPJkzww2DqyXz8fGx0Etm8xhtvvfmvJj7AF9CYC3fUc8Kux+2
jChbefUzyXCr0DWSUT73kozu9nB9IRlm8KKlE8QL8SD0PyVvD7Pnr+SUVgTz
0GW/bKOP7CfB09weOve3re03kvP5PA9O5mQJvuFB18USiyD8J42HVnlQeXDY
2uFnFjDK951ZxLBoGz2ckK1/aNeZBfxfCyTPA2BI6MgsENTLW6vWmYW8/zZG
MxsWXWfDNZJXVlYEN88BYKjpyC68cpvzC/l2ovWug7Alr8wuZCZkn124X8uw
zjPq9XoHt3s/8FwDBmXRbvtcA0F2qxDEEoEWLiwsiDiIRiEoBpllgC95oHrO
MuR73Shs0olB11joH99RYdo=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 353},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->499540]
}, Open  ]],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["BoxOrientation",
   BaseStyle->"Link",
   ButtonData->"paclet:StatisticalPlots/ref/BoxOrientation"]], 
  "InlineFormula"],
 " option allows the graph to be oriented so that the bars run in a \
horizontal rather than a vertical direction. This option takes the value ",
 Cell[BoxData["Vertical"], "InlineFormula"],
 " or ",
 Cell[BoxData["Horizontal"], "InlineFormula"],
 ", depending on the orientation you desire. "
}], "Text",
 CellID->14272],

Cell[TextData[{
 "Labels can be placed for each box via the ",
 Cell[BoxData[
  ButtonBox["BoxLabels",
   BaseStyle->"Link",
   ButtonData->"paclet:StatisticalPlots/ref/BoxLabels"]], "InlineFormula"],
 " option. If this option is ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 ", no label is drawn when a single box is being plotted, but if multiple \
boxes are being drawn, they are numbered sequentially. If a list of labels is \
provided, they are used cyclically for the boxes. "
}], "Text",
 CellID->24431],

Cell[TextData[{
 "You can adjust the spacing between the boxes via the ",
 Cell[BoxData[
  ButtonBox["BoxExtraSpacing",
   BaseStyle->"Link",
   ButtonData->"paclet:StatisticalPlots/ref/BoxExtraSpacing"]], 
  "InlineFormula"],
 " option. A space of 1 is equivalent to the space used for a single box. You \
can provide a list for this option, in which case the additional spaces are \
used cyclically. This is useful when you have multiple groups of boxes to be \
drawn, and you want some space between each group. "
}], "Text",
 CellID->1279],

Cell[TextData[{
 "The styles used to draw the boxes are determined by the ",
 Cell[BoxData[
  ButtonBox["BoxFillingStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:StatisticalPlots/ref/BoxFillingStyle"]], 
  "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["BoxLineStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:StatisticalPlots/ref/BoxLineStyle"]], 
  "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["BoxMedianStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:StatisticalPlots/ref/BoxMedianStyle"]], 
  "InlineFormula"],
 " options. The ",
 Cell[BoxData[
  ButtonBox["BoxFillingStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:StatisticalPlots/ref/BoxFillingStyle"]], 
  "InlineFormula"],
 " option should be a color or list of colors to be used cyclically among the \
boxes. The style for the lines around the boxes is determined by the ",
 Cell[BoxData[
  ButtonBox["BoxLineStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:StatisticalPlots/ref/BoxLineStyle"]], 
  "InlineFormula"],
 " option; this may also take a list of styles to be used cyclically. \
Finally, the median line is often drawn somewhat differently than the rest of \
the lines; you can specify additional style options for the median line via \
the ",
 Cell[BoxData[
  ButtonBox["BoxMedianStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:StatisticalPlots/ref/BoxMedianStyle"]], 
  "InlineFormula"],
 " option. "
}], "Text",
 CellID->1895],

Cell["\<\
This example mixes multiple data sets in a single plot, and applies a variety \
of options to control the final appearance. \
\>", "MathCaption",
 CellID->3097],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BoxWhiskerPlot", "[", 
  RowBox[{"dat", ",", "datm", ",", 
   RowBox[{"BoxOrientation", "\[Rule]", "Horizontal"}], ",", 
   RowBox[{"BoxLabels", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<a\>\"", ",", "\"\<b\>\""}], "}"}]}], ",", 
   RowBox[{"BoxExtraSpacing", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0.5"}], "}"}]}], ",", 
   RowBox[{"BoxFillingStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Hue", "[", "0", "]"}], ",", 
      RowBox[{"Hue", "[", "0.5", "]"}]}], "}"}]}], ",", 
   RowBox[{"BoxMedianStyle", "\[Rule]", 
    RowBox[{"Dashing", "[", 
     RowBox[{"{", "0.05", "}"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->27319],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnT1s4kgUxyc2EG5BJ8JykNOhi/c+RC67p0PJFdtBmr1qT6SIdouTSLQ6
LVucgva2t1JRpHCVmhLpisu1SCu53JKSdJSUlJS598bma2xgTDA47LOSwW/m
79+fMR57xvGQl+cfKn/+df7h3Ztz7bf359XKuzd/ay8u3kOWusUY+8jY1n+7
DNbvIOK/H+/u4HU8DUOqQJGKkYoavjDM23UpYxjDb2a8LDzczla4bTmgZuY4
YpbiUhbibJ6GRiVuOWlHTliogVMRERy/kvCR0ewKXNWhUO9RL7l3HXLdNoj1
2RboKXfK2CeZWaheg6P+6zXXZvA+3GuhSn5u/n4msu3LvR7jLe9Osl3J1mfg
GrFfd6fE4ueQHstX7PrM4lhnHue5czz9AtJ/B/Xl0fhRKr4Dsd2Keyno5av0
Y7RXV7pXnwhb7c2Jv51Rvk4XXP1HiFVSkSqgql94XK/XmbX8jgnGdnnOA0XX
dQY/sPqS8XIdFyzaXyPlKcPrab2uLZGm60Qj2tJoo14mLAo0vmcCU2wJP2AS
brfblUrFxk1ejSaJsJUc0TTNYrFIRCLOJlrHeKcjHuOzyHh3RRlEkg7OVjTL
YfAyyg+t2OuIXz3Zq1dIgp+DSfLbt/ZV9ke+QTabHW6+hhqE7JAN8/zxUYd1
ssYGvrgMR9y+0L20Cv/I3trb5pxtAkc0DEOO2Gq1SqWSK/GB9J6X2QffmP4a
0QJJg2YZ1bREscieQqLAOg9UWKnVavK0PCQ/w8lAaTQaT+CVqf1+3y6TGw8H
dbRPKlKRilSk+jxUezyu1+v8eqqzE0xUuBhaFzT2qweKlkpVGdMh+wQTNRGJ
dDqdBSgdxh8LOeFjQy0evxcli2M/WD9aHk0nGtH8oVl/C4XGBz1LXM240V2O
5n1hO5E7yw0Q0BF2cxNb4L6gJxdy2WQXTDFTfCZwntu0c4Cc6/hThpBOPFvm
vzumyizXZDKJnYQM7ykkYzFX19T29sXFBUr2uQ6CVCrlrc7h4Z4HV9h65JqC
Orm5pqNR0TWdTs+uqyN3ZXva6zFMbkt1q6/KLchnOHK5r4v1NNvNzY0dp+e4
/CToo1Iue3Ooax9hmcHoPxNtg2n23YUsJEoBaBgseJdhdMcjC4lSLpePeI/B
MAxbJ0cL6n0dUpGKVKQiFalIRSpSkYpUpNo8FX+OUn1RKjFr+QMTNZZI9Hq9
UbkcJV8sMtOEPKBgHNc0e2y5Tsohp7DXr1m3i6u5ZVI1jXU6RCVqIKijb+ww
DAPnHH4nsMUW9Q0v13XduqHqmFvs/o7xiW858tnZmTXVkchE9oFstxXDYL2e
W1uRc5qYOSXnOLV1yjlOmYe0Ru8cv+6HIxHWbE73Cj16ZPcTslx/eXlpY8R9
F4B6OudfrcZXHdbZofDP1e0bUfxz89A2V+f06RPr9/11eojnyMCToa8iR65W
q576KUEelSx1bBOcHihRieqgHpdK8Xwep4od8vliSjT65fPnuJqz5o8lEt1u
1yu11+uZfGGHfA7Z9fV1s9nE1RyP2+32hH4eNah3aEhFKlKRilSfh8r65gO4
upWOj4v5PDvFRIXAviP/vQcKXAjz8bgJ2aeYqBiY5gKUYiKBY9pTPr6F4F6U
x5yiM3y4DVcLS6QyohI1ONTRHXnoN2O39MCVbU5lW09dNxoNe0ap+F5dvWD8
DaNwh5fYeu0nuod9emITO5hsTDFTlfKY117lPF3nka3IG1PF6Xl1dZWHzsAB
f9a6XC4/i8Wme0IhSEazvnZ2dm5vb73VF62HbtB5mO4GhRNuyWRybg0duSva
u3JHKnkty6u4Eq/gnbWIPZcNY5pWqyXJtoI5bN9HL8scA01vGRvS/yXqQ6dq
0aiOVN2m6tYssgKPoXABKgxlarUadhMe875CoVCwZ5MVhO/PkaMG9U4OqUgV
ZNXoP9uwrf8BW6DmhQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{188, 432},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->162389815]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Pareto Plots", "Section",
 CellID->1273],

Cell["\<\
The Pareto plot is a quality control plot that combines a bar chart \
displaying percentages of categories in the data with a line plot showing \
cumulative percentages of the categories. \
\>", "Text",
 CellID->2850],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["ParetoPlot",
      BaseStyle->"Link",
      ButtonData->"paclet:StatisticalPlots/ref/ParetoPlot"], "[", 
     StyleBox["list", "TI"], "]"}], Cell[TextData[{
     "find frequencies of data in ",
     StyleBox["list", "TI"],
     " and create a Pareto plot"
    }], "TableText",
     GridBoxOptions->{
     GridBoxDividers->{
      "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
       "RowsIndexed" -> {}}}]},
   {
    RowBox[{
     RowBox[{
      ButtonBox["ParetoPlot",
       BaseStyle->"Link",
       ButtonData->"paclet:StatisticalPlots/ref/ParetoPlot"], "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["cat", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["freq", "TI"], 
           StyleBox["1", "TR"]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["cat", "TI"], 
           StyleBox["2", "TR"]], ",", 
          SubscriptBox[
           StyleBox["freq", "TI"], 
           StyleBox["2", "TR"]]}], "}"}], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}], " "}], Cell[TextData[{
     "create a Pareto plot from the categories ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["cat", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " with given frequencies ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["freq", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->1614],

Cell["Pareto plots. ", "Caption",
 CellID->15044],

Cell[TextData[{
 "In the most basic form, ",
 Cell[BoxData[
  ButtonBox["ParetoPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:StatisticalPlots/ref/ParetoPlot"]], "InlineFormula"],
 " takes a list of data that is assumed to consist of discrete categories. It \
determines the frequency of each category in the list, converts the \
frequencies to percentages, and creates the plot. "
}], "Text",
 CellID->32417],

Cell["Create a Pareto plot from a list.", "MathCaption",
 CellID->21951],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParetoPlot", "[", 
  RowBox[{"{", 
   RowBox[{
   "a", ",", "b", ",", "c", ",", "d", ",", "d", ",", "d", ",", "e", ",", "d", 
    ",", "e", ",", "e", ",", "f", ",", "a", ",", "b", ",", "c"}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->21754],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 225},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->351455888]
}, Open  ]],

Cell[TextData[{
 "If you have data where the frequencies are precomputed, you can plot it \
directly by providing ",
 StyleBox["{", "MR"],
 StyleBox["category", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["frequency", "TI"],
 StyleBox["}", "MR"],
 " pairs instead of the raw data to ",
 Cell[BoxData[
  ButtonBox["ParetoPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:StatisticalPlots/ref/ParetoPlot"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->24493],

Cell["\<\
The data quantities have been precomputed for this Pareto plot. \
\>", "MathCaption",
 CellID->21415],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParetoPlot", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<Oats\>\"", ",", "34.3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\"\<Wheat\>\"", ",", "72.1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\"\<Rye\>\"", ",", "10.2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\"\<Soy\>\"", ",", "68.2"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->1607],

Cell[BoxData[
 GraphicsBox[{{
    {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
     RectangleBox[{0.615, 0}, {1.385, 0.3901515151515151}]}, 
    {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
     RectangleBox[{1.615, 0}, {2.385, 0.36904761904761907`}]}, 
    {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
     RectangleBox[{2.615, 0}, {3.385, 0.18560606060606058`}]}, 
    {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
     RectangleBox[{3.615, 0}, {4.385, 0.055194805194805185`}]}}, {{{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{{1., 0.3901515151515151}, {2., 0.7591991341991342}, {3., 
       0.9448051948051948}, {4., 1.}}]}}, {
     {Hue[0.67, 0.6, 0.6], InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], {1., 0.3901515151515151}], InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], {2., 0.7591991341991342}], InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], {3., 0.9448051948051948}], InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], {4., 1.}]}, {}}}},
  AlignmentPoint->Center,
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->None,
  AxesOrigin->{0.4, 0},
  AxesStyle->{},
  Background->None,
  BaseStyle->{},
  BaselinePosition->Automatic,
  ColorOutput->Automatic,
  ContentSelectable->Automatic,
  DefaultAxesStyle->"GraphicsAxes",
  DefaultBaseStyle->"Graphics",
  DefaultFrameStyle->"GraphicsFrame",
  DefaultLabelStyle->"GraphicsLabel",
  DisplayFunction:>$DisplayFunction,
  Epilog->{},
  FormatType:>TraditionalForm,
  Frame->False,
  FrameLabel->None,
  FrameStyle->{},
  FrameTicks->{{{1, 
      FormBox["\"Wheat\"", TraditionalForm], 0}, {2, 
      FormBox["\"Soy\"", TraditionalForm], 0}, {3, 
      FormBox["\"Oats\"", TraditionalForm], 0}, {4, 
      FormBox["\"Rye\"", TraditionalForm], 0}}, Automatic},
  FrameTicksStyle->{},
  GridLines->None,
  GridLinesStyle->{},
  ImageMargins->0.,
  ImagePadding->All,
  ImageSize->Automatic,
  LabelStyle->{},
  Method->Automatic,
  PlotLabel->None,
  PlotRange->{{0.4, 4.6}, All},
  PlotRangeClipping->False,
  PlotRangePadding->Automatic,
  PlotRegion->Automatic,
  Prolog->{},
  RotateLabel->True,
  Ticks->{{{1, 
      FormBox["\"Wheat\"", TraditionalForm], 0}, {2, 
      FormBox["\"Soy\"", TraditionalForm], 0}, {3, 
      FormBox["\"Oats\"", TraditionalForm], 0}, {4, 
      FormBox["\"Rye\"", TraditionalForm], 0}}, Automatic},
  TicksStyle->{}]], "Output",
 ImageSize->{364, 225},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->205880398]
}, Open  ]],

Cell[BoxData[GridBox[{
   {Cell["option name ", "TableHeader"], Cell[
    "default value ", "TableHeader"], " "},
   {
    RowBox[{
     ButtonBox["BarOrientation",
      BaseStyle->"Link",
      ButtonData->"paclet:BarCharts/ref/BarOrientation"], " "}], 
    RowBox[{"Vertical", " "}], Cell["orientation of the plot", "TableText"]},
   {
    RowBox[{
     ButtonBox["BarStyle",
      BaseStyle->"Link",
      ButtonData->"paclet:BarCharts/ref/BarStyle"], " "}], 
    RowBox[{
     ButtonBox["Automatic",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Automatic"], " "}], Cell[
    "color for the bars", "TableText"]},
   {
    RowBox[{
     ButtonBox["BarLabels",
      BaseStyle->"Link",
      ButtonData->"paclet:BarCharts/ref/BarLabels"], " "}], 
    RowBox[{
     ButtonBox["Automatic",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Automatic"], " "}], Cell[
    "labels for the bars", "TableText"]},
   {
    RowBox[{
     ButtonBox["BarEdges",
      BaseStyle->"Link",
      ButtonData->"paclet:BarCharts/ref/BarEdges"], " "}], 
    RowBox[{
     ButtonBox["True",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/True"], " "}], Cell[
    "whether to draw borders on the bars", "TableText"]},
   {
    RowBox[{
     ButtonBox["BarEdgeStyle",
      BaseStyle->"Link",
      ButtonData->"paclet:BarCharts/ref/BarEdgeStyle"], " "}], 
    RowBox[{
     RowBox[{
      ButtonBox["Opacity",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Opacity"], "[", "0.5", "]"}], " "}], Cell[
    "style for the bar edges", "TableText"]},
   {
    RowBox[{
     ButtonBox["Joined",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Joined"], " "}], 
    RowBox[{
     ButtonBox["True",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/True"], " "}], Cell[
    "whether data points should be joined into a line", "TableText"]},
   {
    RowBox[{
     ButtonBox["PlotStyle",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PlotStyle"], " "}], 
    RowBox[{
     ButtonBox["Automatic",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Automatic"], " "}], Cell[
    "style for the line", "TableText"]},
   {
    RowBox[{
     ButtonBox["PlotMarkers",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PlotMarkers"], " "}], 
    RowBox[{
     ButtonBox["Automatic",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Automatic"], " "}], Cell[
    "markers for the points", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, False, False, False, False, False, {False}, False},
    "RowsIndexed" -> {}}},
 CellID->5393],

Cell[TextData[{
 "Options for ",
 Cell[BoxData[
  ButtonBox["ParetoPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:StatisticalPlots/ref/ParetoPlot"]], "InlineFormula"],
 ". "
}], "Caption",
 CellID->17745],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ParetoPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:StatisticalPlots/ref/ParetoPlot"]], "InlineFormula"],
 " accepts a number of options common to bar charts and line plots, as \
detailed in the above table. It also accepts the usual ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 " options. "
}], "Text",
 CellID->17459],

Cell[TextData[{
 "The various ",
 Cell[BoxData["Bar"], "InlineFormula"],
 " options are drawn from ",
 Cell[BoxData[
  ButtonBox["BarChart",
   BaseStyle->"Link",
   ButtonData->"paclet:BarCharts/ref/BarChart"]], "InlineFormula"],
 ". Most of these behave the same as their ",
 Cell[BoxData[
  ButtonBox["BarChart",
   BaseStyle->"Link",
   ButtonData->"paclet:BarCharts/ref/BarChart"]], "InlineFormula"],
 " counterparts. Note that unless the ",
 Cell[BoxData[
  ButtonBox["BarLabels",
   BaseStyle->"Link",
   ButtonData->"paclet:BarCharts/ref/BarLabels"]], "InlineFormula"],
 " option is set to ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 ", it will simply apply the labels cyclically to the bars in the order they \
appear; they only correspond to the categories in the ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " case. The ",
 Cell[BoxData[
  ButtonBox["BarOrientation",
   BaseStyle->"Link",
   ButtonData->"paclet:BarCharts/ref/BarOrientation"]], "InlineFormula"],
 " option applies to the entire plot, not just the bars. "
}], "Text",
 CellID->14363],

Cell["\<\
This is a Pareto plot with various options controlling the appearance. \
\>", "MathCaption",
 CellID->14922],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParetoPlot", "[", 
  RowBox[{
   RowBox[{"RandomInteger", "[", 
    RowBox[{"10", ",", "50"}], "]"}], ",", 
   RowBox[{"BarLabels", "\[Rule]", "None"}], ",", 
   RowBox[{"BarOrientation", "\[Rule]", "Horizontal"}], ",", 
   RowBox[{"BarStyle", "\[Rule]", 
    RowBox[{"GrayLevel", "[", "1", "]"}]}], ",", 
   RowBox[{"BarEdgeStyle", "\[Rule]", 
    RowBox[{"Dashing", "[", 
     RowBox[{"{", "0.02", "}"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->32620],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 238},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->94860313]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Quantile\[Hyphen]Quantile Plots", "Section",
 CellID->1947],

Cell["\<\
Quantile\[Hyphen]quantile plots are used to determine whether two data sets \
come from populations with a common distribution. If the points of the plot, \
which are formed from the quantiles of the data, are roughly on a line with a \
slope of 1, then the distributions are the same. \
\>", "Text",
 CellID->6104],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["QuantilePlot",
      BaseStyle->"Link",
      ButtonData->"paclet:StatisticalPlots/ref/QuantilePlot"], "[", 
     SubscriptBox[
      StyleBox["list", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["list", "TI"], 
      StyleBox["2", "TR"]], "]"}], Cell["\<\
create a quantile\[Hyphen]quantile plot from the lists of data\
\>", "TableText"]}
  }]], "DefinitionBox",
 CellID->26801],

Cell["Quantile\[Hyphen]quantile plots. ", "Caption",
 CellID->9962],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["QuantilePlot",
   BaseStyle->"Link",
   ButtonData->"paclet:StatisticalPlots/ref/QuantilePlot"]], 
  "InlineFormula"],
 " first sorts the shorter of the two lists of numbers and then determines \
the interpolated quantiles at the equivalent position in the longer list of \
data. It then plots the two sets of quantiles against each other. For data \
sets of equal length, this is equivalent to plotting the sorted lists against \
each other. The plot also displays a reference line with a slope of 1. "
}], "Text",
 CellID->31139],

Cell["\<\
Points for identically distributed lists fall roughly along the reference \
line. \
\>", "MathCaption",
 CellID->14908],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"QuantilePlot", "[", 
  RowBox[{
   RowBox[{"RandomReal", "[", 
    RowBox[{"1", ",", "300"}], "]"}], ",", 
   RowBox[{"RandomReal", "[", 
    RowBox[{"1", ",", "300"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->27472],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 359},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->46592044]
}, Open  ]],

Cell[BoxData[GridBox[{
   {Cell["option name ", "TableHeader"], Cell[
    "default value ", "TableHeader"], " "},
   {
    RowBox[{
     ButtonBox["ReferenceLineStyle",
      BaseStyle->"Link",
      ButtonData->"paclet:StatisticalPlots/ref/ReferenceLineStyle"], " "}], 
    RowBox[{
     ButtonBox["Automatic",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Automatic"], " "}], Cell[
    "style for the reference line", "TableText"]},
   {
    RowBox[{
     ButtonBox["Joined",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Joined"], " "}], 
    RowBox[{
     ButtonBox["False",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/False"], " "}], Cell[
    "whether data points should be joined into a line", "TableText"]},
   {
    RowBox[{
     ButtonBox["PlotStyle",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PlotStyle"], " "}], 
    RowBox[{
     ButtonBox["Automatic",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Automatic"], " "}], Cell[
    "style for the line", "TableText"]},
   {
    RowBox[{
     ButtonBox["PlotMarkers",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PlotMarkers"], " "}], 
    RowBox[{
     ButtonBox["Automatic",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Automatic"], " "}], Cell[
    "markers for the points", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellID->19253],

Cell[TextData[{
 "Options for ",
 Cell[BoxData[
  ButtonBox["QuantilePlot",
   BaseStyle->"Link",
   ButtonData->"paclet:StatisticalPlots/ref/QuantilePlot"]], 
  "InlineFormula"],
 ". "
}], "Caption",
 CellID->3872],

Cell[TextData[{
 "Typical list plot operations are available to control the display. The \
option ",
 Cell[BoxData[
  ButtonBox["ReferenceLineStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:StatisticalPlots/ref/ReferenceLineStyle"]], 
  "InlineFormula"],
 ", which can modify the reference line, can also be used. If it is set to ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 ", the reference line is not drawn; otherwise it should be set to a style or \
list of styles."
}], "Text",
 CellID->29323],

Cell["\<\
Generate a quantile\[Hyphen]quantile plot with a modified appearance. \
\>", "MathCaption",
 CellID->22645],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"QuantilePlot", "[", 
  RowBox[{
   RowBox[{"RandomReal", "[", 
    RowBox[{"1", ",", "300"}], "]"}], ",", 
   RowBox[{"RandomReal", "[", 
    RowBox[{"1", ",", "300"}], "]"}], ",", 
   RowBox[{"PlotMarkers", "\[Rule]", "None"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}], ",", 
   RowBox[{"ReferenceLineStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Hue", "[", "0", "]"}], ",", 
      RowBox[{"Dashing", "[", 
       RowBox[{"{", "0.02", "}"}], "]"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[12]:=",
 CellID->23841],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 368},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]=",
 CellID->820152008]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Pairwise Scatter Plots", "Section",
 CellID->4051],

Cell["\<\
The pairs or matrix scatter plot allows the individual columns in a \
multivariate set of data to be plotted against each other. This can be used \
to investigate relationships between the variables. The resulting plot is a \
matrix of subgraphs. \
\>", "Text",
 CellID->13961],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["PairwiseScatterPlot",
      BaseStyle->"Link",
      ButtonData->"paclet:StatisticalPlots/ref/PairwiseScatterPlot"], "[", 
     StyleBox["matrix", "TI"], "]"}], Cell["\<\
plot the columns of the matrix against each other in a pairwise fashion\
\>", "TableText"]}
  }]], "DefinitionBox",
 CellID->16742],

Cell["A pairwise scatter plot. ", "Caption",
 CellID->11783],

Cell[TextData[{
 "The pairs scatter plot forms a matrix of scatter plots from the columns of \
a multivariate data set plotted against each other. ",
 Cell[BoxData[
  ButtonBox["PairwiseScatterPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:StatisticalPlots/ref/PairwiseScatterPlot"]], 
  "InlineFormula"],
 " by default places the first column at the lower left side of the plot, and \
proceeds to the right and upwards. "
}], "Text",
 CellID->25062],

Cell["Generate data for the examples. ", "MathCaption",
 CellID->13488],

Cell[BoxData[
 RowBox[{
  RowBox[{"dat", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"Sin", "[", "x", "]"}], ",", 
       RowBox[{"Cos", "[", "x", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"2", " ", "\[Pi]"}], ",", "0.1"}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[13]:=",
 CellID->7696],

Cell["Plot the columns of the data against each other. ", "MathCaption",
 CellID->30185],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PairwiseScatterPlot", "[", "dat", "]"}]], "Input",
 CellLabel->"In[14]:=",
 CellID->18144],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 359},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]=",
 CellID->9756616]
}, Open  ]],

Cell[BoxData[GridBox[{
   {Cell["option name ", "TableHeader"], Cell[
    "default value ", "TableHeader"], " "},
   {
    RowBox[{
     ButtonBox["DataRanges",
      BaseStyle->"Link",
      ButtonData->"paclet:StatisticalPlots/ref/DataRanges"], " "}], 
    RowBox[{
     ButtonBox["All",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/All"], " "}], Cell[
    "range limits on the data", "TableText"]},
   {
    RowBox[{
     ButtonBox["DataLabels",
      BaseStyle->"Link",
      ButtonData->"paclet:StatisticalPlots/ref/DataLabels"], " "}], 
    RowBox[{
     ButtonBox["None",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/None"], " "}], Cell[
    "labels for the columns", "TableText"]},
   {
    RowBox[{
     ButtonBox["DataTicks",
      BaseStyle->"Link",
      ButtonData->"paclet:StatisticalPlots/ref/DataTicks"], " "}], 
    RowBox[{
     ButtonBox["None",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/None"], " "}], Cell[
    "tick specifications for the columns", "TableText"]},
   {
    RowBox[{
     ButtonBox["DataSpacing",
      BaseStyle->"Link",
      ButtonData->"paclet:StatisticalPlots/ref/DataSpacing"], " "}], 
    RowBox[{"0", " "}], Cell[
    "space to place between subgraphs", "TableText"]},
   {
    RowBox[{
     ButtonBox["PlotDirection",
      BaseStyle->"Link",
      ButtonData->"paclet:StatisticalPlots/ref/PlotDirection"], " "}], 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       ButtonBox["Right",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Right"], ",", " ", "Down"}], "}"}], " "}], 
    Cell["direction in which scatter plots are generated", "TableText"]},
   {
    RowBox[{
     ButtonBox["PlotStyle",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PlotStyle"], " "}], 
    RowBox[{
     ButtonBox["Automatic",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Automatic"], " "}], Cell[
    "styles for the subgraphs", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellID->3316],

Cell[TextData[{
 "Options specific to ",
 Cell[BoxData[
  ButtonBox["PairwiseScatterPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:StatisticalPlots/ref/PairwiseScatterPlot"]], 
  "InlineFormula"],
 ". "
}], "Caption",
 CellID->22740],

Cell[TextData[{
 "A variety of options can be used to control the appearance of the plot. The \
",
 Cell[BoxData[
  ButtonBox["DataRanges",
   BaseStyle->"Link",
   ButtonData->"paclet:StatisticalPlots/ref/DataRanges"]], "InlineFormula"],
 " option accepts a list of range specifications, which can be used to \
restrict the points to be plotted. The ranges are given as ",
 StyleBox["{", "MR"],
 StyleBox["min", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["max", "TI"],
 StyleBox["}", "MR"],
 " pairs or ",
 Cell[BoxData[
  ButtonBox["All",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/All"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 ", used cyclically for all of the columns. "
}], "Text",
 CellID->13125],

Cell[TextData[{
 "Textual annotations are provided via ",
 Cell[BoxData[
  ButtonBox["DataLabels",
   BaseStyle->"Link",
   ButtonData->"paclet:StatisticalPlots/ref/DataLabels"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["DataTicks",
   BaseStyle->"Link",
   ButtonData->"paclet:StatisticalPlots/ref/DataTicks"]], "InlineFormula"],
 ". Labels can be supplied for each column via the ",
 Cell[BoxData[
  ButtonBox["DataLabels",
   BaseStyle->"Link",
   ButtonData->"paclet:StatisticalPlots/ref/DataLabels"]], "InlineFormula"],
 " option, given as a list of labels. Ticks can be specified for each column \
using the usual graphics ticks syntax; these are drawn at the top and bottom \
of the corresponding column of the matrix of plots, as well as the right and \
left sides of the corresponding row. Tick labels are only drawn on \
alternating sides for each column to prevent labels for adjacent columns from \
overriding. "
}], "Text",
 CellID->7348],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["PlotDirection",
   BaseStyle->"Link",
   ButtonData->"paclet:StatisticalPlots/ref/PlotDirection"]], 
  "InlineFormula"],
 " option specifies the order in which plots are generated in the plot \
matrix. With the default ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    ButtonBox["Right",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Right"], ",", " ", "Down"}], "}"}]], 
  "InlineFormula"],
 ", row ",
 StyleBox["i",
  FontSlant->"Italic"],
 " and column ",
 StyleBox["j",
  FontSlant->"Italic"],
 " of the data are plotted in the ",
 StyleBox["i",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 "\[VeryThinSpace] row and ",
 StyleBox["j",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " column of the grid of scatter plots. The ordering used in versions prior \
to version 6.0 can be obtained by setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PlotDirection",
    BaseStyle->"Link",
    ButtonData->"paclet:StatisticalPlots/ref/PlotDirection"], "->", 
   RowBox[{"{", 
    RowBox[{
     ButtonBox["Right",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Right"], ",", " ", "Up"}], "}"}]}]], 
  "InlineFormula"],
 "."
}], "Text",
 CellID->7510],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["PlotStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotStyle"]], "InlineFormula"],
 " option can take either a single style primitive or a matrix of style \
primitives. If given a matrix, the primitives are applied to the subplots in \
a cyclic fashion. "
}], "Text",
 CellID->12049],

Cell[TextData[{
 "Finally, the ",
 Cell[BoxData[
  ButtonBox["DataSpacing",
   BaseStyle->"Link",
   ButtonData->"paclet:StatisticalPlots/ref/DataSpacing"]], "InlineFormula"],
 " option allows the subgraphs to be drawn with varying amounts of space \
between them. This takes a number or a pair of numbers corresponding to the \
horizontal and vertical space between each graph. This number is scaled to \
the size of one of the subgraphs, which range from 0 to 1. You may provide \
negative numbers for the spacing, which can cause the subgraphs to be \
arranged in a different order. For example, if you prefer the first column to \
be at the upper rather than lower left, you can supply the option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DataSpacing",
    BaseStyle->"Link",
    ButtonData->"paclet:StatisticalPlots/ref/DataSpacing"], " ", "->", " ", 
   RowBox[{"{", 
    RowBox[{"0", ",", " ", 
     RowBox[{"-", "2"}]}], "}"}]}]], "InlineFormula"],
 ". An interesting effect can be derived by setting this option to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "1"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 ", where all the subgraphs are overlaid. "
}], "Text",
 CellID->8110],

Cell[TextData[{
 "In addition, all of the usual ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 " options are accepted. "
}], "Text",
 CellID->31323],

Cell["Generate the plot with options controlling its appearance. ", \
"MathCaption",
 CellID->19192],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PairwiseScatterPlot", "[", 
  RowBox[{"dat", ",", 
   RowBox[{"DataSpacing", "\[Rule]", "0.1"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Hue", "[", "0", "]"}], ",", 
        RowBox[{"Hue", "[", "0.7", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Hue", "[", "0.4", "]"}], ",", 
        RowBox[{"Hue", "[", "0.9", "]"}]}], "}"}]}], "}"}]}], ",", 
   RowBox[{"DataRanges", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"All", ",", "All", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.75"}], ",", "1"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"DataLabels", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<Line\>\"", ",", "\"\<Sin\>\"", ",", "\"\<Cos\>\""}], 
     "}"}]}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", "0.5"}]}], "]"}]], "Input",
 CellLabel->"In[15]:=",
 CellID->17572],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 181},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]=",
 CellID->99766684]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Stem\[Hyphen]and\[Hyphen]Leaf Plots", "Section",
 CellID->5019],

Cell["\<\
The stem-and-leaf plot is generally used to visualize the distribution of \
real\[Hyphen]valued data along with the magnitudes of the individual data \
values. Each data value is represented by a stem and leaf, where the stem is \
an integer multiple of a base unit and the leaf is the remainder given to \
some predetermined number of digits. With a base unit of 10, for instance, \
17.3 could be represented as a stem of 1 and a leaf of 7. Leaves are \
collected onto common stems giving a display analogous to a histogram. The \
stems play a role similar to histogram bar positions, and the leaves are \
similar to the histogram bar heights. An advantage of the stem\[Hyphen]and\
\[Hyphen]leaf plot is that individual data values can be read directly from \
the plot. Side\[Hyphen]by\[Hyphen]side stem\[Hyphen]and\[Hyphen]leaf plots \
can be used to compare distributions and magnitudes of two data sets.\
\>", "Text",
 CellID->10270],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["StemLeafPlot",
      BaseStyle->"Link",
      ButtonData->"paclet:StatisticalPlots/ref/StemLeafPlot"], "[", 
     StyleBox["vector", "TI"], "]"}], Cell["\<\
create a stem\[Hyphen]and\[Hyphen]leaf plot of a vector of data\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["StemLeafPlot",
      BaseStyle->"Link",
      ButtonData->"paclet:StatisticalPlots/ref/StemLeafPlot"], "[", 
     SubscriptBox[
      StyleBox["vector", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["vector", "TI"], 
      StyleBox["2", "TR"]], "]"}], Cell["\<\
create a side\[Hyphen]by\[Hyphen]side stem\[Hyphen]and\[Hyphen]leaf plot of \
two vectors of data\
\>", "TableText"]}
  }]], "DefinitionBox",
 CellID->22389],

Cell["Stem\[Hyphen]and\[Hyphen]leaf plots.", "Caption",
 CellID->18110],

Cell["Here is a vector of real values. ", "MathCaption",
 CellID->29990],

Cell[BoxData[
 RowBox[{
  RowBox[{"sldata", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3.2", ",", "3.1", ",", "4.556", ",", "5.7345"}], 
    "}"}]}], ";"}]], "Input",
 CellLabel->"In[16]:=",
 CellID->22679],

Cell["\<\
This is a basic stem\[Hyphen]and\[Hyphen]leaf plot of the data. \
\>", "MathCaption",
 CellID->30712],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StemLeafPlot", "[", "sldata", "]"}]], "Input",
 CellLabel->"In[17]:=",
 CellID->15275],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWEtLxDAQziZpdRVBEHQVwcXHQVe9+Rf05M2beFhEcA+irP7/mmyTdvo5
adJdXRQstEkm88rMZJLp7fjj+ell/DF5HA9vpuO358nj+/D6dWpAqieEuDfv
w0CYfmF6s/e+KExLv0KVjf1K02amoxxYi3rePpl5+2YoAa6EIxT+sX2LrR03
6bhpR71uWjvfa+ggHOaMtPBPJUw5xubJCVYN7RMsvx6enwbMGf8VwKKyNZ2z
fDeAQ7mSjJWWAa4Oa/+FtoP+ZLwC482O2mYg+We09NGxxWon3SzLpVWDFG2r
2KDxEtGXl6yKtoig+8tbVhX1rlCiibNKdJOVEf2mkoRaE246roeuZBA+FO8S
xntBr0jQ+QIwD6gE8TXnpH+PgPNVC3TH2QWzAO6F0Qx7m/XlahItWiaHMXI5
W4AqtKowNoUiFY5Pk6j4PDGqaDVjOR/roxaP/QborrMvejp38PMk37VZyEZa
zkiI0cSjM+YXcmoFqHW1wgGZDcoi44skKrTTeWVzGdht6g/ETGhP0pPTtscd
fInRwZ+oJcdYNCIvzPQnc3HBc7jUZeB8Gcu6GD9Hc+mA84c/ZOGQh3O3Wn9L
Li35G2KSh1rLZIF9WWe3Acx2yTP/tOm0Nqps9Ky1eqOLf+/8ubLkuOpaNXLZ
AO+ufoyZS4u6fuw3pAuxWL3InlaNMxMrAp0kjatzAvlpoYpxWfqzcuaqHmP3
AxoHWoS8K4tmHVVGxXfUiyn6pVa/i0PLCJmngmxbg6+6NfKoK03RtKaudYlW
kVhL8DdArorcB0yfU8qbpvtb1fsE/0+wGw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{91, 93},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[17]=",
 CellID->831126603]
}, Open  ]],

Cell["\<\
For this vector, multiples of 1 are taken as the stems and the fractional \
parts rounded to one digit are displayed as the leaves. The values 3.1 and \
3.2 are displayed on the common stem 3 as leaves 1 and 2.\
\>", "Text",
 CellID->29682],

Cell["Here is a second vector of real values. ", "MathCaption",
 CellID->18232],

Cell[BoxData[
 RowBox[{
  RowBox[{"sldata2", "=", 
   RowBox[{"{", 
    RowBox[{
    "3.7", ",", "3.4", ",", "2.1", ",", "4.1", ",", "3.8", ",", "2.6"}], 
    "}"}]}], ";"}]], "Input",
 CellLabel->"In[18]:=",
 CellID->10801],

Cell["\<\
The two data sets can be compared in a side\[Hyphen]by\[Hyphen]side stem\
\[Hyphen]and\[Hyphen]leaf plot.\
\>", "MathCaption",
 CellID->11544],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StemLeafPlot", "[", 
  RowBox[{"sldata", ",", "sldata2"}], "]"}]], "Input",
 CellLabel->"In[19]:=",
 CellID->6755],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWdtu1DAQzSZOugWhlhYoQrRdpG7hgSKB+AZ44iNWFVL7UIFKP6P/HDyO
vZmcjGMn2RsSkXLxeDw+Hs9MxvaPxcPNz7vFw+31Yvb9fvH75vb6z+zbr3tN
yiZJkjzq++51or9L/WXux7LUb/5MsupFz1S/c/2RWbJK6nq6cn3v62IK9Cyx
DRN30TdxKysttdKUbf1Uv6n+SwNDYjlN09Jdy84yK1hfBeOqqfuMy41HlqeA
08jfAy7et+J1JPcZSKhGkou95cCr/OhbbXvgZ+U9KB/2RJtDz+tB6azjWESX
2lpRSieCGLRL2+D2EsAr95yVXRbB/ctpNitrr8iSJs+UYUuXSnROlbLWiklT
YRxq2QeTw/k+QfmNd1ZSwHwFnOeW52uJ0WbY8zPIfy8hj+S6BOoUyodWuy8G
tT4QLQTtu5KF+NBnsdXzLUrp1soHoBZCa16WpVyIupPmJ05W7mmtvDOySjv7
t7nmZTXf+Ec9svQjoLvIdtFjJkOWiTbYRzb5YSHgHCsz7Nv+HpSgT2PNdW7R
Sx6nPunQZTzKOVAR7TCpFDMzQZ80N6kgpbB0E2t31kM2z3Va1nmZL7ZJMXpa
1hk9ZjNUPFlKD2dww3yilZdL5ZaUV+Z9BryYS/eNKtS+cCPrXGfQp9GlyWda
+ftIDJ5VQiSiGVCRCxERglSwDfOnbsQf1K/LUSsreSfUjtEEjxg02jYeefzr
tFbEJFtnyGazpF7tYnTu8lSX+/N1QqX7XY1L2+c6sPrCmcT11pm3df//ujz/
p2IPoZx1jGz0qFXixuwplE25XR5Zz33zPYwt56LUYbOHUUVG7PNTl6EUtl7W
3q56y/ZWDz4/7bP+C9n7f1nbluWbffIm8pqXYqtV2h9tfO+ud8Rx4f463+Vz
/zSMaFTvYjBq3+R1NrOqpIZ2+jFm8r9pHyQmjlfPRmaH8T2ckWPZ3wotl7D7
TwPiThdQZjtXXeeIJmvVojg2Vpb30ePONTalN+pn0tQUWCW3Xn9WzzNG9CK/
HvwnJiHdDkPGvArzmsi1yniqNDIqjjmxidHW5kYo25I7t+Knm/RmZzWMSkQl
jEzynpjToS7tDEMmj/JjAK90hnQSwDevYDTQ4OmRy675uN8KWKhY7RHak+zJ
X8rEOd0=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{140, 109},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[19]=",
 CellID->343783524]
}, Open  ]],

Cell["\<\
A number of options can be applied to control the appearance of the stem\
\[Hyphen]and\[Hyphen]leaf plot.\
\>", "Text",
 CellID->14008],

Cell[BoxData[GridBox[{
   {Cell["option name ", "TableHeader"], Cell[
    "default value ", "TableHeader"], " "},
   {
    RowBox[{
     ButtonBox["StemExponent",
      BaseStyle->"Link",
      ButtonData->"paclet:StatisticalPlots/ref/StemExponent"], " "}], 
    RowBox[{
     ButtonBox["Automatic",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Automatic"], " "}], Cell[
    "stem units given as an integer power of 10", "TableText"]},
   {
    RowBox[{
     ButtonBox["Leaves",
      BaseStyle->"Link",
      ButtonData->"paclet:StatisticalPlots/ref/Leaves"], " "}], 
    RowBox[{"\"\<Digits\>\"", " "}], Cell[
    "how leaves are represented", "TableText"]},
   {
    RowBox[{
     ButtonBox["ColumnLabels",
      BaseStyle->"Link",
      ButtonData->"paclet:StatisticalPlots/ref/ColumnLabels"], " "}], 
    RowBox[{
     ButtonBox["Automatic",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Automatic"], " "}], Cell[
    "labels for the columns of the plot", "TableText"]},
   {
    RowBox[{
     ButtonBox["IncludeEmptyStems",
      BaseStyle->"Link",
      ButtonData->"paclet:StatisticalPlots/ref/IncludeEmptyStems"], " "}], 
    RowBox[{
     ButtonBox["False",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/False"], " "}], Cell[
    "whether stems without leaves should be displayed", "TableText"]},
   {
    RowBox[{
     ButtonBox["IncludeStemUnits",
      BaseStyle->"Link",
      ButtonData->"paclet:StatisticalPlots/ref/IncludeStemUnits"], " "}], 
    RowBox[{
     ButtonBox["True",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/True"], " "}], Cell[
    "whether stem units should be included in the plot", "TableText"]},
   {
    RowBox[{
     ButtonBox["IncludeStemCounts",
      BaseStyle->"Link",
      ButtonData->"paclet:StatisticalPlots/ref/IncludeStemCounts"], " "}], 
    RowBox[{
     ButtonBox["Automatic",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Automatic"], " "}], Cell[
    "whether to include a column of counts along with the leaves", 
     "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellID->139],

Cell[TextData[{
 "Options for ",
 Cell[BoxData[
  ButtonBox["StemLeafPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:StatisticalPlots/ref/StemLeafPlot"]], 
  "InlineFormula"],
 ". "
}], "Caption",
 CellID->11055],

Cell[TextData[{
 "The value of ",
 Cell[BoxData[
  ButtonBox["StemExponent",
   BaseStyle->"Link",
   ButtonData->"paclet:StatisticalPlots/ref/StemExponent"]], 
  "InlineFormula"],
 " can be an integer or ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 ". If it is an integer ",
 StyleBox["x",
  FontSlant->"Italic"],
 ", the stem unit is taken to be ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["10", "x"], TraditionalForm]]],
 ".",
 " ",
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["StemExponent",
    BaseStyle->"Link",
    ButtonData->"paclet:StatisticalPlots/ref/StemExponent"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", the exponent is chosen based on the magnitudes of the data."
}], "Text",
 CellID->3479],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["Leaves",
   BaseStyle->"Link",
   ButtonData->"paclet:StatisticalPlots/ref/Leaves"]], "InlineFormula"],
 " option value can be ",
 Cell[BoxData["\"\<Digits\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Tallies\>\""], "InlineFormula"],
 ", or ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 ". With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Leaves",
    BaseStyle->"Link",
    ButtonData->"paclet:StatisticalPlots/ref/Leaves"], "->", 
   "\"\<Tallies\>\""}]], "InlineFormula"],
 ", leaves are represented as tally marks. With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Leaves",
    BaseStyle->"Link",
    ButtonData->"paclet:StatisticalPlots/ref/Leaves"], "->", 
   ButtonBox["None",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/None"]}]], "InlineFormula"],
 ", leaves are not included in the plot. The setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Leaves",
    BaseStyle->"Link",
    ButtonData->"paclet:StatisticalPlots/ref/Leaves"], "->", 
   ButtonBox["None",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/None"]}]], "InlineFormula"],
 " is most useful for plotting large data sets as stems and counts instead of \
displaying all the leaves."
}], "Text",
 CellID->3925],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["ColumnLabels",
   BaseStyle->"Link",
   ButtonData->"paclet:StatisticalPlots/ref/ColumnLabels"]], 
  "InlineFormula"],
 " option can be used to specify the labels for the columns of the plot. The \
",
 Cell[BoxData[
  ButtonBox["ColumnLabels",
   BaseStyle->"Link",
   ButtonData->"paclet:StatisticalPlots/ref/ColumnLabels"]], 
  "InlineFormula"],
 " option value can be a list of a length equal to the number of columns in \
the plot or ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 ". With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ColumnLabels",
    BaseStyle->"Link",
    ButtonData->"paclet:StatisticalPlots/ref/ColumnLabels"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", the stem column is labeled ",
 Cell[BoxData["Stem"], "InlineFormula"],
 ", leaf columns are labeled ",
 Cell[BoxData["Leaves"], "InlineFormula"],
 ", and count columns are labeled ",
 Cell[BoxData["Counts"], "InlineFormula"],
 "."
}], "Text",
 CellID->24426],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["IncludeEmptyStems",
   BaseStyle->"Link",
   ButtonData->"paclet:StatisticalPlots/ref/IncludeEmptyStems"]], 
  "InlineFormula"],
 " option specifies whether stems within the data range should be included if \
they have no leaves. The possible values for this option are ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 "."
}], "Text",
 CellID->16051],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["IncludeStemUnits",
   BaseStyle->"Link",
   ButtonData->"paclet:StatisticalPlots/ref/IncludeStemUnits"]], 
  "InlineFormula"],
 " option specifies whether or not a reminder of the stem units should be \
included in the plot.",
 " ",
 "Possible values are ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 "."
}], "Text",
 CellID->1005],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["IncludeStemCounts",
   BaseStyle->"Link",
   ButtonData->"paclet:StatisticalPlots/ref/IncludeStemCounts"]], 
  "InlineFormula"],
 " option specifies whether a column of counts should be included for each \
vector of real values plotted. If included, counts are displayed in the \
rightmost column in a stem\[Hyphen]and\[Hyphen]leaf plot of a single vector, \
and in the leftmost and rightmost columns for a side\[Hyphen]by\[Hyphen]side \
stem\[Hyphen]and\[Hyphen]leaf plot. Possible values are ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 ". With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["IncludeStemCounts",
    BaseStyle->"Link",
    ButtonData->"paclet:StatisticalPlots/ref/IncludeStemCounts"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", counts are only included if the ",
 Cell[BoxData["Leaves"], "InlineFormula"],
 " option is set to ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 "."
}], "Text",
 CellID->21998],

Cell["\<\
Here is a side\[Hyphen]by\[Hyphen]side stem\[Hyphen]and\[Hyphen]leaf plot \
with stem counts, tally leaves, and nondefault stem units.\
\>", "MathCaption",
 CellID->23056],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StemLeafPlot", "[", 
  RowBox[{"sldata", ",", "sldata2", ",", 
   RowBox[{"StemExponent", "\[Rule]", 
    RowBox[{"-", "1"}]}], ",", 
   RowBox[{"Leaves", "\[Rule]", "\"\<Tallies\>\""}], ",", 
   RowBox[{"IncludeStemCounts", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[20]:=",
 CellID->424],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXMtu1DAUTfOYtlLboQ+gC5AqgcQGWID4AaBlVSRY8NqNqkrtAoEKez4D
CVTxC6z4jYov6b6bEHvsyc3JTRwndqYdZqTJxM97fR8n9o09+6OvR4cfR1+P
D0Y7L05Gn4+OD77s7H06ybKihSAILrLv3+0gu0+zO/m9SNPsl17fZNckKwpF
KhJ15Cf4IUvfieviJFfmBeNr8LPHGm+za5ilYpbL8UiCKG8o6ibZTaSy4yAv
Fx8x4mXVJ82PAtUw0B9xnyjKkZJTrNKi9e8C7UBLMoHRjCtE+bgGpFaeuwzj
Cyv7Q0lENTKUZTEtE/2uyGZnZ2ff5CdYFBeRVs2/y9YJSz0B6nH1aEptLcZD
0ouQHsr0+fl5gfss3ZD7BDjxw7W2mj+yfqhSbKtaik24m9gKtR8DfzzlKOVs
W1ZVkovS3BuioFhnifASToSknSkkrWPSW0zorqn803HDeNI3aU9H8RDStyF9
OpF+CLw+gJp32JYfLHLfKyq/0hyZ2l2PoP97kD60qLWhJPqMSFD8oletKs2g
fw8h/VLV25K9b0Hp85SzqiWotcLWQt9Ayvtsq02Wj12SnvgOKb8GabSrtQ60
9yCNo58mba3lgUOaJlmvQpqzvLa0m9kbUuCxz8bexFV40W5q9qpYIWLC0Ch6
k0u/v9q1mqLWMC0+jdC3XKCV7DOfQzFPoS4WbPIegZUDBpe70DShBI/PiBk+
OVhlZc5p2KWs16Ac9dyFdjNbc8lBU4wakvJ4jlGNa20qubxm5ElnxvKWkate
R2q9PE3HmDfW3gar2VfQB9oDzvqRJr8q2oVaNhxofEJLRcoUPUQ/iAC2NO3n
j2j3XUZdxqc+qSNKmGi7lL0tbRuLq/Mo6inrUI6epGcN19PLjB+XB7H0qkDH
LBBVXCAV77N8bMU/atnP6Vz6kD111+ihI6qctl3Smq6c+7I5V341x612uGWK
WfnDL5dPv3YzPlP0yDluWdD2gVqmyJVz9AI7+t+wS+iYi1zNscsNdg3UL9qx
P8wyxXH8Y9aAGe9szq+KXPhcE9ZFAjiM6Hc97hulBkrmc5RqV8v2LWHVU8Hf
28FmTz7n7whLfW10oGj7ZtAUzXNJu+n8yudbWNP8yn283Zet2bwfjILqFeI8
9n5V8Wqauxn6xI3LgFmm9f9VkfW07K0NWnFx+Dla2a0BhSbpnrrZj7u324nj
6/1Vqv3XyIHLlZrsu7AnN2Z07zcKv+lRwrzFmXYyuFwN6v3f89WgH7yq2s02
S3F2NipWw4FPjOpzbwH2bdrX0VcMy7fM/dtdk7eE890N7Ws1XROaZl0u1oTt
Zhm+9jL64aDJ6mzWOZi+FqZljzZrRnomr78IlzgEeXnRqlktem6MPiNKJxfz
k1YE2fSJRSFzjXj6tJVO47M+Ju3QmuXTLs6t3XzSEq0hacnJuhM5hONCelqU
jIgUFnIKJ+z4dU3d6Uv0wlLfpZle7dqJ65dvhRiQmMdBaPCnVLHPQa8jGrK5
/HhK5yFba1AcqF5I0XL4mV8NL8YVMfqKL2thdUjS/DlTXP/w5377sg/TCS++
167a6csSNMrhSoCiZVxLg85vEcWr9ZtAnwa9duaMff/nRZJl5LfVWjV+8D2x
e+U6jc0ml9OXfm7acWVnA/2NkIs9+dRn2e+1TGlv1afeqXdwdk9nN5Oz9YXZ
DJ0Lxow+OISm3lZ1Yr9Op+0446Ik7SRVljo+P25AehvS9w1S4v5V4KZBKo9Z
C0HKEmcnc89HSgb4vwN65xId460K+T1Rfd2VVek/BgQL/wCQTxd+\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{250, 209},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[20]=",
 CellID->229561606]
}, Open  ]],

Cell[TextData[{
 "This plot displays ",
 Cell[BoxData[
  StyleBox["sldata", "TI"]], "InlineFormula"],
 " including empty stems and using the column labels as a reminder of the \
units."
}], "MathCaption",
 CellID->30111],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StemLeafPlot", "[", 
  RowBox[{"sldata", ",", 
   RowBox[{"ColumnLabels", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<(\[Times]1)\>\"", ",", 
      "\"\<(\[Times]\!\(\*SuperscriptBox[\(10\), \(-1\)]\))\>\""}], "}"}]}], 
   ",", 
   RowBox[{"StemExponent", "\[Rule]", "0"}], ",", 
   RowBox[{"IncludeEmptyStems", "\[Rule]", "True"}], ",", 
   RowBox[{"IncludeStemUnits", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[21]:=",
 CellID->2620],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWF1PwjAULexD0UR90uELoAkfPvoj8Ml3Ep8WYgIPRoP8/7mu3Zhnt73t
BIOJJGy7tz3t7Tm3vYPndLt6fUu362U6fNqkH6v18nM4f9/krqAjhFjk35dE
5M9Z/lR8F1mW3+/lNZB28RGPFu9NfpXOHrSegD0tel/La1R5C58Qp07YW/DG
YOMokx+gTKsy9657EYX22AkVkVxNK2xIMCcxUdXLR8ff9fY1v6h0rP0zJ+1s
DMlMi4kZOAyfnZwuItz1pdFhtcKk1mqcq2Y/OKGQp1nFedew24I/kDOmPVnm
fFffRx5aYnZ0SZQakctGHCsA+67VKCHYKpZEa8mdupg/w1YxYPvgQAybFI71
aiPdrpg8hpykvZKZiOBi18rztst5W41QvRLw0mP1GWVULy432q2BUvV49PJT
8XuN4ri3VYt/rDtWZpE8A86savjoK19/D5E9mOcDsEMShVyMwA5IlNvpWlbG
QHN1SaEateICbGTeVu+EaI5Hx4azqFiw6l0xHHNVE22fWLCO2znGmbh6uE/W
MFJubN9Y6Vj2yS2nm2/E506xyTOk3B+HZxVt3Ffm/Ar1vdG7cU645awvu9Sv
4fp7Wc/IbjMiVIabe0K1N1DIJc6KK6BHRUXLdXKzjbNajRLqvxTR+QLXu2+O
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{88, 91},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[21]=",
 CellID->503219105]
}, Open  ]],

Cell[TextData[{
 "A number of options can be applied to control the appearance of the stem\
\[Hyphen]and\[Hyphen]leaf plot. The plot is constructed as a ",
 Cell[BoxData[
  ButtonBox["GridBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GridBox"]], "InlineFormula"],
 ". In addition to the above options, standard ",
 Cell[BoxData[
  ButtonBox["GridBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GridBox"]], "InlineFormula"],
 " options can be used. If ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["IncludeStemUnits",
    BaseStyle->"Link",
    ButtonData->"paclet:StatisticalPlots/ref/IncludeStemUnits"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["GridBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GridBox"]], "InlineFormula"],
 " options are applied to the grid of stems and leaves, but not to the label \
for stem units."
}], "Text",
 CellID->26458],

Cell[TextData[{
 "Here ",
 Cell[BoxData[
  StyleBox["sldata", "TI"]], "InlineFormula"],
 " is displayed with a frame and nondefault column alignments."
}], "MathCaption",
 CellID->26461],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StemLeafPlot", "[", 
  RowBox[{"sldata", ",", 
   RowBox[{"GridFrame", "\[Rule]", "True"}], ",", 
   RowBox[{"ColumnAlignments", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Left", ",", "Right"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[22]:=",
 CellID->21792],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWdtO3DAQ9drOsgghVeKhiLZcHwq0RXwFPPUHylOEkOChKqL8v7EXz2Zy
GCd22O5FaqRNfBkfH9vj8Xj2Z/18f/e7fn64rQ+vn+rH+4fbv4dXf558kRkp
pW78r95VPu18avq7cc5/+VuZ1094a/+tfMLEYqua+vBU/rfpsxrKjYoNFT0h
HaRtRNMRzcbWW/4b6kctDipKTps6emadmQjsnzGTako3mRSNR8azIDnF3wAp
3rfldQF3GxBeR1KJvVUga9Ps37Qt4M/yG5D/UMi2gp7/DUvSjh2RnY61Ikon
gxy2M93g+tLDV+7ZuC6N4PuLZta4ZlcY1ZaZMG56Nom0qTRrbRma7edhZ30w
HC53Afm95Kpo4PwDJA94D+qtzcl//2I2osE/gf4u/Wu0MElatX1ocS5oC0Po
tGkh+akMj9WgfUGkb5DXC0BKzVIZAs8j0ncn7cZynFMRJz3bdJZ9EXCqzpbL
1dt1kaRT4TO0OHON3RumvVkr3TrpxwKPLJTi3T5ECxnXhD6SzyVjoFclIeD8
DkM6g3yaE3mIiBCsoemckXXR79U8vY5c4/UJVqxYn5FR2q8ftpcRX/It54Ms
+Z/pXaCFuUVEZDD8PEZkfi9qZnlZa5jSteM4T3TXTK/VuuyqJUi2zqlKsJj9
5yWuv2j/C9b7P95q4dFd7QBw+jVjXlq6ive3uUmOYSVc26qlImgYm+FRAbrH
Ux61I9TzWFrKHqQjX3mRtAn0PZVqeZt4q7JZvUmndLFXMDC+tqgxTcRWJWNJ
R9/EMYCOcF2SdYD7eN12YB4xuBzOuRHF95f2+bVjlxej6xoR3WAtYjSxPNWO
b9oMZmTNUd8+9rD52rm6GMvD2y5Zs9MkSu4JEP9vGL0ArP1PGA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{91, 97},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[22]=",
 CellID->209403662]
}, Open  ]],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["StemExponent",
   BaseStyle->"Link",
   ButtonData->"paclet:StatisticalPlots/ref/StemExponent"]], 
  "InlineFormula"],
 " option has additional options than can be used to further subdivide stem \
units and label those divisions."
}], "Text",
 CellID->21274],

Cell[BoxData[GridBox[{
   {Cell["option name ", "TableHeader"], Cell[
    "default value ", "TableHeader"], " "},
   {
    RowBox[{"\"\<UnitDivisions\>\"", " "}], 
    RowBox[{"1", " "}], Cell[
    "the number of divisions for each stem unit", "TableText"]},
   {
    RowBox[{"\"\<DivisionLabels\>\"", " "}], 
    RowBox[{
     ButtonBox["None",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/None"], " "}], Cell["\<\
a list of labels appended to stem numbers within each unit division\
\>", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellID->10713],

Cell[TextData[{
 "Suboptions for ",
 Cell[BoxData[
  ButtonBox["StemExponent",
   BaseStyle->"Link",
   ButtonData->"paclet:StatisticalPlots/ref/StemExponent"]], 
  "InlineFormula"],
 ". "
}], "Caption",
 CellID->5044],

Cell[TextData[{
 "The ",
 Cell[BoxData["\"\<UnitDivisions\>\""], "InlineFormula"],
 " option specifies the number of stems a base unit should be divided into. \
The value of ",
 Cell[BoxData["\"\<UnitDivisions\>\""], "InlineFormula"],
 " must be a positive integer. "
}], "Text",
 CellID->18251],

Cell[TextData[{
 "Alternate labeling of subdivisions can be specified via the ",
 Cell[BoxData["\"\<DivisionLabels\>\""], "InlineFormula"],
 " option. The value of ",
 Cell[BoxData["\"\<DivisionLabels\>\""], "InlineFormula"],
 " must be ",
 StyleBox["None", "MR"],
 " or a list of a length equal to the ",
 Cell[BoxData["\"\<UnitDivisions\>\""], "InlineFormula"],
 " value. If the ",
 Cell[BoxData["\"\<DivisionLabels\>\""], "InlineFormula"],
 " value is a list, the values are appended to each numeric stem in the \
plot."
}], "Text",
 CellID->26303],

Cell[TextData[{
 "Here, each base unit is broken into two stems and the stems are labeled ",
 StyleBox["\"L\"", "MR"],
 " and ",
 StyleBox["\"H\"", "MR"],
 ", for low and high."
}], "MathCaption",
 CellID->28839],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"sldata3", "=", 
   RowBox[{"{", 
    RowBox[{
    "1.34", ",", "1.6", ",", "2.4", ",", "2.8", ",", "1.7", ",", "3.1", ",", 
     "1.63", ",", "0.8"}], "}"}]}], ";"}], "\n", 
 RowBox[{"StemLeafPlot", "[", 
  RowBox[{"sldata3", ",", 
   RowBox[{"StemExponent", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", 
      RowBox[{"\"\<UnitDivisions\>\"", "\[Rule]", "2"}], ",", 
      RowBox[{"\"\<DivisionLabels\>\"", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<L\>\"", ",", "\"\<H\>\""}], "}"}]}]}], "}"}]}]}], 
  "]"}]}], "Input",
 CellLabel->"In[23]:=",
 CellID->5456],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdWUtv2zAMVmTZSVYUbZfDhq7FCvS09XHrX9hOu+3WU1AUaA9Di663/nhN
skSbovWynRjpDDiyZIqkKPITzfxavz7c/1m/Pt6tz36+rJ8fHu/+nv14elFD
xYwxdqvut89MPUv1VN+3UqoW/7LCNPqXq7ZUD4UdFqx9r69S3UvV5WS8YHYi
g0s/a2phuXHLTdjZe6rV72eODsxS1lMlXI2wwjJWV4Wo2tElooL1+PkJQlnz
nxMqLFvgd5rvPuFgVlJ6pZWEVoS178ztoT/qz0n/sKe2JZG8HS3BO1Ze7bh9
6+US1SBH28Y3sL8k9PVLLmTMI3B8gWUL2UZFwVyaBdKNN0aEoOJotkDcRFoP
0chAfDDdNekfB3eFE52vCOVXLIF1MSf/95xwvomMHsoWubRdFoQKrH9RUx8E
9xLFuocLjSzDbeXlRv2pGsFrL2vukbU8jRmKjJuXHLFnbz3wTur2g8eOepW1
3/XykWlHtU1KgFQGF5DStVd2tZcRe/px1ufpXarWtmlM68PxiNCO1/GjlOTE
9cWza6+VO8fjezT6Yhps0/oO8rfonvSIXfDouJ/zwE4t7Dq+R2ybRl6KHd8a
i3ZyqygfvT9Vow313hRiJf02kk9QXlVH16E4nPLcPjjc9dYQDkOuYqh3wRM3
icOQndLs/VT6/GYMNuRlz1PJpes92Tm5oewOsmDdUrQfvQqKMSQOcP/LCFlU
77yvH+MbOl7xF0L8dJlL18/BsobXLsTtsNPGPTW9+J48H3JznaGnVt9TZzNc
9I7zuGW2rkMqO4Kvl1De/x7yoTFZ3rYyz/+Hbzrm39tap/oq+A3cJo6HvjVm
umJcN4MzHvoUewRrq81LR3p4r/Kqy96T2sF+mu+LLGm+qmjAn0bVl6fS3ytn
UK05lRthPxAstLtculVX4xWbqC7n6JeLF+NHjYcMqTen8k+aJXYxCltTtLok
a86fEtIvm72iNecTQgmYYmqC9r+t2T/vEuvq\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{91, 123},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[24]=",
 CellID->101075338]
}, Open  ]],

Cell[TextData[{
 "A number of options to the ",
 Cell[BoxData[
  ButtonBox["Leaves",
   BaseStyle->"Link",
   ButtonData->"paclet:StatisticalPlots/ref/Leaves"]], "InlineFormula"],
 " option can be used to modify how leaves are computed and displayed. "
}], "Text",
 CellID->8561],

Cell[BoxData[GridBox[{
   {Cell["option name ", "TableHeader"], Cell[
    "default value ", "TableHeader"], " "},
   {
    RowBox[{"\"\<LeafDigits\>\"", " "}], 
    RowBox[{"1", " "}], Cell[
    "the number of digits to use for each leaf", "TableText"]},
   {
    RowBox[{"\"\<LeafSpacing\>\"", " "}], 
    RowBox[{
     ButtonBox["Automatic",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Automatic"], " "}], Cell[
    "the number of spaces between displayed leaves", "TableText"]},
   {
    RowBox[{"\"\<LeafWrapping\>\"", " "}], 
    RowBox[{
     ButtonBox["None",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/None"], " "}], Cell[
    "specifies when leaves should be wrapped to a new line", "TableText"]},
   {
    RowBox[{"\"\<RoundLeaves\>\"", " "}], 
    RowBox[{
     ButtonBox["True",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/True"], " "}], Cell["\<\
whether data entries should be rounded before determining leaves\
\>", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellID->20128],

Cell[TextData[{
 "Suboptions for all ",
 Cell[BoxData[
  ButtonBox["Leaves",
   BaseStyle->"Link",
   ButtonData->"paclet:StatisticalPlots/ref/Leaves"]], "InlineFormula"],
 " option values. "
}], "Caption",
 CellID->12410],

Cell[TextData[{
 "The ",
 Cell[BoxData["\"\<LeafDigits\>\""], "InlineFormula"],
 " option specifies the number of digits beyond the stem to use in computing \
leaves. This is also the number of digits displayed for each leaf if leaves \
are displayed as ",
 Cell[BoxData["\"\<Digits\>\""], "InlineFormula"],
 ". The value must be a positive integer. "
}], "Text",
 CellID->8235],

Cell[TextData[{
 Cell[BoxData["\"\<LeafSpacing\>\""], "InlineFormula"],
 " indicates the number of spaces to display between leaves. ",
 Cell[BoxData["\"\<LeafSpacing\>\""], "InlineFormula"],
 " can be set to a nonnegative integer or ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 ". With ",
 Cell[BoxData[
  RowBox[{"\"\<LeafSpacing\>\"", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", zero spaces are used when ",
 Cell[BoxData[
  RowBox[{"\"\<LeafDigits\>\"", "->", "1"}]], "InlineFormula"],
 ", and one space is used otherwise."
}], "Text",
 CellID->23819],

Cell[TextData[{
 Cell[BoxData["\"\<LeafWrapping\>\""], "InlineFormula"],
 " specifies the number of leaves after which leaves should be wrapped to a \
new line. ",
 Cell[BoxData["\"\<LeafWrapping\>\""], "InlineFormula"],
 " can be any positive integer or ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 ", with ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 " indicating that leaves should not be wrapped to new lines."
}], "Text",
 CellID->24453],

Cell[TextData[{
 Cell[BoxData["\"\<RoundLeaves\>\""], "InlineFormula"],
 " specifies whether or not values should be rounded to the last leaf digit \
before computing leaves."
}], "Text",
 CellID->22013],

Cell["The following generates 100 numbers between 0 and 5.", "MathCaption",
 CellID->15698],

Cell[BoxData[
 RowBox[{
  RowBox[{"sldata4", "=", 
   RowBox[{"BlockRandom", "[", 
    RowBox[{
     RowBox[{"SeedRandom", "[", "1", "]"}], ";", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"RandomReal", "[", 
        RowBox[{"{", 
         RowBox[{"0", ",", "5"}], "}"}], "]"}], ",", 
       RowBox[{"{", "100", "}"}]}], "]"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[25]:=",
 CellID->6603],

Cell["\<\
This displays the data using two digits for leaves and including two spaces \
between leaves.\
\>", "MathCaption",
 CellID->13541],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StemLeafPlot", "[", 
  RowBox[{"sldata4", ",", 
   RowBox[{"Leaves", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<Digits\>\"", ",", 
      RowBox[{"\"\<LeafDigits\>\"", "\[Rule]", "2"}], ",", 
      RowBox[{"\"\<LeafSpacing\>\"", "\[Rule]", "2"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[26]:=",
 CellID->23099],

Cell[BoxData[
 TagBox[GridBox[{
    {
     TagBox[GridBox[{
        {"\<\"Stem\"\>", "\<\"Leaves\"\>"},
        {"\<\"0\"\>", "\<\"06  06  09  19  19  28  33  45  46  56  59  64  70 \
 80  85  93  94  98\"\>"},
        {"\<\"1\"\>", "\<\"00  01  02  04  06  08  10  16  17  21  24  32  37 \
 39  46  49  53  58  63  63  66  67  81  95  96  98\"\>"},
        {"\<\"2\"\>", "\<\"08  11  22  29  29  32  35  36  41  57  59  61  70 \
 71  71  72  74  81  83  85  89  90  90  97  97  99\"\>"},
        {"\<\"3\"\>", "\<\"21  22  33  35  38  47  50  50  56  64  65  69  74 \
 84  95  95  95\"\>"},
        {"\<\"4\"\>", "\<\"04  09  10  13  17  26  31  55  63  72  84  87  89\
\"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {Right, Left, {Center}}, "ColumnsIndexed" -> {}, 
         "Rows" -> {{Top}}, "RowsIndexed" -> {}},
       GridBoxDividers->{
        "Columns" -> {False, True, {False}, False}, "ColumnsIndexed" -> {}, 
         "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[1.0499999999999998`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      "Grid"]},
    {"\<\"Stem units: \\!\\(1\\)\"\>"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.5599999999999999]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.8]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  "Grid"]], "Output",
 ImageSize->{760, 109},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[26]=",
 CellID->627658325]
}, Open  ]],

Cell["\<\
Wrapping leaves to a new line can be useful if there is a large number of \
leaves for one or more stems, as is the case with this data set.\
\>", "Text",
 CellID->12877],

Cell["\<\
Here the leaves are wrapped to a new line after 12 leaves, and row lines are \
inserted.\
\>", "MathCaption",
 CellID->2624],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StemLeafPlot", "[", 
  RowBox[{"sldata4", ",", 
   RowBox[{"Leaves", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<Digits\>\"", ",", 
      RowBox[{"\"\<LeafDigits\>\"", "\[Rule]", "2"}], ",", 
      RowBox[{"\"\<LeafWrapping\>\"", "\[Rule]", "12"}]}], "}"}]}], ",", 
   RowBox[{"RowLines", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[27]:=",
 CellID->26819],

Cell[BoxData[
 TagBox[GridBox[{
    {
     TagBox[GridBox[{
        {"\<\"Stem\"\>", "\<\"Leaves\"\>"},
        {"\<\"0\"\>", 
         TagBox[GridBox[{
            {"\<\"06 06 09 19 19 28 33 45 46 56 59 64\"\>"},
            {"\<\"70 80 85 93 94 98\"\>"}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Top}}, 
             "RowsIndexed" -> {}}],
          "Grid"]},
        {"\<\"1\"\>", 
         TagBox[GridBox[{
            {"\<\"00 01 02 04 06 08 10 16 17 21 24 32\"\>"},
            {"\<\"37 39 46 49 53 58 63 63 66 67 81 95\"\>"},
            {"\<\"96 98\"\>"}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Top}}, 
             "RowsIndexed" -> {}}],
          "Grid"]},
        {"\<\"2\"\>", 
         TagBox[GridBox[{
            {"\<\"08 11 22 29 29 32 35 36 41 57 59 61\"\>"},
            {"\<\"70 71 71 72 74 81 83 85 89 90 90 97\"\>"},
            {"\<\"97 99\"\>"}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Top}}, 
             "RowsIndexed" -> {}}],
          "Grid"]},
        {"\<\"3\"\>", 
         TagBox[GridBox[{
            {"\<\"21 22 33 35 38 47 50 50 56 64 65 69\"\>"},
            {"\<\"74 84 95 95 95\"\>"}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Top}}, 
             "RowsIndexed" -> {}}],
          "Grid"]},
        {"\<\"4\"\>", 
         TagBox[GridBox[{
            {"\<\"04 09 10 13 17 26 31 55 63 72 84 87\"\>"},
            {"\<\"89\"\>"}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Top}}, 
             "RowsIndexed" -> {}}],
          "Grid"]}
       },
       GridBoxAlignment->{
        "Columns" -> {Right, Left, {Center}}, "ColumnsIndexed" -> {}, 
         "Rows" -> {{Top}}, "RowsIndexed" -> {}},
       GridBoxDividers->{
        "Columns" -> {False, True, {False}, False}, "ColumnsIndexed" -> {}, 
         "Rows" -> {False, {True}, False}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[1.0499999999999998`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      "Grid"]},
    {"\<\"Stem units: \\!\\(1\\)\"\>"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.5599999999999999]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.8]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  "Grid"]], "Output",
 ImageSize->{291, 219},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[27]=",
 CellID->741716813]
}, Open  ]],

Cell[TextData[{
 "If leaves are displayed as ",
 Cell[BoxData["\"\<Tallies\>\""], "InlineFormula"],
 ", the symbol used as tally markers can also be specified."
}], "Text",
 CellID->3002],

Cell[BoxData[GridBox[{
   {Cell["option name ", "TableHeader"], Cell[
    "default value ", "TableHeader"], " "},
   {
    RowBox[{"\"\<TallySymbol\>\"", " "}], 
    RowBox[{"\"\<X\>\"", " "}], Cell[
    "the symbol to use for each leaf", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellID->1132],

Cell[TextData[{
 "Suboption for ",
 Cell[BoxData["\"\<Tallies\>\""], "InlineFormula"],
 " leaves. "
}], "Caption",
 CellID->22054],

Cell[TextData[{
 "The ",
 Cell[BoxData["\"\<TallySymbol\>\""], "InlineFormula"],
 " option can be any string or symbol."
}], "Text",
 CellID->27382],

Cell[TextData[{
 "Here the leaves for ",
 Cell[BoxData[
  StyleBox["sldata4", "TI"]], "InlineFormula"],
 " are represented by checkmarks."
}], "MathCaption",
 CellID->5693],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StemLeafPlot", "[", 
  RowBox[{"sldata4", ",", 
   RowBox[{"Leaves", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<Tallies\>\"", ",", 
      RowBox[{"\"\<TallySymbol\>\"", "\[Rule]", "\[Checkmark]"}]}], "}"}]}]}],
   "]"}]], "Input",
 CellLabel->"In[28]:=",
 CellID->56],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztW0tv1DAQ9ibOtgXxlmCLkKjEGcTzylOCEyee11WF1B4qUOl/QEgI/gsc
+TX9JcYe24k962TtNCRO6kiJ89kTezwztr/Nxq+XR3ufDpZH+7vLnVeHyy97
+7tfd15+PuRZ+YwQcszPgwXh94zfwXnMGE/NK8llIq4ZTwt+k6tsSqpycRT8
3OIwQ/k5UQ8SfYh7IU1VbZmqjaqnz/JUlH+zdCBKEh5l+igby1XF/JgbUlXu
liGl++OujyJJqH8DSZltU7NM1HsO1SB7UjhbK5Asrdd+5dkA/Q28gfDFQG0L
1PL/0VJHxxWndpkqddbSqIGPtmVsmPGyRl93yzlrighzfGnL5qwaFTmxZTYN
3bLSiHpQZcbT1KiNrteDlm0Y9ZhydxC+XuuVDOl8G0neVDLfGZ5t2l1vofr/
NuRuK+vgESBLcZ/mCOOncOyNHb8HK1zl17nDRnPlt6Kn9GOpzeqo2mzwFJ5b
poA/QHoNnFb1etUOGA8dUV3jd9DtBbIO7jVe6YfWumv81ssKZyLTumv8Bvot
ZvSspvd9zlbSJyFrUb+5Yu4QmXhsyFK/WXbq61/X+AHYcR2r6Htd9U0feWsf
00oZO34I6ULZGI/Gqa/fXeP7zCdGp84Husb3wKp+a8LUWUbX+C7YsW417pu1
+KYyImLgMe5cEauFIzoTu5kOhvdv8jdww9weK5tqm4IVrN964va0vf8YO5av
Q7eR1/CMk9hf3HgmLoltjhCLPzyF96QHE7MdK9Z+HB+DbpvGwa/bsO51nCXx
7WEx/OvvxSxjGAdt08vevRySH552fMnLS4kfD4svMB8vJf47LD7PfLyU2O2w
GL7DAhYrVinsjbGzWBmDMXDU9G94X/hZgO1iYZUvAnWOiTMNjZ8H2C4xNxs/
DbBd4lM2fhJgu8RybPwY7BT7uzPp4ZD1XGxm6ZtDhO6NwXxByOMv9DU25XS5
3iXzy2qdkJPtinGuctY3xnjfA/VqzbWbY/Wpn5AWzrKioYb+9cft/Fijef0e
mSZewZS/zbhwezdj9m4RGRVd7Irx0c93j8/Jc2WEtNkn09QHatjJqoOyclTZ
1qSVLrRsh8n5CscK/kYBt/679FWG9L6BJPWc8gdE1J682T88W00d\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 109},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[28]=",
 CellID->547103057]
}, Open  ]],

Cell["\<\
From the previous display it is clear which stems contain more values than \
others. Including other features, such as counts and leaf wrapping, can be \
useful in determining the actual magnitudes of the leaf counts for each stem.\
\
\>", "Text",
 CellID->25542],

Cell["\<\
Wrapping leaves and including counts can make the plot easier to comprehend.\
\>", "MathCaption",
 CellID->12726],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StemLeafPlot", "[", 
  RowBox[{"sldata4", ",", 
   RowBox[{"Leaves", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<Tallies\>\"", ",", 
      RowBox[{"\"\<TallySymbol\>\"", "\[Rule]", "\[FilledCircle]"}], ",", 
      RowBox[{"\"\<LeafWrapping\>\"", "\[Rule]", "10"}]}], "}"}]}], ",", 
   RowBox[{"IncludeStemCounts", "\[Rule]", "True"}], ",", 
   RowBox[{"RowLines", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[29]:=",
 CellID->13392],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztW81u1DAQ9ibObguiFCH1B5XuSnCBUiROwIVyKhdKhYAHWFag9oBAbV+A
p+lD8TDBduxkMjuJ7cTJbqtdqeu1Pf7m83hsTxz3ZHp19uPX9Op8Np18uJj+
OTufXU6Of1+IonjAGLsWf/92mPidil/q7zpNRQq/WZwl8jsSaSJ+xLqYs6Je
fhLxty6yESqPmW7IzEf+ltJco0UajevWd0Uq609KHJiWVE1T88mVxRpYfIZA
qihdB1KmPzQeR5IKf4SkoG4O6yTuPYSQ9SQhtSVIllezn2vrwR/kRyi/6ck2
QZq7YWm84yHJLtK1JEotAxe2uW9Af7HwpTXHaZ1HwPllLBunxayIWVlmDXCL
ciOaSRWB1hygcTsPnusAOFDuJco/qhyVCHE+RJJjLXOa4tXG9/sJQv7bunQI
rEelM7IVnBNU+p1sJTH3RHYavLYZn2Z9b2/zUKW7mide3X7qXpu9a0NJY/8d
elrDN51Y9Kl5ybbE95Dog21EfdMxwo+03o2cxfxKtobayJ4di+w+gTXf+r5K
t1XDQtYdNZ5rmSHuADkflhy1c0PrehxoVtKzI4JNaB8daz0jnWbafeagDCqX
YzXwXd1c0/ckeii/OCLRpe4jkX0XvLZb3t3afBm8Kivd1jzxE4bZeUwk9yB1
X1273n/wU4fbrtj1+kfvijZWdXsGZ3Btj4hRarKPNWVUh+nmF31EAnW7N+Xn
Xe1DJmJTz6e3ZB8Kszt9I1F8feMriSJ1PBfZL8Frw/ALY6tlGPVFxC8mfRtk
hGzpm0ovkavj6+C1/fDvZyyWweuy0i1tDbwXmfjGnDlt5tL9xzf7pFbrsyhg
hHe10L5EPtFWcNtBsiGevXeRLD5jMJhjlYEYPB9b17hnUsZg+hR3QTHOY1Ir
PuHMethnjCNTE+Pcpmft1dnqbTtbXcUo4WpXMcoiYpTy6b9tf+0nOqFPO2zc
+ohLhs6WahKJuGKOKUzLO4A6vAmFp/Pu7PqJTjjJTUYn8mTkDuLUVXQyTFdv
Akz6iURr6g0nJJrU9UpkPwavDcszrA2XwSvcTvI5Kvc5ue36RL8Nt65Plem3
De3eM98UzOo3/Ysfl2U67eea483Ya3xvRlbd6DDyMcjjaIzrEZTpIWFF8sYl
L/LlO2UGjQW7WUmtdOU4LUIS3EkbtgXd6oAspfuDeVTfAVW6a+58yiu0A5Vv
c6uzL8thPc+cUGtsaD1NGznaKEGIFtugmQFnUDVbIyUbv+i852ZmZnMsSot5
itm73lN1sUS7PviUHrS0YPWco70k86AmN2XrbIZ3oRyjtG7C0eNE3xPQ2n4v
F3qr7hXPGaf0vVv8lgL345S0GX6GVXt4wQ7Yaa+iR581z6dKVP83wOA/Gct6
HQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{167, 219},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[29]=",
 CellID->151986211]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Statistical Plots Package - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 8, 37.2874544}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Statistical Plots Package Tutorial", "language" -> "en", "paclet" -> 
    "StatisticalPlots Package", "status" -> "None", "summary" -> 
    "A wide variety of plots and charts are used to gain an overview of data \
from a statistical perspective. Some summarize statistical computations on \
the data, while others compare data in ways that highlight their properties. \
This package implements several plotting functions of this class, including \
box-and-whisker plots, Pareto plots, quantile-quantile plots, and \
stem-and-leaf plots. Histograms, also commonly used in statistical \
applications, are included in the Histograms Package. Basic \
statistics-related plots. Load the plotting package. ", "synonyms" -> {}, 
    "title" -> "Statistical Plots Package", "type" -> "Tutorial", "uri" -> 
    "StatisticalPlots/tutorial/StatisticalPlots"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1201, 27, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1826, 54, 57, 1, 70, "Title",
 CellID->9219],
Cell[1886, 57, 670, 13, 70, "Text",
 CellID->27083],
Cell[2559, 72, 1527, 45, 70, "DefinitionBox",
 CellID->13576],
Cell[4089, 119, 81, 3, 70, "Caption",
 CellID->5185],
Cell[4173, 124, 66, 1, 70, "MathCaption",
 CellID->12220],
Cell[4242, 127, 100, 3, 70, "Input",
 CellID->32265],
Cell[CellGroupData[{
Cell[4367, 134, 71, 1, 70, "Section",
 CellID->3153],
Cell[4441, 137, 641, 11, 70, "Text",
 CellID->9115],
Cell[5085, 150, 995, 30, 70, "DefinitionBox",
 CellID->20043],
Cell[6083, 182, 72, 1, 70, "Caption",
 CellID->6084],
Cell[6158, 185, 70, 1, 70, "MathCaption",
 CellID->19757],
Cell[6231, 188, 345, 12, 70, "Input",
 CellID->27684],
Cell[6579, 202, 115, 3, 70, "MathCaption",
 CellID->13215],
Cell[CellGroupData[{
Cell[6719, 209, 107, 3, 28, "Input",
 CellID->2619],
Cell[6829, 214, 1152, 23, 368, "Output",
 Evaluatable->False,
 CellID->318979183]
}, Open  ]],
Cell[7996, 240, 113, 3, 70, "MathCaption",
 CellID->29715],
Cell[CellGroupData[{
Cell[8134, 247, 109, 3, 28, "Input",
 CellID->15471],
Cell[8246, 252, 1835, 34, 231, "Output",
 Evaluatable->False,
 CellID->854435838]
}, Open  ]],
Cell[10096, 289, 2972, 89, 70, "DefinitionBox3Col",
 CellID->18766],
Cell[13071, 380, 220, 9, 70, "Caption",
 CellID->27261],
Cell[13294, 391, 312, 9, 70, "Text",
 CellID->3199],
Cell[13609, 402, 532, 11, 70, "Text",
 CellID->32636],
Cell[14144, 415, 1306, 38, 70, "Text",
 CellID->7783],
Cell[15453, 455, 152, 4, 70, "MathCaption",
 CellID->4394],
Cell[CellGroupData[{
Cell[15630, 463, 825, 21, 50, "Input",
 CellID->25798],
Cell[16458, 486, 1637, 31, 374, "Output",
 Evaluatable->False,
 CellID->499540]
}, Open  ]],
Cell[18110, 520, 497, 14, 70, "Text",
 CellID->14272],
Cell[18610, 536, 589, 15, 70, "Text",
 CellID->24431],
Cell[19202, 553, 543, 12, 70, "Text",
 CellID->1279],
Cell[19748, 567, 1444, 43, 70, "Text",
 CellID->1895],
Cell[21195, 612, 170, 4, 70, "MathCaption",
 CellID->3097],
Cell[CellGroupData[{
Cell[21390, 620, 711, 19, 65, "Input",
 CellID->27319],
Cell[22104, 641, 2185, 40, 453, "Output",
 Evaluatable->False,
 CellID->162389815]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[24338, 687, 46, 1, 70, "Section",
 CellID->1273],
Cell[24387, 690, 227, 5, 70, "Text",
 CellID->2850],
Cell[24617, 697, 1630, 52, 70, "DefinitionBox",
 CellID->1614],
Cell[26250, 751, 49, 1, 70, "Caption",
 CellID->15044],
Cell[26302, 754, 414, 10, 70, "Text",
 CellID->32417],
Cell[26719, 766, 72, 1, 70, "MathCaption",
 CellID->21951],
Cell[CellGroupData[{
Cell[26816, 771, 281, 8, 28, "Input",
 CellID->21754],
Cell[27100, 781, 3283, 58, 246, "Output",
 Evaluatable->False,
 CellID->351455888]
}, Open  ]],
Cell[30398, 842, 455, 15, 70, "Text",
 CellID->24493],
Cell[30856, 859, 111, 3, 70, "MathCaption",
 CellID->21415],
Cell[CellGroupData[{
Cell[30992, 866, 427, 13, 70, "Input",
 CellID->1607],
Cell[31422, 881, 2749, 77, 246, "Output",
 CellID->205880398]
}, Open  ]],
Cell[34186, 961, 2675, 86, 70, "DefinitionBox3Col",
 CellID->5393],
Cell[36864, 1049, 209, 8, 70, "Caption",
 CellID->17745],
Cell[37076, 1059, 447, 13, 70, "Text",
 CellID->17459],
Cell[37526, 1074, 1222, 36, 70, "Text",
 CellID->14363],
Cell[38751, 1112, 118, 3, 70, "MathCaption",
 CellID->14922],
Cell[CellGroupData[{
Cell[38894, 1119, 498, 13, 47, "Input",
 CellID->32620],
Cell[39395, 1134, 3535, 62, 259, "Output",
 Evaluatable->False,
 CellID->94860313]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[42979, 1202, 65, 1, 70, "Section",
 CellID->1947],
Cell[43047, 1205, 325, 6, 70, "Text",
 CellID->6104],
Cell[43375, 1213, 467, 15, 70, "DefinitionBox",
 CellID->26801],
Cell[43845, 1230, 67, 1, 70, "Caption",
 CellID->9962],
Cell[43915, 1233, 575, 12, 70, "Text",
 CellID->31139],
Cell[44493, 1247, 129, 4, 70, "MathCaption",
 CellID->14908],
Cell[CellGroupData[{
Cell[44647, 1255, 258, 8, 28, "Input",
 CellID->27472],
Cell[44908, 1265, 4137, 72, 380, "Output",
 Evaluatable->False,
 CellID->46592044]
}, Open  ]],
Cell[49060, 1340, 1522, 48, 70, "DefinitionBox3Col",
 CellID->19253],
Cell[50585, 1390, 215, 9, 70, "Caption",
 CellID->3872],
Cell[50803, 1401, 573, 16, 70, "Text",
 CellID->29323],
Cell[51379, 1419, 117, 3, 70, "MathCaption",
 CellID->22645],
Cell[CellGroupData[{
Cell[51521, 1426, 570, 16, 47, "Input",
 CellID->23841],
Cell[52094, 1444, 6655, 113, 389, "Output",
 Evaluatable->False,
 CellID->820152008]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[58798, 1563, 56, 1, 70, "Section",
 CellID->4051],
Cell[58857, 1566, 287, 6, 70, "Text",
 CellID->13961],
Cell[59147, 1574, 359, 10, 70, "DefinitionBox",
 CellID->16742],
Cell[59509, 1586, 60, 1, 70, "Caption",
 CellID->11783],
Cell[59572, 1589, 455, 11, 70, "Text",
 CellID->25062],
Cell[60030, 1602, 71, 1, 70, "MathCaption",
 CellID->13488],
Cell[60104, 1605, 409, 14, 70, "Input",
 CellID->7696],
Cell[60516, 1621, 88, 1, 70, "MathCaption",
 CellID->30185],
Cell[CellGroupData[{
Cell[60629, 1626, 114, 3, 28, "Input",
 CellID->18144],
Cell[60746, 1631, 7898, 134, 380, "Output",
 Evaluatable->False,
 CellID->9756616]
}, Open  ]],
Cell[68659, 1768, 2133, 67, 70, "DefinitionBox3Col",
 CellID->3316],
Cell[70795, 1837, 238, 9, 70, "Caption",
 CellID->22740],
Cell[71036, 1848, 816, 26, 70, "Text",
 CellID->13125],
Cell[71855, 1876, 966, 23, 70, "Text",
 CellID->7348],
Cell[72824, 1901, 1336, 49, 70, "Text",
 CellID->7510],
Cell[74163, 1952, 346, 10, 70, "Text",
 CellID->12049],
Cell[74512, 1964, 1326, 31, 70, "Text",
 CellID->8110],
Cell[75841, 1997, 224, 8, 70, "Text",
 CellID->31323],
Cell[76068, 2007, 100, 2, 70, "MathCaption",
 CellID->19192],
Cell[CellGroupData[{
Cell[76193, 2013, 933, 27, 83, "Input",
 CellID->17572],
Cell[77129, 2042, 7329, 124, 202, "Output",
 Evaluatable->False,
 CellID->99766684]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[84507, 2172, 69, 1, 70, "Section",
 CellID->5019],
Cell[84579, 2175, 947, 14, 70, "Text",
 CellID->10270],
Cell[85529, 2191, 782, 24, 70, "DefinitionBox",
 CellID->22389],
Cell[86314, 2217, 71, 1, 70, "Caption",
 CellID->18110],
Cell[86388, 2220, 72, 1, 70, "MathCaption",
 CellID->29990],
Cell[86463, 2223, 209, 7, 70, "Input",
 CellID->22679],
Cell[86675, 2232, 111, 3, 70, "MathCaption",
 CellID->30712],
Cell[CellGroupData[{
Cell[86811, 2239, 110, 3, 28, "Input",
 CellID->15275],
Cell[86924, 2244, 1041, 21, 114, "Output",
 Evaluatable->False,
 CellID->831126603]
}, Open  ]],
Cell[87980, 2268, 250, 5, 70, "Text",
 CellID->29682],
Cell[88233, 2275, 79, 1, 70, "MathCaption",
 CellID->18232],
Cell[88315, 2278, 224, 8, 70, "Input",
 CellID->10801],
Cell[88542, 2288, 152, 4, 70, "MathCaption",
 CellID->11544],
Cell[CellGroupData[{
Cell[88719, 2296, 138, 4, 28, "Input",
 CellID->6755],
Cell[88860, 2302, 1381, 27, 130, "Output",
 Evaluatable->False,
 CellID->343783524]
}, Open  ]],
Cell[90256, 2332, 145, 4, 70, "Text",
 CellID->14008],
Cell[90404, 2338, 2234, 66, 70, "DefinitionBox3Col",
 CellID->139],
Cell[92641, 2406, 216, 9, 70, "Caption",
 CellID->11055],
Cell[92860, 2417, 877, 32, 70, "Text",
 CellID->3479],
Cell[93740, 2451, 1314, 43, 70, "Text",
 CellID->3925],
Cell[95057, 2496, 1146, 37, 70, "Text",
 CellID->24426],
Cell[96206, 2535, 592, 20, 70, "Text",
 CellID->16051],
Cell[96801, 2557, 576, 22, 70, "Text",
 CellID->1005],
Cell[97380, 2581, 1440, 44, 70, "Text",
 CellID->21998],
Cell[98823, 2627, 181, 4, 70, "MathCaption",
 CellID->23056],
Cell[CellGroupData[{
Cell[99029, 2635, 326, 8, 47, "Input",
 CellID->424],
Cell[99358, 2645, 2035, 37, 230, "Output",
 Evaluatable->False,
 CellID->229561606]
}, Open  ]],
Cell[101408, 2685, 220, 7, 70, "MathCaption",
 CellID->30111],
Cell[CellGroupData[{
Cell[101653, 2696, 483, 13, 49, "Input",
 CellID->2620],
Cell[102139, 2711, 883, 19, 112, "Output",
 Evaluatable->False,
 CellID->503219105]
}, Open  ]],
Cell[103037, 2733, 972, 29, 70, "Text",
 CellID->26458],
Cell[104012, 2764, 186, 6, 70, "MathCaption",
 CellID->26461],
Cell[CellGroupData[{
Cell[104223, 2774, 287, 8, 28, "Input",
 CellID->21792],
Cell[104513, 2784, 1118, 22, 118, "Output",
 Evaluatable->False,
 CellID->209403662]
}, Open  ]],
Cell[105646, 2809, 311, 10, 70, "Text",
 CellID->21274],
Cell[105960, 2821, 714, 20, 70, "DefinitionBox3Col",
 CellID->10713],
Cell[106677, 2843, 218, 9, 70, "Caption",
 CellID->5044],
Cell[106898, 2854, 295, 8, 70, "Text",
 CellID->18251],
Cell[107196, 2864, 551, 14, 70, "Text",
 CellID->26303],
Cell[107750, 2880, 212, 7, 70, "MathCaption",
 CellID->28839],
Cell[CellGroupData[{
Cell[107987, 2891, 623, 18, 65, "Input",
 CellID->5456],
Cell[108613, 2911, 1225, 24, 144, "Output",
 Evaluatable->False,
 CellID->101075338]
}, Open  ]],
Cell[109853, 2938, 279, 8, 70, "Text",
 CellID->8561],
Cell[110135, 2948, 1179, 34, 70, "DefinitionBox3Col",
 CellID->20128],
Cell[111317, 2984, 222, 8, 70, "Caption",
 CellID->12410],
Cell[111542, 2994, 378, 9, 70, "Text",
 CellID->8235],
Cell[111923, 3005, 713, 20, 70, "Text",
 CellID->23819],
Cell[112639, 3027, 582, 17, 70, "Text",
 CellID->24453],
Cell[113224, 3046, 203, 5, 70, "Text",
 CellID->22013],
Cell[113430, 3053, 91, 1, 70, "MathCaption",
 CellID->15698],
Cell[113524, 3056, 409, 13, 70, "Input",
 CellID->6603],
Cell[113936, 3071, 140, 4, 70, "MathCaption",
 CellID->13541],
Cell[CellGroupData[{
Cell[114101, 3079, 347, 10, 70, "Input",
 CellID->23099],
Cell[114451, 3091, 1933, 47, 130, "Output",
 CellID->627658325]
}, Open  ]],
Cell[116399, 3141, 180, 4, 70, "Text",
 CellID->12877],
Cell[116582, 3147, 134, 4, 70, "MathCaption",
 CellID->2624],
Cell[CellGroupData[{
Cell[116741, 3155, 396, 10, 70, "Input",
 CellID->26819],
Cell[117140, 3167, 3151, 89, 240, "Output",
 CellID->741716813]
}, Open  ]],
Cell[120306, 3259, 187, 5, 70, "Text",
 CellID->3002],
Cell[120496, 3266, 452, 12, 70, "DefinitionBox3Col",
 CellID->1132],
Cell[120951, 3280, 130, 5, 70, "Caption",
 CellID->22054],
Cell[121084, 3287, 148, 5, 70, "Text",
 CellID->27382],
Cell[121235, 3294, 172, 6, 70, "MathCaption",
 CellID->5693],
Cell[CellGroupData[{
Cell[121432, 3304, 296, 9, 28, "Input",
 CellID->56],
Cell[121731, 3315, 1364, 26, 130, "Output",
 Evaluatable->False,
 CellID->547103057]
}, Open  ]],
Cell[123110, 3344, 273, 6, 70, "Text",
 CellID->25542],
Cell[123386, 3352, 123, 3, 70, "MathCaption",
 CellID->12726],
Cell[CellGroupData[{
Cell[123534, 3359, 471, 11, 47, "Input",
 CellID->13392],
Cell[124008, 3372, 1621, 31, 240, "Output",
 Evaluatable->False,
 CellID->151986211]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[125668, 3408, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

