(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     68689,       2094]
NotebookOptionsPosition[     62369,       1907]
NotebookOutlinePosition[     63615,       1939]
CellTagsIndexPosition[     63572,       1936]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Units Package", "GuideTitle",
 CellID->942062912],

Cell["\[NonBreakingSpace]", "GuideAbstract",
 CellID->1],

Cell[TextData[{
 Cell[TextData[ButtonBox["Convert",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Convert"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " convert an expression to a form using specified units"
}], "GuideText",
 CellID->31721603],

Cell[TextData[{
 Cell[TextData[ButtonBox["SI",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/SI"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " convert an expression to SI units"
}], "GuideText",
 CellID->203374175],

Cell[TextData[{
 Cell[TextData[ButtonBox["MKS",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/MKS"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " convert an expression to meter/kilogram/second units"
}], "GuideText",
 CellID->124663],

Cell[TextData[{
 Cell[TextData[ButtonBox["CGS",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/CGS"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " convert an expression to centimeter/gram/second units"
}], "GuideText",
 CellID->758999392],

Cell["\t", "GuideDelimiterSubsection",
 CellID->42556254],

Cell[CellGroupData[{

Cell["SI Prefixes", "GuideFunctionsSubsection",
 CellID->13363392],

Cell[TextData[{
 Cell[TextData[ButtonBox["Atto",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Atto"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Centi",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Centi"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Deca",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Deca"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Deci",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Deci"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Exa",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Exa"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Femto",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Femto"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Giga",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Giga"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Hecto",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Hecto"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Kilo",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Kilo"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Mega",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Mega"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Micro",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Micro"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Milli",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Milli"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Nano",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Nano"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Peta",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Peta"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Pico",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Pico"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Tera",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Tera"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Yocto",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Yocto"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Yotta",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Yotta"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Zepto",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Zepto"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Zetta",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Zetta"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->624945770],

Cell["\t", "GuideDelimiterSubsection",
 CellID->311258892]
}, Open  ]],

Cell[CellGroupData[{

Cell["Length", "GuideFunctionsSubsection",
 CellID->152811561],

Cell[TextData[{
 Cell[TextData[ButtonBox["Angstrom",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Angstrom"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["AU",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/AU"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["AstronomicalUnit",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/AstronomicalUnit"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Bolt",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Bolt"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Cable",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Cable"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Caliber",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Caliber"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Centimeter",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Centimeter"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Chain",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Chain"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Cicero",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Cicero"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Cubit",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Cubit"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Didot",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Didot"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["DidotPoint",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/DidotPoint"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Diopter",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Diopter"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Ell",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Ell"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Fathom",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Fathom"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Feet",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Feet"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Fermi",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Fermi"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Foot",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Foot"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Furlong",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Furlong"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Hand",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Hand"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Inch",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Inch"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Kayser",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Kayser"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["League",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/League"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["LightYear",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/LightYear"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Link",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Link"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Meter",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Meter"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Micron",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Micron"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Mil",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Mil"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Mile",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Mile"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["NauticalMile",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/NauticalMile"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Parsec",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Parsec"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Perch",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Perch"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Pica",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Pica"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Pole",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Pole"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PrintersPoint",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/PrintersPoint"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Rod",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Rod"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Rope",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Rope"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Skein",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Skein"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Stadion",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Stadion"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Stadium",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Stadium"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["StatuteMile",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/StatuteMile"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SurveyMile",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/SurveyMile"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["XUnit",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/XUnit"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Yard",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Yard"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->58033752],

Cell["\t", "GuideDelimiterSubsection",
 CellID->404053002]
}, Open  ]],

Cell[CellGroupData[{

Cell["Mass and Weight", "GuideFunctionsSubsection",
 CellID->269969598],

Cell[TextData[{
 Cell[TextData[ButtonBox["AMU",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/AMU"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["AssayTon",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/AssayTon"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["AtomicMassUnit",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/AtomicMassUnit"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["AvoirdupoisOunce",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/AvoirdupoisOunce"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["AvoirdupoisPound",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/AvoirdupoisPound"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Bale",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Bale"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Carat",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Carat"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Cental",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Cental"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Dalton",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Dalton"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Drachma",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Drachma"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Geepound",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Geepound"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Grain",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Grain"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Gram",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Gram"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["GrossHundredweight",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/GrossHundredweight"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Hundredweight",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Hundredweight"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Kilogram",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Kilogram"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Libra",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Libra"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["LongTon",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/LongTon"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MetricTon",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/MetricTon"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Mina",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Mina"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["NetHundredweight",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/NetHundredweight"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Obolos",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Obolos"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Ounce",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Ounce"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Pennyweight",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Pennyweight"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Pondus",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Pondus"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Pound",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Pound"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Quintal",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Quintal"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Shekel",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Shekel"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ShortHundredweight",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/ShortHundredweight"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ShortTon",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/ShortTon"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Slug",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Slug"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SolarMass",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/SolarMass"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Stone",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Stone"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Talent",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Talent"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Ton",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Ton"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Tonne",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Tonne"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["TroyOunce",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/TroyOunce"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Wey",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Wey"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->212071038],

Cell["\t", "GuideDelimiterSubsection",
 CellID->412687159]
}, Open  ]],

Cell[CellGroupData[{

Cell["Temperature", "GuideFunctionsSubsection",
 CellID->281347196],

Cell[TextData[{
 Cell[TextData[ButtonBox["ConvertTemperature",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/ConvertTemperature"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " convert a temperature to a new temperature scale"
}], "GuideText",
 CellID->398017889],

Cell[TextData[{
 Cell[TextData[ButtonBox["Celsius",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Celsius"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Centigrade",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Centigrade"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Fahrenheit",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Fahrenheit"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Kelvin",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Kelvin"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Rankine",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Rankine"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->38105472],

Cell["\t", "GuideDelimiterSubsection",
 CellID->458748617]
}, Open  ]],

Cell[CellGroupData[{

Cell["Volume", "GuideFunctionsSubsection",
 CellID->184019578],

Cell[TextData[{
 Cell[TextData[ButtonBox["Bag",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Bag"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Barrel",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Barrel"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["BoardFoot",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/BoardFoot"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Bucket",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Bucket"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Bushel",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Bushel"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Butt",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Butt"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Cord",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Cord"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Ephah",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Ephah"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Fifth",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Fifth"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Firkin",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Firkin"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["FluidDram",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/FluidDram"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["FluidOunce",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/FluidOunce"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Gallon",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Gallon"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Gill",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Gill"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Hogshead",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Hogshead"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ImperialGallon",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/ImperialGallon"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ImperialPint",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/ImperialPint"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Jeroboam",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Jeroboam"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Jigger",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Jigger"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Liter",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Liter"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Magnum",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Magnum"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Minim",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Minim"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Noggin",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Noggin"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Omer",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Omer"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Peck",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Peck"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Pint",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Pint"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Pony",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Pony"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Puncheon",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Puncheon"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Quart",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Quart"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["RegisterTon",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/RegisterTon"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Seam",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Seam"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Shot",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Shot"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Stere",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Stere"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Tablespoon",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Tablespoon"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Teaspoon",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Teaspoon"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Tun",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Tun"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["UKGallon",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/UKGallon"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["UKPint",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/UKPint"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["WineBottle",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/WineBottle"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->9895413],

Cell["\t", "GuideDelimiterSubsection",
 CellID->4328243]
}, Open  ]],

Cell[CellGroupData[{

Cell["Area", "GuideFunctionsSubsection",
 CellID->804668177],

Cell[TextData[{
 Cell[TextData[ButtonBox["Acre",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Acre"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Are",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Are"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Barn",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Barn"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Hectare",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Hectare"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Rood",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Rood"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Section",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Section"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Township",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Township"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->163607375],

Cell["\t", "GuideDelimiterSubsection",
 CellID->3099481]
}, Open  ]],

Cell[CellGroupData[{

Cell["Time", "GuideFunctionsSubsection",
 CellID->337379640],

Cell[TextData[{
 Cell[TextData[ButtonBox["Century",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Century"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Day",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Day"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Decade",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Decade"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Fortnight",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Fortnight"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Hour",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Hour"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Millennium",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Millennium"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Minute",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Minute"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Month",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Month"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SiderealSecond",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/SiderealSecond"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SiderealYear",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/SiderealYear"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["TropicalYear",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/TropicalYear"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Week",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Week"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Year",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Year"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->297816772],

Cell["\t", "GuideDelimiterSubsection",
 CellID->20257942]
}, Open  ]],

Cell[CellGroupData[{

Cell["Force, Energy, and Power", "GuideFunctionsSubsection",
 CellID->340895725],

Cell[TextData[{
 Cell[TextData[ButtonBox["BritishThermalUnit",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/BritishThermalUnit"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["BTU",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/BTU"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Calorie",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Calorie"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ChevalVapeur",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/ChevalVapeur"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Dyne",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Dyne"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ElectronVolt",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/ElectronVolt"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Erg",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Erg"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["GramWeight",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/GramWeight"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Horsepower",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Horsepower"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Joule",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Joule"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["KilogramForce",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/KilogramForce"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["KilogramWeight",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/KilogramWeight"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Poundal",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Poundal"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PoundForce",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/PoundForce"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PoundWeight",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/PoundWeight"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Rydberg",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Rydberg"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Therm",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Therm"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[{
  ButtonBox["TonForce",
   BaseStyle->"Link",
   ButtonData->"paclet:Units/ref/TonForce"],
  ButtonBox[" ",
   BaseStyle->"Link",
   ButtonData->"paclet:Units/ref/TonForce"]
 }], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Watt",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Watt"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->10941952],

Cell["\t", "GuideDelimiterSubsection",
 CellID->84794720]
}, Open  ]],

Cell[CellGroupData[{

Cell["Pressure", "GuideFunctionsSubsection",
 CellID->126014810],

Cell[TextData[{
 Cell[TextData[ButtonBox["Atmosphere",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Atmosphere"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Bar",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Bar"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Barye",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Barye"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["InchMercury",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/InchMercury"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MillimeterMercury",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/MillimeterMercury"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Pascal",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Pascal"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PoundsPerSquareInch",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/PoundsPerSquareInch"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PSI",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/PSI"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Torr",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Torr"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->210969856],

Cell["\t", "GuideDelimiterSubsection",
 CellID->48977210]
}, Open  ]],

Cell[CellGroupData[{

Cell["Electromagnetism", "GuideFunctionsSubsection",
 CellID->208163899],

Cell[TextData[{
 Cell[TextData[ButtonBox["Abampere",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Abampere"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Abcoulomb",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Abcoulomb"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Abfarad",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Abfarad"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Abhenry",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Abhenry"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Abmho",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Abmho"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Abohm",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Abohm"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Abvolt",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Abvolt"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Amp",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Amp"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Ampere",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Ampere"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Biot",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Biot"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["BohrMagneton",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/BohrMagneton"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Coulomb",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Coulomb"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Farad",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Farad"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Gauss",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Gauss"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Gilbert",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Gilbert"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Henry",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Henry"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Maxwell",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Maxwell"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Mho",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Mho"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["NuclearMagneton",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/NuclearMagneton"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Oersted",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Oersted"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Ohm",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Ohm"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Siemens",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Siemens"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Statampere",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Statampere"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Statcoulomb",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Statcoulomb"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Statfarad",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Statfarad"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Stathenry",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Stathenry"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Statohm",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Statohm"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[{
  ButtonBox["Statvolt",
   BaseStyle->"Link",
   ButtonData->"paclet:Units/ref/Statvolt"],
  ButtonBox[" ",
   BaseStyle->"Link",
   ButtonData->"paclet:Units/ref/Statvolt"]
 }], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Tesla",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Tesla"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[{
  ButtonBox["Volt",
   BaseStyle->"Link",
   ButtonData->"paclet:Units/ref/Volt"],
  ButtonBox[" ",
   BaseStyle->"Link",
   ButtonData->"paclet:Units/ref/Volt"]
 }], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Weber",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Weber"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->467840077],

Cell["\t", "GuideDelimiterSubsection",
 CellID->468498090]
}, Open  ]],

Cell[CellGroupData[{

Cell["Illumination", "GuideFunctionsSubsection",
 CellID->115027784],

Cell[TextData[{
 Cell[TextData[ButtonBox["Apostilb",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Apostilb"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Candela",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Candela"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Candle",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Candle"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["FootCandle",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/FootCandle"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Hefner",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Hefner"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Lambert",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Lambert"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Lumerg",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Lumerg"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Lumen",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Lumen"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Lux",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Lux"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Nit",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Nit"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Phot",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Phot"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Stilb",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Stilb"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Talbot",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Talbot"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->7723732],

Cell["\t", "GuideDelimiterSubsection",
 CellID->42444898]
}, Open  ]],

Cell[CellGroupData[{

Cell["Information", "GuideFunctionsSubsection",
 CellID->768924972],

Cell[TextData[{
 Cell[TextData[ButtonBox["Baud",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Baud"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Bit",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Bit"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Nibble",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Nibble"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->188401304],

Cell["\t", "GuideDelimiterSubsection",
 CellID->169563543]
}, Open  ]],

Cell[CellGroupData[{

Cell["Radiation", "GuideFunctionsSubsection",
 CellID->166125436],

Cell[TextData[{
 Cell[TextData[ButtonBox["Becquerel",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Becquerel"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[{
  ButtonBox[" ",
   BaseStyle->"Link",
   ButtonData->"paclet:Units/ref/Curie"],
  ButtonBox["Curie",
   BaseStyle->"Link",
   ButtonData->"paclet:Units/ref/Curie"]
 }], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["GrayDose",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/GrayDose"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Rad",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Rad"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Roentgen",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Roentgen"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Rontgen",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Rontgen"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Rutherford",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Rutherford"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->103092267],

Cell["\t", "GuideDelimiterSubsection",
 CellID->445830291]
}, Open  ]],

Cell[CellGroupData[{

Cell["Viscosity", "GuideFunctionsSubsection",
 CellID->202463510],

Cell[TextData[{
 Cell[TextData[ButtonBox["Poise",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Poise"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Reyn",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Reyn"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Rhes",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Rhes"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Stokes",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Stokes"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->96722003],

Cell["\t", "GuideDelimiterSubsection",
 CellID->432138372]
}, Open  ]],

Cell[CellGroupData[{

Cell["Unit Multipliers", "GuideFunctionsSubsection",
 CellID->166696965],

Cell[TextData[{
 Cell[TextData[ButtonBox["ArcMinute",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/ArcMinute"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ArcSecond",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/ArcSecond"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["BakersDozen",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/BakersDozen"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Dozen",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Dozen"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Grade",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Grade"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Gross",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Gross"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Percent",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Percent"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Quadrant",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Quadrant"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["RightAngle",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/RightAngle"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->222033743],

Cell["\t", "GuideDelimiterSubsection",
 CellID->629022147]
}, Open  ]],

Cell[CellGroupData[{

Cell["Others", "GuideFunctionsSubsection",
 CellID->314245727],

Cell[TextData[{
 Cell[TextData[ButtonBox["Denier",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Denier"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Gal",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Gal"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Gravity",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Gravity"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Hertz",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Hertz"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Knot",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Knot"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Mole",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Mole"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Radian",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Radian"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Steradian",
  BaseStyle->"Link",
  ButtonData->"paclet:Units/ref/Steradian"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->149111280]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "GuideTutorial",
 CellID->348812827]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[{
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/DataCollections"],
  FontSlant->"Italic"],
 ButtonBox[" Data Collections",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/DataCollections"]
}], "GuideMoreAbout",
 CellID->241203317]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Units Package - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 8, 43.2251064}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Guide", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> 
    "Convert -- convert an expression to a form using specified units, SI -- \
convert an expression to SI units, MKS -- convert an expression to \
meter/kilogram/second units, CGS -- convert an expression to \
centimeter/gram/second units, ConvertTemperature -- convert a temperature to \
a new temperature scale", "synonyms" -> {}, "title" -> "Units Package", 
    "type" -> "Guide", "uri" -> "Units/guide/UnitsPackage"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 55, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[677, 28, 56, 1, 70, "GuideAbstract",
 CellID->1],
Cell[736, 31, 280, 8, 70, "GuideText",
 CellID->31721603],
Cell[1019, 41, 251, 8, 70, "GuideText",
 CellID->203374175],
Cell[1273, 51, 269, 8, 70, "GuideText",
 CellID->124663],
Cell[1545, 61, 273, 8, 70, "GuideText",
 CellID->758999392],
Cell[1821, 71, 57, 1, 70, "GuideDelimiterSubsection",
 CellID->42556254],
Cell[CellGroupData[{
Cell[1903, 76, 66, 1, 70, "GuideFunctionsSubsection",
 CellID->13363392],
Cell[1972, 79, 4116, 119, 70, "InlineGuideFunctionListing",
 CellID->624945770],
Cell[6091, 200, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->311258892]
}, Open  ]],
Cell[CellGroupData[{
Cell[6186, 206, 62, 1, 70, "GuideFunctionsSubsection",
 CellID->152811561],
Cell[6251, 209, 9231, 263, 70, "InlineGuideFunctionListing",
 CellID->58033752],
Cell[15485, 474, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->404053002]
}, Open  ]],
Cell[CellGroupData[{
Cell[15580, 480, 71, 1, 70, "GuideFunctionsSubsection",
 CellID->269969598],
Cell[15654, 483, 8100, 227, 70, "InlineGuideFunctionListing",
 CellID->212071038],
Cell[23757, 712, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->412687159]
}, Open  ]],
Cell[CellGroupData[{
Cell[23852, 718, 67, 1, 70, "GuideFunctionsSubsection",
 CellID->281347196],
Cell[23922, 721, 298, 8, 70, "GuideText",
 CellID->398017889],
Cell[24223, 731, 1049, 29, 70, "InlineGuideFunctionListing",
 CellID->38105472],
Cell[25275, 762, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->458748617]
}, Open  ]],
Cell[CellGroupData[{
Cell[25370, 768, 62, 1, 70, "GuideFunctionsSubsection",
 CellID->184019578],
Cell[25435, 771, 8202, 233, 70, "InlineGuideFunctionListing",
 CellID->9895413],
Cell[33640, 1006, 56, 1, 70, "GuideDelimiterSubsection",
 CellID->4328243]
}, Open  ]],
Cell[CellGroupData[{
Cell[33733, 1012, 60, 1, 70, "GuideFunctionsSubsection",
 CellID->804668177],
Cell[33796, 1015, 1440, 41, 70, "InlineGuideFunctionListing",
 CellID->163607375],
Cell[35239, 1058, 56, 1, 70, "GuideDelimiterSubsection",
 CellID->3099481]
}, Open  ]],
Cell[CellGroupData[{
Cell[35332, 1064, 60, 1, 70, "GuideFunctionsSubsection",
 CellID->337379640],
Cell[35395, 1067, 2746, 77, 70, "InlineGuideFunctionListing",
 CellID->297816772],
Cell[38144, 1146, 57, 1, 70, "GuideDelimiterSubsection",
 CellID->20257942]
}, Open  ]],
Cell[CellGroupData[{
Cell[38238, 1152, 80, 1, 70, "GuideFunctionsSubsection",
 CellID->340895725],
Cell[38321, 1155, 4160, 118, 70, "InlineGuideFunctionListing",
 CellID->10941952],
Cell[42484, 1275, 57, 1, 70, "GuideDelimiterSubsection",
 CellID->84794720]
}, Open  ]],
Cell[CellGroupData[{
Cell[42578, 1281, 64, 1, 70, "GuideFunctionsSubsection",
 CellID->126014810],
Cell[42645, 1284, 1921, 54, 70, "InlineGuideFunctionListing",
 CellID->210969856],
Cell[44569, 1340, 57, 1, 70, "GuideDelimiterSubsection",
 CellID->48977210]
}, Open  ]],
Cell[CellGroupData[{
Cell[44663, 1346, 72, 1, 70, "GuideFunctionsSubsection",
 CellID->208163899],
Cell[44738, 1349, 6722, 195, 70, "InlineGuideFunctionListing",
 CellID->467840077],
Cell[51463, 1546, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->468498090]
}, Open  ]],
Cell[CellGroupData[{
Cell[51558, 1552, 68, 1, 70, "GuideFunctionsSubsection",
 CellID->115027784],
Cell[51629, 1555, 2704, 77, 70, "InlineGuideFunctionListing",
 CellID->7723732],
Cell[54336, 1634, 57, 1, 70, "GuideDelimiterSubsection",
 CellID->42444898]
}, Open  ]],
Cell[CellGroupData[{
Cell[54430, 1640, 67, 1, 70, "GuideFunctionsSubsection",
 CellID->768924972],
Cell[54500, 1643, 600, 17, 70, "InlineGuideFunctionListing",
 CellID->188401304],
Cell[55103, 1662, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->169563543]
}, Open  ]],
Cell[CellGroupData[{
Cell[55198, 1668, 65, 1, 70, "GuideFunctionsSubsection",
 CellID->166125436],
Cell[55266, 1671, 1556, 46, 70, "InlineGuideFunctionListing",
 CellID->103092267],
Cell[56825, 1719, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->445830291]
}, Open  ]],
Cell[CellGroupData[{
Cell[56920, 1725, 65, 1, 70, "GuideFunctionsSubsection",
 CellID->202463510],
Cell[56988, 1728, 809, 23, 70, "InlineGuideFunctionListing",
 CellID->96722003],
Cell[57800, 1753, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->432138372]
}, Open  ]],
Cell[CellGroupData[{
Cell[57895, 1759, 72, 1, 70, "GuideFunctionsSubsection",
 CellID->166696965],
Cell[57970, 1762, 1900, 53, 70, "InlineGuideFunctionListing",
 CellID->222033743],
Cell[59873, 1817, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->629022147]
}, Open  ]],
Cell[CellGroupData[{
Cell[59968, 1823, 62, 1, 70, "GuideFunctionsSubsection",
 CellID->314245727],
Cell[60033, 1826, 1652, 47, 70, "InlineGuideFunctionListing",
 CellID->149111280]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[61734, 1879, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[61799, 1882, 143, 3, 70, "GuideTutorial",
 CellID->348812827]
}, Open  ]],
Cell[CellGroupData[{
Cell[61979, 1890, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[62044, 1893, 283, 9, 70, "GuideMoreAbout",
 CellID->241203317]
}, Open  ]],
Cell[62342, 1905, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

