(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7218,        260]
NotebookOptionsPosition[      5532,        204]
NotebookOutlinePosition[      6465,        231]
CellTagsIndexPosition[      6422,        228]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Dalton" :> Documentation`HelpLookup["paclet:Units/ref/Dalton"],
           "Gram" :> Documentation`HelpLookup["paclet:Units/ref/Gram"], 
          "AvogadroConstant" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/AvogadroConstant"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Dalton\"\>", 2->"\<\"Gram\"\>", 
       3->"\<\"AvogadroConstant\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["AMU", "ObjectName",
 CellID->7477],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["AMU"], "InlineFormula"],
     " \[LineSeparator]is a unit of mass. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->7979]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["AMU"], "InlineFormula"],
 " an abbreviation for ",
 Cell[BoxData[
  ButtonBox["AtomicMassUnit",
   BaseStyle->"Link",
   ButtonData->"paclet:Units/ref/AtomicMassUnit"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->249092006],

Cell[TextData[{
 Cell[BoxData["AMU"], "InlineFormula"],
 " is equivalent to approximately ",
 Cell[BoxData[
  RowBox[{"1.66054*^-27", " ", 
   ButtonBox["Kilogram",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Kilogram"]}]], "InlineFormula"],
 " (SI units)."
}], "Notes",
 CellID->6556],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Convert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Convert"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["n", "TI"], " ", "AMU"}], ",", 
    StyleBox["newunits", "TI"]}], "]"}]], "InlineFormula"],
 "converts ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], " ", "AMU"}]], "InlineFormula"],
 " to a form involving units ",
 Cell[BoxData[
  StyleBox["newunits", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->25021]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->4533],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Dalton",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Dalton"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Gram",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Gram"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AvogadroConstant",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/AvogadroConstant"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->4580]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->31145],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->23787]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"AMU - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 8, 50.8815524}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "AMU is a unit of mass. ", "synonyms" -> {}, "title" -> 
    "AMU", "type" -> "Symbol", "uri" -> "Units/ref/AMU"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1373, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1996, 61, 40, 1, 70, "ObjectName",
 CellID->7477],
Cell[2039, 64, 311, 10, 70, "Usage",
 CellID->7979]
}, Open  ]],
Cell[CellGroupData[{
Cell[2387, 79, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2865, 96, 256, 9, 70, "Notes",
 CellID->249092006],
Cell[3124, 107, 298, 10, 70, "Notes",
 CellID->6556],
Cell[3425, 119, 497, 19, 70, "Notes",
 CellID->25021]
}, Closed]],
Cell[CellGroupData[{
Cell[3959, 143, 310, 9, 70, "SeeAlsoSection",
 CellID->4533],
Cell[4272, 154, 729, 26, 70, "SeeAlso",
 CellID->4580]
}, Open  ]],
Cell[CellGroupData[{
Cell[5038, 185, 314, 9, 70, "TutorialsSection",
 CellID->31145],
Cell[5355, 196, 135, 3, 70, "Tutorials",
 CellID->23787]
}, Open  ]],
Cell[5505, 202, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

