(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6440,        233]
NotebookOptionsPosition[      4697,        176]
NotebookOutlinePosition[      5687,        204]
CellTagsIndexPosition[      5644,        201]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Statcoulomb" :> 
          Documentation`HelpLookup["paclet:Units/ref/Statcoulomb"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Statcoulomb\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Abcoulomb", "ObjectName",
 CellID->6700],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Abcoulomb"], "InlineFormula"],
     " \[LineSeparator]is a unit of electric charge in the CGS system."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->2404]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Abcoulomb"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{"10", " ", 
   ButtonBox["Coulomb",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Coulomb"]}]], "InlineFormula"],
 " (SI units)."
}], "Notes",
 CellID->18199],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Convert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Convert"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["n", "TI"], " ", "Abcoulomb"}], ",", 
    StyleBox["newunits", "TI"]}], "]"}]], "InlineFormula"],
 "converts ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], " ", "Abcoulomb"}]], "InlineFormula"],
 " to a form involving units ",
 Cell[BoxData[
  StyleBox["newunits", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->26201],

Cell[TextData[{
 Cell[BoxData["Abcoulomb"], "InlineFormula"],
 " is typically abbreviated as abC or aC."
}], "Notes",
 CellID->28526300]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->22137],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["Statcoulomb",
   BaseStyle->"Link",
   ButtonData->"paclet:Units/ref/Statcoulomb"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->28226]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->20528],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->2507]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Abcoulomb - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 8, 43.8657478}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "Abcoulomb is a unit of electric charge in the CGS system.", 
    "synonyms" -> {}, "title" -> "Abcoulomb", "type" -> "Symbol", "uri" -> 
    "Units/ref/Abcoulomb"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1146, 31, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1769, 58, 46, 1, 70, "ObjectName",
 CellID->6700],
Cell[1818, 61, 345, 10, 70, "Usage",
 CellID->2404]
}, Open  ]],
Cell[CellGroupData[{
Cell[2200, 76, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2678, 93, 279, 10, 70, "Notes",
 CellID->18199],
Cell[2960, 105, 509, 19, 70, "Notes",
 CellID->26201],
Cell[3472, 126, 136, 4, 70, "Notes",
 CellID->28526300]
}, Closed]],
Cell[CellGroupData[{
Cell[3645, 135, 311, 9, 70, "SeeAlsoSection",
 CellID->22137],
Cell[3959, 146, 208, 6, 70, "SeeAlso",
 CellID->28226]
}, Open  ]],
Cell[CellGroupData[{
Cell[4204, 157, 314, 9, 70, "TutorialsSection",
 CellID->20528],
Cell[4521, 168, 134, 3, 70, "Tutorials",
 CellID->2507]
}, Open  ]],
Cell[4670, 174, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

