(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6529,        238]
NotebookOptionsPosition[      4799,        181]
NotebookOutlinePosition[      5777,        209]
CellTagsIndexPosition[      5734,        206]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Statohm" :> 
          Documentation`HelpLookup["paclet:Units/ref/Statohm"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Statohm\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Abohm", "ObjectName",
 CellID->1277],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Abohm"], "InlineFormula"],
     " \[LineSeparator]is a unit of electric resistance in the CGS system."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->1067]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Abohm"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["10", 
    RowBox[{"-", "9"}]], " ", 
   ButtonBox["Ohm",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Abohm"]}]], "InlineFormula"],
 " (SI units)."
}], "Notes",
 CellID->24123],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Convert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Convert"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["n", "TI"], " ", "Abohm"}], ",", 
    StyleBox["newunits", "TI"]}], "]"}]], "InlineFormula"],
 "converts ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], " ", "Abohm"}]], "InlineFormula"],
 " to a form involving units ",
 Cell[BoxData[
  StyleBox["newunits", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->7918],

Cell[TextData[{
 Cell[BoxData["Abohm"], "InlineFormula"],
 " is typically abbreviated as ",
 Cell[BoxData["ab\[CapitalOmega]"], "InlineFormula"],
 " or ",
 Cell[BoxData["a\[CapitalOmega]"], "InlineFormula"],
 "."
}], "Notes",
 CellID->179905296]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->23438],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["Statohm",
   BaseStyle->"Link",
   ButtonData->"paclet:Units/ref/Statohm"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->8516]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->12060],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->2797]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Abohm - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 8, 44.5376400}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "Abohm is a unit of electric resistance in the CGS system.", 
    "synonyms" -> {}, "title" -> "Abohm", "type" -> "Symbol", "uri" -> 
    "Units/ref/Abohm"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1126, 30, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1749, 57, 42, 1, 70, "ObjectName",
 CellID->1277],
Cell[1794, 60, 345, 10, 70, "Usage",
 CellID->1067]
}, Open  ]],
Cell[CellGroupData[{
Cell[2176, 75, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2654, 92, 314, 12, 70, "Notes",
 CellID->24123],
Cell[2971, 106, 500, 19, 70, "Notes",
 CellID->7918],
Cell[3474, 127, 245, 8, 70, "Notes",
 CellID->179905296]
}, Closed]],
Cell[CellGroupData[{
Cell[3756, 140, 311, 9, 70, "SeeAlsoSection",
 CellID->23438],
Cell[4070, 151, 199, 6, 70, "SeeAlso",
 CellID->8516]
}, Open  ]],
Cell[CellGroupData[{
Cell[4306, 162, 314, 9, 70, "TutorialsSection",
 CellID->12060],
Cell[4623, 173, 134, 3, 70, "Tutorials",
 CellID->2797]
}, Open  ]],
Cell[4772, 179, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

