(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8209,        296]
NotebookOptionsPosition[      6464,        238]
NotebookOutlinePosition[      7400,        265]
CellTagsIndexPosition[      7357,        262]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Rood" :> Documentation`HelpLookup["paclet:Units/ref/Rood"], 
          "Are" :> Documentation`HelpLookup["paclet:Units/ref/Are"], 
          "Section" :> Documentation`HelpLookup["paclet:Units/ref/Section"], 
          "Township" :> Documentation`HelpLookup["paclet:Units/ref/Township"],
           "Barn" :> Documentation`HelpLookup["paclet:Units/ref/Barn"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Rood\"\>", 2->"\<\"Are\"\>", 
       3->"\<\"Section\"\>", 4->"\<\"Township\"\>", 
       5->"\<\"Barn\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Acre", "ObjectName",
 CellID->10534],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Acre"], "InlineFormula"],
     " \[LineSeparator]is a unit of area."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->31592]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Acre"], "InlineFormula"],
 " is equivalent to approximately ",
 Cell[BoxData[
  RowBox[{"4046.86", " ", 
   SuperscriptBox[
    ButtonBox["Meter",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Meter"], "2"]}]], "InlineFormula"],
 " (SI units)."
}], "Notes",
 CellID->6214],

Cell[TextData[{
 Cell[BoxData["Acre"], "InlineFormula"],
 " is equivalent to approximately ",
 Cell[BoxData[
  RowBox[{"0.404686", " ", 
   ButtonBox["Hectare",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Hectare"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->12525],

Cell[TextData[{
 Cell[BoxData["Acre"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{"43560", " ", 
   SuperscriptBox[
    ButtonBox["Foot",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Foot"], "2"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->23204],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Convert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Convert"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["n", "TI"], " ", "Acre"}], ",", 
    StyleBox["newunits", "TI"]}], "]"}]], "InlineFormula"],
 "converts ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], " ", "Acre"}]], "InlineFormula"],
 " to a form involving units ",
 Cell[BoxData[
  StyleBox["newunits", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->32301]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->32691],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Rood",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Rood"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Are",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Are"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Section",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Section"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Township",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Township"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Barn",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Barn"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->13140]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->32373],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->5663]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Acre - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 8, 44.8813988}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "Acre is a unit of area.", "synonyms" -> {}, "title" -> 
    "Acre", "type" -> "Symbol", "uri" -> "Units/ref/Acre"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1505, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2128, 62, 42, 1, 70, "ObjectName",
 CellID->10534],
Cell[2173, 65, 312, 10, 70, "Usage",
 CellID->31592]
}, Open  ]],
Cell[CellGroupData[{
Cell[2522, 80, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3000, 97, 316, 11, 70, "Notes",
 CellID->6214],
Cell[3319, 110, 283, 10, 70, "Notes",
 CellID->12525],
Cell[3605, 122, 288, 11, 70, "Notes",
 CellID->23204],
Cell[3896, 135, 499, 19, 70, "Notes",
 CellID->32301]
}, Closed]],
Cell[CellGroupData[{
Cell[4432, 159, 311, 9, 70, "SeeAlsoSection",
 CellID->32691],
Cell[4746, 170, 1188, 44, 70, "SeeAlso",
 CellID->13140]
}, Open  ]],
Cell[CellGroupData[{
Cell[5971, 219, 314, 9, 70, "TutorialsSection",
 CellID->32373],
Cell[6288, 230, 134, 3, 70, "Tutorials",
 CellID->5663]
}, Open  ]],
Cell[6437, 236, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

