(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7705,        280]
NotebookOptionsPosition[      5907,        221]
NotebookOutlinePosition[      6894,        249]
CellTagsIndexPosition[      6851,        246]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Stilb" :> Documentation`HelpLookup["paclet:Units/ref/Stilb"], 
          "Nit" :> Documentation`HelpLookup["paclet:Units/ref/Nit"], 
          "Candela" :> 
          Documentation`HelpLookup["paclet:Units/ref/Candela"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Stilb\"\>", 2->"\<\"Nit\"\>", 
       3->"\<\"Candela\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Apostilb", "ObjectName",
 CellID->3608],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Apostilb"], "InlineFormula"],
     " \[LineSeparator]is a unit of luminance (photometric brightness)."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->14718]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Apostilb"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Candela",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Candela"], "/", 
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox[
      ButtonBox["Meter",
       BaseStyle->"Link",
       ButtonData->"paclet:Units/ref/Meter"], "2"], " ", 
     ButtonBox["Pi",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Pi"]}], ")"}]}]], "InlineFormula"],
 " (SI units)."
}], "Notes",
 CellID->28930],

Cell[TextData[{
 Cell[BoxData["Apostilb"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["10", 
    RowBox[{"-", "4"}]], " ", 
   ButtonBox["Lambert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Lambert"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->24703],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Convert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Convert"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["n", "TI"], " ", "Apostilb"}], ",", 
    StyleBox["newunits", "TI"]}], "]"}]], "InlineFormula"],
 "converts ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], " ", "Apostilb"}]], "InlineFormula"],
 " to a form involving units ",
 Cell[BoxData[
  StyleBox["newunits", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->18010],

Cell[TextData[{
 Cell[BoxData["Apostilb"], "InlineFormula"],
 " is typically abbreviated as asb."
}], "Notes",
 CellID->669496215]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->30486],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Stilb",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Stilb"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Nit",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Nit"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Candela",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Candela"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->28905]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->21642],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->5284]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Apostilb - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 8, 51.2253112}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "Apostilb is a unit of luminance (photometric brightness).", 
    "synonyms" -> {}, "title" -> "Apostilb", "type" -> "Symbol", "uri" -> 
    "Units/ref/Apostilb"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1316, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1939, 60, 45, 1, 70, "ObjectName",
 CellID->3608],
Cell[1987, 63, 346, 10, 70, "Usage",
 CellID->14718]
}, Open  ]],
Cell[CellGroupData[{
Cell[2370, 78, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2848, 95, 524, 19, 70, "Notes",
 CellID->28930],
Cell[3375, 116, 312, 12, 70, "Notes",
 CellID->24703],
Cell[3690, 130, 507, 19, 70, "Notes",
 CellID->18010],
Cell[4200, 151, 130, 4, 70, "Notes",
 CellID->669496215]
}, Closed]],
Cell[CellGroupData[{
Cell[4367, 160, 311, 9, 70, "SeeAlsoSection",
 CellID->30486],
Cell[4681, 171, 696, 26, 70, "SeeAlso",
 CellID->28905]
}, Open  ]],
Cell[CellGroupData[{
Cell[5414, 202, 314, 9, 70, "TutorialsSection",
 CellID->21642],
Cell[5731, 213, 134, 3, 70, "Tutorials",
 CellID->5284]
}, Open  ]],
Cell[5880, 219, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

