(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8607,        300]
NotebookOptionsPosition[      6885,        243]
NotebookOutlinePosition[      7854,        271]
CellTagsIndexPosition[      7811,        268]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Bar" :> Documentation`HelpLookup["paclet:Units/ref/Bar"], 
          "Torr" :> Documentation`HelpLookup["paclet:Units/ref/Torr"], 
          "InchMercury" :> 
          Documentation`HelpLookup["paclet:Units/ref/InchMercury"], "PSI" :> 
          Documentation`HelpLookup["paclet:Units/ref/PSI"], "Barye" :> 
          Documentation`HelpLookup["paclet:Units/ref/Barye"], 
          "MillimeterMercury" :> 
          Documentation`HelpLookup["paclet:Units/ref/MillimeterMercury"], 
          "PoundsPerSquareInch" :> 
          Documentation`HelpLookup[
           "paclet:Units/ref/PoundsPerSquareInch"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Bar\"\>", 2->"\<\"Torr\"\>", 
       3->"\<\"InchMercury\"\>", 4->"\<\"PSI\"\>", 5->"\<\"Barye\"\>", 
       6->"\<\"MillimeterMercury\"\>", 
       7->"\<\"PoundsPerSquareInch\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Atmosphere", "ObjectName",
 CellID->1708],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Atmosphere"], "InlineFormula"],
     " \[LineSeparator]is a unit of pressure."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->7891]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Atmosphere"], "InlineFormula"],
 " is equivalent to approximately ",
 Cell[BoxData[
  RowBox[{"101325.", " ", 
   ButtonBox["Pascal",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Pascal"]}]], "InlineFormula"],
 " (SI units)."
}], "Notes",
 CellID->21821],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Convert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Convert"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["n", "TI"], " ", "Atmosphere"}], ",", 
    StyleBox["newunits", "TI"]}], "]"}]], "InlineFormula"],
 "converts ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], " ", "Atmosphere"}]], "InlineFormula"],
 " to a form involving units ",
 Cell[BoxData[
  StyleBox["newunits", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->13006],

Cell[TextData[{
 Cell[BoxData["Atmosphere"], "InlineFormula"],
 " is typically abbreviated as atm."
}], "Notes",
 CellID->24416]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1912],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Bar",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Bar"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Torr",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Torr"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InchMercury",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/InchMercury"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PSI",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/PSI"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Barye",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Barye"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MillimeterMercury",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/MillimeterMercury"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PoundsPerSquareInch",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/PoundsPerSquareInch"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->31686]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->29386],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->29277]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Atmosphere - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 8, 58.6942524}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "Atmosphere is a unit of pressure.", "synonyms" -> {}, 
    "title" -> "Atmosphere", "type" -> "Symbol", "uri" -> 
    "Units/ref/Atmosphere"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1823, 42, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2446, 69, 47, 1, 70, "ObjectName",
 CellID->1708],
Cell[2496, 72, 321, 10, 70, "Usage",
 CellID->7891]
}, Open  ]],
Cell[CellGroupData[{
Cell[2854, 87, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3332, 104, 297, 10, 70, "Notes",
 CellID->21821],
Cell[3632, 116, 511, 19, 70, "Notes",
 CellID->13006],
Cell[4146, 137, 128, 4, 70, "Notes",
 CellID->24416]
}, Closed]],
Cell[CellGroupData[{
Cell[4311, 146, 310, 9, 70, "SeeAlsoSection",
 CellID->1912],
Cell[4624, 157, 1730, 62, 70, "SeeAlso",
 CellID->31686]
}, Open  ]],
Cell[CellGroupData[{
Cell[6391, 224, 314, 9, 70, "TutorialsSection",
 CellID->29386],
Cell[6708, 235, 135, 3, 70, "Tutorials",
 CellID->29277]
}, Open  ]],
Cell[6858, 241, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

