(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7238,        262]
NotebookOptionsPosition[      5448,        203]
NotebookOutlinePosition[      6432,        231]
CellTagsIndexPosition[      6389,        228]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NuclearMagneton" :> 
          Documentation`HelpLookup["paclet:Units/ref/NuclearMagneton"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"NuclearMagneton\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["BohrMagneton", "ObjectName",
 CellID->15423],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["BohrMagneton"], "InlineFormula"],
     " \[LineSeparator]is a unit of magnetic moment."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->3164]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["BohrMagneton"], "InlineFormula"],
 " is typically abbreviated as ",
 Cell[BoxData[
  SubscriptBox["\[Mu]", "B"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->418165591],

Cell[TextData[{
 Cell[BoxData["BohrMagneton"], "InlineFormula"],
 " is equivalent to approximately ",
 Cell[BoxData[
  RowBox[{"9.2740154", "\[Times]", 
   SuperscriptBox["10", 
    RowBox[{"-", "24"}]], " ", 
   RowBox[{
    ButtonBox["Joule",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Joule"], "/", 
    ButtonBox["Tesla",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Tesla"]}]}]], "InlineFormula"],
 " (SI units)."
}], "Notes",
 CellID->13767],

Cell[TextData[{
 Cell[BoxData["BohrMagneton"], "InlineFormula"],
 " is equivalent to approximately ",
 Cell[BoxData[
  RowBox[{"9.2740154", "\[Times]", 
   SuperscriptBox["10", 
    RowBox[{"-", "21"}]], " ", 
   RowBox[{
    ButtonBox["Erg",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Erg"], "/", 
    ButtonBox["Gauss",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Gauss"]}]}]], "InlineFormula"],
 " (CGS units)."
}], "Notes",
 CellID->23030],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Convert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Convert"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["n", "TI"], " ", "BohrMagneton"}], ",", 
    StyleBox["newunits", "TI"]}], "]"}]], "InlineFormula"],
 "converts ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], " ", "BohrMagneton"}]], "InlineFormula"],
 " to a form involving units ",
 Cell[BoxData[
  StyleBox["newunits", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->772]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->7419],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["NuclearMagneton",
   BaseStyle->"Link",
   ButtonData->"paclet:Units/ref/NuclearMagneton"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->23643]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->8756],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->9226]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"BohrMagneton - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 9, 14.8040398}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "BohrMagneton is a unit of magnetic moment.", 
    "synonyms" -> {}, "title" -> "BohrMagneton", "type" -> "Symbol", "uri" -> 
    "Units/ref/BohrMagneton"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1159, 31, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1782, 58, 50, 1, 70, "ObjectName",
 CellID->15423],
Cell[1835, 61, 330, 10, 70, "Usage",
 CellID->3164]
}, Open  ]],
Cell[CellGroupData[{
Cell[2202, 76, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2680, 93, 200, 7, 70, "Notes",
 CellID->418165591],
Cell[2883, 102, 477, 16, 70, "Notes",
 CellID->13767],
Cell[3363, 120, 474, 16, 70, "Notes",
 CellID->23030],
Cell[3840, 138, 513, 19, 70, "Notes",
 CellID->772]
}, Closed]],
Cell[CellGroupData[{
Cell[4390, 162, 310, 9, 70, "SeeAlsoSection",
 CellID->7419],
Cell[4703, 173, 216, 6, 70, "SeeAlso",
 CellID->23643]
}, Open  ]],
Cell[CellGroupData[{
Cell[4956, 184, 313, 9, 70, "TutorialsSection",
 CellID->8756],
Cell[5272, 195, 134, 3, 70, "Tutorials",
 CellID->9226]
}, Open  ]],
Cell[5421, 201, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

