(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7355,        268]
NotebookOptionsPosition[      5601,        210]
NotebookOutlinePosition[      6543,        237]
CellTagsIndexPosition[      6500,        234]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Grain" :> Documentation`HelpLookup["paclet:Units/ref/Grain"], 
          "Ounce" :> Documentation`HelpLookup["paclet:Units/ref/Ounce"], 
          "Pennyweight" :> 
          Documentation`HelpLookup["paclet:Units/ref/Pennyweight"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Grain\"\>", 2->"\<\"Ounce\"\>", 
       3->"\<\"Pennyweight\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Carat", "ObjectName",
 CellID->18152],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Carat"], "InlineFormula"],
     " \[LineSeparator]is a unit of weight."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->28468]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Carat"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{"0.0002", " ", 
   ButtonBox["Kilogram",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Carat"]}]], "InlineFormula"],
 " (SI units)."
}], "Notes",
 CellID->13626],

Cell[TextData[{
 Cell[BoxData["Carat"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{"0.2", " ", 
   ButtonBox["Gram",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Gram"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->4696],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Convert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Convert"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["n", "TI"], " ", "Carat"}], ",", 
    StyleBox["newunits", "TI"]}], "]"}]], "InlineFormula"],
 "converts ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], " ", "Carat"}]], "InlineFormula"],
 " to a form involving units ",
 Cell[BoxData[
  StyleBox["newunits", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->27036],

Cell[TextData[{
 Cell[BoxData["Carat"], "InlineFormula"],
 " is typically abbreviated as c or car."
}], "Notes",
 CellID->443372884]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->20735],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Grain",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Grain"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Ounce",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Ounce"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Pennyweight",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Pennyweight"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->13131]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->25451],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->21721]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Carat - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 9, 23.3355082}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "Carat is a unit of weight.", "synonyms" -> {}, "title" -> 
    "Carat", "type" -> "Symbol", "uri" -> "Units/ref/Carat"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1334, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1957, 60, 43, 1, 70, "ObjectName",
 CellID->18152],
Cell[2003, 63, 315, 10, 70, "Usage",
 CellID->28468]
}, Open  ]],
Cell[CellGroupData[{
Cell[2355, 78, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2833, 95, 278, 10, 70, "Notes",
 CellID->13626],
Cell[3114, 107, 258, 10, 70, "Notes",
 CellID->4696],
Cell[3375, 119, 501, 19, 70, "Notes",
 CellID->27036],
Cell[3879, 140, 132, 4, 70, "Notes",
 CellID->443372884]
}, Closed]],
Cell[CellGroupData[{
Cell[4048, 149, 311, 9, 70, "SeeAlsoSection",
 CellID->20735],
Cell[4362, 160, 708, 26, 70, "SeeAlso",
 CellID->13131]
}, Open  ]],
Cell[CellGroupData[{
Cell[5107, 191, 314, 9, 70, "TutorialsSection",
 CellID->25451],
Cell[5424, 202, 135, 3, 70, "Tutorials",
 CellID->21721]
}, Open  ]],
Cell[5574, 208, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

