(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7729,        278]
NotebookOptionsPosition[      5938,        219]
NotebookOutlinePosition[      6923,        247]
CellTagsIndexPosition[      6880,        244]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Foot" :> Documentation`HelpLookup["paclet:Units/ref/Foot"], 
          "Micron" :> Documentation`HelpLookup["paclet:Units/ref/Micron"], 
          "CGS" :> Documentation`HelpLookup["paclet:Units/ref/CGS"], "Feet" :> 
          Documentation`HelpLookup["paclet:Units/ref/Feet"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Foot\"\>", 2->"\<\"Micron\"\>", 
       3->"\<\"CGS\"\>", 4->"\<\"Feet\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Centimeter", "ObjectName",
 CellID->17753],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Centimeter"], "InlineFormula"],
     " \[LineSeparator]is the fundamental CGS unit of length."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->27158]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Centimeter"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Meter",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Meter"], "/", "100"}]], "InlineFormula"],
 " (SI units)."
}], "Notes",
 CellID->25550],

Cell[TextData[{
 Cell[BoxData["Centimeter"], "InlineFormula"],
 " is equivalent to approximately ",
 Cell[BoxData[
  RowBox[{"0.393701", " ", 
   ButtonBox["Inch",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Inch"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->9037],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Convert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Convert"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["n", "TI"], " ", "Centimeter"}], ",", 
    StyleBox["newunits", "TI"]}], "]"}]], "InlineFormula"],
 "converts ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], " ", "Centimeter"}]], "InlineFormula"],
 " to a form involving units ",
 Cell[BoxData[
  StyleBox["newunits", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->29072],

Cell[TextData[{
 Cell[BoxData["Centimeter"], "InlineFormula"],
 " is typically abbreviated as cm."
}], "Notes",
 CellID->26739]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->7358],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Foot",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Foot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Micron",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Micron"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CGS",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/CGS"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Feet",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Feet"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->10963]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->1781],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->26975]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Centimeter - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 9, 30.4763160}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "Centimeter is the fundamental CGS unit of length.", 
    "synonyms" -> {}, "title" -> "Centimeter", "type" -> "Symbol", "uri" -> 
    "Units/ref/Centimeter"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1390, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2013, 60, 48, 1, 70, "ObjectName",
 CellID->17753],
Cell[2064, 63, 338, 10, 70, "Usage",
 CellID->27158]
}, Open  ]],
Cell[CellGroupData[{
Cell[2439, 78, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2917, 95, 277, 10, 70, "Notes",
 CellID->25550],
Cell[3197, 107, 282, 10, 70, "Notes",
 CellID->9037],
Cell[3482, 119, 511, 19, 70, "Notes",
 CellID->29072],
Cell[3996, 140, 127, 4, 70, "Notes",
 CellID->26739]
}, Closed]],
Cell[CellGroupData[{
Cell[4160, 149, 310, 9, 70, "SeeAlsoSection",
 CellID->7358],
Cell[4473, 160, 935, 35, 70, "SeeAlso",
 CellID->10963]
}, Open  ]],
Cell[CellGroupData[{
Cell[5445, 200, 313, 9, 70, "TutorialsSection",
 CellID->1781],
Cell[5761, 211, 135, 3, 70, "Tutorials",
 CellID->26975]
}, Open  ]],
Cell[5911, 217, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

