(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7771,        281]
NotebookOptionsPosition[      6016,        223]
NotebookOutlinePosition[      6962,        250]
CellTagsIndexPosition[      6919,        247]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DidotPoint" :> 
          Documentation`HelpLookup["paclet:Units/ref/DidotPoint"], "Inch" :> 
          Documentation`HelpLookup["paclet:Units/ref/Inch"], "Pica" :> 
          Documentation`HelpLookup["paclet:Units/ref/Pica"], "PrintersPoint" :> 
          Documentation`HelpLookup["paclet:Units/ref/PrintersPoint"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"DidotPoint\"\>", 
       2->"\<\"Inch\"\>", 3->"\<\"Pica\"\>", 
       4->"\<\"PrintersPoint\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Cicero", "ObjectName",
 CellID->8890],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Cicero"], "InlineFormula"],
     " \[LineSeparator]is a unit of length."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->7281]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Cicero"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"(", 
    RowBox[{"3", "/", "665"}], ")"}], " ", 
   ButtonBox["Meter",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Meter"]}]], "InlineFormula"],
 " (SI units)."
}], "Notes",
 CellID->30556],

Cell[TextData[{
 Cell[BoxData["Cicero"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{"12", " ", 
   ButtonBox["Didot",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Didot"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->2711],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Convert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Convert"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["n", "TI"], " ", "Cicero"}], ",", 
    StyleBox["newunits", "TI"]}], "]"}]], "InlineFormula"],
 "converts ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], " ", "Cicero"}]], "InlineFormula"],
 " to a form involving units ",
 Cell[BoxData[
  StyleBox["newunits", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->12387],

Cell[TextData[{
 Cell[BoxData["Cicero"], "InlineFormula"],
 " is typically abbreviated as cc."
}], "Notes",
 CellID->322351222]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->9810],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["DidotPoint",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/DidotPoint"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Inch",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Inch"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Pica",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Pica"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PrintersPoint",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/PrintersPoint"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->27879]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->32315],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->32236]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Cicero - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 9, 31.6013448}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "Cicero is a unit of length.", "synonyms" -> {}, "title" -> 
    "Cicero", "type" -> "Symbol", "uri" -> "Units/ref/Cicero"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1452, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2075, 62, 43, 1, 70, "ObjectName",
 CellID->8890],
Cell[2121, 65, 315, 10, 70, "Usage",
 CellID->7281]
}, Open  ]],
Cell[CellGroupData[{
Cell[2473, 80, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2951, 97, 322, 12, 70, "Notes",
 CellID->30556],
Cell[3276, 111, 260, 10, 70, "Notes",
 CellID->2711],
Cell[3539, 123, 503, 19, 70, "Notes",
 CellID->12387],
Cell[4045, 144, 127, 4, 70, "Notes",
 CellID->322351222]
}, Closed]],
Cell[CellGroupData[{
Cell[4209, 153, 310, 9, 70, "SeeAlsoSection",
 CellID->9810],
Cell[4522, 164, 963, 35, 70, "SeeAlso",
 CellID->27879]
}, Open  ]],
Cell[CellGroupData[{
Cell[5522, 204, 314, 9, 70, "TutorialsSection",
 CellID->32315],
Cell[5839, 215, 135, 3, 70, "Tutorials",
 CellID->32236]
}, Open  ]],
Cell[5989, 221, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

