(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7784,        276]
NotebookOptionsPosition[      6086,        220]
NotebookOutlinePosition[      7035,        247]
CellTagsIndexPosition[      6992,        244]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Rutherford" :> 
          Documentation`HelpLookup["paclet:Units/ref/Rutherford"], "GrayDose" :> 
          Documentation`HelpLookup["paclet:Units/ref/GrayDose"], "Rad" :> 
          Documentation`HelpLookup["paclet:Units/ref/Rad"], "Rontgen" :> 
          Documentation`HelpLookup["paclet:Units/ref/Rontgen"], "Roentgen" :> 
          Documentation`HelpLookup["paclet:Units/ref/Roentgen"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Rutherford\"\>", 
       2->"\<\"GrayDose\"\>", 3->"\<\"Rad\"\>", 4->"\<\"Rontgen\"\>", 
       5->"\<\"Roentgen\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Curie", "ObjectName",
 CellID->10203],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Curie"], "InlineFormula"],
     " \[LineSeparator]is a unit of radioactivity."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->12755]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Curie"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{"37", "\[Times]", 
   SuperscriptBox["10", "9"], " ", 
   ButtonBox["Becquerel",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Becquerel"]}]], "InlineFormula"],
 " (SI units)."
}], "Notes",
 CellID->20157],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Convert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Convert"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["n", "TI"], " ", "Curie"}], ",", 
    StyleBox["newunits", "TI"]}], "]"}]], "InlineFormula"],
 "converts ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], " ", "Curie"}]], "InlineFormula"],
 " to a form involving units ",
 Cell[BoxData[
  StyleBox["newunits", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->11323],

Cell[TextData[{
 Cell[BoxData["Curie"], "InlineFormula"],
 " is typically abbreviated as Ci."
}], "Notes",
 CellID->2303]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->9374],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Rutherford",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Rutherford"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GrayDose",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/GrayDose"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Rad",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Rad"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Rontgen",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Rontgen"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Roentgen",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Roentgen"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->6128]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->7469],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->677]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Curie - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 9, 38.9765336}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "Curie is a unit of radioactivity.", "synonyms" -> {}, 
    "title" -> "Curie", "type" -> "Symbol", "uri" -> "Units/ref/Curie"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1545, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2168, 63, 43, 1, 70, "ObjectName",
 CellID->10203],
Cell[2214, 66, 322, 10, 70, "Usage",
 CellID->12755]
}, Open  ]],
Cell[CellGroupData[{
Cell[2573, 81, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3051, 98, 322, 11, 70, "Notes",
 CellID->20157],
Cell[3376, 111, 501, 19, 70, "Notes",
 CellID->11323],
Cell[3880, 132, 121, 4, 70, "Notes",
 CellID->2303]
}, Closed]],
Cell[CellGroupData[{
Cell[4038, 141, 310, 9, 70, "SeeAlsoSection",
 CellID->9374],
Cell[4351, 152, 1207, 44, 70, "SeeAlso",
 CellID->6128]
}, Open  ]],
Cell[CellGroupData[{
Cell[5595, 201, 313, 9, 70, "TutorialsSection",
 CellID->7469],
Cell[5911, 212, 133, 3, 70, "Tutorials",
 CellID->677]
}, Open  ]],
Cell[6059, 218, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

