(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7599,        272]
NotebookOptionsPosition[      5906,        216]
NotebookOutlinePosition[      6848,        243]
CellTagsIndexPosition[      6805,        240]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Cicero" :> Documentation`HelpLookup["paclet:Units/ref/Cicero"],
           "PrintersPoint" :> 
          Documentation`HelpLookup["paclet:Units/ref/PrintersPoint"], "Pica" :> 
          Documentation`HelpLookup["paclet:Units/ref/Pica"], "Centimeter" :> 
          Documentation`HelpLookup["paclet:Units/ref/Centimeter"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Cicero\"\>", 
       2->"\<\"PrintersPoint\"\>", 3->"\<\"Pica\"\>", 
       4->"\<\"Centimeter\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Didot", "ObjectName",
 CellID->30782],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Didot"], "InlineFormula"],
     " \[LineSeparator]is a unit of length."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->25384]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Didot"], "InlineFormula"],
 " is equivalent to approximately ",
 Cell[BoxData[
  RowBox[{"0.37594", "\[Times]", 
   SuperscriptBox["10", 
    RowBox[{"-", "3"}]], "  ", 
   ButtonBox["Meter",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Meter"]}]], "InlineFormula"],
 " (SI units)."
}], "Notes",
 CellID->3192],

Cell[TextData[{
 Cell[BoxData["Didot"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  ButtonBox["DidotPoint",
   BaseStyle->"Link",
   ButtonData->"paclet:Units/ref/DidotPoint"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->4682],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Convert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Convert"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["n", "TI"], " ", "Didot"}], ",", 
    StyleBox["newunits", "TI"]}], "]"}]], "InlineFormula"],
 "converts ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], " ", "Didot"}]], "InlineFormula"],
 " to a form involving units ",
 Cell[BoxData[
  StyleBox["newunits", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->31677]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->29624],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Cicero",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Cicero"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PrintersPoint",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/PrintersPoint"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Pica",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Pica"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Centimeter",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Centimeter"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->32082]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->3609],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->27800]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Didot - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 9, 46.6486050}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "Didot is a unit of length.", "synonyms" -> {}, "title" -> 
    "Didot", "type" -> "Symbol", "uri" -> "Units/ref/Didot"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1457, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2080, 62, 43, 1, 70, "ObjectName",
 CellID->30782],
Cell[2126, 65, 315, 10, 70, "Usage",
 CellID->25384]
}, Open  ]],
Cell[CellGroupData[{
Cell[2478, 80, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2956, 97, 353, 12, 70, "Notes",
 CellID->3192],
Cell[3312, 111, 242, 9, 70, "Notes",
 CellID->4682],
Cell[3557, 122, 501, 19, 70, "Notes",
 CellID->31677]
}, Closed]],
Cell[CellGroupData[{
Cell[4095, 146, 311, 9, 70, "SeeAlsoSection",
 CellID->29624],
Cell[4409, 157, 967, 35, 70, "SeeAlso",
 CellID->32082]
}, Open  ]],
Cell[CellGroupData[{
Cell[5413, 197, 313, 9, 70, "TutorialsSection",
 CellID->3609],
Cell[5729, 208, 135, 3, 70, "Tutorials",
 CellID->27800]
}, Open  ]],
Cell[5879, 214, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

