(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7637,        272]
NotebookOptionsPosition[      5925,        216]
NotebookOutlinePosition[      6887,        243]
CellTagsIndexPosition[      6844,        240]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Cicero" :> Documentation`HelpLookup["paclet:Units/ref/Cicero"],
           "PrintersPoint" :> 
          Documentation`HelpLookup["paclet:Units/ref/PrintersPoint"], "Pica" :> 
          Documentation`HelpLookup["paclet:Units/ref/Pica"], "Centimeter" :> 
          Documentation`HelpLookup["paclet:Units/ref/Centimeter"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Cicero\"\>", 
       2->"\<\"PrintersPoint\"\>", 3->"\<\"Pica\"\>", 
       4->"\<\"Centimeter\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["DidotPoint", "ObjectName",
 CellID->5234],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["DidotPoint"], "InlineFormula"],
     " \[LineSeparator]is a unit of length."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->9170]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["DidotPoint"], "InlineFormula"],
 " is equivalent to approximately ",
 Cell[BoxData[
  RowBox[{"0.37594", "\[Times]", 
   SuperscriptBox["10", 
    RowBox[{"-", "3"}]], "  ", 
   ButtonBox["Meter",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Meter"]}]], "InlineFormula"],
 " (SI units)."
}], "Notes",
 CellID->4845],

Cell[TextData[{
 Cell[BoxData["DidotPoint"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  ButtonBox["Didot",
   BaseStyle->"Link",
   ButtonData->"paclet:Units/ref/Didot"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->11401],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Convert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Convert"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["n", "TI"], " ", "DidotPoint"}], ",", 
    StyleBox["newunits", "TI"]}], "]"}]], "InlineFormula"],
 "converts ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], " ", "DidotPoint"}]], "InlineFormula"],
 " to a form involving units ",
 Cell[BoxData[
  StyleBox["newunits", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->3289]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->23290],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Cicero",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Cicero"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PrintersPoint",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/PrintersPoint"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Pica",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Pica"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Centimeter",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Centimeter"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->23758]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->15249],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->16611]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DidotPoint - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 9, 46.8204844}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "DidotPoint is a unit of length.", "synonyms" -> {}, "title" -> 
    "DidotPoint", "type" -> "Symbol", "uri" -> "Units/ref/DidotPoint"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1457, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2080, 62, 47, 1, 70, "ObjectName",
 CellID->5234],
Cell[2130, 65, 319, 10, 70, "Usage",
 CellID->9170]
}, Open  ]],
Cell[CellGroupData[{
Cell[2486, 80, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2964, 97, 358, 12, 70, "Notes",
 CellID->4845],
Cell[3325, 111, 238, 9, 70, "Notes",
 CellID->11401],
Cell[3566, 122, 510, 19, 70, "Notes",
 CellID->3289]
}, Closed]],
Cell[CellGroupData[{
Cell[4113, 146, 311, 9, 70, "SeeAlsoSection",
 CellID->23290],
Cell[4427, 157, 967, 35, 70, "SeeAlso",
 CellID->23758]
}, Open  ]],
Cell[CellGroupData[{
Cell[5431, 197, 314, 9, 70, "TutorialsSection",
 CellID->15249],
Cell[5748, 208, 135, 3, 70, "Tutorials",
 CellID->16611]
}, Open  ]],
Cell[5898, 214, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

