(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7948,        283]
NotebookOptionsPosition[      6240,        227]
NotebookOutlinePosition[      7198,        254]
CellTagsIndexPosition[      7155,        251]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Teaspoon" :> 
          Documentation`HelpLookup["paclet:Units/ref/Teaspoon"], "Tablespoon" :> 
          Documentation`HelpLookup["paclet:Units/ref/Tablespoon"], "Gallon" :> 
          Documentation`HelpLookup["paclet:Units/ref/Gallon"], "Pint" :> 
          Documentation`HelpLookup["paclet:Units/ref/Pint"], "Minim" :> 
          Documentation`HelpLookup["paclet:Units/ref/Minim"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Teaspoon\"\>", 
       2->"\<\"Tablespoon\"\>", 3->"\<\"Gallon\"\>", 4->"\<\"Pint\"\>", 
       5->"\<\"Minim\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["FluidDram", "ObjectName",
 CellID->27221],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["FluidDram"], "InlineFormula"],
     " \[LineSeparator]is a unit of volume."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->6734]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["FluidDram"], "InlineFormula"],
 " is equivalent to approximately ",
 Cell[BoxData[
  RowBox[{"3.6966875*^-6", " ", 
   SuperscriptBox[
    ButtonBox["Meter",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Meter"], "3"]}]], "InlineFormula"],
 " (SI units)."
}], "Notes",
 CellID->4288],

Cell[TextData[{
 Cell[BoxData["FluidDram"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FluidOunce",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/FluidOunce"], "/", "8"}]], 
  "InlineFormula"],
 "."
}], "Notes",
 CellID->4675],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Convert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Convert"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["n", "TI"], " ", "FluidDram"}], ",", 
    StyleBox["newunits", "TI"]}], "]"}]], "InlineFormula"],
 "converts ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], " ", "FluidDram"}]], "InlineFormula"],
 " to a form involving units ",
 Cell[BoxData[
  StyleBox["newunits", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->14178]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->21242],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Teaspoon",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Teaspoon"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Tablespoon",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Tablespoon"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Gallon",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Gallon"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Pint",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Pint"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Minim",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Minim"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->25687]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->639],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->2920]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FluidDram - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 10, 2.8521448}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "FluidDram is a unit of volume.", "synonyms" -> {}, "title" -> 
    "FluidDram", "type" -> "Symbol", "uri" -> "Units/ref/FluidDram"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1536, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2159, 63, 47, 1, 70, "ObjectName",
 CellID->27221],
Cell[2209, 66, 318, 10, 70, "Usage",
 CellID->6734]
}, Open  ]],
Cell[CellGroupData[{
Cell[2564, 81, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3042, 98, 327, 11, 70, "Notes",
 CellID->4288],
Cell[3372, 111, 275, 11, 70, "Notes",
 CellID->4675],
Cell[3650, 124, 509, 19, 70, "Notes",
 CellID->14178]
}, Closed]],
Cell[CellGroupData[{
Cell[4196, 148, 311, 9, 70, "SeeAlsoSection",
 CellID->21242],
Cell[4510, 159, 1202, 44, 70, "SeeAlso",
 CellID->25687]
}, Open  ]],
Cell[CellGroupData[{
Cell[5749, 208, 312, 9, 70, "TutorialsSection",
 CellID->639],
Cell[6064, 219, 134, 3, 70, "Tutorials",
 CellID->2920]
}, Open  ]],
Cell[6213, 225, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

