(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7674,        278]
NotebookOptionsPosition[      5877,        219]
NotebookOutlinePosition[      6864,        247]
CellTagsIndexPosition[      6821,        244]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Phot" :> Documentation`HelpLookup["paclet:Units/ref/Phot"], 
          "Candela" :> Documentation`HelpLookup["paclet:Units/ref/Candela"], 
          "Lumen" :> Documentation`HelpLookup["paclet:Units/ref/Lumen"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Phot\"\>", 
       2->"\<\"Candela\"\>", 3->"\<\"Lumen\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["FootCandle", "ObjectName",
 CellID->19080],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["FootCandle"], "InlineFormula"],
     " \[LineSeparator]is a unit of illumination (illuminance)."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->20417]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["FootCandle"], "InlineFormula"],
 " is equivalent to approximately ",
 Cell[BoxData[
  RowBox[{"10.7639", " ", 
   ButtonBox["Lux",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Lux"]}]], "InlineFormula"],
 " (SI units)."
}], "Notes",
 CellID->17095],

Cell[TextData[{
 Cell[BoxData["FootCandle"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Lux",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Lux"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      ButtonBox["Meter",
       BaseStyle->"Link",
       ButtonData->"paclet:Units/ref/Meter"], "/", 
      ButtonBox["Foot",
       BaseStyle->"Link",
       ButtonData->"paclet:Units/ref/Foot"]}], ")"}], "2"]}]], 
  "InlineFormula"],
 "."
}], "Notes",
 CellID->1940],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Convert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Convert"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["n", "TI"], " ", "FootCandle"}], ",", 
    StyleBox["newunits", "TI"]}], "]"}]], "InlineFormula"],
 "converts ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], " ", "FootCandle"}]], "InlineFormula"],
 " to a form involving units ",
 Cell[BoxData[
  StyleBox["newunits", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->11714],

Cell[TextData[{
 Cell[BoxData["FootCandle"], "InlineFormula"],
 " is typically abbreviated fc."
}], "Notes",
 CellID->82173503]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->2197],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Phot",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Phot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Candela",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Candela"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Lumen",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Lumen"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->29353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->13029],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->31784]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FootCandle - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 10, 3.1802782}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "FootCandle is a unit of illumination (illuminance).", 
    "synonyms" -> {}, "title" -> "FootCandle", "type" -> "Symbol", "uri" -> 
    "Units/ref/FootCandle"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1309, 32, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1932, 59, 48, 1, 70, "ObjectName",
 CellID->19080],
Cell[1983, 62, 340, 10, 70, "Usage",
 CellID->20417]
}, Open  ]],
Cell[CellGroupData[{
Cell[2360, 77, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2838, 94, 291, 10, 70, "Notes",
 CellID->17095],
Cell[3132, 106, 522, 20, 70, "Notes",
 CellID->1940],
Cell[3657, 128, 511, 19, 70, "Notes",
 CellID->11714],
Cell[4171, 149, 127, 4, 70, "Notes",
 CellID->82173503]
}, Closed]],
Cell[CellGroupData[{
Cell[4335, 158, 310, 9, 70, "SeeAlsoSection",
 CellID->2197],
Cell[4648, 169, 698, 26, 70, "SeeAlso",
 CellID->29353]
}, Open  ]],
Cell[CellGroupData[{
Cell[5383, 200, 314, 9, 70, "TutorialsSection",
 CellID->13029],
Cell[5700, 211, 135, 3, 70, "Tutorials",
 CellID->31784]
}, Open  ]],
Cell[5850, 217, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

