(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8799,        314]
NotebookOptionsPosition[      7035,        256]
NotebookOutlinePosition[      7985,        283]
CellTagsIndexPosition[      7942,        280]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Foot" :> Documentation`HelpLookup["paclet:Units/ref/Foot"], 
          "Rod" :> Documentation`HelpLookup["paclet:Units/ref/Rod"], "Chain" :> 
          Documentation`HelpLookup["paclet:Units/ref/Chain"], "Pole" :> 
          Documentation`HelpLookup["paclet:Units/ref/Pole"], "Perch" :> 
          Documentation`HelpLookup["paclet:Units/ref/Perch"], "Link" :> 
          Documentation`HelpLookup["paclet:Units/ref/Link"], "Feet" :> 
          Documentation`HelpLookup["paclet:Units/ref/Feet"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Foot\"\>", 2->"\<\"Rod\"\>", 
       3->"\<\"Chain\"\>", 4->"\<\"Pole\"\>", 5->"\<\"Perch\"\>", 
       6->"\<\"Link\"\>", 7->"\<\"Feet\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Furlong", "ObjectName",
 CellID->17790],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Furlong"], "InlineFormula"],
     " \[LineSeparator]is a unit of length."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->26511]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Furlong"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{"201.168", " ", 
   ButtonBox["Meter",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Meter"]}]], "InlineFormula"],
 " (SI units)."
}], "Notes",
 CellID->12542],

Cell[TextData[{
 Cell[BoxData["Furlong"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{"220", " ", 
   ButtonBox["Yard",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Yard"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->27905],

Cell[TextData[{
 Cell[BoxData["Furlong"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Mile",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Mile"], "/", "8"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->14967],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Convert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Convert"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["n", "TI"], " ", "Furlong"}], ",", 
    StyleBox["newunits", "TI"]}], "]"}]], "InlineFormula"],
 "converts ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], " ", "Furlong"}]], "InlineFormula"],
 " to a form involving units ",
 Cell[BoxData[
  StyleBox["newunits", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->11845]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->28408],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Foot",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Foot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Rod",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Rod"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Chain",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Chain"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Pole",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Pole"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Perch",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Perch"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Link",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Link"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Feet",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Feet"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->201950538]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->23613],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->7257]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Furlong - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 10, 3.7271672}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "Furlong is a unit of length.", "synonyms" -> {}, "title" -> 
    "Furlong", "type" -> "Symbol", "uri" -> "Units/ref/Furlong"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1671, 37, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2294, 64, 45, 1, 70, "ObjectName",
 CellID->17790],
Cell[2342, 67, 317, 10, 70, "Usage",
 CellID->26511]
}, Open  ]],
Cell[CellGroupData[{
Cell[2696, 82, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3174, 99, 278, 10, 70, "Notes",
 CellID->12542],
Cell[3455, 111, 261, 10, 70, "Notes",
 CellID->27905],
Cell[3719, 123, 259, 10, 70, "Notes",
 CellID->14967],
Cell[3981, 135, 505, 19, 70, "Notes",
 CellID->11845]
}, Closed]],
Cell[CellGroupData[{
Cell[4523, 159, 311, 9, 70, "SeeAlsoSection",
 CellID->28408],
Cell[4837, 170, 1668, 62, 70, "SeeAlso",
 CellID->201950538]
}, Open  ]],
Cell[CellGroupData[{
Cell[6542, 237, 314, 9, 70, "TutorialsSection",
 CellID->23613],
Cell[6859, 248, 134, 3, 70, "Tutorials",
 CellID->7257]
}, Open  ]],
Cell[7008, 254, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

