(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7362,        266]
NotebookOptionsPosition[      5632,        208]
NotebookOutlinePosition[      6615,        237]
CellTagsIndexPosition[      6572,        234]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Gravity" :> 
          Documentation`HelpLookup["paclet:Units/ref/Gravity"], "CGS" :> 
          Documentation`HelpLookup["paclet:Units/ref/CGS"], 
          "AccelerationDueToGravity" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/AccelerationDueToGravity"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Gravity\"\>", 2->"\<\"CGS\"\>", 
       3->"\<\"AccelerationDueToGravity\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Gal", "ObjectName",
 CellID->182],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Gal"], "InlineFormula"],
     " \[LineSeparator]is the derived CGS measure of acceleration due to \
gravity."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->20728]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Gal"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Meter",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Meter"], "/", 
   RowBox[{"(", 
    RowBox[{"100", " ", 
     SuperscriptBox[
      ButtonBox["Second",
       BaseStyle->"Link",
       ButtonData->"paclet:Units/ref/Second"], "2"]}], ")"}]}]], 
  "InlineFormula"],
 " (SI units)."
}], "Notes",
 CellID->6756],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Convert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Convert"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["n", "TI"], " ", "Gal"}], ",", 
    StyleBox["newunits", "TI"]}], "]"}]], "InlineFormula"],
 "converts ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], " ", "Gal"}]], "InlineFormula"],
 " to a form involving units ",
 Cell[BoxData[
  StyleBox["newunits", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->7033],

Cell[TextData[{
 Cell[BoxData["Gal"], "InlineFormula"],
 " is typically abbreviated as gal."
}], "Notes",
 CellID->7262]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->9332],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Gravity",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Gravity"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CGS",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/CGS"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AccelerationDueToGravity",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/AccelerationDueToGravity"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->4897]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->30899],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->17496]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Gal - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 10, 10.4773400}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> 
    "Gal is the derived CGS measure of acceleration due to gravity.", 
    "synonyms" -> {}, "title" -> "Gal", "type" -> "Symbol", "uri" -> 
    "Units/ref/Gal"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1408, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2031, 62, 39, 1, 70, "ObjectName",
 CellID->182],
Cell[2073, 65, 353, 11, 70, "Usage",
 CellID->20728]
}, Open  ]],
Cell[CellGroupData[{
Cell[2463, 81, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2941, 98, 443, 17, 70, "Notes",
 CellID->6756],
Cell[3387, 117, 496, 19, 70, "Notes",
 CellID->7033],
Cell[3886, 138, 120, 4, 70, "Notes",
 CellID->7262]
}, Closed]],
Cell[CellGroupData[{
Cell[4043, 147, 310, 9, 70, "SeeAlsoSection",
 CellID->9332],
Cell[4356, 158, 745, 26, 70, "SeeAlso",
 CellID->4897]
}, Open  ]],
Cell[CellGroupData[{
Cell[5138, 189, 314, 9, 70, "TutorialsSection",
 CellID->30899],
Cell[5455, 200, 135, 3, 70, "Tutorials",
 CellID->17496]
}, Open  ]],
Cell[5605, 206, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

