(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8014,        285]
NotebookOptionsPosition[      6225,        226]
NotebookOutlinePosition[      7202,        254]
CellTagsIndexPosition[      7159,        251]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Maxwell" :> 
          Documentation`HelpLookup["paclet:Units/ref/Maxwell"], "Oersted" :> 
          Documentation`HelpLookup["paclet:Units/ref/Oersted"], 
          "NuclearMagneton" :> 
          Documentation`HelpLookup["paclet:Units/ref/NuclearMagneton"], 
          "BohrMagneton" :> 
          Documentation`HelpLookup["paclet:Units/ref/BohrMagneton"], "CGS" :> 
          Documentation`HelpLookup["paclet:Units/ref/CGS"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Maxwell\"\>", 2->"\<\"Oersted\"\>", 
       3->"\<\"NuclearMagneton\"\>", 4->"\<\"BohrMagneton\"\>", 
       5->"\<\"CGS\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Gauss", "ObjectName",
 CellID->31871],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Gauss"], "InlineFormula"],
     " \[LineSeparator]is the derived ",
     Cell[BoxData["CGS"], "InlineFormula"],
     " unit of magnetic flux density."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->18646]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Gauss"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Tesla",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Tesla"], "/", "10000"}]], "InlineFormula"],
 " (SI units)."
}], "Notes",
 CellID->18781],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Convert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Convert"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["n", "TI"], " ", "Gauss"}], ",", 
    StyleBox["newunits", "TI"]}], "]"}]], "InlineFormula"],
 "converts ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], " ", "Gauss"}]], "InlineFormula"],
 " to a form involving units ",
 Cell[BoxData[
  StyleBox["newunits", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->16911],

Cell[TextData[{
 Cell[BoxData["Gauss"], "InlineFormula"],
 " is typically abbreviated as G."
}], "Notes",
 CellID->10328]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->19040],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Maxwell",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Maxwell"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Oersted",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Oersted"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NuclearMagneton",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/NuclearMagneton"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BohrMagneton",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/BohrMagneton"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CGS",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/CGS"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->24388],

Cell[BoxData[""], "Input",
 CellID->150715778]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->1746],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->28690]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Gauss - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 10, 10.6492194}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "Gauss is the derived CGS unit of magnetic flux density.", 
    "synonyms" -> {}, "title" -> "Gauss", "type" -> "Symbol", "uri" -> 
    "Units/ref/Gauss"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1591, 38, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2214, 65, 43, 1, 70, "ObjectName",
 CellID->31871],
Cell[2260, 68, 394, 12, 70, "Usage",
 CellID->18646]
}, Open  ]],
Cell[CellGroupData[{
Cell[2691, 85, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3169, 102, 274, 10, 70, "Notes",
 CellID->18781],
Cell[3446, 114, 501, 19, 70, "Notes",
 CellID->16911],
Cell[3950, 135, 121, 4, 70, "Notes",
 CellID->10328]
}, Closed]],
Cell[CellGroupData[{
Cell[4108, 144, 311, 9, 70, "SeeAlsoSection",
 CellID->19040],
Cell[4422, 155, 1224, 44, 70, "SeeAlso",
 CellID->24388],
Cell[5649, 201, 46, 1, 70, "Input",
 CellID->150715778]
}, Open  ]],
Cell[CellGroupData[{
Cell[5732, 207, 313, 9, 70, "TutorialsSection",
 CellID->1746],
Cell[6048, 218, 135, 3, 70, "Tutorials",
 CellID->28690]
}, Open  ]],
Cell[6198, 224, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

