(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8780,        303]
NotebookOptionsPosition[      7030,        246]
NotebookOutlinePosition[      8030,        274]
CellTagsIndexPosition[      7987,        271]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Pound" :> Documentation`HelpLookup["paclet:Units/ref/Pound"], 
          "Stone" :> Documentation`HelpLookup["paclet:Units/ref/Stone"], 
          "LongTon" :> Documentation`HelpLookup["paclet:Units/ref/LongTon"], 
          "NetHundredweight" :> 
          Documentation`HelpLookup["paclet:Units/ref/NetHundredweight"], 
          "ShortHundredweight" :> 
          Documentation`HelpLookup["paclet:Units/ref/ShortHundredweight"], 
          "Quintal" :> Documentation`HelpLookup["paclet:Units/ref/Quintal"], 
          "Wey" :> Documentation`HelpLookup["paclet:Units/ref/Wey"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Pound\"\>", 2->"\<\"Stone\"\>", 
       3->"\<\"LongTon\"\>", 4->"\<\"NetHundredweight\"\>", 
       5->"\<\"ShortHundredweight\"\>", 6->"\<\"Quintal\"\>", 
       7->"\<\"Wey\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["GrossHundredweight", "ObjectName",
 CellID->17262],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["GrossHundredweight"], "InlineFormula"],
     " \[LineSeparator]is a unit of weight."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->9123]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["GrossHundredweight"], "InlineFormula"],
 " is equivalent to approximately ",
 Cell[BoxData[
  RowBox[{"50.8023", " ", 
   ButtonBox["Kilogram",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Kilogram"]}]], "InlineFormula"],
 " (SI units)."
}], "Notes",
 CellID->18684],

Cell[TextData[{
 Cell[BoxData["GrossHundredweight"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  ButtonBox["Hundredweight",
   BaseStyle->"Link",
   ButtonData->"paclet:Units/ref/Hundredweight"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->30391],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Convert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Convert"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["n", "TI"], " ", "GrossHundredweight"}], ",", 
    StyleBox["newunits", "TI"]}], "]"}]], "InlineFormula"],
 "converts ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], " ", "GrossHundredweight"}]], "InlineFormula"],
 " to a form involving units ",
 Cell[BoxData[
  StyleBox["newunits", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->1311]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->27770],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Pound",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Pound"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Stone",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Stone"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LongTon",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/LongTon"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NetHundredweight",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/NetHundredweight"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ShortHundredweight",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/ShortHundredweight"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Quintal",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Quintal"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Wey",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Wey"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->27845]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->74],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->5136]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"GrossHundredweight - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 10, 18.9775576}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "GrossHundredweight is a unit of weight.", "synonyms" -> {}, 
    "title" -> "GrossHundredweight", "type" -> "Symbol", "uri" -> 
    "Units/ref/GrossHundredweight"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1797, 40, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2420, 67, 56, 1, 70, "ObjectName",
 CellID->17262],
Cell[2479, 70, 327, 10, 70, "Usage",
 CellID->9123]
}, Open  ]],
Cell[CellGroupData[{
Cell[2843, 85, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3321, 102, 309, 10, 70, "Notes",
 CellID->18684],
Cell[3633, 114, 262, 9, 70, "Notes",
 CellID->30391],
Cell[3898, 125, 526, 19, 70, "Notes",
 CellID->1311]
}, Closed]],
Cell[CellGroupData[{
Cell[4461, 149, 311, 9, 70, "SeeAlsoSection",
 CellID->27770],
Cell[4775, 160, 1728, 62, 70, "SeeAlso",
 CellID->27845]
}, Open  ]],
Cell[CellGroupData[{
Cell[6540, 227, 311, 9, 70, "TutorialsSection",
 CellID->74],
Cell[6854, 238, 134, 3, 70, "Tutorials",
 CellID->5136]
}, Open  ]],
Cell[7003, 244, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

