(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8689,        297]
NotebookOptionsPosition[      7029,        243]
NotebookOutlinePosition[      7985,        270]
CellTagsIndexPosition[      7942,        267]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Volt" :> Documentation`HelpLookup["paclet:Units/ref/Volt"], 
          "Watt" :> Documentation`HelpLookup["paclet:Units/ref/Watt"], 
          "ElectronVolt" :> 
          Documentation`HelpLookup["paclet:Units/ref/ElectronVolt"], 
          "Calorie" :> Documentation`HelpLookup["paclet:Units/ref/Calorie"], 
          "BritishThermalUnit" :> 
          Documentation`HelpLookup["paclet:Units/ref/BritishThermalUnit"], 
          "BTU" :> Documentation`HelpLookup["paclet:Units/ref/BTU"], "Therm" :> 
          Documentation`HelpLookup["paclet:Units/ref/Therm"], "Erg" :> 
          Documentation`HelpLookup["paclet:Units/ref/Erg"], "Rydberg" :> 
          Documentation`HelpLookup["paclet:Units/ref/Rydberg"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Volt\"\>", 2->"\<\"Watt\"\>", 
       3->"\<\"ElectronVolt\"\>", 4->"\<\"Calorie\"\>", 
       5->"\<\"BritishThermalUnit\"\>", 6->"\<\"BTU\"\>", 7->"\<\"Therm\"\>", 
       8->"\<\"Erg\"\>", 9->"\<\"Rydberg\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Joule", "ObjectName",
 CellID->30402],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Joule"], "InlineFormula"],
     " \[LineSeparator]is the derived SI unit of energy."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->26275]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Joule"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Newton",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Newton"], " ", 
   ButtonBox["Meter",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Meter"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->11430],

Cell[TextData[{
 Cell[BoxData["Joule"], "InlineFormula"],
 " is typically abbreviated as J."
}], "Notes",
 CellID->31450]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->26526],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Volt",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Volt"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Watt",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Watt"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ElectronVolt",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/ElectronVolt"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Calorie",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Calorie"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BritishThermalUnit",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/BritishThermalUnit"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BTU",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/BTU"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Therm",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Therm"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Erg",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Erg"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Rydberg",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Rydberg"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->240217896]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->19449],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->4123]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Joule - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 10, 34.9623418}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "Joule is the derived SI unit of energy.", "synonyms" -> {}, 
    "title" -> "Joule", "type" -> "Symbol", "uri" -> "Units/ref/Joule"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1961, 42, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2584, 69, 43, 1, 70, "ObjectName",
 CellID->30402],
Cell[2630, 72, 328, 10, 70, "Usage",
 CellID->26275]
}, Open  ]],
Cell[CellGroupData[{
Cell[2995, 87, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3473, 104, 345, 13, 70, "Notes",
 CellID->11430],
Cell[3821, 119, 121, 4, 70, "Notes",
 CellID->31450]
}, Closed]],
Cell[CellGroupData[{
Cell[3979, 128, 311, 9, 70, "SeeAlsoSection",
 CellID->26526],
Cell[4293, 139, 2206, 80, 70, "SeeAlso",
 CellID->240217896]
}, Open  ]],
Cell[CellGroupData[{
Cell[6536, 224, 314, 9, 70, "TutorialsSection",
 CellID->19449],
Cell[6853, 235, 134, 3, 70, "Tutorials",
 CellID->4123]
}, Open  ]],
Cell[7002, 241, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

