(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8635,        299]
NotebookOptionsPosition[      6899,        242]
NotebookOutlinePosition[      7878,        270]
CellTagsIndexPosition[      7835,        267]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PoundForce" :> 
          Documentation`HelpLookup["paclet:Units/ref/PoundForce"], "Poundal" :> 
          Documentation`HelpLookup["paclet:Units/ref/Poundal"], "TonForce" :> 
          Documentation`HelpLookup["paclet:Units/ref/TonForce"], "Dyne" :> 
          Documentation`HelpLookup["paclet:Units/ref/Dyne"], "KilogramWeight" :> 
          Documentation`HelpLookup["paclet:Units/ref/KilogramWeight"], 
          "PoundWeight" :> 
          Documentation`HelpLookup["paclet:Units/ref/PoundWeight"], 
          "GramWeight" :> 
          Documentation`HelpLookup["paclet:Units/ref/GramWeight"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"PoundForce\"\>", 
       2->"\<\"Poundal\"\>", 3->"\<\"TonForce\"\>", 4->"\<\"Dyne\"\>", 
       5->"\<\"KilogramWeight\"\>", 6->"\<\"PoundWeight\"\>", 
       7->"\<\"GramWeight\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["KilogramForce", "ObjectName",
 CellID->24816],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["KilogramForce"], "InlineFormula"],
     " \[LineSeparator]is a unit of force."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->12922]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["KilogramForce"], "InlineFormula"],
 " is equivalent to approximately ",
 Cell[BoxData[
  RowBox[{"9.80665", " ", 
   ButtonBox["Newton",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Newton"]}]], "InlineFormula"],
 " (SI units)."
}], "Notes",
 CellID->24842],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Convert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Convert"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["n", "TI"], " ", "KilogramForce"}], ",", 
    StyleBox["newunits", "TI"]}], "]"}]], "InlineFormula"],
 "converts ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], " ", "KilogramForce"}]], "InlineFormula"],
 " to a form involving units ",
 Cell[BoxData[
  StyleBox["newunits", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->12485],

Cell[TextData[{
 Cell[BoxData["KilogramForce"], "InlineFormula"],
 " is typically abbreviated kgf."
}], "Notes",
 CellID->34395105]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->23979],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["PoundForce",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/PoundForce"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Poundal",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Poundal"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TonForce",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/TonForce"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Dyne",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Dyne"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["KilogramWeight",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/KilogramWeight"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PoundWeight",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/PoundWeight"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GramWeight",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/GramWeight"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->23439]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->8324],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->8420]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"KilogramForce - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 10, 35.4779800}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "KilogramForce is a unit of force.", "synonyms" -> {}, 
    "title" -> "KilogramForce", "type" -> "Symbol", "uri" -> 
    "Units/ref/KilogramForce"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1817, 41, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2440, 68, 51, 1, 70, "ObjectName",
 CellID->24816],
Cell[2494, 71, 322, 10, 70, "Usage",
 CellID->12922]
}, Open  ]],
Cell[CellGroupData[{
Cell[2853, 86, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3331, 103, 300, 10, 70, "Notes",
 CellID->24842],
Cell[3634, 115, 517, 19, 70, "Notes",
 CellID->12485],
Cell[4154, 136, 131, 4, 70, "Notes",
 CellID->34395105]
}, Closed]],
Cell[CellGroupData[{
Cell[4322, 145, 311, 9, 70, "SeeAlsoSection",
 CellID->23979],
Cell[4636, 156, 1734, 62, 70, "SeeAlso",
 CellID->23439]
}, Open  ]],
Cell[CellGroupData[{
Cell[6407, 223, 313, 9, 70, "TutorialsSection",
 CellID->8324],
Cell[6723, 234, 134, 3, 70, "Tutorials",
 CellID->8420]
}, Open  ]],
Cell[6872, 240, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

